/*
 * Decompiled with CFR 0.152.
 */
package waelti.statistics.queries;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import waelti.statistics.queries.AbstractTimeSeries;
import waelti.statistics.queries.QueryUtil;
import waelti.statistics.queries.SetDataException;
import waelti.statistics.queries.annotations.GetProperty;
import waelti.statistics.queries.annotations.SetProperty;
import waelti.statistics.queries.providers.QueryContentProvider;
import waelti.statistics.queries.providers.QueryLabelProvider;

public class Consultations
extends AbstractTimeSeries {
    private Query patientQuery = new Query(Patient.class);
    private int firstCohort;
    private int cohortSize;
    private List<String> header;
    private IProgressMonitor monitor;
    private int size = 0;

    public Consultations() {
        super("Konsultationsauswertung");
        this.initHeader();
    }

    @Override
    protected void initData() {
        super.initData();
        this.cohortSize = 1;
    }

    private void initHeader() {
        this.header = new ArrayList<String>(7);
        this.header.add("Geburtsjahr");
        this.header.add("Anzahl F");
        this.header.add("Gesamtkosten F");
        this.header.add("Konsultationen F");
        this.header.add("Kosten/Konsultation F");
        this.header.add("Kosten/Patient F");
        this.header.add("Anzahl M");
        this.header.add("Gesamtkosten M");
        this.header.add("Konsultationen M");
        this.header.add("Kosten/Konsultation M");
        this.header.add("Kosten/Patient M");
    }

    @Override
    public List<String> getTableHeadings() {
        return this.header;
    }

    @Override
    public IStatus execute(IProgressMonitor monitor) {
        this.monitor = monitor;
        this.createContent();
        this.initProvider();
        monitor.done();
        return Status.OK_STATUS;
    }

    private void initProvider() {
        QueryContentProvider content = new QueryContentProvider(this.getList());
        QueryLabelProvider label = new QueryLabelProvider();
        this.setContentProvider(content);
        this.setLabelProvider(label);
    }

    private List<String[]> createContent() {
        Object[] patients = this.patientQuery.execute().toArray();
        this.size = patients.length;
        this.monitor.beginTask("querying database", this.size);
        this.initList(patients);
        this.calculateContent(patients);
        this.convertList();
        return QueryUtil.convertToString(this.getList());
    }

    private void convertList() {
        this.setList(QueryUtil.createCohorts(this.getList(), this.cohortSize));
        this.setList(QueryUtil.addAverage(this.getList(), 2, 3, 4));
        this.setList(QueryUtil.addAverage(this.getList(), 7, 8, 9));
        this.setList(QueryUtil.addAverage(this.getList(), 2, 1, 5));
        this.setList(QueryUtil.addAverage(this.getList(), 7, 6, 10));
        QueryUtil.convertDoubleToInteger(this.getList(), 3);
        QueryUtil.convertDoubleToInteger(this.getList(), 8);
        QueryUtil.convertDoubleToInteger(this.getList(), 1);
        QueryUtil.convertDoubleToInteger(this.getList(), 6);
        QueryUtil.convertToCurrency(this.getList(), 2);
        QueryUtil.convertToCurrency(this.getList(), 4);
        QueryUtil.convertToCurrency(this.getList(), 5);
        QueryUtil.convertToCurrency(this.getList(), 7);
        QueryUtil.convertToCurrency(this.getList(), 9);
        QueryUtil.convertToCurrency(this.getList(), 10);
    }

    private void calculateContent(Object[] patients) {
        int i = 0;
        while (i < patients.length) {
            Patient patient = (Patient)patients[i];
            if (this.validate_data(patient)) {
                int year = QueryUtil.extractYear(patient.getGeburtsdatum());
                if (year != 0 && this.handleCases(patient, year)) {
                    this.increment_patient_counter(patient, year);
                }
                this.monitor.worked(1);
            }
            ++i;
        }
    }

    private void initList(Object[] patients) {
        this.firstCohort = Calendar.getInstance().get(1);
        int i = 0;
        while (i < patients.length) {
            int birthYear = QueryUtil.extractYear(((Patient)patients[i]).getGeburtsdatum());
            if (this.firstCohort > birthYear && birthYear > 0) {
                this.firstCohort = this.determineFirstYear(birthYear);
            }
            ++i;
        }
        this.setList(QueryUtil.initiateYears(this.firstCohort, 11));
    }

    private int determineFirstYear(int birthYear) {
        if (birthYear % 5 == 0) {
            return birthYear;
        }
        int diff = birthYear % 5;
        assert ((birthYear - diff) % 5 == 0);
        return birthYear - diff;
    }

    private boolean handleCases(Patient patient, int birthYear) {
        Fall[] faelle = patient.getFaelle();
        boolean male = this.determineSex(patient);
        boolean result = false;
        int i = 0;
        while (i < faelle.length) {
            if (this.handleConsultation(faelle[i], birthYear, male)) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private boolean determineSex(Patient patient) {
        return patient.getGeschlecht().equals("m");
    }

    private boolean inPeriod(String date) {
        Calendar fallDate = Calendar.getInstance();
        try {
            fallDate = QueryUtil.convertToCalendar(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fallDate.compareTo(this.getStartDate()) >= 0 && fallDate.compareTo(this.getEndDate()) <= 0;
    }

    private boolean handleConsultation(Fall fall, int birthYear, boolean male) {
        Konsultation[] consultations = fall.getBehandlungen(false);
        boolean result = false;
        int i = 0;
        while (i < consultations.length) {
            Konsultation cons = consultations[i];
            if (this.inPeriod(cons.getDatum())) {
                result = true;
                if (male) {
                    this.add_male(birthYear, cons);
                } else {
                    this.add_female(birthYear, cons);
                }
            }
            ++i;
        }
        return result;
    }

    private void increment_patient_counter(Patient patient, int year) {
        int index = this.determineSex(patient) ? 6 : 1;
        this.getList().get((int)(year - this.firstCohort))[index] = (Integer)this.getList().get(year - this.firstCohort)[index] + 1;
    }

    private void add_male(int birthYear, Konsultation cons) {
        this.getList().get((int)(birthYear - this.firstCohort))[7] = (Integer)this.getList().get(birthYear - this.firstCohort)[7] + Double.valueOf(cons.getUmsatz()).intValue();
        this.getList().get((int)(birthYear - this.firstCohort))[8] = (Integer)this.getList().get(birthYear - this.firstCohort)[8] + 1;
    }

    private void add_female(int birthYear, Konsultation cons) {
        this.getList().get((int)(birthYear - this.firstCohort))[2] = (Integer)this.getList().get(birthYear - this.firstCohort)[2] + Double.valueOf(cons.getUmsatz()).intValue();
        this.getList().get((int)(birthYear - this.firstCohort))[3] = (Integer)this.getList().get(birthYear - this.firstCohort)[3] + 1;
    }

    private boolean validate_data(Patient patient) {
        boolean result;
        int actualYear;
        int birthYear = QueryUtil.extractYear(patient.getGeburtsdatum());
        boolean birth = birthYear <= (actualYear = Calendar.getInstance().get(1));
        boolean gender = patient.getGeschlecht().equals("m") || patient.getGeschlecht().equals("w");
        boolean bl = result = birth && gender;
        if (!birth) {
            this.showValidationError(patient);
        }
        return result;
    }

    private void showValidationError(Patient patient) {
        String patientData = "Bei der Auswertung der Patientendaten ist ein Fehler aufgetreten.\nDieser Patient wird in der Auswertung nicht ber\u00fccksichtigt.\n\nFolgender Patient hat ein Geburtsdatum in der Zukunft:\n\n";
        patientData = String.valueOf(patientData) + patient.getLabel();
        SWTHelper.showError((String)"Fehlerhafte Patientendaten", (String)patientData);
    }

    public int getSize() {
        return 0;
    }

    @Override
    public String getDescription() {
        return "Erstellt eine Liste mit der Anzahl an Konsultationen, den totalen sowie den durchschnittlichen Kosten pro Konsultation. Die Kohortengr\u00f6sse ist definiert als die Anzahl Jahrg\u00e4nge, die in einer Kohorte zusammengefasst werden sollen.";
    }

    @Override
    public String getTitle() {
        return "Konsultationsauswertung";
    }

    @GetProperty(value="Kohortengr\u00f6sse", index=2)
    public String getCohortSize() {
        return "" + this.cohortSize;
    }

    @SetProperty(value="Kohortengr\u00f6sse")
    public void setCohortSize(String cohortSize) throws SetDataException {
        Integer size = new Integer(1);
        try {
            size = new Integer(cohortSize);
            if (size < 1) {
                throw new Exception();
            }
            this.cohortSize = size;
        }
        catch (Exception exception) {
            throw new SetDataException("Kohortengr\u00f6sse muss eine positive Ganzzahl sein.");
        }
    }
}

