/*
 * Decompiled with CFR 0.152.
 */
package waelti.statistics.export;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import waelti.statistics.queries.AbstractQuery;
import waelti.statistics.queries.ResultMatrix;

public class CSVWriter {
    private static String delimiter = ";";

    public static File write(AbstractQuery query, String file) throws IOException {
        return CSVWriter.write(query, new File(file));
    }

    public static File write(AbstractQuery query, File file) throws IOException {
        ResultMatrix matrix = query.getMatrix();
        return CSVWriter.writer(matrix, file);
    }

    public static File writer(ResultMatrix matrix, File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        CSVWriter.writeHeading(writer, matrix.getHeadings());
        for (Object[] objects : matrix) {
            CSVWriter.writeRow(writer, objects);
        }
        writer.close();
        return file;
    }

    private static void writeHeading(FileWriter writer, List<String> headings) throws IOException {
        Object[] objects = headings.toArray();
        CSVWriter.writeRow(writer, objects);
    }

    private static void writeRow(FileWriter writer, Object[] objects) throws IOException {
        StringBuffer buf = new StringBuffer();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            buf.append(obj.toString());
            buf.append(delimiter);
            ++n2;
        }
        buf.deleteCharAt(buf.length() - 1);
        buf.append("\n");
        writer.write(buf.toString());
    }
}

