/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.widgets;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import de.kupzog.ktable.KTableCellRenderer;
import de.kupzog.ktable.KTableModel;
import de.kupzog.ktable.renderers.FixedCellRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.iatrix.actions.IatrixEventHelper;
import org.iatrix.data.Problem;
import org.iatrix.util.Constants;
import org.iatrix.util.DateComparator;
import org.iatrix.util.Heartbeat;
import org.iatrix.util.Helpers;
import org.iatrix.util.NumberComparator;
import org.iatrix.util.StatusComparator;
import org.iatrix.views.JournalView;
import org.iatrix.widgets.IJournalArea;
import org.iatrix.widgets.MyKTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProblemsTableModel
implements KTableModel {
    private Patient actPatient;
    private static Logger log = LoggerFactory.getLogger(ProblemsTableModel.class);
    private MyKTable problemsKTable;
    private Color highlightColor;
    private ProblemsTableColorProvider problemsTableColorProvider = new ProblemsTableColorProvider();
    private Object[] problems = null;
    private final Hashtable<Integer, Integer> colWidths = new Hashtable();
    private final Hashtable<Integer, Integer> rowHeights = new Hashtable();
    private final KTableCellRenderer fixedRenderer = new FixedCellRenderer(88);
    private final KTableCellRenderer textRenderer = new ProblemsTableTextCellRenderer();
    private final KTableCellRenderer imageRenderer = new ProblemsTableImageCellRenderer();
    private final KTableCellRenderer therapyRenderer = new ProblemsTableTherapyCellRenderer();
    private static final DateComparator DATE_COMPARATOR = new DateComparator();
    private static final NumberComparator NUMBER_COMPARATOR = new NumberComparator();
    private static final StatusComparator STATUS_COMPARATOR = new StatusComparator();
    private static Comparator<Problem> comparator = new DateComparator();
    private boolean highlightSelection = false;
    private boolean highlightRow = false;
    private boolean heartbeatProblemEnabled = true;
    private Konsultation actKons;

    public void refresh() {
        this.problemsKTable.redraw();
    }

    public void heartbeatProblem() {
        log.debug("heartbeatProblem enabled " + this.heartbeatProblemEnabled);
        if (this.heartbeatProblemEnabled) {
            int rowIndex;
            int row;
            Point[] cells;
            boolean isRowSelectMode = this.problemsKTable.isRowSelectMode();
            Problem selectedProblem = null;
            int currentColumn = -1;
            if (!isRowSelectMode && (cells = this.problemsKTable.getCellSelection()) != null && cells.length > 0) {
                row = cells[0].y;
                int rowIndex2 = row - this.getFixedHeaderRowCount();
                selectedProblem = this.getProblem(rowIndex2);
                currentColumn = cells[0].x;
            }
            if (selectedProblem != null && !isRowSelectMode && (rowIndex = this.getIndexOf(selectedProblem)) >= 0) {
                row = rowIndex + this.getFixedHeaderRowCount();
                if (currentColumn == -1) {
                    currentColumn = this.getFixedHeaderColumnCount();
                }
                this.problemsKTable.setSelection(currentColumn, row, true);
            }
        }
    }

    public Problem getProblem(int index) {
        Object element;
        Problem problem = null;
        if (this.problems != null && index >= 0 && index < this.problems.length && (element = this.problems[index]) instanceof Problem) {
            problem = (Problem)((Object)element);
        }
        return problem;
    }

    public int getIndexOf(Problem problem) {
        if (this.problems != null) {
            int i = 0;
            while (i < this.problems.length) {
                Problem p;
                Object element = this.problems[i];
                if (element instanceof Problem && (p = (Problem)((Object)element)).getId().equals(problem.getId())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int modelIndexToTableIndex(int rowIndex) {
        return rowIndex + this.getFixedHeaderRowCount();
    }

    public int tableIndexToRowIndex(int row) {
        return row - this.getFixedHeaderRowCount();
    }

    public Point belongsToCell(int col, int row) {
        return new Point(col, row);
    }

    public KTableCellEditor getCellEditor(int col, int row) {
        if (row < this.getFixedHeaderRowCount() || col < this.getFixedHeaderColumnCount()) {
            return null;
        }
        int colIndex = col - this.getFixedHeaderColumnCount();
        if (colIndex == 2 || colIndex == 1 || colIndex == 0) {
            return new MyKTableCellEditorText2();
        }
        if (colIndex == 3) {
            return new KTableTherapyCellEditor();
        }
        return null;
    }

    public KTableCellRenderer getCellRenderer(int col, int row) {
        if (row < this.getFixedHeaderRowCount() || col < this.getFixedHeaderColumnCount()) {
            return this.fixedRenderer;
        }
        int colIndex = col - this.getFixedHeaderColumnCount();
        if (colIndex == 5) {
            return this.imageRenderer;
        }
        if (colIndex == 3) {
            return this.therapyRenderer;
        }
        return this.textRenderer;
    }

    public int getColumnCount() {
        return this.getFixedHeaderColumnCount() + Constants.COLUMN_TEXT.length;
    }

    public int getRowCount() {
        this.loadElements();
        return this.getFixedHeaderRowCount() + this.problems.length;
    }

    public int getFixedHeaderColumnCount() {
        return 1;
    }

    public int getFixedSelectableColumnCount() {
        return 0;
    }

    public int getFixedHeaderRowCount() {
        return 1;
    }

    public int getFixedSelectableRowCount() {
        return 0;
    }

    private int getInitialColumnWidth(int col) {
        if (col < this.getFixedHeaderColumnCount()) {
            return 20;
        }
        int colIndex = col - this.getFixedHeaderColumnCount();
        if (colIndex >= 0 && colIndex < Constants.COLUMN_TEXT.length) {
            int width = CoreHub.localCfg.get(Constants.COLUMN_CFG_KEY[colIndex], Constants.DEFAULT_COLUMN_WIDTH[colIndex]);
            return width;
        }
        return 0;
    }

    public int getColumnWidth(int col) {
        Integer width = this.colWidths.get(new Integer(col));
        if (width == null) {
            width = new Integer(this.getInitialColumnWidth(col));
            this.colWidths.put(new Integer(col), width);
        }
        return width;
    }

    private int getHeaderRowHeight() {
        return 22;
    }

    public int getRowHeightMinimum() {
        return 10;
    }

    public int getRowHeight(int row) {
        Integer height = this.rowHeights.get(new Integer(row));
        if (height == null) {
            height = new Integer(this.getOptimalRowHeight(row));
            this.rowHeights.put(new Integer(row), height);
        }
        return height;
    }

    private int getOptimalRowHeight(int row) {
        if (row < this.getFixedHeaderRowCount()) {
            return this.getHeaderRowHeight();
        }
        int height = 0;
        GC gc = new GC((Drawable)this.problemsKTable);
        int i = 0;
        while (i < Constants.COLUMN_TEXT.length) {
            int col = i + this.getFixedHeaderColumnCount();
            int currentHeight = 0;
            Object obj = this.getContentAt(col, row);
            if (obj instanceof String) {
                String text = (String)obj;
                currentHeight = gc.textExtent((String)text).y;
            } else if (obj instanceof Image) {
                Image image = (Image)obj;
                currentHeight = image.getBounds().height;
            } else if (obj instanceof Problem && i == 3) {
                Problem problem = (Problem)((Object)obj);
                ProblemsTableTherapyCellRenderer cellRenderer = (ProblemsTableTherapyCellRenderer)this.getCellRenderer(col, row);
                currentHeight = cellRenderer.getOptimalHeight(gc, problem);
            }
            if (currentHeight > height) {
                height = currentHeight;
            }
            ++i;
        }
        gc.dispose();
        return height;
    }

    public void setColumnWidth(int col, int width) {
        this.colWidths.put(new Integer(col), new Integer(width));
        int colIndex = col - this.getFixedHeaderColumnCount();
        if (colIndex >= 0 && colIndex < Constants.COLUMN_TEXT.length) {
            CoreHub.localCfg.set(Constants.COLUMN_CFG_KEY[colIndex], width);
        }
    }

    public void setRowHeight(int row, int height) {
        this.rowHeights.put(new Integer(row), new Integer(height));
    }

    private void loadElements() {
        if (this.problems == null) {
            ArrayList<Object> elements = new ArrayList<Object>();
            if (this.actPatient != null) {
                List<Problem> problems = Problem.getProblemsOfPatient(this.actPatient);
                if (comparator != null) {
                    Collections.sort(problems, comparator);
                }
                elements.addAll(problems);
                elements.add(new DummyProblem());
            }
            this.problems = elements.toArray();
        }
    }

    private void addElement(Object element) {
        Object[] newProblems = new Object[this.problems.length + 1];
        System.arraycopy(this.problems, 0, newProblems, 0, this.problems.length);
        newProblems[newProblems.length - 1] = element;
    }

    public void reload() {
        this.problems = null;
        this.rowHeights.clear();
    }

    private Object getHeaderContentAt(int col) {
        int colIndex = col - this.getFixedHeaderColumnCount();
        if (colIndex >= 0 && colIndex < Constants.COLUMN_TEXT.length) {
            return Constants.COLUMN_TEXT[colIndex];
        }
        return "";
    }

    public Object getContentAt(int col, int row) {
        if (row < this.getFixedHeaderRowCount()) {
            return this.getHeaderContentAt(col);
        }
        this.loadElements();
        int colIndex = col - this.getFixedHeaderColumnCount();
        int rowIndex = row - this.getFixedHeaderRowCount();
        if (rowIndex >= 0 && rowIndex < this.problems.length) {
            Object element = this.problems[rowIndex];
            if (element instanceof Problem) {
                Problem problem = (Problem)((Object)element);
                switch (colIndex) {
                    case 2: {
                        return problem.getTitle();
                    }
                    case 1: {
                        return problem.getNumber();
                    }
                    case 0: {
                        return problem.getStartDate();
                    }
                    case 4: {
                        String diagnosen = problem.getDiagnosenAsText();
                        String lineSeparator = System.getProperty("line.separator");
                        String text = diagnosen.replaceAll("::", lineSeparator);
                        return text;
                    }
                    case 3: {
                        return problem;
                    }
                    case 5: {
                        if (problem.getStatus() == 1) {
                            return UiDesk.getImage((String)"org.iatrix_active");
                        }
                        return UiDesk.getImage((String)"org.iatrix_inactive");
                    }
                }
                return "";
            }
            if (col < this.getFixedHeaderColumnCount()) {
                return "*";
            }
            return "";
        }
        return "";
    }

    public String getTooltipAt(int col, int row) {
        if (col < Constants.TOOLTIP_TEXT.length) {
            return Constants.TOOLTIP_TEXT[col];
        }
        return "Tooltip f\u00fcr col " + col;
    }

    public boolean isColumnResizable(int col) {
        return true;
    }

    public boolean isRowResizable(int row) {
        return true;
    }

    public void setContentAt(int col, int row, Object value) {
        if (this.problems == null) {
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        String text = (String)value;
        int colIndex = col - this.getFixedHeaderColumnCount();
        int rowIndex = row - this.getFixedHeaderRowCount();
        if (rowIndex >= 0 && rowIndex < this.problems.length) {
            Problem problem;
            boolean isNew = false;
            if (this.problems[rowIndex] instanceof Problem) {
                problem = (Problem)((Object)this.problems[rowIndex]);
            } else {
                if (this.actPatient == null) {
                    return;
                }
                problem = new Problem(this.actPatient, "");
                String currentDate = new TimeTool().toString(6);
                problem.setStartDate(currentDate);
                IatrixEventHelper.fireSelectionEventProblem(problem);
                this.problems[rowIndex] = problem;
                this.addElement(new DummyProblem());
                isNew = true;
            }
            switch (colIndex) {
                case 2: {
                    problem.setTitle(text);
                    break;
                }
                case 1: {
                    problem.setNumber(text);
                    break;
                }
                case 0: {
                    problem.setStartDate(text);
                    break;
                }
                case 3: {
                    problem.setProcedere(text);
                }
            }
            if (isNew) {
                this.reload();
                this.refresh();
                this.problemsKTable.refresh();
            }
            log.debug("setContentAt row {} col {} set to '{}' value {}", new Object[]{rowIndex, colIndex, problem, value});
            JournalView.updateKonsProblems(this.actKons.getFall().getPatient(), this.actKons, IJournalArea.KonsActions.EVENT_UPDATE);
        }
    }

    public void setComparator(int col, int row) {
        if (row < this.getFixedHeaderRowCount()) {
            int colIndex = col - this.getFixedHeaderColumnCount();
            switch (colIndex) {
                case 0: {
                    comparator = DATE_COMPARATOR;
                    break;
                }
                case 1: {
                    comparator = NUMBER_COMPARATOR;
                    break;
                }
                case 5: {
                    comparator = STATUS_COMPARATOR;
                }
            }
        }
    }

    public void setHighlightSelection(boolean highlight, boolean row) {
        this.highlightSelection = highlight;
        this.highlightRow = row;
    }

    public boolean isHighlightSelection() {
        return this.highlightSelection;
    }

    public boolean isHighlightRow() {
        return this.highlightSelection && this.highlightRow;
    }

    public KTable getProblemsKTable() {
        return this.problemsKTable;
    }

    public void setProblemsKTable(MyKTable problemsKTable2) {
        this.problemsKTable = problemsKTable2;
    }

    public void setKons(Patient newPatient, Konsultation newKons) {
        Helpers.checkActPatKons(newPatient, newKons);
        log.debug("newPat " + (newPatient == null ? "null" : newPatient.getPersonalia()) + " newKons " + (newKons == null ? "null" : newKons.getDatum()));
        this.actKons = newKons;
        this.actPatient = newPatient;
    }

    abstract class BaseCellEditor
    extends KTableCellEditor {
        BaseCellEditor() {
        }

        public void open(KTable table, int col, int row, Rectangle rect) {
            Heartbeat.getInstance().setHeartbeatProblemEnabled(false);
            super.open(table, col, row, rect);
        }

        public void close(boolean save) {
            super.close(save);
            Heartbeat.getInstance().setHeartbeatProblemEnabled(true);
        }
    }

    static class DummyProblem {
        DummyProblem() {
        }
    }

    public class KTableDiagnosisCellEditor
    extends BaseCellEditor {
        private Combo combo;
        private final KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                try {
                    KTableDiagnosisCellEditor.this.onKeyPressed(e);
                }
                catch (Exception exception) {}
            }
        };
        private final TraverseListener travListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                KTableDiagnosisCellEditor.this.onTraverse(e);
            }
        };

        @Override
        public void open(KTable table, int col, int row, Rectangle rect) {
            super.open(table, col, row, rect);
            String text = "";
            Object obj = this.m_Model.getContentAt(this.m_Col, this.m_Row);
            if (obj instanceof Problem) {
                text = "test";
            }
            this.combo.setText(text);
            this.combo.setVisible(true);
            this.combo.setFocus();
        }

        @Override
        public void close(boolean save) {
            if (save) {
                this.m_Model.setContentAt(this.m_Col, this.m_Row, (Object)this.combo.getText());
            }
            this.combo.removeKeyListener((KeyListener)this.keyListener);
            this.combo.removeTraverseListener(this.travListener);
            this.combo = null;
            super.close(save);
        }

        protected Control createControl() {
            this.combo = new Combo((Composite)this.m_Table, 4);
            this.combo.addKeyListener((KeyListener)this.keyListener);
            this.combo.addTraverseListener(this.travListener);
            return this.combo;
        }

        protected void onTraverse(TraverseEvent e) {
            if (e.keyCode != 0x1000003 && e.keyCode != 0x1000004) {
                super.onTraverse(e);
            }
        }

        public void setBounds(Rectangle rect) {
            super.setBounds(new Rectangle(rect.x, rect.y, rect.width, rect.height));
        }

        public void setContent(Object content) {
            this.combo.setText(content.toString());
        }
    }

    public class KTableTherapyCellEditor
    extends BaseCellEditor {
        private Text m_Text;
        private final KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                try {
                    KTableTherapyCellEditor.this.onKeyPressed(e);
                }
                catch (Exception exception) {}
            }
        };
        private final TraverseListener travListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                KTableTherapyCellEditor.this.onTraverse(e);
            }
        };

        @Override
        public void open(KTable table, int col, int row, Rectangle rect) {
            super.open(table, col, row, rect);
            String text = "";
            Object obj = this.m_Model.getContentAt(this.m_Col, this.m_Row);
            if (obj instanceof Problem) {
                Problem problem = (Problem)((Object)obj);
                text = problem.getProcedere();
            }
            this.m_Text.setText(PersistentObject.checkNull((Object)text));
            this.m_Text.selectAll();
            this.m_Text.setVisible(true);
            this.m_Text.setFocus();
        }

        @Override
        public void close(boolean save) {
            if (this.m_Model != null) {
                if (this.m_Text != null) {
                    if (save) {
                        this.m_Model.setContentAt(this.m_Col, this.m_Row, (Object)this.m_Text.getText());
                    }
                    if (this.m_Text != null) {
                        this.m_Text.removeKeyListener((KeyListener)this.keyListener);
                    }
                    if (this.m_Text != null) {
                        this.m_Text.removeTraverseListener(this.travListener);
                    }
                }
                this.m_Text = null;
            }
            super.close(save);
        }

        protected Control createControl() {
            this.m_Text = new Text((Composite)this.m_Table, 514);
            this.m_Text.addKeyListener((KeyListener)this.keyListener);
            this.m_Text.addTraverseListener(this.travListener);
            return this.m_Text;
        }

        protected void onTraverse(TraverseEvent e) {
            if (e.keyCode != 0x1000003 && e.keyCode != 0x1000004) {
                super.onTraverse(e);
            }
        }

        public void setBounds(Rectangle rect) {
            super.setBounds(new Rectangle(rect.x, rect.y, rect.width, rect.height));
        }

        public void setContent(Object content) {
            this.m_Text.setText(content.toString());
            this.m_Text.setSelection(content.toString().length());
        }
    }

    public class MyKTableCellEditorText2
    extends BaseCellEditor {
        protected Text m_Text;
        protected KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                try {
                    MyKTableCellEditorText2.this.onKeyPressed(e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        protected TraverseListener travListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                MyKTableCellEditorText2.this.onTraverse(e);
            }
        };

        @Override
        public void open(KTable table, int col, int row, Rectangle rect) {
            super.open(table, col, row, rect);
            this.m_Text.setText(this.m_Model.getContentAt(this.m_Col, this.m_Row).toString());
            this.m_Text.selectAll();
            this.m_Text.setVisible(true);
            this.m_Text.setFocus();
        }

        @Override
        public void close(boolean save) {
            if (save && this.m_Text != null) {
                this.m_Model.setContentAt(this.m_Col, this.m_Row, (Object)this.m_Text.getText());
            }
            if (this.m_Text != null) {
                this.m_Text.removeKeyListener((KeyListener)this.keyListener);
            }
            if (this.m_Text != null) {
                this.m_Text.removeTraverseListener(this.travListener);
            }
            super.close(save);
            this.m_Text = null;
        }

        protected Control createControl() {
            this.m_Text = new Text((Composite)this.m_Table, 0);
            this.m_Text.addKeyListener((KeyListener)this.keyListener);
            this.m_Text.addTraverseListener(this.travListener);
            return this.m_Text;
        }

        protected void onTraverse(TraverseEvent e) {
            if (e.keyCode != 0x1000003 && e.keyCode != 0x1000004) {
                super.onTraverse(e);
            }
        }

        protected void onKeyPressed(KeyEvent e) {
            if (e.character == '\r' && (e.stateMask & 0x20000) == 0) {
                this.close(true);
            } else {
                super.onKeyPressed(e);
            }
        }

        public void setContent(Object content) {
            this.m_Text.setText(content.toString());
            this.m_Text.setSelection(content.toString().length());
        }
    }

    abstract class ProblemsTableCellRendererBase
    implements KTableCellRenderer {
        ProblemsTableCellRendererBase() {
        }

        protected Problem getSelectedProblem() {
            Point[] selection = ProblemsTableModel.this.problemsKTable.getCellSelection();
            if (selection == null || selection.length == 0) {
                return null;
            }
            int rowIndex = selection[0].y - ProblemsTableModel.this.getFixedHeaderRowCount();
            Problem problem = ProblemsTableModel.this.getProblem(rowIndex);
            return problem;
        }

        protected boolean isSelected(int row) {
            block6: {
                block5: {
                    if (!ProblemsTableModel.this.problemsKTable.isRowSelectMode()) break block5;
                    int[] selectedRows = ProblemsTableModel.this.problemsKTable.getRowSelection();
                    if (selectedRows == null) break block6;
                    int[] nArray = selectedRows;
                    int n = selectedRows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int r = nArray[n2];
                        if (r == row) {
                            return true;
                        }
                        ++n2;
                    }
                    break block6;
                }
                Point[] selectedCells = ProblemsTableModel.this.problemsKTable.getCellSelection();
                if (selectedCells != null) {
                    Point[] pointArray = selectedCells;
                    int n = selectedCells.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Point cell = pointArray[n3];
                        if (cell.y == row) {
                            return true;
                        }
                        ++n3;
                    }
                }
            }
            return false;
        }
    }

    class ProblemsTableColorProvider {
        ProblemsTableColorProvider() {
        }

        public Color getForegroundColor(int col, int row) {
            int rowIndex = row - ProblemsTableModel.this.getFixedHeaderRowCount();
            Problem problem = ProblemsTableModel.this.getProblem(rowIndex);
            if (problem != null && problem.getStatus() == 1) {
                return Display.getCurrent().getSystemColor(2);
            }
            return Display.getCurrent().getSystemColor(15);
        }
    }

    class ProblemsTableImageCellRenderer
    extends ProblemsTableCellRendererBase {
        private final Display display = Display.getCurrent();

        public int getOptimalWidth(GC gc, int col, int row, Object content, boolean fixed, KTableModel model) {
            if (content instanceof Image) {
                Image image = (Image)content;
                return image.getBounds().width;
            }
            return 0;
        }

        public void drawCell(GC gc, Rectangle rect, int col, int row, Object content, boolean focus, boolean fixed, boolean clicked, KTableModel model) {
            ProblemsTableModel.this.highlightColor = this.display.getSystemColor(26);
            Image image = null;
            if (content instanceof Image) {
                image = (Image)content;
            }
            Color backColor = this.isSelected(row) && ((ProblemsTableModel)model).isHighlightRow() ? ProblemsTableModel.this.highlightColor : (focus && ((ProblemsTableModel)model).isHighlightSelection() ? ProblemsTableModel.this.highlightColor : this.display.getSystemColor(25));
            Color borderColor = this.display.getSystemColor(22);
            gc.setForeground(borderColor);
            gc.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
            gc.setForeground(borderColor);
            gc.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
            gc.setBackground(backColor);
            gc.fillRectangle(rect);
            if (image != null) {
                Rectangle imageBounds = image.getBounds();
                int imageWidth = imageBounds.width;
                int imageHeight = imageBounds.height;
                int xOffset = (rect.width - imageWidth) / 2;
                int yOffset = (rect.height - imageHeight) / 2;
                Rectangle oldClipping = gc.getClipping();
                gc.setClipping(rect);
                gc.drawImage(image, rect.x + xOffset, rect.y + yOffset);
                gc.setClipping(oldClipping);
            }
            if (focus) {
                gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    class ProblemsTableTextCellRenderer
    extends ProblemsTableCellRendererBase {
        private final Display display = Display.getCurrent();

        public int getOptimalWidth(GC gc, int col, int row, Object content, boolean fixed, KTableModel model) {
            if (content instanceof String) {
                String text = (String)content;
                return gc.textExtent((String)text).x + 8;
            }
            return 0;
        }

        public void drawCell(GC gc, Rectangle rect, int col, int row, Object content, boolean focus, boolean fixed, boolean clicked, KTableModel model) {
            String text = content instanceof String ? (String)content : "";
            Color textColor = focus ? this.display.getSystemColor(9) : ProblemsTableModel.this.problemsTableColorProvider.getForegroundColor(col, row);
            Color backColor = this.display.getSystemColor(25);
            ProblemsTableModel.this.highlightColor = this.display.getSystemColor(29);
            if (this.isSelected(row) && ((ProblemsTableModel)model).isHighlightRow()) {
                backColor = ProblemsTableModel.this.highlightColor;
            } else if (focus && ((ProblemsTableModel)model).isHighlightSelection()) {
                backColor = ProblemsTableModel.this.highlightColor;
            }
            Color borderColor = this.display.getSystemColor(22);
            gc.setForeground(borderColor);
            gc.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
            gc.setForeground(borderColor);
            gc.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
            gc.setBackground(backColor);
            gc.setForeground(textColor);
            gc.fillRectangle(rect);
            Rectangle oldClipping = gc.getClipping();
            gc.setClipping(rect);
            gc.drawText(text, rect.x + 3, rect.y);
            gc.setClipping(oldClipping);
            if (focus) {
                gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    class ProblemsTableTherapyCellRenderer
    extends ProblemsTableCellRendererBase {
        private static final int MARGIN = 8;
        private static final int PADDING = 3;
        private final Display display = Display.getCurrent();

        private boolean hasPrescriptions(Problem problem) {
            List<Prescription> prescriptions = problem.getPrescriptions();
            return prescriptions.size() > 0;
        }

        private boolean hasProcedere(Problem problem) {
            return !StringTool.isNothing((Object)PersistentObject.checkNull((Object)problem.getProcedere()));
        }

        private String getPrescriptionsText(Problem problem) {
            String prescriptions = PersistentObject.checkNull((Object)problem.getPrescriptionsAsText());
            String lineSeparator = System.getProperty("line.separator");
            String prescriptionsText = prescriptions.replaceAll("::", lineSeparator);
            return prescriptionsText;
        }

        private String getProcedereText(Problem problem) {
            return PersistentObject.checkNull((Object)problem.getProcedere());
        }

        public int getOptimalHeight(GC gc, Problem problem) {
            int height = 0;
            int prescriptionsHeight = 0;
            if (this.hasPrescriptions(problem)) {
                String prescriptionsText = this.getPrescriptionsText(problem);
                prescriptionsHeight = gc.textExtent((String)prescriptionsText).y;
            }
            int procedereHeight = 0;
            if (this.hasProcedere(problem)) {
                String procedereText = this.getProcedereText(problem);
                procedereHeight = gc.textExtent((String)procedereText).y;
            }
            if (prescriptionsHeight > 0 && procedereHeight > 0) {
                height = prescriptionsHeight + 3 + procedereHeight;
            } else if (prescriptionsHeight > 0) {
                height = prescriptionsHeight;
            } else if (procedereHeight > 0) {
                height = procedereHeight;
            }
            if (height == 0) {
                height = gc.textExtent((String)"").y;
            }
            return height;
        }

        public int getOptimalWidth(GC gc, int col, int row, Object content, boolean fixed, KTableModel model) {
            if (content instanceof Problem) {
                Problem problem = (Problem)((Object)content);
                String prescriptionsText = this.getPrescriptionsText(problem);
                String procedereText = this.getProcedereText(problem);
                int width1 = gc.textExtent((String)prescriptionsText).x;
                int width2 = gc.textExtent((String)procedereText).x;
                int width = Math.max(width1, width2);
                return width + 8;
            }
            return 0;
        }

        public void drawCell(GC gc, Rectangle rect, int col, int row, Object content, boolean focus, boolean fixed, boolean clicked, KTableModel model) {
            String prescriptionsText = "";
            String procedereText = "";
            boolean hasPrescriptions = false;
            boolean hasProcedere = false;
            if (content instanceof Problem) {
                Problem problem = (Problem)((Object)content);
                prescriptionsText = this.getPrescriptionsText(problem);
                procedereText = this.getProcedereText(problem);
                hasPrescriptions = this.hasPrescriptions(problem);
                hasProcedere = this.hasProcedere(problem);
            }
            Color textColor = focus ? this.display.getSystemColor(9) : ProblemsTableModel.this.problemsTableColorProvider.getForegroundColor(col, row);
            Color backColor = this.isSelected(row) && ((ProblemsTableModel)model).isHighlightRow() ? ProblemsTableModel.this.highlightColor : (focus && ((ProblemsTableModel)model).isHighlightSelection() ? ProblemsTableModel.this.highlightColor : this.display.getSystemColor(25));
            Color borderColor = this.display.getSystemColor(22);
            gc.setForeground(borderColor);
            gc.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
            gc.setForeground(borderColor);
            gc.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
            gc.setBackground(backColor);
            gc.setForeground(textColor);
            gc.fillRectangle(rect);
            Rectangle oldClipping = gc.getClipping();
            gc.setClipping(rect);
            if (hasPrescriptions && hasProcedere) {
                int prescriptionsHeight = gc.textExtent((String)prescriptionsText).y;
                gc.setForeground(borderColor);
                gc.drawLine(rect.x, rect.y + prescriptionsHeight + 1, rect.x + rect.width, rect.y + prescriptionsHeight + 1);
                gc.setBackground(backColor);
                gc.setForeground(textColor);
                gc.drawText(prescriptionsText, rect.x + 3, rect.y);
                gc.drawText(procedereText, rect.x + 3, rect.y + prescriptionsHeight + 3);
            } else {
                String text = hasPrescriptions ? prescriptionsText : (hasProcedere ? procedereText : "");
                gc.setBackground(backColor);
                gc.setForeground(textColor);
                gc.drawText(text, rect.x + 3, rect.y);
            }
            gc.setClipping(oldClipping);
            if (focus) {
                gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

