/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.widgets;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.dialogs.MediDetailDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.ListDisplay;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.core.ui.util.PersistentObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.RezeptBlatt;
import ch.elexis.data.Artikel;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.elexis.data.Rezept;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IViewSite;
import org.iatrix.Messages;
import org.iatrix.actions.IatrixEventHelper;
import org.iatrix.data.Problem;

public class ProblemFixMediDisplay
extends ListDisplay<Prescription> {
    private static final String TTCOST = Messages.FixMediDisplay_DailyCost;
    private final ListDisplay.LDListener dlisten;
    private IAction stopMedicationAction;
    private IAction changeMedicationAction;
    private IAction removeMedicationAction;
    ProblemFixMediDisplay self;
    Label lCost = new Label((Composite)this, 0);
    PersistentObjectDropTarget target;
    static final String REZEPT = Messages.FixMediDisplay_Prescription;
    static final String LISTE = Messages.FixMediDisplay_UsageList;
    static final String HINZU = Messages.FixMediDisplay_AddItem;
    static final String KOPIEREN = Messages.FixMediDisplay_Copy;

    public org.eclipse.swt.widgets.List getList() {
        return this.list;
    }

    public ProblemFixMediDisplay(Composite parent, IViewSite s) {
        super(parent, 0, null);
        this.lCost.setText(TTCOST);
        this.lCost.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.dlisten = new DauerMediListener(s);
        this.self = this;
        this.addHyperlinks(new String[]{HINZU, LISTE, REZEPT});
        this.makeActions();
        ViewMenus menu = new ViewMenus(s);
        menu.createControlContextMenu((Control)this.list, new IAction[]{this.stopMedicationAction, this.changeMedicationAction, null, this.removeMedicationAction});
        this.setDLDListener(this.dlisten);
        this.target = new PersistentObjectDropTarget(Messages.FixMediDisplay_FixMedikation, (Control)this, new PersistentObjectDropTarget.IReceiver(){

            public boolean accept(PersistentObject o) {
                if (o instanceof Prescription) {
                    return true;
                }
                return o instanceof Artikel;
            }

            public void dropped(PersistentObject o, DropTargetEvent e) {
                Problem problem = IatrixEventHelper.getSelectedProblem();
                if (problem != null) {
                    if (o instanceof Artikel) {
                        Artikel artikel = (Artikel)o;
                        Prescription prescription = new Prescription(artikel, problem.getPatient(), "", "");
                        prescription.set("DateFrom", new TimeTool().toString(4));
                        problem.addPrescription(prescription);
                        MediDetailDialog dlg = new MediDetailDialog(ProblemFixMediDisplay.this.getShell(), prescription);
                        dlg.open();
                        IatrixEventHelper.updateProblem(problem);
                        ProblemFixMediDisplay.this.reload();
                    } else if (o instanceof Prescription) {
                        Prescription pre = (Prescription)o;
                        List<Prescription> existing = problem.getPrescriptions();
                        for (Prescription prescription : existing) {
                            if (!prescription.equals((Object)pre)) continue;
                            return;
                        }
                        Prescription now = new Prescription(pre.getArtikel(), problem.getPatient(), pre.getDosis(), pre.getBemerkung());
                        now.set("DateFrom", new TimeTool().toString(4));
                        problem.addPrescription(now);
                        IatrixEventHelper.updateProblem(problem);
                        ProblemFixMediDisplay.this.reload();
                    }
                } else {
                    SWTHelper.alert((String)Messages.ProblemFixMediDisplay_AlertNoProblemSelectedTitle, (String)Messages.ProblemFixMediDisplay_AlertNoProblemSelectedText);
                }
            }
        });
        new PersistentObjectDragSource((Control)this.list, new PersistentObjectDragSource.ISelectionRenderer(){

            public List<PersistentObject> getSelection() {
                Prescription pr = (Prescription)ProblemFixMediDisplay.this.getSelection();
                ArrayList<PersistentObject> ret = new ArrayList<PersistentObject>(1);
                if (pr != null) {
                    ret.add((PersistentObject)pr);
                }
                return ret;
            }
        });
    }

    public void reload() {
        this.clear();
        Problem problem = IatrixEventHelper.getSelectedProblem();
        Patient patient = ElexisEventDispatcher.getSelectedPatient();
        if (problem != null && patient != null && !problem.getPatient().getId().equals(patient.getId())) {
            problem = null;
        }
        double cost = 0.0;
        boolean canCalculate = true;
        if (problem != null) {
            List<Prescription> pre = problem.getPrescriptions();
            for (Prescription pr : pre) {
                float num = 0.0f;
                try {
                    String dosis = pr.getDosis();
                    if (dosis != null) {
                        if (dosis.matches("[0-9]+[xX][0-9]+(/[0-9]+)?")) {
                            String[] dose = dosis.split("[xX]");
                            int count = Integer.parseInt(dose[0]);
                            num = this.getNum(dose[1]) * (float)count;
                        } else if (dosis.indexOf(45) != -1) {
                            String[] dos = dosis.split("-");
                            if (dos.length > 2) {
                                String[] stringArray = dos;
                                int n = dos.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String d = stringArray[n2];
                                    num += this.getNum(d);
                                    ++n2;
                                }
                            } else {
                                num = this.getNum(dos[1]);
                            }
                        } else {
                            canCalculate = false;
                        }
                    } else {
                        canCalculate = false;
                    }
                    Artikel art = pr.getArtikel();
                    if (art != null) {
                        int ve = art.guessVE();
                        if (ve != 0) {
                            Money price = pr.getArtikel().getVKPreis();
                            cost += (double)num * price.getAmount() / (double)ve;
                        } else {
                            canCalculate = false;
                        }
                    } else {
                        canCalculate = false;
                    }
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    canCalculate = false;
                }
                this.add(pr);
            }
            double rounded = (double)Math.round(100.0 * cost) / 100.0;
            if (canCalculate) {
                this.lCost.setText(String.valueOf(TTCOST) + Double.toString(rounded));
            } else if (rounded == 0.0) {
                this.lCost.setText(String.valueOf(TTCOST) + "?");
            } else {
                this.lCost.setText(String.valueOf(TTCOST) + ">" + Double.toString(rounded));
            }
        }
    }

    private float getNum(String n) {
        if (n.indexOf(47) != -1) {
            String[] bruch = n.split("/");
            float zaehler = Float.parseFloat(bruch[0]);
            float nenner = Float.parseFloat(bruch[1]);
            return zaehler / nenner;
        }
        return Float.parseFloat(n);
    }

    private void makeActions() {
        this.changeMedicationAction = new RestrictedAction(AccessControlDefaults.MEDICATION_MODIFY, Messages.FixMediDisplay_Change){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.FixMediDisplay_Modify);
            }

            public void doRun() {
                Prescription pr = (Prescription)ProblemFixMediDisplay.this.getSelection();
                if (pr != null) {
                    new MediDetailDialog(ProblemFixMediDisplay.this.getShell(), pr).open();
                    ProblemFixMediDisplay.this.reload();
                    ProblemFixMediDisplay.this.redraw();
                    IatrixEventHelper.updateProblem(IatrixEventHelper.getSelectedProblem());
                }
            }
        };
        this.stopMedicationAction = new RestrictedAction(AccessControlDefaults.MEDICATION_MODIFY, Messages.FixMediDisplay_Stop){
            {
                this.setImageDescriptor(Images.IMG_REMOVEITEM.getImageDescriptor());
                this.setToolTipText(Messages.FixMediDisplay_StopThisMedicament);
            }

            public void doRun() {
                Prescription pr = (Prescription)ProblemFixMediDisplay.this.getSelection();
                if (pr != null) {
                    ProblemFixMediDisplay.this.remove(pr);
                    pr.delete();
                    ProblemFixMediDisplay.this.reload();
                    IatrixEventHelper.updateProblem(IatrixEventHelper.getSelectedProblem());
                }
            }
        };
        this.removeMedicationAction = new RestrictedAction(AccessControlDefaults.DELETE_MEDICATION, Messages.FixMediDisplay_Delete){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.FixMediDisplay_DeleteUnrecoverable);
            }

            public void doRun() {
                Prescription pr = (Prescription)ProblemFixMediDisplay.this.getSelection();
                if (pr != null) {
                    Problem problem = IatrixEventHelper.getSelectedProblem();
                    if (problem != null) {
                        problem.removePrescription(pr);
                    }
                    ProblemFixMediDisplay.this.remove(pr);
                    pr.remove();
                    IatrixEventHelper.updateProblem(problem);
                    ProblemFixMediDisplay.this.reload();
                }
            }
        };
    }

    class DauerMediListener
    implements ListDisplay.LDListener {
        IViewSite site;

        DauerMediListener(IViewSite s) {
            this.site = s;
        }

        public void hyperlinkActivated(String l) {
            try {
                if (l.equals(HINZU)) {
                    this.site.getPage().showView("ch.elexis.LeistungenView");
                    if (ProblemFixMediDisplay.this.target != null) {
                        CodeSelectorHandler.getInstance().setCodeSelectorTarget((ICodeSelectorTarget)ProblemFixMediDisplay.this.target);
                    }
                } else if (l.equals(LISTE)) {
                    RezeptBlatt rpb = (RezeptBlatt)this.site.getPage().showView("ch.elexis.RezeptBlatt");
                    rpb.createEinnahmeliste(ElexisEventDispatcher.getSelectedPatient(), ProblemFixMediDisplay.this.getAll().toArray(new Prescription[0]));
                } else if (l.equals(REZEPT)) {
                    Rezept rp = new Rezept(ElexisEventDispatcher.getSelectedPatient());
                    Prescription[] prescriptionArray = ProblemFixMediDisplay.this.getAll().toArray(new Prescription[0]);
                    int n = prescriptionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Prescription p = prescriptionArray[n2];
                        rp.addPrescription(new Prescription(p));
                        ++n2;
                    }
                    RezeptBlatt rpb = (RezeptBlatt)this.site.getPage().showView("ch.elexis.RezeptBlatt");
                    rpb.createRezept(rp);
                } else if (l.equals(KOPIEREN)) {
                    ProblemFixMediDisplay.this.toClipBoard(true);
                }
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
            }
        }

        public String getLabel(Object o) {
            if (o instanceof Prescription) {
                return ((Prescription)o).getLabel();
            }
            return o.toString();
        }
    }
}

