/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.widgets;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.dialogs.MediDetailDialog;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.data.Artikel;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellDoubleClickListener;
import de.kupzog.ktable.KTableCellEditor;
import de.kupzog.ktable.KTableCellSelectionListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.iatrix.actions.IatrixEventHelper;
import org.iatrix.data.Problem;
import org.iatrix.util.Heartbeat;
import org.iatrix.util.Helpers;
import org.iatrix.widgets.IJournalArea;
import org.iatrix.widgets.MyKTable;
import org.iatrix.widgets.ProblemsTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProblemArea
implements IJournalArea {
    private ProblemsTableModel problemsTableModel;
    private MyKTable problemsKTable;
    private static Logger log = LoggerFactory.getLogger(ProblemArea.class);
    private ICodeSelectorTarget problemFixmedikationCodeSelectorTarget;
    private ICodeSelectorTarget problemDiagnosesCodeSelectorTarget;
    private String journalViewPartName;
    public Action addProblemAction;
    public Action delProblemAction;
    public Action addFixmedikationAction;
    public Action deleteFixmedikationAction;
    public Action editFixmedikationAction;
    private FormToolkit tk = UiDesk.getToolkit();
    private Patient actPat = null;
    private boolean heartbeatProblemEnabled;

    public ProblemArea(Composite topArea, String partName, final IViewSite viewSite) {
        this.journalViewPartName = partName;
        this.problemsKTable = new MyKTable(topArea, -1073477888);
        this.tk.adapt((Composite)this.problemsKTable);
        this.problemsTableModel = new ProblemsTableModel();
        this.problemsTableModel.setProblemsKTable(this.problemsKTable);
        this.problemsKTable.setModel(this.problemsTableModel);
        this.makeActions(viewSite);
        log.debug("addProblemAction is : " + this.addProblemAction);
        this.problemsKTable.addCellSelectionListener(new KTableCellSelectionListener(){

            public void cellSelected(int col, int row, int statemask) {
                int rowIndex = row - ProblemArea.this.problemsTableModel.getFixedHeaderRowCount();
                Problem problem = ProblemArea.this.problemsTableModel.getProblem(rowIndex);
                if (problem != null) {
                    IatrixEventHelper.fireSelectionEventProblem(problem);
                } else {
                    IatrixEventHelper.clearSelectionProblem();
                }
            }

            public void fixedCellSelected(int col, int row, int statemask) {
                ProblemArea.this.problemsTableModel.setComparator(col, row);
                ProblemArea.this.reloadAndRefresh();
            }
        });
        this.registerUpdateHeartbeat();
        this.problemsKTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                block16: {
                    block17: {
                        block15: {
                            if (e.keyCode != 27) break block15;
                            ProblemArea.this.problemsKTable.clearSelection();
                            ProblemArea.this.problemsKTable.redraw();
                            IatrixEventHelper.clearSelectionProblem();
                            break block16;
                        }
                        if (e.character != ' ' && e.character != '\r') break block16;
                        if ((e.stateMask & 0x40000) != 0) break block17;
                        Point[] selection = ProblemArea.this.problemsKTable.getCellSelection();
                        if (selection.length != 1) break block16;
                        int col = selection[0].x;
                        int row = selection[0].y;
                        int colIndex = col - ProblemArea.this.problemsTableModel.getFixedHeaderColumnCount();
                        int rowIndex = row - ProblemArea.this.problemsTableModel.getFixedHeaderRowCount();
                        Problem problem = ProblemArea.this.problemsTableModel.getProblem(rowIndex);
                        switch (colIndex) {
                            case 4: {
                                if (problem != null && ProblemArea.this.problemDiagnosesCodeSelectorTarget != null) {
                                    try {
                                        log.debug("doe problemDiagnosesCodeSelectorTarget");
                                        viewSite.getPage().showView("ch.elexis.DiagnosenView");
                                        CodeSelectorHandler.getInstance().setCodeSelectorTarget(ProblemArea.this.problemDiagnosesCodeSelectorTarget);
                                    }
                                    catch (Exception ex) {
                                        ExHandler.handle((Throwable)ex);
                                        log.error("Fehler beim Starten des Diagnosencodes " + ex.getMessage());
                                    }
                                    break;
                                }
                                break block16;
                            }
                            case 5: {
                                if (problem == null) break block16;
                                if (problem.getStatus() == 1) {
                                    problem.setStatus(0);
                                    break;
                                }
                                problem.setStatus(1);
                            }
                            default: {
                                break;
                            }
                            {
                                break block16;
                            }
                        }
                        break block16;
                    }
                    Point[] selection = ProblemArea.this.problemsKTable.getCellSelection();
                    if (selection.length == 1) {
                        int col = selection[0].x;
                        int row = selection[0].y;
                        int colIndex = col - ProblemArea.this.problemsTableModel.getFixedHeaderColumnCount();
                        switch (colIndex) {
                            case 4: {
                                KTableCellEditor editor = ProblemArea.this.problemsTableModel.getCellEditor(col, row);
                                if (editor == null || (editor.getActivationSignals() & 0x10) == 0 || !editor.isApplicable(16, (KTable)ProblemArea.this.problemsKTable, col, row, null, String.valueOf(e.character), e.stateMask)) break;
                                ProblemArea.this.problemsKTable.openEditorInFocus();
                            }
                        }
                    }
                }
            }
        });
        this.problemsKTable.addCellDoubleClickListener(new KTableCellDoubleClickListener(){

            public void cellDoubleClicked(int col, int row, int statemask) {
                int colIndex = col - ProblemArea.this.problemsTableModel.getFixedHeaderColumnCount();
                int rowIndex = row - ProblemArea.this.problemsTableModel.getFixedHeaderRowCount();
                Problem problem = ProblemArea.this.problemsTableModel.getProblem(rowIndex);
                switch (colIndex) {
                    case 4: {
                        if (problem == null || ProblemArea.this.problemDiagnosesCodeSelectorTarget == null) break;
                        try {
                            log.debug("problemDiagnosesCodeSelectorTarget");
                            viewSite.getPage().showView("ch.elexis.DiagnosenView");
                            CodeSelectorHandler.getInstance().setCodeSelectorTarget(ProblemArea.this.problemDiagnosesCodeSelectorTarget);
                        }
                        catch (Exception ex) {
                            ExHandler.handle((Throwable)ex);
                            log.error("Fehler beim Starten des Diagnosencodes " + ex.getMessage());
                        }
                        break;
                    }
                    case 5: {
                        if (problem == null) break;
                        if (problem.getStatus() == 1) {
                            problem.setStatus(0);
                        } else {
                            problem.setStatus(1);
                        }
                        log.info("Problem status changed to: " + problem.getStatus());
                        IatrixEventHelper.fireSelectionEventProblem(problem);
                    }
                }
            }

            public void fixedCellDoubleClicked(int col, int row, int statemask) {
            }
        });
        DragSource ds = new DragSource((Control)this.problemsKTable, 1);
        ds.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        ds.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                Problem problem;
                Point cell = ProblemArea.this.problemsKTable.getCellForCoordinates(event.x, event.y);
                int col = cell.x;
                int row = cell.y;
                event.doit = col >= ProblemArea.this.problemsTableModel.getFixedHeaderColumnCount() && row >= ProblemArea.this.problemsTableModel.getFixedHeaderRowCount() ? ((problem = ProblemArea.this.getSelectedProblem()) != null ? problem.isDragOK() : false) : false;
            }

            public void dragSetData(DragSourceEvent event) {
                Problem problem = ProblemArea.this.getSelectedProblem();
                StringBuilder sb = new StringBuilder();
                if (problem != null) {
                    sb.append(problem.storeToString()).append(",");
                }
                event.data = sb.toString().replace(",$", "");
            }
        });
        DropTarget dt = new DropTarget((Control)this.problemsKTable, 1);
        dt.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dt.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                String[] dl;
                String drp = (String)event.data;
                String[] stringArray = dl = drp.split(",");
                int n = dl.length;
                int n2 = 0;
                while (n2 < n) {
                    String obj = stringArray[n2];
                    CoreHub.poFactory.createFromString(obj);
                    ++n2;
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        new ICodeSelectorTarget(){

            public String getName() {
                return ProblemArea.this.journalViewPartName;
            }

            public void codeSelected(PersistentObject po) {
                if (po instanceof IDiagnose) {
                    IDiagnose diagnose = (IDiagnose)po;
                    Problem problem = ProblemArea.this.getSelectedProblem();
                    if (problem != null) {
                        problem.addDiagnose(diagnose);
                        IatrixEventHelper.updateProblem(problem);
                        if (CoreHub.userCfg.get("org.iatrix/code_selection_autoclose", false)) {
                            try {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.iatrix.views.JournalView");
                            }
                            catch (Exception ex) {
                                ExHandler.handle((Throwable)ex);
                                log.error("Fehler beim \u00d6ffnen von JournalView: " + ex.getMessage());
                            }
                        }
                    }
                }
            }

            public void registered(boolean registered) {
                ProblemArea.this.highlightProblemsTable(registered);
            }
        };
        this.problemFixmedikationCodeSelectorTarget = new ICodeSelectorTarget(){

            public String getName() {
                return ProblemArea.this.journalViewPartName;
            }

            public void codeSelected(PersistentObject po) {
                Problem problem = ProblemArea.this.getSelectedProblem();
                if (problem != null && po instanceof Artikel) {
                    Artikel artikel = (Artikel)po;
                    Prescription prescription = new Prescription(artikel, problem.getPatient(), "", "");
                    problem.addPrescription(prescription);
                    MediDetailDialog dlg = new MediDetailDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), prescription);
                    dlg.open();
                    IatrixEventHelper.updateProblem(problem);
                    if (CoreHub.userCfg.get("org.iatrix/code_selection_autoclose", false)) {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.iatrix.views.JournalView");
                        }
                        catch (Exception ex) {
                            ExHandler.handle((Throwable)ex);
                            log.error("Fehler beim \u00d6ffnen von JournalView: " + ex.getMessage());
                        }
                    }
                }
            }

            public void registered(boolean registered) {
                if (registered) {
                    ProblemArea.this.highlightProblemsTable(true, true);
                } else {
                    ProblemArea.this.highlightProblemsTable(false);
                }
            }
        };
    }

    private void highlightProblemsTable(boolean highlight) {
        this.highlightProblemsTable(highlight, false);
    }

    private void highlightProblemsTable(boolean highlight, boolean full) {
        this.problemsTableModel.setHighlightSelection(highlight, full);
        this.problemsKTable.redraw();
    }

    public Problem getSelectedProblem() {
        Point[] selection = this.problemsKTable.getCellSelection();
        if (selection == null || selection.length == 0) {
            return null;
        }
        int rowIndex = selection[0].y - this.problemsTableModel.getFixedHeaderRowCount();
        Problem problem = this.problemsTableModel.getProblem(rowIndex);
        return problem;
    }

    public void reloadAndRefresh() {
        this.problemsTableModel.reload();
        this.problemsKTable.refresh();
    }

    private void makeActions(IViewSite viewSite) {
        this.delProblemAction = new Action("Problem l\u00f6schen"){

            public void run() {
                Problem problem = ProblemArea.this.getSelectedProblem();
                if (problem != null) {
                    String label = problem.getLabel();
                    if (StringTool.isNothing((Object)label)) {
                        label = "(unbekannt)";
                    }
                    if (!CoreHub.acl.request(AccessControlDefaults.DELETE_FORCED)) {
                        log.error("Das Problem konnte nicht gel\u00f6scht werden: " + (Object)((Object)problem) + " missing AccessControlDefaults.DELETE_FORCED");
                        SWTHelper.alert((String)"Konnte Problem nicht l\u00f6schen", (String)"Sie haben keine Berechtigung das Problem mit den verkn\u00fcpften Daten zu l\u00f6schen. (aka AccessControlDefaults.DELETE_FORCED)");
                        return;
                    }
                    if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Wirklich l\u00f6schen?", (String)label)) {
                        if (!problem.remove(true)) {
                            log.error("Das Problem konnte nicht gel\u00f6scht werden: " + (Object)((Object)problem));
                            SWTHelper.alert((String)"Konnte Problem nicht l\u00f6schen", (String)"Das Problem konnte nicht gel\u00f6scht werden.");
                        } else {
                            ProblemArea.this.reloadAndRefresh();
                        }
                    }
                }
            }
        };
        this.addProblemAction = new Action("Neues Problem"){
            {
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.iatrix", (String)"icons/new_problem.ico"));
                this.setToolTipText("Neues Problem f\u00fcr diesen Patienten erstellen");
            }

            public void run() {
                Problem problem = new Problem(ElexisEventDispatcher.getSelectedPatient(), "");
                String currentDate = new TimeTool().toString(6);
                problem.setStartDate(currentDate);
                IatrixEventHelper.fireSelectionEventProblem(problem);
                ProblemArea.this.reloadAndRefresh();
                int rowIndex = ProblemArea.this.problemsTableModel.getIndexOf(problem);
                if (rowIndex > -1) {
                    int col = ProblemArea.this.problemsTableModel.getFixedHeaderColumnCount();
                    int row = rowIndex + ProblemArea.this.problemsTableModel.getFixedHeaderRowCount();
                    ProblemArea.this.problemsKTable.setSelection(col, row, true);
                }
                ElexisEventDispatcher.fireSelectionEvents((PersistentObject[])new PersistentObject[]{ProblemArea.this.actPat});
            }
        };
        this.addFixmedikationAction = new Action("Fixmedikation hinzuf\u00fcgen"){
            {
                this.setToolTipText("Fixmedikation hinzuf\u00fcgen");
            }

            public void run() {
                Point[] selection = ProblemArea.this.problemsKTable.getCellSelection();
                if (selection.length != 1) {
                    SWTHelper.alert((String)"Fixmedikation hinzuf\u00fcgen", (String)"Sie k\u00f6nnen eine Fixmedikation nur dann hinzuf\u00fcgen,wenn Sie in der entsprechenden Spalte der Patienten\u00fcbersicht stehen.");
                    return;
                }
                int row = selection[0].y;
                int rowIndex = row - ProblemArea.this.problemsTableModel.getFixedHeaderRowCount();
                Problem problem = ProblemArea.this.problemsTableModel.getProblem(rowIndex);
                if (problem != null) {
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.LeistungenView");
                        if (ProblemArea.this.problemFixmedikationCodeSelectorTarget != null) {
                            CodeSelectorHandler.getInstance().setCodeSelectorTarget(ProblemArea.this.problemFixmedikationCodeSelectorTarget);
                        }
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                        log.error("Fehler beim Anzeigen der Artikel " + ex.getMessage());
                    }
                }
            }
        };
        this.editFixmedikationAction = new Action("Fixmedikation \u00e4ndern..."){
            {
                this.setToolTipText("Fixmedikation \u00e4ndern...");
            }

            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.iatrix.views.ProblemView");
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    log.error("Fehler beim \u00d6ffnen von ProblemView: " + ex.getMessage());
                }
            }
        };
        this.deleteFixmedikationAction = new Action("Fixmedikation entfernen..."){
            {
                this.setToolTipText("Fixmedikation entfernen...");
            }

            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.iatrix.views.ProblemView");
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    log.error("Fehler beim \u00d6ffnen von ProblemView: " + ex.getMessage());
                }
            }
        };
        ViewMenus menus = new ViewMenus(viewSite);
        menus.createControlContextMenu((Control)this.problemsKTable, new IAction[]{this.addFixmedikationAction, this.editFixmedikationAction, this.deleteFixmedikationAction});
    }

    public IAction getAddProblemAction() {
        return this.addProblemAction;
    }

    public IAction getDelProblemAction() {
        return this.delProblemAction;
    }

    public IAction getAddFixmedikationAction() {
        return this.addFixmedikationAction;
    }

    public IAction getEditFixmedikationAction() {
        return this.editFixmedikationAction;
    }

    public IAction getDeleteFixmedikationAction() {
        return this.deleteFixmedikationAction;
    }

    private void logEvent(String msg) {
        StringBuilder sb = new StringBuilder(String.valueOf(msg) + ": ");
        if (this.actPat == null) {
            sb.append("actPat null");
        } else {
            sb.append(" " + this.actPat.getPersonalia());
        }
        log.debug(sb.toString());
    }

    public void registerUpdateHeartbeat() {
        Heartbeat heat = Heartbeat.getInstance();
        heat.addListener(new Heartbeat.IatrixHeartListener(){

            @Override
            public void heartbeat() {
                ProblemArea.this.logEvent(String.format("heartbeatProblem enabled %s version %s", ProblemArea.this.heartbeatProblemEnabled, Platform.getBundle((String)"org.iatrix").getVersion().toString()));
                if (ProblemArea.this.heartbeatProblemEnabled) {
                    int rowIndex;
                    int row;
                    Point[] cells;
                    boolean isRowSelectMode = ProblemArea.this.problemsKTable.isRowSelectMode();
                    Problem selectedProblem = null;
                    int currentColumn = -1;
                    if (!isRowSelectMode && (cells = ProblemArea.this.problemsKTable.getCellSelection()) != null && cells.length > 0) {
                        row = cells[0].y;
                        int rowIndex2 = row - ProblemArea.this.problemsTableModel.getFixedHeaderRowCount();
                        selectedProblem = ProblemArea.this.problemsTableModel.getProblem(rowIndex2);
                        currentColumn = cells[0].x;
                    }
                    ProblemArea.this.reloadAndRefresh();
                    if (selectedProblem != null && !isRowSelectMode && (rowIndex = ProblemArea.this.problemsTableModel.getIndexOf(selectedProblem)) >= 0) {
                        row = rowIndex + ProblemArea.this.problemsTableModel.getFixedHeaderRowCount();
                        if (currentColumn == -1) {
                            currentColumn = ProblemArea.this.problemsTableModel.getFixedHeaderColumnCount();
                        }
                        ProblemArea.this.problemsKTable.setSelection(currentColumn, row, true);
                    }
                }
            }
        });
    }

    @Override
    public void setKons(Patient newPatient, Konsultation newKons, IJournalArea.KonsActions op) {
        Helpers.checkActPatKons(newPatient, newKons);
        if (newPatient == null || this.actPat == null || !newPatient.getId().equals(this.actPat.getId())) {
            this.actPat = newPatient;
            this.problemsTableModel.setKons(newPatient, newKons);
            this.reloadAndRefresh();
        } else {
            this.problemsTableModel.setKons(newPatient, newKons);
        }
    }

    public MyKTable getProblemKTable() {
        return this.problemsKTable;
    }

    public ProblemsTableModel getProblemsTableModel() {
        return this.problemsTableModel;
    }

    @Override
    public void visible(boolean mode) {
    }

    @Override
    public void activation(boolean mode, Patient selectedPat, Konsultation selectedKons) {
        if (mode) {
            this.setKons(selectedPat, selectedKons, IJournalArea.KonsActions.ACTIVATE_KONS);
        }
    }

    static class DummyProblem {
        DummyProblem() {
        }
    }
}

