/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.widgets;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.model.article.IArticle;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Artikel;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.PersistentObjectFactory;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.iatrix.data.Problem;
import org.iatrix.util.Helpers;
import org.iatrix.widgets.IJournalArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KonsVerrechnung
implements IJournalArea {
    private Patient actPat = null;
    private Konsultation lastSelectedKons = null;
    private FormToolkit tk = UiDesk.getToolkit();
    private static Logger log = LoggerFactory.getLogger(KonsVerrechnung.class);
    public IAction delVerrechnetAction;
    public IAction changeVerrechnetPreisAction;
    public IAction changeVerrechnetZahlAction;
    private TableViewer verrechnungViewer;
    private Color verrechnungViewerColor;
    private Hyperlink hVerrechnung;
    private Text tVerrechnungKuerzel;
    private ICodeSelectorTarget konsultationVerrechnungCodeSelectorTarget;
    private Color highlightColor;

    public KonsVerrechnung(Composite verrechnungComposite, Form form, final String partName, Composite assignmentComposite) {
        this.highlightColor = form.getDisplay().getSystemColor(29);
        verrechnungComposite.setLayout((Layout)new GridLayout(1, true));
        Composite verrechnungHeader = this.tk.createComposite(verrechnungComposite);
        verrechnungHeader.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        verrechnungHeader.setLayout((Layout)new GridLayout(2, false));
        this.hVerrechnung = this.tk.createHyperlink(verrechnungHeader, "Verrechnung", 0);
        this.hVerrechnung.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.hVerrechnung.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    if (KonsVerrechnung.this.konsultationVerrechnungCodeSelectorTarget != null) {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.LeistungenView");
                        CodeSelectorHandler.getInstance().setCodeSelectorTarget(KonsVerrechnung.this.konsultationVerrechnungCodeSelectorTarget);
                    }
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    log.error("Fehler beim Starten des Leistungscodes " + ex.getMessage());
                }
            }
        });
        this.hVerrechnung.setEnabled(false);
        this.tVerrechnungKuerzel = this.tk.createText(verrechnungHeader, "", 2048);
        GridData gd = new GridData(0x1000008);
        gd.widthHint = 50;
        this.tVerrechnungKuerzel.setLayoutData((Object)gd);
        this.tVerrechnungKuerzel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String mnemonic = KonsVerrechnung.this.tVerrechnungKuerzel.getText();
                if (!StringTool.isNothing((Object)mnemonic)) {
                    KonsVerrechnung.this.addLeistungByMnemonic(mnemonic, false, false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tVerrechnungKuerzel.setEnabled(false);
        Table verrechnungTable = this.tk.createTable(verrechnungComposite, 2);
        this.verrechnungViewer = new TableViewer(verrechnungTable);
        this.verrechnungViewer.getControl().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        verrechnungHeader.setBackground(verrechnungHeader.getBackground());
        verrechnungTable.setBackground(verrechnungHeader.getBackground());
        this.verrechnungViewerColor = verrechnungTable.getBackground();
        this.hVerrechnung.setBackground(verrechnungHeader.getBackground());
        this.verrechnungViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (KonsVerrechnung.this.lastSelectedKons != null) {
                    List lgl = KonsVerrechnung.this.lastSelectedKons.getLeistungen();
                    return lgl.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.verrechnungViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof Verrechnet)) {
                    return "";
                }
                Verrechnet verrechnet = (Verrechnet)element;
                StringBuilder sb = new StringBuilder();
                int z = verrechnet.getZahl();
                Money preis = new Money(verrechnet.getEffPreis()).multiply((double)z);
                sb.append(z).append(" ").append(verrechnet.getCode()).append(" ").append(verrechnet.getText()).append(" (").append(preis.getAmountAsString()).append(")");
                return sb.toString();
            }
        });
        this.verrechnungViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enableDel = false;
                boolean enableChange = false;
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel != null) {
                    if (sel.size() >= 1) {
                        enableDel = true;
                    }
                    if (sel.size() == 1) {
                        enableChange = true;
                    }
                }
                KonsVerrechnung.this.delVerrechnetAction.setEnabled(enableDel);
                KonsVerrechnung.this.changeVerrechnetZahlAction.setEnabled(enableChange);
                KonsVerrechnung.this.changeVerrechnetPreisAction.setEnabled(enableChange);
            }
        });
        this.verrechnungViewer.setInput((Object)this);
        this.makeActions();
        TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] types = new Transfer[]{textTransfer};
        this.verrechnungViewer.getControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    int j = KonsVerrechnung.this.verrechnungViewer.getTable().getSelectionIndex();
                    KonsVerrechnung.this.deleleSelectedItem();
                    if (j >= 1) {
                        KonsVerrechnung.this.verrechnungViewer.getTable().setFocus();
                        KonsVerrechnung.this.verrechnungViewer.getTable().select(j - 1);
                    }
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        DropTarget dtarget = new DropTarget((Control)assignmentComposite, 1);
        dtarget.setTransfer(types);
        dtarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                String[] dl;
                String drp = (String)event.data;
                String[] stringArray = dl = drp.split(",");
                int n = dl.length;
                int n2 = 0;
                while (n2 < n) {
                    String obj = stringArray[n2];
                    PersistentObject dropped = CoreHub.poFactory.createFromString(obj);
                    if (dropped instanceof Problem) {
                        Problem problem = (Problem)dropped;
                        problem.addToKonsultation(KonsVerrechnung.this.lastSelectedKons);
                    }
                    ++n2;
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        dtarget = new DropTarget((Control)verrechnungComposite, 1);
        dtarget.setTransfer(types);
        dtarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                String[] dl;
                Helpers.checkActPatKons(KonsVerrechnung.this.actPat, KonsVerrechnung.this.lastSelectedKons);
                String drp = (String)event.data;
                String[] stringArray = dl = drp.split(",");
                int n = dl.length;
                int n2 = 0;
                while (n2 < n) {
                    String obj = stringArray[n2];
                    PersistentObject dropped = CoreHub.poFactory.createFromString(obj);
                    if (dropped instanceof IVerrechenbar) {
                        if (!CoreHub.acl.request(AccessControlDefaults.LSTG_VERRECHNEN)) {
                            SWTHelper.alert((String)"Fehlende Rechte", (String)"Sie haben nicht die Berechtigung, Leistungen zu verrechnen");
                        } else {
                            Konsultation cfr_ignored_0 = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
                            if (KonsVerrechnung.this.lastSelectedKons == null) {
                                String msg = "Die zuletze ausgew\u00e4hlte Konsultation is leer? Weshalb?";
                                log.error(msg);
                                SWTHelper.alert((String)"Programmierfehler ", (String)msg);
                            } else {
                                IVerrechenbar droppedItem = (IVerrechenbar)dropped;
                                Result result = KonsVerrechnung.this.lastSelectedKons.addLeistung(droppedItem);
                                if (!result.isOK()) {
                                    SWTHelper.alert((String)"Diese Verrechnung it ung\u00fcltig", (String)result.toString());
                                }
                                log.debug(String.format("dtarget verrechenbar pat %s kons id %s deleted? %s '%s' dropped %s", KonsVerrechnung.this.actPat.getPersonalia(), KonsVerrechnung.this.lastSelectedKons.getId(), KonsVerrechnung.this.lastSelectedKons.isDeleted(), KonsVerrechnung.this.lastSelectedKons.getLabel(), droppedItem.getText()));
                                KonsVerrechnung.this.verrechnungViewer.refresh();
                                KonsVerrechnung.this.updateVerrechnungSum();
                                KonsVerrechnung.this.lastSelectedKons.undelete();
                            }
                        }
                    }
                    ++n2;
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        this.konsultationVerrechnungCodeSelectorTarget = new ICodeSelectorTarget(){

            public String getName() {
                return partName;
            }

            public void codeSelected(PersistentObject po) {
                Helpers.checkActPatKons(KonsVerrechnung.this.actPat, KonsVerrechnung.this.lastSelectedKons);
                if (po instanceof IVerrechenbar) {
                    if (!CoreHub.acl.request(AccessControlDefaults.LSTG_VERRECHNEN)) {
                        SWTHelper.alert((String)"Fehlende Rechte", (String)"Sie haben nicht die Berechtigung, Leistungen zu verrechnen");
                    } else {
                        IVerrechenbar verrechenbar = (IVerrechenbar)po;
                        if (KonsVerrechnung.this.lastSelectedKons != null) {
                            Result result = KonsVerrechnung.this.lastSelectedKons.addLeistung(verrechenbar);
                            if (!result.isOK()) {
                                SWTHelper.alert((String)"Diese Verrechnung ist ung\u00fcltig", (String)result.toString());
                            } else {
                                log.debug(String.format("konsultationVerrechnungCodeSelectorTarget pat %s kons %s isDragOK %s verrechenbar %s", KonsVerrechnung.this.actPat, KonsVerrechnung.this.lastSelectedKons, KonsVerrechnung.this.lastSelectedKons.isDragOK(), verrechenbar.getText()));
                                if (CoreHub.userCfg.get("org.iatrix/code_selection_autoclose", false)) {
                                    try {
                                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.iatrix.views.JournalView");
                                    }
                                    catch (Exception ex) {
                                        ExHandler.handle((Throwable)ex);
                                        log.error("Fehler beim \u00d6ffnen von JournalView: " + ex.getMessage());
                                    }
                                }
                            }
                            KonsVerrechnung.this.verrechnungViewer.refresh();
                            KonsVerrechnung.this.updateVerrechnungSum();
                        }
                    }
                }
            }

            public void registered(boolean registered) {
                KonsVerrechnung.this.highlightVerrechnung(registered);
            }
        };
    }

    public void updateVerrechnungSum() {
        StringBuilder sb = new StringBuilder();
        sb.append("Verrechnung");
        if (this.lastSelectedKons != null) {
            List leistungen = this.lastSelectedKons.getLeistungen();
            Money sum = new Money(0);
            for (Verrechnet leistung : leistungen) {
                int z = leistung.getZahl();
                Money preis = leistung.getEffPreis().multiply((double)z);
                sum.addMoney(preis);
            }
            sb.append(" (");
            sb.append(sum.getAmountAsString());
            sb.append(")");
        }
        log.debug(String.format("pat %s kons %s sum is now %s", this.actPat, this.lastSelectedKons, sb.toString()));
        this.hVerrechnung.setText(sb.toString());
        this.hVerrechnung.update();
    }

    private boolean addLeistungByMnemonic(String mnemonic, boolean approximation, boolean multi) {
        boolean success = false;
        if (this.lastSelectedKons != null && !StringTool.isNothing((Object)mnemonic)) {
            Query query = new Query(Artikel.class);
            if (approximation) {
                query.add("Eigenname", "LIKE", String.valueOf(mnemonic) + "%");
            } else {
                query.add("Eigenname", "=", mnemonic);
            }
            List artikels = query.execute();
            if (artikels != null && !artikels.isEmpty()) {
                ArrayList<Artikel> selection = new ArrayList<Artikel>();
                if (multi) {
                    selection.addAll(artikels);
                } else {
                    selection.add((Artikel)artikels.get(0));
                }
                ArrayList<Result> results = new ArrayList<Result>();
                PersistentObjectFactory factory = new PersistentObjectFactory();
                for (Artikel artikel : artikels) {
                    Result result;
                    PersistentObject po;
                    String typ = artikel.get("Typ");
                    String id = artikel.getId();
                    if (typ.equals("Medikament") || typ.equals("Medical") || typ.equals("MiGeL")) {
                        typ = "ch.elexis.artikel_ch.data." + typ;
                    }
                    if (!((po = factory.createFromString(String.valueOf(typ) + "::" + id)) instanceof IVerrechenbar) || (result = this.lastSelectedKons.addLeistung((IVerrechenbar)po)).isOK()) continue;
                    results.add(result);
                }
                this.verrechnungViewer.refresh();
                this.updateVerrechnungSum();
                if (results.isEmpty()) {
                    success = true;
                } else {
                    StringBuffer sb = new StringBuffer();
                    boolean first = true;
                    for (Result result : results) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append("; ");
                        }
                        sb.append(result.toString());
                        SWTHelper.alert((String)"Diese Verrechnung ist ung\u00fcltig", (String)sb.toString());
                    }
                }
            }
        }
        return success;
    }

    public void updateKonsultation() {
        if (this.lastSelectedKons != null) {
            this.hVerrechnung.setEnabled(true);
            this.tVerrechnungKuerzel.setEnabled(true);
            log.debug(String.format("Konsultation: %s %s ", this.lastSelectedKons.getId(), this.lastSelectedKons.getLabel()));
        } else {
            log.debug("Konsultation is null ");
            this.hVerrechnung.setEnabled(false);
            this.tVerrechnungKuerzel.setEnabled(false);
            log.debug("Konsultation: null");
        }
    }

    private void highlightVerrechnung(boolean highlight) {
        Table table = this.verrechnungViewer.getTable();
        if (highlight) {
            table.setBackground(this.highlightColor);
        } else {
            table.setBackground(this.verrechnungViewerColor);
        }
    }

    private void deleleSelectedItem() {
        IStructuredSelection sel = (IStructuredSelection)this.verrechnungViewer.getSelection();
        if (sel != null) {
            Object[] objectArray = sel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof Verrechnet) {
                    Verrechnet verrechnet = (Verrechnet)obj;
                    Result result = this.lastSelectedKons.removeLeistung(verrechnet);
                    if (!result.isOK()) {
                        SWTHelper.alert((String)"Leistungsposition kann nicht entfernt werden", (String)result.toString());
                    }
                    this.verrechnungViewer.refresh();
                    this.updateVerrechnungSum();
                }
                ++n2;
            }
        }
    }

    private void makeActions() {
        this.delVerrechnetAction = new Action("Leistungsposition entfernen"){

            public void run() {
                KonsVerrechnung.this.deleleSelectedItem();
            }
        };
        this.changeVerrechnetPreisAction = new Action("Preis \u00e4ndern"){

            public void run() {
                Object sel = ((IStructuredSelection)KonsVerrechnung.this.verrechnungViewer.getSelection()).getFirstElement();
                if (sel != null) {
                    Verrechnet verrechnet = (Verrechnet)sel;
                    boolean konsEditable = Helpers.hasRightToChangeConsultations(verrechnet.getKons(), true);
                    if (!konsEditable) {
                        return;
                    }
                    String p = verrechnet.getEffPreis().getAmountAsString();
                    InputDialog dlg = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Preis f\u00fcr Leistung \u00e4ndern", "Geben Sie bitte den neuen Preis f\u00fcr die Leistung ein (x.xx)", p, null);
                    if (dlg.open() == 0) {
                        try {
                            Money newPrice = new Money(dlg.getValue());
                            verrechnet.setPreis(newPrice);
                            KonsVerrechnung.this.verrechnungViewer.refresh();
                            KonsVerrechnung.this.updateVerrechnungSum();
                        }
                        catch (ParseException e) {
                            ExHandler.handle((Throwable)e);
                            SWTHelper.showError((String)"Falsche Eingabe", (String)"Konnte Angabe nicht interpretieren");
                        }
                    }
                }
            }
        };
        this.changeVerrechnetZahlAction = new Action("Zahl \u00e4ndern"){

            public void run() {
                Object sel = ((IStructuredSelection)KonsVerrechnung.this.verrechnungViewer.getSelection()).getFirstElement();
                if (sel != null) {
                    Verrechnet verrechnet = (Verrechnet)sel;
                    String p = Integer.toString(verrechnet.getZahl());
                    InputDialog dlg = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Zahl der Leistung \u00e4ndern", "Geben Sie bitte die neue Anwendungszahl f\u00fcr die Leistung bzw. den Artikel ein", p, null);
                    if (dlg.open() == 0) {
                        verrechnet.getZahl();
                        int neu = Integer.parseInt(dlg.getValue());
                        verrechnet.setZahl(neu);
                        IVerrechenbar verrechenbar = verrechnet.getVerrechenbar();
                        if (verrechenbar instanceof Artikel) {
                            Artikel art = (Artikel)verrechenbar;
                            CoreHub.getStockService().performSingleReturn((IArticle)art, 1);
                            CoreHub.getStockService().performSingleDisposal((IArticle)art, 1);
                        }
                        KonsVerrechnung.this.verrechnungViewer.refresh();
                        KonsVerrechnung.this.updateVerrechnungSum();
                    }
                }
            }
        };
    }

    @Override
    public void setKons(Patient newPatient, Konsultation newKons, IJournalArea.KonsActions op) {
        Helpers.checkActPatKons(newPatient, newKons);
        boolean sameKons = Helpers.twoKonsEqual(newKons, this.lastSelectedKons);
        log.debug(String.format("op %s sameKons %s newPat %s newKons %s lastSelectedKons %s", new Object[]{op, sameKons, newPatient == null ? "null" : newPatient.getPersonalia(), newKons == null ? "null" : newKons.getLabel(), this.lastSelectedKons == null ? "null" : this.lastSelectedKons.getLabel()}));
        if (sameKons && op != IJournalArea.KonsActions.EVENT_UPDATE) {
            return;
        }
        if (newKons != null && newPatient != null) {
            log.debug(String.format("set lastSelectedKons  %s newPat %s", newKons.getLabel(), newPatient.getPersonalia()));
            this.lastSelectedKons = newKons;
            this.actPat = newPatient;
            this.updateKonsultation();
            this.verrechnungViewer.refresh();
            this.updateVerrechnungSum();
        } else if (newPatient != null && newKons != null) {
            this.actPat = newPatient;
            this.lastSelectedKons = newKons;
            log.debug(String.format("sameKons2 %s newPat %s newKons %s", sameKons, newPatient.getPersonalia(), newKons == null ? "null" : newKons.getLabel()));
        } else {
            log.debug(String.format("sameKons3 %s newPat %s newKons %s lastSelectedKons %s", sameKons, newPatient == null ? "null" : newPatient.getPersonalia(), newKons == null ? "null" : newKons.getLabel(), this.lastSelectedKons == null ? "null" : this.lastSelectedKons.getLabel()));
        }
        Helpers.checkActPatKons(this.actPat, this.lastSelectedKons);
    }

    @Override
    public void visible(boolean mode) {
    }

    @Override
    public void activation(boolean mode, Patient selectedPat, Konsultation selectedKons) {
        if (mode) {
            this.setKons(selectedPat, selectedKons, IJournalArea.KonsActions.ACTIVATE_KONS);
        }
    }

    public TableViewer getVerrechnungViewer() {
        return this.verrechnungViewer;
    }
}

