/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.widgets;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.text.EnhancedTextField;
import ch.elexis.core.ui.text.IRichTextDisplay;
import ch.elexis.core.ui.util.IKonsExtension;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Anwender;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionedResource;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.iatrix.data.KonsTextLock;
import org.iatrix.dialogs.ChooseKonsRevisionDialog;
import org.iatrix.util.Heartbeat;
import org.iatrix.util.Helpers;
import org.iatrix.views.JournalView;
import org.iatrix.widgets.IJournalArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KonsText
implements IJournalArea {
    private static Konsultation actKons = null;
    private static int konsTextSaverCount = 0;
    private static Logger log = LoggerFactory.getLogger(KonsText.class);
    private static EnhancedTextField text;
    private static Label lVersion;
    private static Label lKonsLock;
    private static KonsTextLock konsTextLock;
    private static String unable_to_save_kons_id;
    int displayedVersion;
    private Action purgeAction;
    private IAction saveAction;
    private Action chooseVersionAction;
    private Action versionFwdAction;
    private Action versionBackAction;
    private final FormToolkit tk;
    private Composite parent;
    private Hashtable<String, IKonsExtension> hXrefs;

    static {
        lVersion = null;
        lKonsLock = null;
        konsTextLock = null;
        unable_to_save_kons_id = "";
    }

    public KonsText(Composite parentComposite) {
        this.parent = parentComposite;
        this.tk = UiDesk.getToolkit();
        SashForm konsultationSash = new SashForm(this.parent, 256);
        konsultationSash.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite konsultationTextComposite = this.tk.createComposite((Composite)konsultationSash);
        konsultationTextComposite.setLayout((Layout)new GridLayout(1, true));
        text = new EnhancedTextField(konsultationTextComposite);
        this.hXrefs = new Hashtable();
        List listKonsextensions = Extensions.getClasses((List)Extensions.getExtensions((String)"ch.elexis.core.ui.KonsExtension"), (String)"KonsExtension", (boolean)false);
        for (IKonsExtension x : listKonsextensions) {
            String provider = x.connect((IRichTextDisplay)text);
            this.hXrefs.put(provider, x);
        }
        text.setXrefHandlers(this.hXrefs);
        List makros = Extensions.getClasses((List)Extensions.getExtensions((String)"ch.elexis.core.ui.KonsExtension"), (String)"KonsMakro", (boolean)false);
        text.setExternalMakros(makros);
        text.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.makeActions();
        text.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                KonsText.this.logEvent("widgetDisposed removeKonsTextLock");
                KonsText.this.updateEintrag();
                KonsText.this.removeKonsTextLock();
            }
        });
        this.tk.adapt((Composite)text);
        lVersion = this.tk.createLabel(konsultationTextComposite, "<aktuell>");
        lVersion.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        lKonsLock = this.tk.createLabel(konsultationTextComposite, "");
        lKonsLock.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        lKonsLock.setForeground(lKonsLock.getDisplay().getSystemColor(3));
        lKonsLock.setVisible(false);
        this.registerUpdateHeartbeat();
    }

    public Action getPurgeAction() {
        return this.purgeAction;
    }

    public IAction getSaveAction() {
        return this.saveAction;
    }

    public Action getChooseVersionAction() {
        return this.chooseVersionAction;
    }

    public Action getVersionForwardAction() {
        return this.versionFwdAction;
    }

    public Action getVersionBackAction() {
        return this.versionBackAction;
    }

    private void showUnableToSaveKons(String plain, String errMsg) {
        this.logEvent("showUnableToSaveKons errMsg: " + errMsg + " plain: " + plain);
        if (plain.length() == 0) {
            log.warn("showUnableToSaveKons Inhalt war leer");
            return;
        }
        boolean added = false;
        try {
            Clipboard clipboard = new Clipboard(UiDesk.getDisplay());
            TextTransfer textTransfer = TextTransfer.getInstance();
            Transfer[] transfers = new Transfer[]{textTransfer};
            Object[] data = new Object[]{plain};
            clipboard.setContents(data, transfers);
            clipboard.dispose();
            added = true;
        }
        catch (Exception exception) {
            log.error("Fehlerhaftes clipboard " + plain);
        }
        StringBuilder sb = new StringBuilder();
        if (plain.length() > 0 && added) {
            sb.append("Inhalt wurde in die Zwischenablage aufgenommen\n");
        }
        sb.append("Patient: " + actKons.getFall().getPatient().getPersonalia() + "\n");
        sb.append("\nInhalt ist:\n---------------------------------------------------\n");
        sb.append(plain);
        sb.append("\n----------------------------------------------------------------\n");
        SWTHelper.alert((String)"Konnte Konsultationstext nicht abspeichern", (String)sb.toString());
    }

    public synchronized void updateEintrag() {
        if (actKons != null) {
            if (actKons.getFall() == null) {
                return;
            }
            if (!Helpers.userMayEditKons(actKons)) {
                this.logEvent(String.format("skip updateEintrag as userMay not Edit dirty %s changed %s ", text.isDirty(), this.textChanged()));
            } else if (text.isDirty() || this.textChanged()) {
                int old_version = actKons.getHeadVersion();
                String plain = text.getContentsPlaintext();
                this.logEvent("updateEintrag old_version " + old_version + " " + actKons.getId() + " dirty " + text.isDirty() + " changed " + this.textChanged());
                if (this.hasKonsTextLock()) {
                    if (!actKons.isEditable(false)) {
                        String notEditable = "Aktuelle Konsultation kannn nicht editiert werden";
                        this.showUnableToSaveKons(plain, notEditable);
                    } else {
                        actKons.updateEintrag(text.getContentsAsXML(), false);
                        ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)actKons, Konsultation.class, 4)});
                        int new_version = actKons.getHeadVersion();
                        String samdasText = new Samdas(actKons.getEintrag().getHead()).getRecordText();
                        if (new_version <= old_version || !plain.equals(samdasText)) {
                            if (!unable_to_save_kons_id.equals(actKons.getId())) {
                                String errMsg = "Unable to update: old_version " + old_version + " " + plain + " new_version " + new_version + " " + samdasText;
                                this.logEvent("updateEintrag " + errMsg + plain);
                                this.showUnableToSaveKons(plain, errMsg);
                                unable_to_save_kons_id = actKons.getId();
                            }
                        } else {
                            unable_to_save_kons_id = "";
                        }
                    }
                } else {
                    String errMsg = "Konsultation gesperrt old_version " + old_version + "konsTextLock " + (konsTextLock == null ? "null" : "key " + konsTextLock.getKey() + " lock " + konsTextLock.getLockValue());
                    this.showUnableToSaveKons(plain, errMsg);
                }
            }
        }
        text.setDirty(false);
        this.updateKonsVersionLabel();
    }

    private boolean textChanged() {
        if (actKons == null || text == null || actKons.getEintrag() == null) {
            return false;
        }
        String dbEintrag = actKons.getEintrag().getHead();
        String textEintrag = text.getContentsAsXML();
        if (textEintrag != null && dbEintrag != null && !textEintrag.equals(dbEintrag)) {
            log.debug("textChanged {}: saved text != db entry. Length {} == {}?. Is now '{}'", new Object[]{actKons.getId(), textEintrag.length(), dbEintrag.length(), this.getPlainBegining()});
            return true;
        }
        return false;
    }

    private void updateKonsLockLabel() {
        if (konsTextLock == null || this.hasKonsTextLock()) {
            lKonsLock.setVisible(false);
            lKonsLock.setText("");
        } else {
            Anwender user = konsTextLock.getLockValue().getUser();
            StringBuilder text = new StringBuilder();
            if (user != null && user.exists()) {
                text.append("Konsultation wird von Benutzer \"" + user.getLabel() + "\" bearbeitet.");
            } else {
                text.append("Konsultation wird von anderem Benutzer bearbeitet.");
            }
            text.append(" Rechner \"" + konsTextLock.getLockValue().getHost() + "\".");
            log.debug("updateKonsLockLabel: " + text.toString());
            lKonsLock.setText(text.toString());
            lKonsLock.setVisible(true);
        }
        lKonsLock.getParent().layout();
    }

    private synchronized void createKonsTextLock() {
        this.removeKonsTextLock();
        konsTextLock = actKons != null && CoreHub.actUser != null ? new KonsTextLock(actKons, CoreHub.actUser) : null;
        if (konsTextLock != null) {
            konsTextLock.lock();
        }
    }

    private synchronized void removeKonsTextLock() {
        if (konsTextLock != null) {
            konsTextLock.unlock();
            konsTextLock = null;
        }
    }

    private synchronized boolean hasKonsTextLock() {
        return true;
    }

    @Override
    public synchronized void visible(boolean mode) {
    }

    private void makeActions() {
        this.purgeAction = new Action("Alte Eintragsversionen entfernen"){

            public void run() {
                actKons.purgeEintrag();
                ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)actKons, Konsultation.class, 4)});
            }
        };
        this.versionBackAction = new Action("Vorherige Version"){

            public void run() {
                if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Konsultationstext ersetzen", (String)"Wollen Sie wirklich den aktuellen Konsultationstext gegen eine fr\u00fchere Version desselben Eintrags ersetzen?")) {
                    KonsText.this.setKonsText(actKons, KonsText.this.displayedVersion - 1, false);
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)actKons, Konsultation.class, 4)});
                }
            }
        };
        this.versionFwdAction = new Action("n\u00e4chste Version"){

            public void run() {
                if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Konsultationstext ersetzen", (String)"Wollen Sie wirklich den aktuellen Konsultationstext gegen eine sp\u00e4tere Version desselben Eintrags ersetzen?")) {
                    KonsText.this.setKonsText(actKons, KonsText.this.displayedVersion + 1, false);
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)actKons, Konsultation.class, 4)});
                }
            }
        };
        this.chooseVersionAction = new Action("Version w\u00e4hlen..."){

            public void run() {
                ChooseKonsRevisionDialog dlg = new ChooseKonsRevisionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), actKons);
                if (dlg.open() == 0) {
                    int selectedVersion = dlg.getSelectedVersion();
                    if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Konsultationstext ersetzen", (String)("Wollen Sie wirklich den aktuellen Konsultationstext gegen die Version " + selectedVersion + " desselben Eintrags ersetzen?"))) {
                        KonsText.this.setKonsText(actKons, selectedVersion, false);
                        ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)actKons, Konsultation.class, 4)});
                    }
                }
            }
        };
        this.saveAction = new Action("Konstext sichern"){
            {
                this.setImageDescriptor(Images.IMG_DISK.getImageDescriptor());
                this.setToolTipText("Konsultationstext explizit speichern");
            }

            public void run() {
                KonsText.this.logEvent("saveAction: " + actKons);
                if (actKons != null) {
                    KonsText.this.updateEintrag();
                    JournalView.updateAllKonsAreas(actKons.getFall().getPatient(), actKons, IJournalArea.KonsActions.SAVE_KONS);
                }
            }
        };
    }

    private void updateKonsultation(boolean updateText) {
        if (actKons != null) {
            if (updateText) {
                this.setKonsText(actKons, actKons.getHeadVersion(), true);
            }
            this.logEvent("updateKonsultation: " + actKons.getId());
        } else {
            this.setKonsText(null, 0, true);
            this.logEvent("updateKonsultation: null");
        }
    }

    @Override
    public synchronized void setKons(Patient newPatient, Konsultation k, IJournalArea.KonsActions op) {
        Helpers.checkActPatKons(newPatient, k);
        if (op == IJournalArea.KonsActions.SAVE_KONS) {
            if (text.isDirty() || this.textChanged()) {
                this.logEvent("setKons.SAVE_KONS text.isDirty or changed saving Kons from " + actKons.getDatum() + " is '" + text.getContentsPlaintext() + "' by " + actKons.getAuthor());
                this.updateEintrag();
            } else if (actKons != null && text != null) {
                this.logEvent("setKons.SAVE_KONS nothing to save for Kons from " + actKons.getDatum() + " is '" + text.getContentsPlaintext() + "' by" + actKons.getAuthor());
            }
            return;
        }
        boolean hasTextChanges = false;
        if (text != null && actKons != null) {
            hasTextChanges = this.textChanged();
            this.logEvent(String.format("op %s same? %s text.isDirty %s hasTextChanges %s actKons vom:  %s", new Object[]{op, Helpers.twoKonsEqual(actKons, k), text.isDirty(), hasTextChanges, actKons.getDatum()}));
            if (hasTextChanges) {
                this.updateEintrag();
            }
        }
        if (!Helpers.twoKonsEqual(actKons, k)) {
            this.removeKonsTextLock();
        }
        if (k == null) {
            actKons = k;
            this.logEvent("setKons null");
        } else {
            this.logEvent("setKons " + (actKons == null ? "null" : actKons.getId()) + " => " + k.getId());
            actKons = k;
            this.setKonsText(actKons, actKons.getHeadVersion(), true);
            boolean konsEditable = Helpers.hasRightToChangeConsultations(actKons, false);
            if (!konsEditable) {
                this.logEvent("setKons actKons is not editable");
                this.updateKonsultation(true);
                this.updateKonsLockLabel();
                this.updateKonsVersionLabel();
                lVersion.setText(String.valueOf(lVersion.getText()) + " Nicht editierbar. (Keine Zugriffsrechte oder schon verrechnet)");
                return;
            }
            if (actKons.getMandant().getId().contentEquals(CoreHub.actMandant.getId())) {
                this.createKonsTextLock();
            }
        }
        this.updateKonsultation(true);
        this.updateKonsLockLabel();
        this.updateKonsVersionLabel();
        this.saveAction.setEnabled(konsTextLock == null || this.hasKonsTextLock());
        if (op == IJournalArea.KonsActions.EVENT_SELECTED) {
            text.setFocus();
        }
    }

    private void updateKonsVersionLabel() {
        text.setEnabled(false);
        if (actKons != null) {
            actKons.getMandant();
            int version = actKons.getHeadVersion();
            VersionedResource vr = actKons.getEintrag();
            VersionedResource.ResourceItem entry = vr.getVersion(version);
            StringBuilder sb = new StringBuilder();
            if (entry == null) {
                sb.append(String.valueOf(actKons.getLabel()) + " (neu)");
            } else {
                String revisionTime = new TimeTool(entry.timestamp).toString(0);
                String revisionDate = new TimeTool(entry.timestamp).toString(4);
                if (!actKons.getDatum().equals(revisionDate)) {
                    sb.append("Kons vom " + actKons.getDatum() + ": ");
                }
                sb.append("rev. ").append(version).append(" vom ").append(revisionTime).append(" (").append(entry.remark).append(")");
                TimeTool konsDate = new TimeTool(actKons.getDatum());
                if (version == -1 && konsDate.isSameDay(new TimeTool())) {
                    sb.append(" (NEU)");
                }
            }
            sb.append(Helpers.hasRightToChangeConsultations(actKons, false) ? "" : " Kein Recht ");
            if (Helpers.userMayEditKons(actKons)) {
                sb.append(" editierbar");
                text.setEnabled(actKons.isEditable(false));
            } else {
                sb.append(" NICHT editierbar");
                text.setEnabled(false);
            }
            lVersion.setText(sb.toString());
            this.logEvent(String.format("UpdateVersionLabel: %s author <%s> >actUser <%s> editable? %s dirty? %s", sb.toString(), actKons.getAuthor(), CoreHub.actUser.getLabel(), actKons.isEditable(false), text.isDirty()));
        } else {
            lVersion.setText("");
        }
        if (text.isEnabled() && text.isDirty()) {
            text.getControl().setBackground(text.getDisplay().getSystemColor(19));
        } else {
            text.getControl().setBackground(text.getDisplay().getSystemColor(1));
        }
    }

    private synchronized void setKonsText(Konsultation aNewKons, int version, boolean putCaretToEnd) {
        if (aNewKons != null) {
            String ntext = "";
            if (version >= 0 && version <= aNewKons.getHeadVersion()) {
                VersionedResource vr = aNewKons.getEintrag();
                VersionedResource.ResourceItem entry = vr.getVersion(version);
                ntext = entry.data;
                StringBuilder sb = new StringBuilder();
                sb.append("rev. ").append(version).append(" vom ").append(new TimeTool(entry.timestamp).toString(0)).append(" (").append(entry.remark).append(")");
                lVersion.setText(sb.toString());
            } else {
                lVersion.setText("");
            }
            String desc = String.format("setKonsText version %s => %s. toEnd %s. Len %s => %s. id: %s", aNewKons.getHeadVersion(), version, putCaretToEnd, this.getPlainText().length(), ntext.length(), aNewKons.getId());
            text.setText(PersistentObject.checkNull((Object)ntext));
            text.setKons(aNewKons);
            this.displayedVersion = version;
            this.versionBackAction.setEnabled(version != 0);
            this.versionFwdAction.setEnabled(version != aNewKons.getHeadVersion());
            boolean locked = this.hasKonsTextLock();
            if (locked) {
                this.logEvent("setKonsText hasKonsTextLock " + desc);
            } else {
                this.logEvent("setKonsText (locked) " + desc);
            }
            if (putCaretToEnd) {
                text.putCaretToEnd();
            }
        } else {
            lVersion.setText("");
            text.setText("");
            text.setKons(null);
            this.displayedVersion = -1;
            this.updateKonsVersionLabel();
            this.versionBackAction.setEnabled(false);
            this.versionFwdAction.setEnabled(false);
            this.logEvent("setKonsText null " + lVersion.getText() + " " + text.getContentsPlaintext());
        }
    }

    private void logEvent(String msg) {
        StringBuilder sb = new StringBuilder(String.valueOf(msg) + ": ");
        if (actKons == null) {
            sb.append("actKons null");
        } else {
            sb.append(actKons.getId());
            sb.append(" kons rev. " + actKons.getHeadVersion());
            sb.append(" vom " + actKons.getDatum());
            if (actKons.getFall() != null) {
                sb.append(" " + actKons.getFall().getPatient().getPersonalia());
            }
        }
        log.debug(sb.toString());
    }

    @Override
    public synchronized void activation(boolean mode, Patient selectedPat, Konsultation selectedKons) {
        this.logEvent("activation: " + mode);
        if (!mode) {
            if (actKons != null && Helpers.userMayEditKons(actKons) && text.isDirty() || this.textChanged()) {
                actKons.updateEintrag(text.getContentsAsXML(), false);
                this.logEvent(String.format("updateEintrag activation vers %s dtext.isDirty ", actKons.getHeadVersion()));
                text.setDirty(false);
            } else {
                this.logEvent(String.format("skip updateEintrag activation as %s mayEdit %s dirty %s changed %s", actKons, Helpers.userMayEditKons(actKons), text.isDirty(), this.textChanged()));
            }
        } else if (actKons != null && !text.isDirty()) {
            this.setKonsText(actKons, actKons.getHeadVersion(), true);
        }
    }

    public synchronized void registerUpdateHeartbeat() {
        Heartbeat heat = Heartbeat.getInstance();
        heat.addListener(new Heartbeat.IatrixHeartListener(){

            @Override
            public void heartbeat() {
                int konsTextSaverPeriod = Heartbeat.getKonsTextSaverPeriod();
                KonsText.this.logEvent("Period: " + konsTextSaverPeriod + " dirty? " + text.isDirty());
                if (konsTextSaverPeriod <= 0) {
                    return;
                }
                konsTextSaverCount = konsTextSaverCount + 1;
                konsTextSaverCount = konsTextSaverCount % konsTextSaverPeriod;
                KonsText.this.logEvent("konsTextSaverCount = " + konsTextSaverCount);
                if (konsTextSaverCount == 0) {
                    KonsText.this.logEvent("Auto Save Kons Text");
                    KonsText.this.updateEintrag();
                }
            }
        });
    }

    public String getPlainText() {
        if (text == null) {
            return "";
        }
        return text.getContentsPlaintext();
    }

    private String getPlainBegining() {
        String plain;
        int strlen = (plain = this.getPlainText()).length();
        return plain.substring(0, strlen < 120 ? strlen : 120);
    }
}

