/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.widgets;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.icpc.Encounter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.iatrix.actions.IatrixEventHelper;
import org.iatrix.data.Problem;
import org.iatrix.util.DateComparator;
import org.iatrix.util.Helpers;
import org.iatrix.views.IatrixViewTool;
import org.iatrix.widgets.IJournalArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KonsProblems
implements IJournalArea {
    private Konsultation actKons = null;
    private FormToolkit tk = UiDesk.getToolkit();
    private static Logger log = LoggerFactory.getLogger(KonsProblems.class);
    private static CheckboxTableViewer problemAssignmentViewer;
    public Action unassignProblemAction;
    private static final DateComparator DATE_COMPARATOR;
    private Label lProbleme;

    static {
        DATE_COMPARATOR = new DateComparator();
    }

    public KonsProblems(Composite assignmentComposite) {
        this.lProbleme = this.tk.createLabel(assignmentComposite, "Probleme", 16384);
        this.lProbleme.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        problemAssignmentViewer = CheckboxTableViewer.newCheckList((Composite)assignmentComposite, (int)4);
        Table problemAssignmentTable = problemAssignmentViewer.getTable();
        this.tk.adapt((Composite)problemAssignmentTable);
        this.makeActions();
        problemAssignmentViewer.getControl().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        problemAssignmentViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (KonsProblems.this.actKons != null) {
                    List<Problem> patientProblems = Problem.getProblemsOfPatient(KonsProblems.this.actKons.getFall().getPatient());
                    List<Problem> konsProblems = Problem.getProblemsOfKonsultation(KonsProblems.this.actKons);
                    ArrayList<Problem> problems = new ArrayList<Problem>();
                    for (Problem problem : patientProblems) {
                        if (problem.getStatus() != 1) continue;
                        problems.add(problem);
                    }
                    for (Problem problem : konsProblems) {
                        if (problems.contains((Object)problem)) continue;
                        problems.add(problem);
                    }
                    Collections.sort(problems, DATE_COMPARATOR);
                    return problems.toArray();
                }
                return new Problem[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        problemAssignmentViewer.setLabelProvider((IBaseLabelProvider)new ProblemAssignmentLabelProvider());
        problemAssignmentViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (KonsProblems.this.actKons == null) {
                    return;
                }
                Object element = event.getElement();
                if (element instanceof Problem) {
                    Problem problem = (Problem)((Object)element);
                    if (event.getChecked()) {
                        problem.addToKonsultation(KonsProblems.this.actKons);
                    } else {
                        IatrixViewTool.removeProblemFromKonsultation(KonsProblems.this.actKons, problem);
                    }
                }
                KonsProblems.this.updateProblemAssignmentViewer();
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)KonsProblems.this.actKons);
            }
        });
        problemAssignmentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel != null && sel.size() == 1 && (obj = sel.getFirstElement()) instanceof Problem) {
                    Problem problem = (Problem)((Object)obj);
                    IatrixEventHelper.fireSelectionEventProblem(problem);
                    Encounter encounter = problem.getEncounter(KonsProblems.this.actKons);
                    if (encounter != null) {
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)encounter);
                    } else {
                        ElexisEventDispatcher.clearSelection(Encounter.class);
                    }
                }
            }
        });
        problemAssignmentViewer.setInput((Object)this);
    }

    private void makeActions() {
        this.unassignProblemAction = new Action("Problem entfernen"){
            {
                this.setToolTipText("Problem von Konsulation entfernen");
            }

            public void run() {
                Object sel = ((IStructuredSelection)problemAssignmentViewer.getSelection()).getFirstElement();
                if (sel != null) {
                    Problem problem = (Problem)((Object)sel);
                    problem.removeFromKonsultation(KonsProblems.this.actKons);
                    KonsProblems.this.updateProblemAssignmentViewer();
                    KonsProblems.this.logEvent("unassignProblemAction: " + problem.getTitle());
                    ElexisEventDispatcher.fireSelectionEvents((PersistentObject[])new PersistentObject[]{KonsProblems.this.actKons});
                }
            }
        };
    }

    private void updateProblemAssignmentViewer() {
        problemAssignmentViewer.refresh();
        if (this.actKons != null) {
            List<Problem> problems = Problem.getProblemsOfKonsultation(this.actKons);
            problemAssignmentViewer.setCheckedElements(problems.toArray());
            problemAssignmentViewer.refresh();
            this.lProbleme.setText("Probleme");
        } else {
            problemAssignmentViewer.setCheckedElements((Object[])new Problem[0]);
            problemAssignmentViewer.refresh();
            this.lProbleme.setText("Probleme");
        }
    }

    public CheckboxTableViewer getProblemAssignmentViewer() {
        return problemAssignmentViewer;
    }

    @Override
    public void setKons(Patient newPatient, Konsultation newKons, IJournalArea.KonsActions op) {
        Helpers.checkActPatKons(newPatient, newKons);
        if (op == IJournalArea.KonsActions.EVENT_UPDATE || !Helpers.twoKonsEqual(newKons, this.actKons)) {
            this.actKons = newKons;
            this.updateProblemAssignmentViewer();
        }
    }

    @Override
    public void visible(boolean mode) {
    }

    @Override
    public void activation(boolean mode, Patient selectedPat, Konsultation selectedKons) {
        if (mode) {
            this.setKons(selectedPat, selectedKons, IJournalArea.KonsActions.ACTIVATE_KONS);
        }
    }

    private void logEvent(String msg) {
        StringBuilder sb = new StringBuilder(String.valueOf(msg) + ": ");
        if (this.actKons == null) {
            sb.append("actKons null");
        } else {
            Patient pat = this.actKons.getFall().getPatient();
            sb.append(this.actKons.getId());
            sb.append(" kons vom " + this.actKons.getDatum());
            sb.append(" " + pat.getId() + ": " + pat.getPersonalia());
        }
        log.debug(sb.toString());
    }

    class ProblemAssignmentLabelProvider
    extends LabelProvider
    implements ITableColorProvider {
        ProblemAssignmentLabelProvider() {
        }

        public Color getForeground(Object element, int columnIndex) {
            Color color = null;
            color = problemAssignmentViewer.getChecked(element) ? Display.getCurrent().getSystemColor(2) : Display.getCurrent().getSystemColor(15);
            return color;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }
    }
}

