/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.widgets;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.actions.ObjectFilterRegistry;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.iatrix.util.Helpers;
import org.iatrix.widgets.IJournalArea;
import org.iatrix.widgets.KonsListComposite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KonsListDisplay
extends Composite
implements IJobChangeListener,
IJournalArea {
    private final FormToolkit toolkit;
    private final ScrolledForm form;
    private final Composite formBody;
    private final KonsListComposite konsListComposite;
    private final KonsLoader dataLoader;
    private static Logger log = LoggerFactory.getLogger(KonsListDisplay.class);
    private boolean showAllCharges = false;
    private boolean showAllCases = true;
    private boolean showAllConsultations = false;
    private Patient actPat = null;
    private Konsultation actKons = null;
    protected boolean dontShowActiveKons = false;

    public KonsListDisplay(Composite parent, boolean setShowActiveKons) {
        super(parent, 2048);
        this.dontShowActiveKons = setShowActiveKons;
        this.setLayout((Layout)new FillLayout());
        this.toolkit = new FormToolkit(this.getDisplay());
        this.form = this.toolkit.createScrolledForm((Composite)this);
        this.formBody = this.form.getBody();
        this.formBody.setLayout((Layout)new TableWrapLayout());
        this.konsListComposite = new KonsListComposite(this.formBody, this.toolkit, this.dontShowActiveKons);
        this.konsListComposite.setLayoutData(SWTHelper.getFillTableWrapData((int)1, (boolean)true, (int)1, (boolean)false));
        this.dataLoader = new KonsLoader(this.actPat);
        this.dataLoader.addJobChangeListener(this);
    }

    private void reload(boolean showLoading, List<KonsListComposite.KonsData> konsultationen) {
        if (this.actPat != null && konsultationen != null) {
            this.konsListComposite.setKonsultationen(konsultationen);
        } else if (konsultationen == null) {
            this.konsListComposite.setKonsultationen(null);
        } else if (showLoading) {
            this.konsListComposite.setKonsultationen(null);
        }
        this.refresh();
    }

    private void refresh() {
        if (this.form.isDisposed()) {
            this.dataLoader.cancel();
        } else {
            this.form.reflow(true);
        }
    }

    @Override
    public void visible(boolean mode) {
        if (mode) {
            this.setKons(this.actPat, this.actKons, IJournalArea.KonsActions.ACTIVATE_KONS);
        }
    }

    @Override
    public void activation(boolean mode, Patient selectedPat, Konsultation selectedKons) {
        if (mode) {
            this.setKons(this.actPat, this.actKons, IJournalArea.KonsActions.ACTIVATE_KONS);
        }
    }

    public void setShowAllCases(boolean showAll) {
        this.showAllCases = showAll;
        log.debug("setShowAllCases {}", (Object)this.showAllCases);
        this.dataLoader.cancel();
        this.reload(false, null);
    }

    @Override
    public void setKons(Patient newPatient, Konsultation newKons, IJournalArea.KonsActions op) {
        Helpers.checkActPatKons(newPatient, newKons);
        if (newPatient == null) {
            this.actPat = newPatient;
            log.debug("setPatient is null");
            this.dataLoader.cancel();
            this.reload(false, null);
            return;
        }
        if (this.actPat != null && op != IJournalArea.KonsActions.SAVE_KONS && newPatient.getId().equals(this.actPat.getId()) && Helpers.twoKonsEqual(this.actKons, newKons)) {
            if (newKons != null) {
                log.debug("setPatient skip reloading {} op {} vom {} showAllCases {}", new Object[]{newPatient.getPersonalia(), op, newKons.getLabel(), this.showAllCases});
            }
            return;
        }
        this.actPat = newPatient;
        this.actKons = newKons;
        log.debug("setPatient {} op {} all {} newKons {}", new Object[]{newPatient == null ? "null" : newPatient.getPersonalia(), op, this.showAllCases, newKons == null ? "null" : newKons.getLabel()});
        this.dataLoader.cancel();
        this.reload(true, null);
        this.dataLoader.setPatient(newPatient, this.showAllCharges, this.showAllConsultations);
        this.dataLoader.schedule();
        if (newKons != null) {
            this.konsListComposite.refeshHyperLinks(newKons);
        }
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        final ArrayList<KonsListComposite.KonsData> copy = new ArrayList<KonsListComposite.KonsData>(this.dataLoader.getKonsultationen());
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                log.debug("loaderJob got done for " + copy.size() + " kons.");
                KonsListDisplay.this.reload(false, copy);
            }
        });
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    public void highlightActKons(Konsultation newKons, boolean showCharges, boolean showConsultations) {
        this.showAllCharges = showCharges;
        this.showAllConsultations = showConsultations;
    }

    class KonsLoader
    extends Job {
        String name;
        Patient patient;
        private boolean showAllCharges;
        private boolean showAllConsultations;
        List<KonsListComposite.KonsData> konsDataList;

        public KonsLoader(Patient newPatient) {
            super("KonsLoader");
            this.patient = null;
            this.showAllCharges = true;
            this.showAllConsultations = true;
            this.konsDataList = new ArrayList<KonsListComposite.KonsData>();
            this.patient = newPatient;
            log.debug("loaderJob KonsLoader created: " + (newPatient != null ? newPatient.getPersonalia() : "null"));
        }

        public void setPatient(Patient newPatient, boolean showAllCharges, boolean showAllConsultations) {
            if (newPatient == null) {
                KonsListDisplay.this.dataLoader.cancel();
            }
            this.patient = newPatient;
            log.debug("loaderJob KonsLoader setPatient: " + (newPatient != null ? newPatient.getPersonalia() : "null"));
            this.showAllCharges = showAllCharges;
            this.showAllConsultations = showAllConsultations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            List<KonsListComposite.KonsData> list = this.konsDataList;
            synchronized (list) {
                log.debug("loaderJob started patient {} showAllCases {}", (Object)(this.patient == null ? "null" : this.patient.getPersonalia()), (Object)KonsListDisplay.this.showAllCases);
                this.konsDataList.clear();
                ArrayList<Konsultation> konsList = new ArrayList<Konsultation>();
                if (this.patient != null) {
                    Fall actFall;
                    Fall[] faelle = null;
                    faelle = KonsListDisplay.this.showAllCases ? this.patient.getFaelle() : ((actFall = (Fall)ElexisEventDispatcher.getSelected(Fall.class)) != null ? new Fall[]{actFall} : new Fall[]{});
                    if (faelle.length > 0) {
                        IFilter globalFilter = ObjectFilterRegistry.getInstance().getFilterFor(Fall.class);
                        Query query = new Query(Konsultation.class);
                        query.startGroup();
                        Fall[] fallArray = faelle;
                        int n = faelle.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Fall fall = fallArray[n2];
                            query.add("FallID", "=", fall.getId());
                            query.or();
                            ++n2;
                        }
                        query.endGroup();
                        query.orderBy(true, new String[]{"Datum"});
                        List kons = query.execute();
                        if (monitor.isCanceled()) {
                            monitor.done();
                            return Status.CANCEL_STATUS;
                        }
                        if (kons != null) {
                            for (Konsultation k : kons) {
                                if (globalFilter != null && !globalFilter.select((Object)k)) continue;
                                konsList.add(k);
                            }
                        }
                    }
                }
                if (monitor == null) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(1);
                if (CoreHub.globalCfg != null) {
                    int maxShownConsultations = CoreHub.globalCfg.get("org.iatrix/max_shown_consultations", 5);
                    if (!this.showAllConsultations && konsList.size() > maxShownConsultations) {
                        ArrayList<Konsultation> newList = new ArrayList<Konsultation>();
                        int i = 0;
                        while (i < maxShownConsultations) {
                            newList.add((Konsultation)konsList.get(i));
                            ++i;
                        }
                        konsList = newList;
                    }
                }
                if (monitor.isCanceled()) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                if (CoreHub.globalCfg != null) {
                    int maxShownCharges = CoreHub.globalCfg.get("org.iatrix/max_shown_charges", 2);
                    int i = 0;
                    for (Konsultation k : konsList) {
                        KonsListComposite.KonsData ks = new KonsListComposite.KonsData(k, this.showAllCharges || i < maxShownCharges);
                        this.konsDataList.add(ks);
                        if (++i > maxShownCharges) break;
                    }
                }
                monitor.worked(1);
                monitor.done();
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        }

        public List<KonsListComposite.KonsData> getKonsultationen() {
            return this.konsDataList;
        }
    }
}

