/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.widgets;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.iatrix.data.Problem;
import org.iatrix.util.Helpers;
import org.iatrix.widgets.EnhancedTextFieldRO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KonsListComposite {
    private static Logger log = LoggerFactory.getLogger(KonsListComposite.class);
    private final Composite composite;
    private final FormToolkit toolkit;
    private final Label loadingLabel;
    private final List<WidgetRow> widgetRows;
    private final Sash sashLeft;
    private final Sash sashRight;
    private static final String CFG_SASH_X_PERCENT_LEFT = "org.iatrix/widgets/konslistcomposite/sash_x_percent_left";
    private static final String CFG_SASH_X_PERCENT_RIGHT = "org.iatrix/widgets/konslistcomposite/sash_x_percent_right";
    private static final int SASH_X_DEFAULT_PERCENT_LEFT = 10;
    private static final int SASH_X_DEFAULT_PERCENT_RIGHT = 75;
    private static final int SASH_X_NOTSET = -1;
    private int currentSashXPercentLeft = -1;
    private int currentSashXPercentRight = -1;
    private static final String TEXT_NOT_SHOWN = "?";
    private List<KonsData> konsultationen;
    private Konsultation actKons;
    private boolean dontShowActiveKons = false;
    private static LabelProvider verrechnetLabelProvider;

    public KonsListComposite(Composite parent, FormToolkit toolkit, boolean dontShowActKonsultation) {
        verrechnetLabelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof Verrechnet)) {
                    return "";
                }
                Verrechnet verrechnet = (Verrechnet)element;
                String name = verrechnet.getText();
                IVerrechenbar verrechenbar = verrechnet.getVerrechenbar();
                if (verrechenbar != null) {
                    String nick;
                    String vClass = verrechenbar.getClass().getName();
                    if (vClass.equals("ch.elexis.data.TarmedLeistung") && !StringTool.isNothing((Object)(nick = verrechenbar.getText()))) {
                        name = nick;
                    }
                } else {
                    log.debug("Invalid Verrechenbar: " + verrechnet.getText());
                }
                StringBuilder sb = new StringBuilder();
                int z = verrechnet.getZahl();
                Money preis = new Money(verrechnet.getEffPreis()).multiply((double)z);
                sb.append(z).append(" ").append(name).append(" (").append(preis.getAmountAsString()).append(")");
                return sb.toString();
            }
        };
        this.composite = toolkit.createComposite(parent);
        this.dontShowActiveKons = dontShowActKonsultation;
        this.toolkit = toolkit;
        this.composite.setLayout((Layout)new MyLayout());
        this.loadingLabel = toolkit.createLabel(this.composite, "Lade Konsultationen...");
        this.loadingLabel.setVisible(false);
        this.widgetRows = new ArrayList<WidgetRow>();
        this.sashLeft = new Sash(this.composite, 512);
        this.sashLeft.setVisible(false);
        this.sashLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sashX = event.x;
                KonsListComposite.this.currentSashXPercentLeft = KonsListComposite.this.absoluteToPercent(((KonsListComposite)KonsListComposite.this).composite.getSize().x, sashX);
                CoreHub.localCfg.set(KonsListComposite.CFG_SASH_X_PERCENT_LEFT, KonsListComposite.this.currentSashXPercentLeft);
                KonsListComposite.this.composite.layout();
            }
        });
        this.sashRight = new Sash(this.composite, 512);
        this.sashRight.setVisible(false);
        this.sashRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sashX = event.x;
                KonsListComposite.this.currentSashXPercentRight = KonsListComposite.this.absoluteToPercent(((KonsListComposite)KonsListComposite.this).composite.getSize().x, sashX);
                CoreHub.localCfg.set(KonsListComposite.CFG_SASH_X_PERCENT_RIGHT, KonsListComposite.this.currentSashXPercentRight);
                KonsListComposite.this.composite.layout();
            }
        });
    }

    public void setLayoutData(Object layoutData) {
        this.composite.setLayoutData(layoutData);
    }

    public void setKonsultationen(List<KonsData> konsultationen) {
        this.konsultationen = konsultationen;
        this.refreshAllKons();
    }

    private void setLinkEnabled(String caller, WidgetRow row, Konsultation actKons) {
        String msg = "";
        Konsultation row_kons = null;
        if (actKons != null) {
            msg = "act: " + actKons.getId() + " " + actKons.getDatum();
        }
        if (row.konsData != null && row.konsData.konsultation != null) {
            row_kons = row.konsData.konsultation;
            msg = String.valueOf(msg) + " row " + row_kons.getId() + " " + row_kons.getDatum() + (row.hTitle.getEnabled() ? " wasEnabled " : " wasDisabled");
        }
        if (actKons != null && row != null && row_kons != null) {
            boolean disabled;
            boolean konsEditable = Helpers.hasRightToChangeConsultations(row_kons, false);
            boolean bl = disabled = row_kons.getId().equals(actKons.getId()) || !konsEditable;
            if (disabled == row.hTitle.getEnabled()) {
                row.hTitle.setEnabled(!disabled);
                if (!row.hTitle.getEnabled() && this.dontShowActiveKons) {
                    row.setKonsData(null);
                }
            }
        } else if (row != null) {
            boolean enabled = row.hTitle != null;
            row.hTitle.setEnabled(enabled);
        }
    }

    public void refeshHyperLinks(Konsultation selectedKons) {
        String konsString = selectedKons != null ? String.valueOf(selectedKons.getId()) + " " + selectedKons.getLabel() : "null";
        log.debug("refeshHyperLinks for " + konsString + " on " + this.widgetRows.size() + " rows and redraw");
        this.actKons = selectedKons;
        for (WidgetRow row : this.widgetRows) {
            this.setLinkEnabled("refeshHyperLinks", row, selectedKons);
        }
        this.composite.redraw();
    }

    private void refreshAllKons() {
        for (WidgetRow row : this.widgetRows) {
            row.setKonsData(null);
        }
        ArrayList<WidgetRow> availableRows = new ArrayList<WidgetRow>();
        availableRows.addAll(this.widgetRows);
        if (this.konsultationen != null) {
            int j = 0;
            for (KonsData konsData : this.konsultationen) {
                WidgetRow row;
                if (availableRows.size() > 0) {
                    row = (WidgetRow)availableRows.remove(0);
                } else {
                    row = new WidgetRow(this.composite);
                    this.widgetRows.add(row);
                }
                row.hTitle.setData("TEST_COMP_NAME", (Object)("KG_Iatrix_klc_row_" + ++j + "_htitle"));
                row.etf.setData("TEST_COMP_NAME", "KG_Iatrix_klc_row_" + j + "_text");
                row.verrechnung.setData("TEST_COMP_NAME", (Object)("KG_Iatrix_klc_row_" + j + "_verrechnung"));
                row.problems.setData("TEST_COMP_NAME", (Object)("KG_Iatrix_klc_row_" + j + "_problems"));
                row.setKonsData(konsData);
                row.hTitle.setToolTipText(Helpers.getExplantionForKonsEditIfBillet());
            }
            log.debug("refreshAllKons for " + this.widgetRows.size() + " rows and " + this.konsultationen.size() + " konsultationen ");
            this.loadingLabel.setVisible(false);
            this.sashLeft.setVisible(this.konsultationen.size() > 0);
            this.sashRight.setVisible(this.konsultationen.size() > 0);
            this.refeshHyperLinks(this.actKons);
        } else {
            this.loadingLabel.setVisible(false);
            this.sashLeft.setVisible(false);
            this.sashRight.setVisible(false);
        }
        this.composite.layout(true);
    }

    private int percentToAbsolute(int base, int percent) {
        return base * percent / 100;
    }

    private int absoluteToPercent(int base, int absolute) {
        return absolute * 100 / base;
    }

    public static class KonsData {
        Konsultation konsultation;
        boolean showCharges;
        String konsTitle;
        String fallTitle;
        String problemsText;
        String konsText;
        String verrechnungenText;

        public KonsData(Konsultation konsultation, boolean showCharges) {
            this.konsultation = konsultation;
            this.showCharges = showCharges;
            this.updateCacheFields();
        }

        private void updateCacheFields() {
            if (this.konsultation != null) {
                String lineSeparator = System.getProperty("line.separator");
                this.konsTitle = String.valueOf(this.konsultation.getLabel()) + " f\u00fcr " + this.konsultation.getFall().getPatient().getPersonalia();
                if (!Helpers.hasRightToChangeConsultations(this.konsultation, false)) {
                    this.konsTitle = String.valueOf(this.konsTitle) + " Nicht editierbar (Zugriffsrechte/Verrechnet)";
                }
                this.fallTitle = this.konsultation.getFall().getLabel();
                List<Problem> problems = Problem.getProblemsOfKonsultation(this.konsultation);
                this.problemsText = this.assembleProblemsText(problems);
                this.konsText = this.konsultation.getEintrag().getHead();
                if (this.konsText == null) {
                    this.konsText = "";
                }
                if (this.showCharges) {
                    List leistungen = this.konsultation.getLeistungen();
                    List<String> leistungenLabels = this.replaceBlocks(leistungen);
                    StringBuffer sb = new StringBuffer();
                    boolean isFirst = true;
                    for (String leistungLabel : leistungenLabels) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            sb.append(lineSeparator);
                        }
                        sb.append(leistungLabel);
                    }
                    this.verrechnungenText = sb.toString();
                } else {
                    this.verrechnungenText = KonsListComposite.TEXT_NOT_SHOWN;
                }
            } else {
                this.konsTitle = "";
                this.fallTitle = "";
                this.problemsText = "";
                this.konsText = "";
                this.verrechnungenText = "";
            }
        }

        private String assembleProblemsText(List<Problem> problems) {
            String lineSeparator = System.getProperty("line.separator");
            StringBuffer sb = new StringBuffer();
            if (problems != null) {
                boolean isFirst = true;
                for (Problem problem : problems) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(lineSeparator);
                    }
                    sb.append(problem.getTitle());
                }
            }
            return sb.toString();
        }

        private List<String> replaceBlocks(List<Verrechnet> leistungen) {
            ArrayList<String> labels = new ArrayList<String>();
            for (Verrechnet leistung : leistungen) {
                labels.add(verrechnetLabelProvider.getText((Object)leistung));
            }
            return labels;
        }
    }

    public class MyLayout
    extends Layout
    implements ILayoutExtension {
        private static final int TITLE_SPACING = 2;
        private static final int ROW_SPACING = 4;
        private int minWidthCache = -1;
        private int maxWidthCache = -1;
        private Point labelSizeCache = null;
        private Point rowSizeTotalCache = null;

        public int computeMinimumWidth(Composite parent, boolean changed) {
            return this.computeMinimumMaximumWidth(parent, changed, false);
        }

        public int computeMaximumWidth(Composite parent, boolean changed) {
            return this.computeMinimumMaximumWidth(parent, changed, true);
        }

        private int computeMinimumMaximumWidth(Composite parent, boolean changed, boolean max) {
            if (!changed) {
                if (max) {
                    if (this.maxWidthCache != -1) {
                        return this.maxWidthCache;
                    }
                } else if (this.minWidthCache != -1) {
                    return this.minWidthCache;
                }
            }
            this.maxWidthCache = -1;
            this.minWidthCache = -1;
            int sashWidthLeft = ((KonsListComposite)KonsListComposite.this).sashLeft.computeSize((int)-1, (int)-1).x;
            int sashWidthRight = ((KonsListComposite)KonsListComposite.this).sashRight.computeSize((int)-1, (int)-1).x;
            int leftWidth = 0;
            int middleWidth = 0;
            int rightWidth = 0;
            int totalWidth = 0;
            for (WidgetRow row : KonsListComposite.this.widgetRows) {
                if (row.konsData == null) continue;
                int width = row.hTitle.computeSize((int)-1, (int)-1, (boolean)changed).x + row.lFall.computeSize((int)-1, (int)-1, (boolean)changed).x;
                if (width > totalWidth) {
                    totalWidth = width;
                }
                if ((width = max ? row.problems.computeSize((int)-1, (int)-1, (boolean)true).x : row.problems.computeSize((int)5, (int)-1, (boolean)true).x) > leftWidth) {
                    leftWidth = width;
                }
                if ((width = max ? row.etf.computeSize((int)-1, (int)-1, (boolean)true).x : row.etf.computeSize((int)5, (int)-1).x) > middleWidth) {
                    middleWidth = width;
                }
                if ((width = max ? row.verrechnung.computeSize((int)-1, (int)-1, (boolean)true).x : row.verrechnung.computeSize((int)5, (int)-1).x) <= rightWidth) continue;
                rightWidth = width;
            }
            int width = Math.max(totalWidth, leftWidth + middleWidth + rightWidth);
            width += sashWidthLeft + sashWidthRight;
            if (max) {
                this.maxWidthCache = width;
            } else {
                this.minWidthCache = width;
            }
            return width;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point size = this.layout(false, flushCache);
            return size;
        }

        protected void layout(Composite composite, boolean flushCache) {
            this.layout(true, flushCache);
        }

        private Point layout(boolean move, boolean flushCache) {
            int width = ((KonsListComposite)KonsListComposite.this).composite.getSize().x;
            if (KonsListComposite.this.loadingLabel.isVisible()) {
                return this.layoutLoadingLabel(move, width, flushCache);
            }
            return this.layoutRows(move, width, flushCache);
        }

        private Point layoutLoadingLabel(boolean move, int width, boolean flushCache) {
            Point size;
            if (!flushCache && this.labelSizeCache != null) {
                size = new Point(this.labelSizeCache.x, this.labelSizeCache.y);
            } else {
                size = KonsListComposite.this.loadingLabel.computeSize(width, -1, flushCache);
                this.labelSizeCache = new Point(size.x, size.y);
            }
            if (move) {
                KonsListComposite.this.loadingLabel.setSize(size);
            }
            return size;
        }

        private void initializeCaches(boolean flushCache) {
            if (flushCache) {
                this.rowSizeTotalCache = null;
            }
        }

        private Point layoutRows(boolean move, int width, boolean flushCache) {
            int cfgSashXPercentRight;
            int cfgSashXPercentLeft;
            this.initializeCaches(flushCache);
            if (!move && !flushCache && this.rowSizeTotalCache != null) {
                return new Point(this.rowSizeTotalCache.x, this.rowSizeTotalCache.y);
            }
            if (KonsListComposite.this.widgetRows == null) {
                this.rowSizeTotalCache = new Point(0, 0);
                return new Point(0, 0);
            }
            int sashWidthLeft = ((KonsListComposite)KonsListComposite.this).sashLeft.computeSize((int)-1, (int)-1).x;
            int sashWidthRight = ((KonsListComposite)KonsListComposite.this).sashRight.computeSize((int)-1, (int)-1).x;
            int sashXLeft = KonsListComposite.this.currentSashXPercentLeft != -1 ? KonsListComposite.this.percentToAbsolute(width, KonsListComposite.this.currentSashXPercentLeft) : ((cfgSashXPercentLeft = CoreHub.localCfg.get(KonsListComposite.CFG_SASH_X_PERCENT_LEFT, -1)) != -1 && cfgSashXPercentLeft < 100 ? KonsListComposite.this.percentToAbsolute(width, cfgSashXPercentLeft) : KonsListComposite.this.percentToAbsolute(width, 10));
            int sashXRight = KonsListComposite.this.currentSashXPercentRight != -1 ? KonsListComposite.this.percentToAbsolute(width, KonsListComposite.this.currentSashXPercentRight) : ((cfgSashXPercentRight = CoreHub.localCfg.get(KonsListComposite.CFG_SASH_X_PERCENT_RIGHT, -1)) != -1 && cfgSashXPercentRight < 100 ? KonsListComposite.this.percentToAbsolute(width, cfgSashXPercentRight) : KonsListComposite.this.percentToAbsolute(width, 75));
            int leftX = 0;
            int middleX = sashXLeft + sashWidthLeft;
            int rightX = sashXRight + sashWidthRight;
            int leftWidth = sashXLeft;
            int middleWidth = sashXRight - middleX;
            int rightWidth = width - rightX;
            int y = 0;
            for (WidgetRow row : KonsListComposite.this.widgetRows) {
                if (row.konsData == null) continue;
                Point konsTitleSize = row.hTitle.computeSize(-1, -1, flushCache);
                Point fallTitleSize = row.lFall.computeSize(-1, -1, flushCache);
                int konsTitleWidth = konsTitleSize.x;
                int fallTitleWidth = Math.min(width - konsTitleWidth, fallTitleSize.x);
                int currentHeight = Math.max(konsTitleSize.y, fallTitleSize.y);
                if (move) {
                    row.hTitle.setBounds(leftX, y, konsTitleWidth, currentHeight);
                    row.lFall.setBounds(width - fallTitleWidth, y, fallTitleWidth, currentHeight);
                    row.hTitle.moveAbove((Control)KonsListComposite.this.sashLeft);
                    row.lFall.moveAbove((Control)KonsListComposite.this.sashRight);
                }
                y += currentHeight + 2;
                Point problemsSize = row.problems.computeSize(leftWidth, -1, flushCache);
                Point etfSize = row.etf.computeSize(middleWidth, -1, flushCache);
                Point verrechnungSize = row.verrechnung.computeSize(rightWidth, -1, flushCache);
                currentHeight = Math.max(Math.max(problemsSize.y, etfSize.y), verrechnungSize.y);
                if (move) {
                    row.problems.setBounds(leftX, y, leftWidth, currentHeight);
                    row.etf.setBounds(middleX, y, middleWidth, currentHeight);
                    row.verrechnung.setBounds(rightX, y, rightWidth, currentHeight);
                    row.horizontalSeparator.setBounds(leftX, y + currentHeight, width, 1);
                    row.horizontalSeparator.moveAbove((Control)KonsListComposite.this.sashLeft);
                    row.horizontalSeparator.moveAbove((Control)KonsListComposite.this.sashRight);
                }
                y += currentHeight + 1 + 4;
            }
            int height = y - 4;
            if (move) {
                KonsListComposite.this.sashLeft.setBounds(sashXLeft, 0, sashWidthLeft, height);
                KonsListComposite.this.sashRight.setBounds(sashXRight, 0, sashWidthRight, height);
            }
            Point size = new Point(width, height);
            this.rowSizeTotalCache = new Point(width, height);
            return size;
        }
    }

    private class WidgetRow {
        Hyperlink hTitle;
        Label lFall;
        Text problems;
        EnhancedTextFieldRO etf;
        Text verrechnung;
        Label horizontalSeparator;
        KonsData konsData;
        List<Control> controls = new ArrayList<Control>();

        WidgetRow(Composite parent) {
            this.hTitle = KonsListComposite.this.toolkit.createHyperlink(parent, "", 0);
            this.hTitle.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    if (KonsListComposite.this.actKons != null && WidgetRow.this.konsData.konsultation != null) {
                        boolean enableFire;
                        Konsultation selectedKons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
                        boolean bl = enableFire = !WidgetRow.this.konsData.konsultation.getId().contentEquals(selectedKons == null ? "" : selectedKons.getId());
                        if (enableFire) {
                            log.debug("fireSelectionEvent " + WidgetRow.this.konsData.konsultation.getId() + " " + WidgetRow.this.konsData.konsultation.getDatum());
                            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)WidgetRow.this.konsData.konsultation);
                        } else {
                            KonsListComposite.this.refeshHyperLinks(selectedKons);
                        }
                    }
                }
            });
            this.controls.add((Control)this.hTitle);
            this.lFall = KonsListComposite.this.toolkit.createLabel(parent, "");
            this.controls.add((Control)this.lFall);
            this.problems = KonsListComposite.this.toolkit.createText(parent, "", 10);
            this.controls.add((Control)this.problems);
            this.etf = new EnhancedTextFieldRO(parent);
            this.controls.add((Control)this.etf);
            KonsListComposite.this.toolkit.adapt((Composite)this.etf);
            this.verrechnung = KonsListComposite.this.toolkit.createText(parent, "", 10);
            this.controls.add((Control)this.verrechnung);
            this.horizontalSeparator = KonsListComposite.this.toolkit.createLabel(parent, "", 258);
            this.controls.add((Control)this.horizontalSeparator);
            this.konsData = null;
            this.showControls(false);
        }

        public void setKonsData(KonsData konsData) {
            this.konsData = konsData;
            if (konsData != null) {
                this.showControls(true);
            } else {
                this.showControls(false);
            }
            this.refresh();
        }

        private void refresh() {
            if (this.konsData != null) {
                this.hTitle.setText(this.konsData.konsTitle);
                this.lFall.setText(this.konsData.fallTitle);
                this.problems.setText(this.konsData.problemsText);
                this.etf.setText(this.konsData.konsText);
                this.verrechnung.setText(this.konsData.verrechnungenText);
            } else {
                this.hTitle.setText("");
                this.lFall.setText("");
                this.problems.setText("");
                this.etf.setText("");
                this.verrechnung.setText("");
            }
        }

        void showControls(boolean visible) {
            for (Control control : this.controls) {
                if (control == null) continue;
                control.setVisible(visible);
            }
        }
    }
}

