/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.widgets;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Rechnungssteller;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionedResource;
import com.tiff.common.ui.datepicker.EnhancedDatePickerCombo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.iatrix.util.Helpers;
import org.iatrix.views.JournalView;
import org.iatrix.widgets.IJournalArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KonsHeader
implements IJournalArea {
    private Konsultation actKons = null;
    private FormToolkit tk = UiDesk.getToolkit();
    private Composite konsFallArea;
    private EnhancedDatePickerCombo hlKonsultationDatum = null;
    private Hyperlink hlMandant;
    private Hyperlink hlAuthor;
    private String hlAuthorLabel = "Ersteller";
    private String hlAuthorLabelOkay = "von Ihnen";
    private Combo cbFall;
    private Label cbLabel;
    private Patient actPat = null;
    private static Logger log = LoggerFactory.getLogger(KonsHeader.class);

    public KonsHeader(Composite konsultationComposite) {
        this.konsFallArea = this.tk.createComposite(konsultationComposite);
        this.konsFallArea.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.konsFallArea.setLayout((Layout)new GridLayout(4, false));
        this.hlKonsultationDatum = new EnhancedDatePickerCombo(this.konsFallArea, 0, new EnhancedDatePickerCombo.ExecuteIfValidInterface(){

            public void doIt() {
                String new_date = new TimeTool(KonsHeader.this.hlKonsultationDatum.getDate().getTime()).toString(4);
                if (KonsHeader.this.actKons != null && !KonsHeader.this.actKons.getDatum().equals(new_date)) {
                    log.info("fire EVENT_UPDATE from hlKonsultationDatum " + KonsHeader.this.actKons.getDatum() + " => " + new_date);
                    KonsHeader.this.actKons.setDatum(new_date, false);
                    JournalView.updateAllKonsAreas(KonsHeader.this.actKons.getFall().getPatient(), KonsHeader.this.actKons, IJournalArea.KonsActions.EVENT_UPDATE);
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)KonsHeader.this.actKons, Konsultation.class, 4)});
                    KonsHeader.this.setKonsDate();
                }
            }
        });
        this.hlKonsultationDatum.setToolTipText("Datum der Konsultation \u00e4ndern");
        this.hlKonsultationDatum.setFont(JFaceResources.getHeaderFont());
        if (this.actKons != null) {
            this.actKons.setDatum(this.hlKonsultationDatum.getText(), false);
        }
        this.hlMandant = this.tk.createHyperlink(this.konsFallArea, "", 0);
        this.hlMandant.setText("--");
        this.hlMandant.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                KontaktSelektor ksl = new KontaktSelektor(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Mandant.class, "Mandant ausw\u00e4hlen", "Auf wen soll diese Kons verrechnet werden?", new String[]{"Kuerzel", "Bezeichnung1", "Bezeichnung2"});
                if (ksl.open() == 0) {
                    KonsHeader.this.actKons.setMandant((Mandant)ksl.getSelection());
                    KonsHeader.this.setKons(KonsHeader.this.actPat, KonsHeader.this.actKons, IJournalArea.KonsActions.ACTIVATE_KONS);
                }
            }
        });
        final String autherOverride = "Ersteller der Konsultation \u00fcberschreiben";
        this.hlAuthor = this.tk.createHyperlink(this.konsFallArea, "", 0);
        this.hlAuthor.setText("--");
        this.hlAuthor.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                VersionedResource resource;
                if (KonsHeader.this.actKons != null && (resource = KonsHeader.this.actKons.getEintrag()) != null) {
                    resource.getVersion(resource.getHeadVersion());
                    int version = resource.getHeadVersion();
                    String actUser = CoreHub.actUser.getLabel();
                    String actLabel = KonsHeader.this.actKons.getLabel();
                    String actAuthor = KonsHeader.this.actKons.getAuthor();
                    MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)autherOverride, (String)String.format("Wollen Sie wirklich f\u00fcr die aktuelle Konsultation %s mit der Version %s den aktuellen Ersteller (%s) durch Sie (%s)\n\u00fcberschreiben? (Keine Wirkung im Moment)", actLabel, version, actAuthor, actUser));
                }
            }
        });
        Composite fallArea = this.tk.createComposite(this.konsFallArea);
        GridData gd = new GridData(131072, 128, true, false);
        fallArea.setLayoutData((Object)gd);
        fallArea.setLayout((Layout)new GridLayout(2, false));
        this.cbLabel = this.tk.createLabel(fallArea, "Fall:");
        this.cbFall = new Combo(fallArea, 12);
        this.cbFall.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cbFall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageDialog msd;
                Fall[] faelle = (Fall[])KonsHeader.this.cbFall.getData();
                int i = KonsHeader.this.cbFall.getSelectionIndex();
                Fall nFall = faelle[i];
                Fall actFall = KonsHeader.this.actKons.getFall();
                if (!nFall.getId().equals(actFall.getId()) && (msd = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Fallzuordnung \u00e4ndern", Images.IMG_LOGO.getImage(), "M\u00f6chten Sie diese Behandlung vom Fall:\n'" + actFall.getLabel() + "' zum Fall:\n'" + nFall.getLabel() + "' transferieren?", 3, new String[]{"Ja", "Nein"}, 0)).open() == 0) {
                    KonsHeader.this.actKons.setFall(nFall);
                    KonsHeader.this.setKons(KonsHeader.this.actPat, KonsHeader.this.actKons, IJournalArea.KonsActions.ACTIVATE_KONS);
                }
            }
        });
        this.tk.adapt((Composite)this.cbFall);
        this.cbFall.setEnabled(false);
    }

    private void setKonsAuthor(Konsultation kons, String newAuthor) {
        VersionedResource resource = kons.getEintrag();
        if (resource != null) {
            VersionedResource.ResourceItem item = resource.getVersion(resource.getHeadVersion());
            if (item != null) {
                item.remark = newAuthor;
            }
            String samdasText = new Samdas(this.actKons.getEintrag().getHead()).getRecordText();
            String newText = String.valueOf(samdasText) + " => " + newAuthor;
            log.debug(String.format("setKonsAuthor for id %s txt %s", kons.getId(), newText));
            kons.updateEintrag(newText, false);
        }
    }

    private void setKonsDate() {
        this.hlKonsultationDatum.setDate(new TimeTool(this.actKons.getDatum().toString()).getTime());
        boolean isEditable = Helpers.hasRightToChangeConsultations(this.actKons, false);
        log.debug("SetDate Enabled " + isEditable + " for " + this.actKons.getId() + " setVisible/parent of " + this.actKons.getDatum());
        this.hlKonsultationDatum.setEnabled(isEditable);
        this.hlKonsultationDatum.setVisible(true);
        this.hlKonsultationDatum.redraw();
        this.hlKonsultationDatum.update();
    }

    @Override
    public void setKons(Patient newPatient, Konsultation newKons, IJournalArea.KonsActions op) {
        Helpers.checkActPatKons(newPatient, newKons);
        if (newPatient == null || newKons == null && newPatient != null) {
            this.actKons = newKons;
            log.debug("setKons set actKons null {}", (Object)op);
            this.cbFall.setEnabled(false);
            this.hlKonsultationDatum.setEnabled(false);
            if (this.hlMandant != null) {
                this.hlMandant.setText("");
                this.hlMandant.setEnabled(false);
            }
            if (this.hlAuthor != null) {
                this.hlAuthor.setText("");
                this.hlAuthor.setEnabled(false);
            }
            this.reloadFaelle(null);
            this.konsFallArea.layout();
            return;
        }
        if (this.actPat == null || newPatient != null && !this.actPat.getId().equals(newPatient.getId())) {
            this.actPat = newPatient;
            this.konsFallArea.layout();
        }
        if (op == IJournalArea.KonsActions.SAVE_KONS) {
            return;
        }
        this.actKons = newKons;
        if (this.cbFall.isDisposed()) {
            return;
        }
        this.cbFall.setEnabled(true);
        StringBuilder sb = new StringBuilder();
        sb.append(this.actKons.getDatum());
        Mandant m = this.actKons.getMandant();
        sb = new StringBuilder();
        if (m == null) {
            sb.append(Messages.KonsDetailView_NotYours);
        } else {
            Rechnungssteller rs = m.getRechnungssteller();
            if (rs.getId().equals(m.getId())) {
                sb.append("(").append(m.getLabel()).append(")");
            } else {
                sb.append("(").append(m.getLabel()).append("/").append(rs.getLabel()).append(")");
            }
        }
        boolean enabled = CoreHub.acl.request(AccessControlDefaults.KONS_REASSIGN);
        this.hlMandant.setBackground(this.konsFallArea.getBackground());
        this.hlMandant.setEnabled(enabled);
        if (enabled) {
            this.hlMandant.setToolTipText("Sie haben die Erlaubnis, Konsultation jemanden anderem zuzuordnen");
        } else {
            this.hlMandant.setToolTipText("Sie haben keine Erlaubnis, Konsultation jemanden anderem zuzuordnen");
        }
        this.hlMandant.setText(sb.toString());
        this.hlAuthor.setBackground(this.konsFallArea.getBackground());
        if (Helpers.userIsKonsAuthor(this.actKons)) {
            this.hlAuthor.setEnabled(false);
            this.hlAuthor.setText(this.hlAuthorLabelOkay);
        } else {
            this.hlAuthor.setText(this.hlAuthorLabel);
            this.hlAuthor.setEnabled(enabled);
        }
        if (this.hlAuthor.isEnabled()) {
            this.hlAuthor.setToolTipText(String.format("Sie k\u00f6nnen den Autor (%s) der aktuellen Konsultation auf Sie (%s) umschreiben", this.actKons.getAuthor(), CoreHub.actUser.getLabel()));
        } else {
            this.hlAuthor.setToolTipText("");
        }
        this.reloadFaelle(this.actKons);
        this.setKonsDate();
        log.debug("setKons {} actKons now {} vom {} Rechnungssteller {} enabled? {}", new Object[]{op, this.actKons.getId(), this.actKons.getLabel(), sb.toString(), enabled});
        this.konsFallArea.layout();
    }

    private void reloadFaelle(Konsultation konsultation) {
        this.cbFall.removeAll();
        if (konsultation != null) {
            Fall fall = konsultation.getFall();
            if (fall == null) {
                return;
            }
            Patient patient = fall.getPatient();
            Fall[] faelle = patient.getFaelle();
            int index = -1;
            int i = 0;
            while (i < faelle.length) {
                if (faelle[i].getId().equals(fall.getId())) {
                    index = i;
                }
                ++i;
            }
            if (index >= 0) {
                this.cbFall.setData((Object)faelle);
                Fall[] fallArray = faelle;
                int n = faelle.length;
                int n2 = 0;
                while (n2 < n) {
                    Fall f = fallArray[n2];
                    this.cbFall.add(f.getLabel());
                    ++n2;
                }
                this.cbFall.select(index);
            }
            String label = fall.getLabel();
            this.cbFall.setBackground(this.cbFall.getDisplay().getSystemColor(1));
            Color color = null;
            color = label.contains("UVG") ? UiDesk.getColor((String)"rot") : (label.contains("KVG") ? this.cbFall.getDisplay().getSystemColor(5) : this.cbFall.getDisplay().getSystemColor(1));
            String explanation = "Die Farben erkl\u00e4ren sich wie folgt: Bei Unfall rot wie Blut, bei Krankheit gr\u00fcn wie Galle, sonst weiss";
            this.cbLabel.setToolTipText(explanation);
            this.cbLabel.setBackground(color);
            this.cbFall.setToolTipText(explanation);
            this.cbFall.getParent().setBackground(color);
        }
    }

    @Override
    public void visible(boolean mode) {
    }

    @Override
    public void activation(boolean mode, Patient selectedPat, Konsultation selectedKons) {
        if (mode) {
            this.setKons(selectedPat, selectedKons, IJournalArea.KonsActions.ACTIVATE_KONS);
        }
    }
}

