/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.widgets;

import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.iatrix.util.Helpers;
import org.iatrix.widgets.IJournalArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KonsDiagnosen
implements IJournalArea {
    private Konsultation actKons = null;
    private CLabel lDiagnosis;
    private static Logger log = LoggerFactory.getLogger(KonsDiagnosen.class);

    public KonsDiagnosen(Composite konsultationComposite) {
        this.lDiagnosis = new CLabel(konsultationComposite, 16384);
        this.lDiagnosis.setText("");
        FormToolkit tk = UiDesk.getToolkit();
        tk.adapt((Composite)this.lDiagnosis);
        this.lDiagnosis.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
    }

    private void setDiagnosenText(Konsultation konsultation) {
        String text = "";
        Image image = null;
        this.actKons = konsultation;
        if (konsultation != null) {
            ArrayList diagnosen = konsultation.getDiagnosen();
            if (diagnosen != null && diagnosen.size() > 0) {
                ArrayList<String> dxList = new ArrayList<String>();
                for (IDiagnose diagnose : diagnosen) {
                    dxList.add(diagnose.getLabel());
                }
                text = "Diagnosen: " + StringTool.join(dxList, (String)", ");
            } else {
                text = "Keine Diagnosen";
                image = Images.IMG_ACHTUNG.getImage();
            }
        }
        this.lDiagnosis.setText(PersistentObject.checkNull((Object)text));
        this.lDiagnosis.setImage(image);
        this.logEvent("setDiagnosenText");
    }

    private void updateKonsultation(boolean updateText) {
        if (this.actKons != null) {
            this.setDiagnosenText(this.actKons);
        } else {
            this.setDiagnosenText(null);
        }
        this.logEvent("updateKonsultation");
    }

    private void logEvent(String msg) {
        StringBuilder sb = new StringBuilder(String.valueOf(msg) + ": ");
        sb.append(String.valueOf(this.lDiagnosis.getText()) + " ");
        if (this.actKons == null) {
            sb.append("actKons null ");
        } else {
            sb.append(this.actKons.getId());
            Patient pat = this.actKons.getFall().getPatient();
            sb.append(" kons vom " + this.actKons.getDatum());
            sb.append(" " + pat.getId() + ": " + pat.getPersonalia());
        }
        log.debug(sb.toString());
    }

    @Override
    public void setKons(Patient newPatient, Konsultation newKons, IJournalArea.KonsActions op) {
        Helpers.checkActPatKons(newPatient, newKons);
        if (newPatient == null || newKons == null) {
            this.actKons = null;
            this.updateKonsultation(true);
        }
        boolean konsChanged = !Helpers.twoKonsSamePatient(this.actKons, newKons);
        this.logEvent("setKons " + (newKons != null ? String.valueOf(newKons.getId()) + " vom " + newKons.getDatum() : "null") + " konsChanged: " + konsChanged);
        if (op == IJournalArea.KonsActions.ACTIVATE_KONS || konsChanged) {
            this.updateKonsultation(true);
        }
        this.actKons = newKons;
    }

    @Override
    public void visible(boolean mode) {
    }

    @Override
    public void activation(boolean mode, Patient selectedPat, Konsultation selectedKons) {
        if (!mode) {
            this.setDiagnosenText(null);
        }
    }
}

