/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.widgets;

import ch.elexis.core.model.ISticker;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.data.UiSticker;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Sticker;
import ch.rgw.tools.ExHandler;
import java.util.List;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.iatrix.util.Helpers;
import org.iatrix.widgets.IJournalArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalHeader
implements IJournalArea {
    private Patient actPat = null;
    private FormToolkit tk = UiDesk.getToolkit();
    private static Logger log = LoggerFactory.getLogger(JournalHeader.class);
    private Hyperlink formTitel;
    private Label remarkLabel;
    private Label kontoLabel;
    private Color kontoLabelColor;
    Composite cEtiketten;

    public JournalHeader(Composite formBody) {
        formBody.setLayout((Layout)new GridLayout(1, true));
        Composite formHeader = new Composite(formBody, 0);
        this.tk.adapt(formHeader);
        formHeader.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        formHeader.setLayout((Layout)new GridLayout(3, false));
        this.formTitel = this.tk.createHyperlink(formHeader, "Iatrix KG", 64);
        this.formTitel.setFont(JFaceResources.getHeaderFont());
        this.formTitel.setText("Kein Patient ausgew\u00e4hlt");
        this.formTitel.setEnabled(false);
        this.formTitel.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (JournalHeader.this.actPat != null) {
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.PatDetail_v2");
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                        log.error("Fehler beim \u00d6ffnen von PatientDetailView: " + ex.getMessage());
                    }
                }
            }
        });
        Composite patInfoArea = this.tk.createComposite(formHeader);
        GridData gd = SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false);
        patInfoArea.setLayoutData((Object)gd);
        GridLayout infoLayout = new GridLayout(2, false);
        infoLayout.horizontalSpacing = 5;
        infoLayout.verticalSpacing = 0;
        infoLayout.marginWidth = 0;
        infoLayout.marginHeight = 0;
        patInfoArea.setLayout((Layout)infoLayout);
        this.remarkLabel = this.tk.createLabel(patInfoArea, "");
        gd = new GridData(16384, 128, false, false);
        this.remarkLabel.setLayoutData((Object)gd);
        this.remarkLabel.setBackground(patInfoArea.getDisplay().getSystemColor(7));
        this.remarkLabel.setToolTipText("Bemerkung kann via Doppelclick ge\u00e4ndert werden");
        this.remarkLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                JournalHeader.this.openRemarkEditorDialog();
            }
        });
        this.cEtiketten = new Composite(patInfoArea, 0);
        this.cEtiketten.setLayout((Layout)new RowLayout(256));
        this.cEtiketten.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cEtiketten.setBackground(patInfoArea.getBackground());
        Composite kontoArea = this.tk.createComposite(formHeader);
        gd = new GridData(0x1000008, 0x1000000, true, false);
        kontoArea.setLayoutData((Object)gd);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        kontoArea.setLayout((Layout)gridLayout);
        Hyperlink kontoHyperlink = this.tk.createHyperlink(kontoArea, "Kontostand:", 0);
        kontoHyperlink.setData("TEST_COMP_NAME", (Object)"KG_Iatrix_acount_balance_hl");
        kontoHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (JournalHeader.this.actPat != null) {
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.views.rechnung.AccountView");
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                        log.error("Fehler beim \u00d6ffnen von AccountView: " + ex.getMessage());
                    }
                }
            }
        });
        this.kontoLabel = this.tk.createLabel(kontoArea, "", 131072);
        gd = SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false);
        gd.verticalAlignment = 3;
        this.kontoLabel.setLayoutData((Object)gd);
        this.kontoLabelColor = this.kontoLabel.getForeground();
        Hyperlink openBillsHyperlink = this.tk.createHyperlink(kontoArea, "Rechnungs\u00fcbersicht", 0);
        openBillsHyperlink.setData("TEST_COMP_NAME", (Object)"KG_Iatrix_account_overview_hl");
        openBillsHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (JournalHeader.this.actPat != null) {
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.views.rechnung.BillSummary");
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                        log.error("Fehler beim \u00d6ffnen von AccountView: " + ex.getMessage());
                    }
                }
            }
        });
        openBillsHyperlink.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.formTitel.getParent().layout();
    }

    private void setPatientTitel() {
        String text = "Kein Patient ausgew\u00e4hlt";
        this.formTitel.setEnabled(this.actPat != null);
        if (this.actPat != null) {
            text = this.actPat.getLabel();
        }
        this.formTitel.setText(PersistentObject.checkNull((Object)text));
        this.formTitel.getParent().layout();
    }

    private Composite createStickerWithTooltip(Composite parent, ISticker et) {
        Image img = new UiSticker((Sticker)et).getImage();
        if (img == null) {
            img = this.actPat.getGeschlecht().equals("m") ? Images.IMG_MANN.getImage() : Images.IMG_FRAU.getImage();
        }
        GridData gd1 = null;
        Composite cImg = new Composite(parent, 0);
        if (img != null) {
            cImg.setBackgroundImage(img);
            gd1 = new GridData(img.getBounds().width, img.getBounds().height);
        } else {
            gd1 = new GridData(10, 10);
        }
        cImg.setLayoutData((Object)gd1);
        cImg.setToolTipText(et.getLabel());
        return cImg;
    }

    private void setRemarkAndSticker() {
        String text = "";
        if (this.actPat != null) {
            text = this.actPat.getBemerkung();
        }
        Control[] controlArray = this.cEtiketten.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control cc = controlArray[n2];
            cc.dispose();
            ++n2;
        }
        if (this.actPat != null) {
            List etis = this.actPat.getStickers();
            GridLayout stickerLayout = new GridLayout(etis.size(), false);
            stickerLayout.horizontalSpacing = 5;
            stickerLayout.verticalSpacing = 0;
            stickerLayout.marginWidth = 0;
            stickerLayout.marginHeight = 0;
            this.cEtiketten.setLayout((Layout)stickerLayout);
            if (etis.size() > 0) {
                for (ISticker et : etis) {
                    if (et == null) continue;
                    this.createStickerWithTooltip(this.cEtiketten, et);
                }
            }
        }
        if (PersistentObject.checkNull((Object)text).length() == 0) {
            this.remarkLabel.setText("Bemerkungen");
        } else {
            this.remarkLabel.setText(PersistentObject.checkNull((Object)text));
        }
    }

    private void setKontoText() {
        this.kontoLabel.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean tardyPayer = false;
                if (JournalHeader.this.remarkLabel.isDisposed()) {
                    return;
                }
                String text = "";
                if (JournalHeader.this.actPat != null) {
                    text = JournalHeader.this.actPat.getKontostand().getAmountAsString();
                    tardyPayer = JournalHeader.this.isTardyPayer(JournalHeader.this.actPat);
                }
                JournalHeader.this.kontoLabel.setText(PersistentObject.checkNull((Object)text));
                if (JournalHeader.this.kontoLabel.getText() == null || JournalHeader.this.kontoLabel.getText().length() == 0) {
                    JournalHeader.this.kontoLabel.setText("leeres Konto");
                }
                JournalHeader.this.kontoLabel.getParent().layout();
                Color textColor = tardyPayer ? JournalHeader.this.kontoLabel.getDisplay().getSystemColor(3) : JournalHeader.this.kontoLabelColor;
                JournalHeader.this.kontoLabel.setForeground(textColor);
                JournalHeader.this.formTitel.getParent().layout();
            }
        });
    }

    private void openRemarkEditorDialog() {
        if (this.actPat == null) {
            return;
        }
        String initialValue = PersistentObject.checkNull((Object)this.actPat.getBemerkung());
        InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Bemerkungen", "Bemerkungen eingeben", initialValue, null);
        if (dialog.open() == 0) {
            String text = dialog.getValue();
            this.actPat.setBemerkung(text);
            this.setRemarkAndSticker();
        }
    }

    private boolean isTardyPayer(Patient patient) {
        Query query = new Query(Rechnung.class);
        Fall[] faelle = patient.getFaelle();
        if (faelle != null && faelle.length > 0) {
            query.startGroup();
            query.insertFalse();
            query.or();
            Fall[] fallArray = faelle;
            int n = faelle.length;
            int n2 = 0;
            while (n2 < n) {
                Fall fall = fallArray[n2];
                if (fall.isOpen()) {
                    query.add("FallID", "=", fall.getId());
                }
                ++n2;
            }
        } else {
            return false;
        }
        query.endGroup();
        query.and();
        query.startGroup();
        query.insertFalse();
        query.or();
        int s = 6;
        while (s <= 14) {
            query.add("RnStatus", "=", new Integer(s).toString());
            ++s;
        }
        query.endGroup();
        List rechnungen = query.execute();
        return rechnungen != null && rechnungen.size() > 0;
    }

    @Override
    public void setKons(Patient newPatient, Konsultation newKons, IJournalArea.KonsActions op) {
        Helpers.checkActPatKons(newPatient, newKons);
        if (this.actPat == null || newPatient == null || !this.actPat.getId().equals(newPatient.getId())) {
            this.actPat = newPatient;
            this.setPatientTitel();
            this.setRemarkAndSticker();
            this.setKontoText();
            this.formTitel.getParent().layout();
        }
    }

    @Override
    public void visible(boolean mode) {
    }

    @Override
    public void activation(boolean mode, Patient selectedPat, Konsultation selectedKons) {
        if (mode) {
            this.setKons(selectedPat, selectedKons, IJournalArea.KonsActions.ACTIVATE_KONS);
        }
    }
}

