/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.widgets;

import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.util.SWTHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class EnhancedTextFieldRO
extends Composite {
    StyledText text;
    List<Samdas.XRef> links;
    List<Samdas.Markup> markups;
    List<Samdas.Range> ranges;
    Samdas samdas;
    Samdas.Record record;
    private static Pattern outline = Pattern.compile("^\\S+:", 8);
    private static Pattern bold = Pattern.compile("\\*\\S+\\*");
    private static Pattern italic = Pattern.compile("\\/\\S+\\/");
    private static Pattern underline = Pattern.compile("_\\S+_");

    public EnhancedTextFieldRO(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new TableWrapLayout());
        this.text = new StyledText((Composite)this, 72);
        this.text.setLayoutData((Object)SWTHelper.getFillTableWrapData((int)1, (boolean)true, (int)1, (boolean)true));
        this.text.setWordWrap(true);
    }

    void doFormat(String tx) {
        StyleRange n;
        this.text.setStyleRange(null);
        if (tx.startsWith("<")) {
            this.doFormatXML(tx);
            tx = this.text.getText();
        } else {
            this.samdas = new Samdas(tx);
            this.record = this.samdas.getRecord();
            this.text.setText(tx);
        }
        Matcher matcher = outline.matcher(tx);
        while (matcher.find()) {
            n = new StyleRange();
            n.start = matcher.start();
            n.length = matcher.end() - n.start;
            n.fontStyle = 1;
            this.text.setStyleRange(n);
        }
        matcher = bold.matcher(tx);
        while (matcher.find()) {
            n = new StyleRange();
            n.start = matcher.start();
            n.length = matcher.end() - n.start;
            n.fontStyle = 1;
            this.text.setStyleRange(n);
        }
        matcher = italic.matcher(tx);
        while (matcher.find()) {
            n = new StyleRange();
            n.start = matcher.start();
            n.length = matcher.end() - n.start;
            n.fontStyle = 2;
            this.text.setStyleRange(n);
        }
        matcher = underline.matcher(tx);
        while (matcher.find()) {
            n = new StyleRange();
            n.start = matcher.start();
            n.length = matcher.end() - n.start;
            n.underline = true;
            this.text.setStyleRange(n);
        }
    }

    void doFormatXML(String tx) {
        this.samdas = new Samdas(tx);
        this.record = this.samdas.getRecord();
        List xrefs = this.record.getXrefs();
        this.text.setText(this.record.getText());
        int textlen = this.text.getCharCount();
        this.markups = this.record.getMarkups();
        this.links = new ArrayList<Samdas.XRef>(xrefs.size());
        this.ranges = new ArrayList<Samdas.Range>(xrefs.size() + this.markups.size());
        for (Samdas.Markup m : this.markups) {
            String type = m.getType();
            StyleRange n = new StyleRange();
            n.start = m.getPos();
            n.length = m.getLength();
            if (type.equalsIgnoreCase("emphasized")) {
                n.strikeout = true;
            } else if (type.equalsIgnoreCase("bold")) {
                n.fontStyle = 1;
            } else if (type.equalsIgnoreCase("italic")) {
                n.fontStyle = 2;
            } else if (type.equalsIgnoreCase("underlined")) {
                n.underline = true;
            }
            if (n.start + n.length > textlen) {
                n.length = textlen - n.start;
            }
            if (n.length > 0 && n.start >= 0) {
                this.text.setStyleRange(n);
                this.ranges.add((Samdas.Range)m);
                continue;
            }
            this.record.remove((Samdas.Range)m);
        }
    }

    private Document getDocument() {
        this.record.setText(this.text.getText());
        return this.samdas.getDocument();
    }

    private String getContentsAsXML() {
        XMLOutputter xo = new XMLOutputter(Format.getRawFormat());
        return xo.outputString(this.getDocument());
    }

    public void createMarkup(char type, int pos, int len) {
        String typ = "bold";
        switch (type) {
            case '/': {
                typ = "italic";
                break;
            }
            case '_': {
                typ = "underline";
            }
        }
        Samdas.Markup markup = new Samdas.Markup(pos, len, typ);
        this.record.add((Samdas.Range)markup);
        this.doFormat(this.getContentsAsXML());
    }

    public void replace(int start, int len, String nt) {
        this.text.replaceTextRange(start, len, nt);
    }

    public void setText(String ntext) {
        this.doFormat(ntext);
    }

    public Control getControl() {
        return this.text;
    }
}

