/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.views;

import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.ViewMenus;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class WebBrowserView
extends ViewPart
implements ISaveablePart2 {
    public static final String ID = "org.iatrix.views.WebBrowserView";
    private static final String PROP_TITLE = "title";
    private static final String PROP_URL = "url";
    private Browser browser;
    private Action newViewAction;
    private Action editLocationAction;
    private Action editTitleAction;

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createToolbar(new IAction[]{this.newViewAction, this.editLocationAction});
        menu.createMenu(new IAction[]{this.newViewAction, this.editLocationAction, this.editTitleAction});
        if (this.getViewSite().getSecondaryId() == null) {
            this.editTitleAction.setEnabled(false);
        }
        this.initialize();
    }

    private void makeActions() {
        this.newViewAction = new Action("Neues Fenster"){
            {
                this.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
                this.setToolTipText("Ein neues Fenster \u00f6ffnen");
            }

            public void run() {
                try {
                    WebBrowserView.this.getViewSite().getPage().showView(WebBrowserView.ID, StringTool.unique((String)WebBrowserView.ID), 1);
                }
                catch (PartInitException e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        };
        this.editLocationAction = new Action("Adresse \u00e4ndern"){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText("Die Adresse der gew\u00fcnschten Website angeben");
            }

            public void run() {
                String current = WebBrowserView.this.browser.getUrl();
                InputDialog dialog = new InputDialog(WebBrowserView.this.getSite().getShell(), "Adresse \u00e4ndern", "Bitte geben Sie die neue Adresse ein", current, null);
                if (dialog.open() == 0) {
                    String location = dialog.getValue();
                    WebBrowserView.this.setPartProperty(WebBrowserView.PROP_URL, location);
                    WebBrowserView.this.setLocation(location);
                }
            }
        };
        this.editTitleAction = new Action("Titel \u00e4ndern"){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText("Den Titel dieser View angeben");
            }

            public void run() {
                String current = WebBrowserView.this.getPartName();
                InputDialog dialog = new InputDialog(WebBrowserView.this.getSite().getShell(), "Titel \u00e4ndern", "Bitte geben Sie den neuen Titel ein", current, null);
                if (dialog.open() == 0) {
                    String title = dialog.getValue();
                    WebBrowserView.this.setPartProperty(WebBrowserView.PROP_TITLE, title);
                    WebBrowserView.this.setPartName(title);
                }
            }
        };
    }

    public void setLocation(String location) {
        if (location != null) {
            this.browser.setUrl(location);
        }
    }

    public void initialize() {
        String title = this.getPartProperty(PROP_TITLE);
        if (title != null) {
            this.setPartName(title);
        }
        String location = this.getPartProperty(PROP_URL);
        this.setLocation(location);
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }
}

