/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.icpc.Episode;
import ch.rgw.tools.ExHandler;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;
import org.iatrix.actions.IatrixEventHelper;
import org.iatrix.data.Problem;
import org.iatrix.views.IatrixViewTool;
import org.iatrix.views.JournalView;
import org.iatrix.widgets.ProblemFixMediDisplay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProblemView
extends ViewPart
implements IActivationListener,
ISaveablePart2 {
    public static final String ID = "org.iatrix.views.ProblemView";
    private static Logger log = LoggerFactory.getLogger(JournalView.class);
    private Problem actProblem;
    private FormToolkit tk;
    private ScrolledForm form;
    private ExpandableComposite dauermedikationSection;
    private ProblemFixMediDisplay dlDauerMedi;
    private Composite diagnosenComposite;
    private TableViewer diagnosenViewer;
    private TableViewer konsultationenViewer;
    private IAction delDiagnoseAction;
    private IAction unassignProblemAction;
    private ViewMenus menus;
    private ElexisUiEventListenerImpl eeli_problem = null;
    private ElexisUiEventListenerImpl eeli_patient = null;

    private void makeListeners() {
        this.eeli_problem = new ElexisUiEventListenerImpl(Episode.class, 52){

            public void runInUi(ElexisEvent ev) {
                if (ev.getType() == 16) {
                    PersistentObject obj = ev.getObject();
                    if (obj instanceof Episode) {
                        Episode episode = (Episode)obj;
                        ProblemView.this.setProblem(Problem.convertEpisodeToProblem(episode));
                    } else {
                        ProblemView.this.setProblem(null);
                    }
                } else if (ev.getType() == 32) {
                    ProblemView.this.setProblem(null);
                } else if (ev.getType() == 4) {
                    PersistentObject obj = ev.getObject();
                    if (obj instanceof Episode) {
                        Episode updatedEpisode = (Episode)obj;
                        Problem actEpisode = ProblemView.this.actProblem;
                        if (updatedEpisode.getId().equals(actEpisode.getId())) {
                            ProblemView.this.setProblem(ProblemView.this.actProblem);
                        }
                    } else {
                        ProblemView.this.setProblem(null);
                    }
                }
            }
        };
        this.eeli_patient = new ElexisUiEventListenerImpl(Patient.class, 48){

            public void runInUi(ElexisEvent ev) {
                PersistentObject obj;
                if (ev.getType() == 16 && (obj = ev.getObject()) instanceof Patient) {
                    Patient selectedPatient = (Patient)obj;
                    if (ProblemView.this.actProblem != null) {
                        if (selectedPatient != null && !ProblemView.this.actProblem.getPatient().getId().equals(selectedPatient.getId())) {
                            ProblemView.this.setProblem(null);
                        }
                    } else {
                        Problem previousProblem = IatrixEventHelper.getSelectedProblem();
                        if (selectedPatient != null && previousProblem != null && previousProblem.getPatient().getId().equals(selectedPatient.getId())) {
                            ProblemView.this.setProblem(previousProblem);
                        }
                    }
                }
            }
        };
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FillLayout());
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createScrolledForm(main);
        this.form.getBody().setLayout((Layout)new GridLayout(1, true));
        SashForm mainSash = new SashForm(this.form.getBody(), 512);
        mainSash.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.dauermedikationSection = this.tk.createExpandableComposite((Composite)mainSash, 66);
        this.dauermedikationSection.setText("Fixmedikation");
        Composite dauermedikationComposite = this.tk.createComposite((Composite)this.dauermedikationSection);
        this.dauermedikationSection.setClient((Control)dauermedikationComposite);
        Composite bottomComposite = this.tk.createComposite((Composite)mainSash);
        mainSash.setWeights(new int[]{25, 75});
        dauermedikationComposite.setLayout((Layout)new GridLayout());
        this.dlDauerMedi = new ProblemFixMediDisplay(dauermedikationComposite, this.getViewSite());
        bottomComposite.setLayout((Layout)new GridLayout());
        SashForm bottomSash = new SashForm(bottomComposite, 256);
        bottomSash.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.diagnosenComposite = this.tk.createComposite((Composite)bottomSash);
        Composite konsultationenComposite = this.tk.createComposite((Composite)bottomSash);
        bottomSash.setWeights(new int[]{25, 75});
        this.diagnosenComposite.setLayout((Layout)new GridLayout(1, true));
        Hyperlink hDiagnosen = this.tk.createHyperlink(this.diagnosenComposite, "Diagnosen", 0);
        hDiagnosen.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        hDiagnosen.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    ProblemView.this.getViewSite().getPage().showView("ch.elexis.DiagnosenView");
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    log.error("Fehler beim Starten des Diagnosencodes " + ex.getMessage());
                }
            }
        });
        Table diagnosenTable = this.tk.createTable(this.diagnosenComposite, 4);
        diagnosenTable.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.diagnosenViewer = new TableViewer(diagnosenTable);
        this.diagnosenViewer.getControl().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.diagnosenViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (ProblemView.this.actProblem != null) {
                    List<IDiagnose> diagnosen = ProblemView.this.actProblem.getDiagnosen();
                    return diagnosen.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.diagnosenViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof IDiagnose)) {
                    return "";
                }
                IDiagnose diagnose = (IDiagnose)element;
                return diagnose.getLabel();
            }
        });
        this.diagnosenViewer.setInput((Object)this);
        konsultationenComposite.setLayout((Layout)new GridLayout(1, true));
        Label lKonsultationen = this.tk.createLabel(konsultationenComposite, "Konsultationen", 16384);
        lKonsultationen.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Table konsultationenTable = this.tk.createTable(konsultationenComposite, 4);
        konsultationenTable.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.konsultationenViewer = new TableViewer(konsultationenTable);
        this.konsultationenViewer.getControl().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.konsultationenViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (ProblemView.this.actProblem != null) {
                    List<Konsultation> konsultationen = ProblemView.this.actProblem.getKonsultationen();
                    return konsultationen.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.konsultationenViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof Konsultation)) {
                    return "";
                }
                Konsultation konsultation = (Konsultation)element;
                return konsultation.getLabel();
            }
        });
        this.konsultationenViewer.setInput((Object)this);
        TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] types = new Transfer[]{textTransfer};
        DropTarget dtarget = new DropTarget((Control)this.diagnosenComposite, 1);
        dtarget.setTransfer(types);
        dtarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                String[] dl;
                String drp = (String)event.data;
                String[] stringArray = dl = drp.split(",");
                int n = dl.length;
                int n2 = 0;
                while (n2 < n) {
                    String obj = stringArray[n2];
                    PersistentObject dropped = CoreHub.poFactory.createFromString(obj);
                    if (dropped instanceof IDiagnose) {
                        IDiagnose diagnose = (IDiagnose)dropped;
                        ProblemView.this.actProblem.addDiagnose(diagnose);
                        IatrixEventHelper.updateProblem(ProblemView.this.actProblem);
                        ProblemView.this.diagnosenViewer.refresh();
                    }
                    ++n2;
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        this.makeListeners();
        this.makeActions();
        this.menus = new ViewMenus(this.getViewSite());
        this.menus.createViewerContextMenu((StructuredViewer)this.diagnosenViewer, new IAction[]{this.delDiagnoseAction});
        this.menus.createViewerContextMenu((StructuredViewer)this.konsultationenViewer, new IAction[]{this.unassignProblemAction});
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
    }

    public void setFocus() {
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        super.dispose();
    }

    private void makeActions() {
        this.delDiagnoseAction = new Action("Diagnose entfernen"){

            public void run() {
                Object sel = ((IStructuredSelection)ProblemView.this.diagnosenViewer.getSelection()).getFirstElement();
                if (sel != null && ProblemView.this.actProblem != null) {
                    IDiagnose diagnose = (IDiagnose)sel;
                    ProblemView.this.actProblem.removeDiagnose(diagnose);
                    ProblemView.this.diagnosenViewer.refresh();
                    IatrixEventHelper.updateProblem(ProblemView.this.actProblem);
                }
            }
        };
        this.unassignProblemAction = new Action("Problem entfernen"){
            {
                this.setToolTipText("Problem von Konsulation entfernen");
            }

            public void run() {
                Object sel = ((IStructuredSelection)ProblemView.this.konsultationenViewer.getSelection()).getFirstElement();
                if (sel != null && ProblemView.this.actProblem != null) {
                    Konsultation konsultation = (Konsultation)sel;
                    IatrixViewTool.removeProblemFromKonsultation(konsultation, ProblemView.this.actProblem);
                    ProblemView.this.konsultationenViewer.refresh();
                    IatrixEventHelper.updateProblem(ProblemView.this.actProblem);
                }
            }
        };
    }

    public void activation(boolean mode) {
    }

    public void visible(boolean mode) {
        if (mode) {
            Problem problem = IatrixEventHelper.getSelectedProblem();
            if (problem != null) {
                Patient selectedPatient = ElexisEventDispatcher.getSelectedPatient();
                if (selectedPatient != null && problem.getPatient().getId().equals(selectedPatient.getId())) {
                    this.setProblem(problem);
                } else {
                    this.setProblem(null);
                }
            } else {
                this.setProblem(null);
            }
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_problem, this.eeli_patient});
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_problem, this.eeli_patient});
        }
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    private void setProblem(Problem problem) {
        this.actProblem = problem;
        if (this.actProblem != null) {
            this.form.setText("Problem " + problem.getLabel() + " von " + problem.getPatient().getLabel());
        } else {
            this.form.setText("Kein Problem ausgew\u00e4hlt");
        }
        this.diagnosenViewer.refresh();
        this.konsultationenViewer.refresh();
        this.dlDauerMedi.reload();
        this.dlDauerMedi.reload();
        this.dauermedikationSection.layout(true);
        this.form.reflow(true);
    }

    class Focusreact
    extends FocusAdapter {
        private final String field;

        Focusreact(String f) {
            this.field = f;
        }

        public void focusLost(FocusEvent e) {
            if (ProblemView.this.actProblem == null) {
                return;
            }
            String oldvalue = ProblemView.this.actProblem.get(this.field);
            String newvalue = ((Text)e.getSource()).getText();
            if (oldvalue != null && oldvalue.equals(newvalue)) {
                return;
            }
            if (newvalue != null) {
                ProblemView.this.actProblem.set(this.field, newvalue);
            }
        }
    }
}

