/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.iatrix.widgets.IJournalArea;
import org.iatrix.widgets.KonsListDisplay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KonsListView
extends ViewPart
implements IActivationListener,
ISaveablePart2 {
    public static final String ID = "org.iatrix.views.KonsListView";
    private static final String VIEW_CONTEXT_ID = "org.iatrix.view.konslist.context";
    private static Logger log = LoggerFactory.getLogger(KonsListView.class);
    KonsListDisplay konsListDisplay;
    private FormToolkit tk;
    private Form form;
    private Label formTitel;
    private Action showAllChargesAction;
    private Action showAllConsultationsAction;
    private Konsultation actKons = null;
    private String actPatId = null;
    private final ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class, 60){

        public void runInUi(ElexisEvent ev) {
            log.debug("eeli_pat " + ev);
            Patient newPat = (Patient)ev.getObject();
            Konsultation newCons = null;
            if (newPat != null) {
                newCons = newPat.getLetzteKons(false);
            }
            KonsListView.this.displaySelectedConsultation(newCons);
        }
    };
    private final ElexisUiEventListenerImpl eeli_fall = new ElexisUiEventListenerImpl(Fall.class, 16){

        public void runInUi(ElexisEvent ev) {
            Fall fall = (Fall)ev.getObject();
            boolean isSamePatient = KonsListView.this.actPatId != null && fall != null && KonsListView.this.actPatId.equals(fall.getPatient().getId());
            log.debug("eeli_fall {} fall {} same {}", new Object[]{ev.getType(), fall == null ? "null" : fall.getLabel(), isSamePatient});
            KonsListView.this.konsListDisplay.setShowAllCases(!isSamePatient);
        }
    };
    private final ElexisUiEventListenerImpl eeli_kons = new ElexisUiEventListenerImpl(Konsultation.class){

        public void runInUi(ElexisEvent ev) {
            log.debug("eeli_kons " + ev);
            Konsultation newKons = (Konsultation)ev.getObject();
            if (ev.getType() == 16) {
                KonsListView.this.showAllChargesAction.setChecked(false);
                KonsListView.this.showAllConsultationsAction.setChecked(false);
                KonsListView.this.displaySelectedConsultation(newKons);
            } else if (ev.getType() == 32) {
                KonsListView.this.displaySelectedConsultation(null);
            }
        }
    };

    private synchronized void displaySelectedConsultation(Konsultation newKons) {
        this.actKons = newKons;
        Patient newPat = null;
        if (newKons != null) {
            newPat = newKons.getFall().getPatient();
            if (!newPat.getId().equals(this.actPatId)) {
                log.debug("KonstListView " + newPat + " " + newPat.getPersonalia() + " hasSameId " + this.actPatId);
            } else {
                log.debug("KonstListView " + newKons.getLabel() + " for " + newPat.getPersonalia());
            }
        } else {
            newPat = ElexisEventDispatcher.getSelectedPatient();
            log.debug("KonstListView new kons is null newPat is " + newPat);
        }
        this.actPatId = newPat != null ? newPat.getId() : null;
        this.setPatientTitel(newPat);
        this.konsListDisplay.setKons(newPat, this.actKons, IJournalArea.KonsActions.ACTIVATE_KONS);
    }

    private synchronized void setPatientTitel(Patient patient) {
        String text = "Kein Patient ausgew\u00e4hlt";
        this.formTitel.setEnabled(patient != null);
        if (patient != null) {
            text = patient.getLabel();
        }
        this.formTitel.setText(PersistentObject.checkNull((Object)text));
        this.formTitel.setFont(UiDesk.getFont((String)"Helvetica", (int)14, (int)1));
        this.formTitel.getParent().layout();
    }

    public void createPartControl(Composite parent) {
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createForm(parent);
        Composite formBody = this.form.getBody();
        formBody.setLayout((Layout)new GridLayout(1, true));
        formBody.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.formTitel = this.tk.createLabel(formBody, "Leer");
        this.konsListDisplay = new KonsListDisplay(formBody, false);
        this.konsListDisplay.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.makeActions();
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        this.activateContext();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext(VIEW_CONTEXT_ID);
    }

    private void makeActions() {
        this.showAllChargesAction = new Action("Alle Leistungen anzeigen", 2){
            {
                this.setToolTipText("Leistungen aller Konsultationen anzeigen, nicht nur der ersten paar.");
            }

            public void run() {
                boolean showAllCharges = this.isChecked();
                KonsListView.this.konsListDisplay.highlightActKons(KonsListView.this.actKons, showAllCharges, KonsListView.this.showAllConsultationsAction.isChecked());
            }
        };
        this.showAllChargesAction.setActionDefinitionId("org.iatrix.commands.show_all_charges");
        GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.showAllChargesAction);
        this.showAllConsultationsAction = new Action("Alle Konsultationen anzeigen", 2){
            {
                this.setToolTipText("Alle Konsultationen anzeigen.");
            }

            public void run() {
                KonsListView.this.konsListDisplay.highlightActKons(KonsListView.this.actKons, KonsListView.this.showAllChargesAction.isChecked(), KonsListView.this.showAllConsultationsAction.isChecked());
            }
        };
        this.showAllConsultationsAction.setActionDefinitionId("org.iatrix.commands.show_all_consultations");
        GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.showAllConsultationsAction);
    }

    public void setFocus() {
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        super.dispose();
    }

    public void activation(boolean mode) {
    }

    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_fall, this.eeli_kons});
            Konsultation newKons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
            if (newKons != null) {
                String msg = String.valueOf(newKons.getId()) + " " + newKons.getLabel() + " " + newKons.getFall().getPatient().getPersonalia();
                log.debug("visible true " + msg);
            } else {
                log.debug("visible true newKons is null");
                Patient newPat = ElexisEventDispatcher.getSelectedPatient();
                if (newPat != null) {
                    newKons = newPat.getLetzteKons(false);
                    log.debug("visible true " + newPat.getPersonalia() + " " + newPat.getId());
                }
            }
            this.displaySelectedConsultation(newKons);
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_fall, this.eeli_kons});
        }
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }
}

