/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.data.Anwender;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.extdoc.util.Email;
import ch.elexis.icpc.Episode;
import ch.rgw.tools.TimeTool;
import de.kupzog.ktable.KTable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.iatrix.data.KonsTextLock;
import org.iatrix.util.Heartbeat;
import org.iatrix.util.Helpers;
import org.iatrix.widgets.IJournalArea;
import org.iatrix.widgets.JournalHeader;
import org.iatrix.widgets.KonsDiagnosen;
import org.iatrix.widgets.KonsHeader;
import org.iatrix.widgets.KonsListDisplay;
import org.iatrix.widgets.KonsProblems;
import org.iatrix.widgets.KonsText;
import org.iatrix.widgets.KonsVerrechnung;
import org.iatrix.widgets.ProblemArea;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalView
extends ViewPart
implements IActivationListener,
ISaveablePart2 {
    public static final String ID = "org.iatrix.views.JournalView";
    private static Logger log = LoggerFactory.getLogger(JournalView.class);
    private static Patient actPat = null;
    private static Konsultation actKons = null;
    private static boolean removedStaleKonsLocks = false;
    private static boolean createNewKonsOnEntry = false;
    private FormToolkit tk;
    private Form form;
    private JournalHeader formHeader = null;
    private KTable problemsKTable = null;
    private ProblemArea problemsArea = null;
    private KonsProblems konsProblems = null;
    private KonsText konsTextComposite;
    private KonsVerrechnung konsVerrechnung = null;
    private KonsDiagnosen konsDiagnosen = null;
    private KonsListDisplay konsListDisplay;
    private ViewMenus menus;
    private IAction exportToClipboardAction;
    private IAction sendEmailAction;
    private IAction addKonsultationAction;
    private IAction saveKonsultationAction;
    private Action showAllChargesAction;
    private Action showAllConsultationsAction;
    private static List<IJournalArea> allAreas;
    private KonsHeader konsHeader;
    private Heartbeat heartbeat;
    private boolean setShowActiveKons;
    private final ElexisUiEventListenerImpl eeli_problem = new ElexisUiEventListenerImpl(Episode.class, 36){

        public void runInUi(ElexisEvent ev) {
            switch (ev.getType()) {
                case 4: {
                    JournalView.logEvent(null, "eeli_problem EVENT_UPDATE");
                    JournalView.this.problemsArea.reloadAndRefresh();
                    break;
                }
                case 32: {
                    JournalView.logEvent(null, "eeli_problem EVENT_DESELECTED");
                    JournalView.this.problemsKTable.clearSelection();
                }
            }
        }
    };
    private final ElexisEventListener eeli_update = new ElexisUiEventListenerImpl(Konsultation.class, 4){

        public void runInUi(ElexisEvent ev) {
            Konsultation actKons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
            Helpers.checkActPatKons(actPat, actKons);
            if (actKons != null) {
                JournalView.this.konsVerrechnung.setKons(actKons.getFall().getPatient(), actKons, IJournalArea.KonsActions.EVENT_UPDATE);
            }
            log.debug(String.format("eeli_update %s ", ev.toString()), (Object)actKons);
        }
    };
    private final ElexisUiEventListenerImpl eeli_kons = new ElexisUiEventListenerImpl(Konsultation.class){

        public void runInUi(ElexisEvent ev) {
            Konsultation newKons = (Konsultation)ev.getObject();
            String msg = "";
            switch (ev.getType()) {
                case 16: {
                    msg = "EVENT_SELECTED";
                    break;
                }
                case 4: {
                    msg = "EVENT_SELECTED";
                    break;
                }
                case 8: {
                    msg = "EVENT_SELECTED";
                    break;
                }
                case 32: {
                    msg = "EVENT_SELECTED";
                    Konsultation selected_kons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
                    log.debug(String.format("runInUi %s selected_kons is now: %s", msg, selected_kons));
                    newKons = selected_kons;
                    JournalView.updateAllKonsAreas(actPat, newKons, IJournalArea.KonsActions.ACTIVATE_KONS);
                    return;
                }
            }
            log.debug(String.format("runInUi act %s new %s %s", actKons, msg, ev.toString()), (Object)newKons);
            if (!removedStaleKonsLocks) {
                removedStaleKonsLocks = true;
                KonsTextLock.deleteObsoleteLocks(newKons);
            }
            if (newKons != null) {
                actPat = newKons.getFall().getPatient();
            }
            actKons = newKons;
            if (ev.getType() == 8) {
                JournalView.updateAllKonsAreas(actPat, newKons, IJournalArea.KonsActions.EVENT_RELOAD);
            }
            if (ev.getType() == 4) {
                JournalView.updateAllKonsAreas(actPat, newKons, IJournalArea.KonsActions.EVENT_UPDATE);
            }
            if (ev.getType() == 16) {
                JournalView.updateAllKonsAreas(actPat, newKons, IJournalArea.KonsActions.EVENT_SELECTED);
            }
        }
    };
    private final ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class, 28){

        public void runInUi(ElexisEvent ev) {
            Patient newPat = (Patient)ev.getObject();
            String msg = "";
            switch (ev.getType()) {
                case 16: {
                    msg = "EVENT_SELECTED";
                    break;
                }
                case 4: {
                    msg = "EVENT_UPDATE";
                    break;
                }
                case 32: {
                    msg = "EVENT_DESELECTED";
                    log.debug(String.format("eeli_pat 1: %d %s %s", ev.getType(), msg, newPat.getPersonalia()));
                    return;
                }
                case 8: {
                    msg = "EVENT_RELOAD";
                }
            }
            log.debug(String.format("eeli_pat 1: %d %s %s", ev.getType(), msg, newPat.getPersonalia()));
            actPat = newPat;
            JournalView.this.displaySelectedPatient(newPat, "eeli_pat 2: " + ev.getType());
        }
    };
    private final ElexisUiEventListenerImpl eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        public void runInUi(ElexisEvent ev) {
            JournalView.logEvent(null, "runInUi eeli_user adaptMenus");
            JournalView.this.adaptMenus();
        }
    };

    public void createPartControl(Composite parent) {
        Bundle bundle = Platform.getBundle((String)"org.iatrix");
        log.info("VERSION: " + bundle.getVersion().toString());
        parent.setLayout((Layout)new FillLayout());
        this.heartbeat = Heartbeat.getInstance();
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createForm(parent);
        Composite formBody = this.form.getBody();
        formBody.setLayout((Layout)new GridLayout(1, true));
        this.formHeader = new JournalHeader(formBody);
        SashForm mainSash = new SashForm(this.form.getBody(), 512);
        mainSash.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite topArea = this.tk.createComposite((Composite)mainSash, 0);
        topArea.setLayout((Layout)new FillLayout(512));
        topArea.setBackground(topArea.getDisplay().getSystemColor(1));
        this.problemsArea = new ProblemArea(topArea, this.getPartName(), this.getViewSite());
        this.problemsKTable = this.problemsArea.getProblemKTable();
        Composite middleArea = this.tk.createComposite((Composite)mainSash, 0);
        middleArea.setLayout((Layout)new FillLayout());
        Composite konsultationComposite = this.tk.createComposite(middleArea);
        konsultationComposite.setLayout((Layout)new GridLayout(1, true));
        this.konsHeader = new KonsHeader(konsultationComposite);
        SashForm konsultationSash = new SashForm(konsultationComposite, 256);
        konsultationSash.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite assignmentComposite = this.tk.createComposite((Composite)konsultationSash);
        assignmentComposite.setLayout((Layout)new GridLayout(1, true));
        this.konsProblems = new KonsProblems(assignmentComposite);
        Composite konsultationTextComposite = this.tk.createComposite((Composite)konsultationSash);
        konsultationTextComposite.setLayout((Layout)new GridLayout(1, true));
        this.konsTextComposite = new KonsText(konsultationTextComposite);
        this.konsDiagnosen = new KonsDiagnosen(konsultationComposite);
        Composite verrechnungComposite = this.tk.createComposite((Composite)konsultationSash);
        this.konsVerrechnung = new KonsVerrechnung(verrechnungComposite, this.form, this.getPartName(), assignmentComposite);
        if (konsultationSash.getChildren().length == 3) {
            konsultationSash.setWeights(new int[]{15, 65, 20});
        }
        Composite bottomArea = this.tk.createComposite((Composite)mainSash, 0);
        bottomArea.setLayout((Layout)new FillLayout());
        bottomArea.setBackground(bottomArea.getDisplay().getSystemColor(1));
        this.konsListDisplay = new KonsListDisplay(bottomArea, true);
        mainSash.setWeights(new int[]{20, 40, 30});
        allAreas = new ArrayList<IJournalArea>();
        allAreas.add(this.konsTextComposite);
        allAreas.add(this.formHeader);
        allAreas.add(this.problemsArea);
        allAreas.add(this.konsHeader);
        allAreas.add(this.konsProblems);
        allAreas.add(this.konsDiagnosen);
        allAreas.add(this.konsVerrechnung);
        allAreas.add(this.konsListDisplay);
        this.makeActions();
        this.menus = new ViewMenus(this.getViewSite());
        if (CoreHub.acl.request(AccessControlDefaults.AC_PURGE)) {
            this.menus.createMenu(new IAction[]{this.addKonsultationAction, GlobalActions.redateAction, this.problemsArea.addProblemAction, GlobalActions.delKonsAction, this.problemsArea.delProblemAction, this.exportToClipboardAction, this.sendEmailAction, this.konsTextComposite.getVersionForwardAction(), this.konsTextComposite.getVersionBackAction(), this.konsTextComposite.getChooseVersionAction(), this.konsTextComposite.getPurgeAction(), this.saveKonsultationAction, this.showAllConsultationsAction, this.showAllChargesAction, this.problemsArea.addFixmedikationAction});
        } else {
            this.menus.createMenu(new IAction[]{this.addKonsultationAction, GlobalActions.redateAction, this.problemsArea.addProblemAction, GlobalActions.delKonsAction, this.problemsArea.delProblemAction, this.exportToClipboardAction, this.sendEmailAction, this.konsTextComposite.getVersionForwardAction(), this.konsTextComposite.getVersionBackAction(), this.konsTextComposite.getChooseVersionAction(), this.saveKonsultationAction, this.showAllConsultationsAction, this.showAllChargesAction, this.problemsArea.addFixmedikationAction});
        }
        this.menus.createToolbar(new IAction[]{this.sendEmailAction, this.exportToClipboardAction, this.addKonsultationAction, this.problemsArea.getAddProblemAction(), this.saveKonsultationAction});
        this.menus.createViewerContextMenu((StructuredViewer)this.konsProblems.getProblemAssignmentViewer(), new IAction[]{this.konsProblems.unassignProblemAction});
        this.menus.createViewerContextMenu((StructuredViewer)this.konsVerrechnung.getVerrechnungViewer(), new IAction[]{this.konsVerrechnung.changeVerrechnetPreisAction, this.konsVerrechnung.changeVerrechnetZahlAction, this.konsVerrechnung.delVerrechnetAction});
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        this.activateContext();
    }

    public static void saveActKonst() {
        Helpers.checkActPatKons(actPat, actKons);
        if (actKons == null) {
            return;
        }
        JournalView.logEvent(actKons, "saveActKonst");
        int i = 0;
        while (i < allAreas.size()) {
            IJournalArea a = allAreas.get(i);
            if (a != null) {
                a.setKons(actKons.getFall().getPatient(), actKons, IJournalArea.KonsActions.SAVE_KONS);
            }
            ++i;
        }
    }

    public static synchronized void updateAllKonsAreas(Patient newPatient, Konsultation newKons, IJournalArea.KonsActions op) {
        if (newKons != null && newPatient == null) {
            actPat = newKons.getFall().getPatient();
            log.warn("Programming error newKons != null && newPatient == null");
        }
        if (newKons != null && newPatient != null && !newPatient.getId().equals(newKons.getFall().getPatient().getId())) {
            actPat = newKons.getFall().getPatient();
            log.warn("Discovered changed patient " + (Object)((Object)op) + " actPat " + actPat.getPersonalia());
        } else {
            actPat = newPatient;
            log.warn("Set actPat to {} actPat {}", (Object)op, (Object)actPat);
        }
        actKons = newKons;
        Helpers.checkActPatKons(actPat, actKons);
        JournalView.logEvent(newKons, "updateAllKonsAreas: newKons op is " + (Object)((Object)op));
        int i = 0;
        while (i < allAreas.size()) {
            IJournalArea a = allAreas.get(i);
            if (a != null) {
                Helpers.checkActPatKons(actPat, actKons);
                a.setKons(actPat, newKons, op);
            }
            ++i;
        }
    }

    public static synchronized void updateKonsProblems(Patient newPatient, Konsultation newKons, IJournalArea.KonsActions op) {
        if (Helpers.twoKonsEqual(actKons, newKons)) {
            int i = 0;
            while (i < allAreas.size()) {
                IJournalArea a = allAreas.get(i);
                if (a != null && a.getClass().equals(KonsProblems.class)) {
                    a.setKons(newPatient, newKons, op);
                }
                ++i;
            }
        } else {
            JournalView.updateAllKonsAreas(newPatient, newKons, op);
        }
    }

    private synchronized void activateAllKonsAreas(boolean mode) {
        JournalView.logEvent(null, "activateAllKonsAreas: " + mode);
        Helpers.checkActPatKons(actPat, actKons);
        int i = 0;
        while (i < allAreas.size()) {
            IJournalArea a = allAreas.get(i);
            if (a != null) {
                Helpers.checkActPatKons(actPat, actKons);
                a.activation(mode, actPat, actKons);
            }
            ++i;
        }
    }

    private synchronized void visibleAllKonsAreas(boolean mode) {
        JournalView.logEvent(null, "visibleAllKonsAreas: " + mode);
        Helpers.checkActPatKons(actPat, actKons);
        int i = 0;
        while (i < allAreas.size()) {
            IJournalArea a = allAreas.get(i);
            if (a != null) {
                a.visible(mode);
            }
            ++i;
        }
    }

    private synchronized void displaySelectedPatient(Patient selectedPatient, String why) {
        if (selectedPatient == null) {
            JournalView.logEvent(null, String.valueOf(why) + " displaySelectedPatient 1 no patient");
            JournalView.updateAllKonsAreas(null, null, IJournalArea.KonsActions.ACTIVATE_KONS);
            return;
        }
        JournalView.logEvent(null, String.valueOf(why) + " displaySelectedPatient 2 " + selectedPatient.getId() + selectedPatient.getPersonalia());
        this.showAllChargesAction.setChecked(false);
        this.showAllConsultationsAction.setChecked(false);
        Konsultation konsultation = null;
        konsultation = selectedPatient.getLetzteKons(false);
        if (konsultation == null && createNewKonsOnEntry) {
            Fall[] faelle = selectedPatient.getFaelle();
            if (faelle.length == 0) {
                konsultation = selectedPatient.createFallUndKons();
            } else {
                Fall[] fallArray = faelle;
                int n = faelle.length;
                int n2 = 0;
                while (n2 < n) {
                    Fall fall = fallArray[n2];
                    if (fall.isOpen()) {
                        konsultation = fall.getLetzteBehandlung();
                        if (konsultation == null) {
                            konsultation = fall.neueKonsultation();
                        } else {
                            TimeTool konsDate = new TimeTool(konsultation.getDatum());
                            if (!konsDate.isSameDay(new TimeTool())) {
                                konsultation = konsultation.getFall().neueKonsultation();
                            }
                        }
                        log.debug("displaySelectedPatient 3 neue Kons fall.isOpen " + konsultation.getId() + " " + konsultation.getLabel());
                        break;
                    }
                    ++n2;
                }
                if (konsultation == null) {
                    konsultation = selectedPatient.createFallUndKons();
                    log.debug("displaySelectedPatient 4 neue Kons createFallUndKons " + konsultation.getId() + " " + konsultation.getLabel());
                }
            }
        }
        if (konsultation != null) {
            TimeTool konsDate = new TimeTool(konsultation.getDatum());
            konsDate.isSameDay(new TimeTool());
        }
        JournalView.updateAllKonsAreas(selectedPatient, konsultation, IJournalArea.KonsActions.ACTIVATE_KONS);
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("org.iatrix.view.context");
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_kons, this.eeli_problem, this.eeli_pat, this.eeli_user});
        super.dispose();
    }

    public void setFocus() {
    }

    public void adaptMenus() {
        this.konsVerrechnung.getVerrechnungViewer().getTable().getMenu().setEnabled(CoreHub.acl.request(AccessControlDefaults.LSTG_VERRECHNEN));
        GlobalActions.delKonsAction.setEnabled(CoreHub.acl.request(AccessControlDefaults.KONS_DELETE));
        GlobalActions.neueKonsAction.setEnabled(CoreHub.acl.request(AccessControlDefaults.KONS_CREATE));
    }

    private void makeActions() {
        this.addKonsultationAction = new Action(GlobalActions.neueKonsAction.getText()){
            {
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.iatrix", (String)"icons/new_konsultation.ico"));
                this.setToolTipText(GlobalActions.neueKonsAction.getToolTipText());
            }

            public void run() {
                GlobalActions.neueKonsAction.run();
            }
        };
        this.addKonsultationAction.setActionDefinitionId("org.iatrix.commands.newcons");
        GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.addKonsultationAction);
        this.saveKonsultationAction = this.konsTextComposite.getSaveAction();
        this.saveKonsultationAction.setActionDefinitionId("org.iatrix.commands.savecons");
        GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.saveKonsultationAction);
        if (this.problemsArea != null) {
            GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.problemsArea.addProblemAction);
            this.problemsArea.addProblemAction.setActionDefinitionId("org.iatrix.commands.newproblem");
        }
        this.exportToClipboardAction = new Action("Export (Zwischenablage)"){
            {
                this.setImageDescriptor(Images.IMG_EXPORT.getImageDescriptor());
                this.setToolTipText("Zusammenfassung in Zwischenablage kopieren");
            }

            public void run() {
                if (actKons != null) {
                    Helpers.exportToClipboard(actKons.getFall().getPatient(), null);
                }
            }
        };
        this.exportToClipboardAction.setActionDefinitionId("org.iatrix.commands.export_clipboard");
        GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.exportToClipboardAction);
        this.sendEmailAction = new Action("E-Mail verschicken"){
            {
                this.setImageDescriptor(Images.IMG_MAIL.getImageDescriptor());
                this.setToolTipText("E-Mail Programm \u00f6ffnent (mit Medikation und allen Konsultationen)");
            }

            public void run() {
                if (actKons != null) {
                    Email.openMailApplication((String)"", null, (String)Helpers.exportToClipboard(actKons.getFall().getPatient(), null), null);
                }
            }
        };
        this.sendEmailAction.setActionDefinitionId("org.iatrix.commands.send_email");
        GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.sendEmailAction);
        this.showAllChargesAction = new Action("Alle Leistungen anzeigen", 2){
            {
                this.setChecked(false);
                this.setToolTipText("Leistungen aller Konsultationen anzeigen, nicht nur der ersten paar.");
            }

            public void run() {
                JournalView.this.konsListDisplay.highlightActKons(actKons, JournalView.this.showAllChargesAction.isChecked(), JournalView.this.showAllConsultationsAction.isChecked());
            }
        };
        this.showAllChargesAction.setActionDefinitionId("org.iatrix.commands.show_all_charges");
        GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.showAllChargesAction);
        this.showAllConsultationsAction = new Action("Alle Konsultationen anzeigen", 2){
            {
                this.setChecked(false);
                this.setToolTipText("Alle Konsultationen anzeigen");
            }

            public void run() {
                JournalView.this.konsListDisplay.highlightActKons(actKons, JournalView.this.showAllChargesAction.isChecked(), JournalView.this.showAllConsultationsAction.isChecked());
            }
        };
        this.showAllConsultationsAction.setActionDefinitionId("org.iatrix.commands.show_all_consultations");
        GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.showAllConsultationsAction);
    }

    public void activation(boolean mode) {
        Helpers.checkActPatKons(actPat, actKons);
        Konsultation selected_kons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
        if (selected_kons != null && actKons != null && !selected_kons.getId().equals(actKons.getId())) {
            JournalView.logEvent(null, "activation " + mode + " sel: " + selected_kons.getLabel() + " act: " + actKons.getId());
            return;
        }
        this.activateAllKonsAreas(mode);
        if (!mode) {
            if (actKons == null) {
                return;
            }
            boolean noLeistungen = actKons.getLeistungen() == null || actKons.getLeistungen().isEmpty();
            TimeTool konsDate = new TimeTool(actKons.getDatum());
            boolean ofToday = konsDate.isSameDay(new TimeTool());
            log.debug(String.format("Delete the kons? %s %s noLeistungen %s from %s ofToday %s", actKons.getId(), this.konsTextComposite.getPlainText().length(), noLeistungen, actKons.getLabel(), ofToday));
            if (this.konsTextComposite.getPlainText().length() == 0 && noLeistungen && ofToday) {
                Fall f = actKons.getFall();
                Konsultation[] ret = f.getBehandlungen(false);
                actKons.delete(true);
                int cfr_ignored_0 = ret.length;
            }
        }
    }

    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_kons, this.eeli_problem, this.eeli_pat, this.eeli_user, this.eeli_update});
            Konsultation newKons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
            if (newKons != null) {
                actPat = newKons.getFall().getPatient();
                String msg = String.valueOf(newKons.getId()) + " " + newKons.getLabel() + " " + actPat.getPersonalia();
                JournalView.logEvent(newKons, "visible true " + msg);
                JournalView.updateAllKonsAreas(actPat, newKons, IJournalArea.KonsActions.ACTIVATE_KONS);
            } else {
                Patient newPat = ElexisEventDispatcher.getSelectedPatient();
                JournalView.logEvent(null, "visible true newKons is null for " + (newPat == null ? "null" : newPat.getPersonalia()));
                this.displaySelectedPatient(newPat, "view visible");
            }
            this.visibleAllKonsAreas(mode);
            this.heartbeat.enableListener(true);
        } else {
            JournalView.logEvent(actKons, "visible false");
            this.heartbeat.enableListener(false);
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_kons, this.eeli_problem, this.eeli_pat, this.eeli_user, this.eeli_update});
        }
    }

    private static void logEvent(Konsultation kons, String msg) {
        Fall f;
        StringBuilder sb = new StringBuilder(msg);
        if (kons != null && (f = kons.getFall()) != null) {
            Patient pat = f.getPatient();
            sb.append(" kons: " + kons.getId());
            sb.append(" vom " + kons.getDatum());
            sb.append(" " + pat.getId() + ": " + pat.getPersonalia());
        }
        log.debug(sb.toString());
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }
}

