/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.data.Anwender;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.extdoc.util.Email;
import ch.elexis.icpc.Episode;
import de.kupzog.ktable.KTable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.iatrix.util.Heartbeat;
import org.iatrix.util.Helpers;
import org.iatrix.widgets.IJournalArea;
import org.iatrix.widgets.JournalHeader;
import org.iatrix.widgets.ProblemArea;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IatrixOverview
extends ViewPart
implements IActivationListener,
ISaveablePart2 {
    public static final String ID = "org.iatrix.views.JournalView";
    private static Logger log = LoggerFactory.getLogger(IatrixOverview.class);
    private static Patient actPat = null;
    private static Konsultation actKons = null;
    private FormToolkit tk;
    private Form form;
    private JournalHeader journalHeader = null;
    private KTable problemsKTable = null;
    private ProblemArea problemsArea = null;
    private ViewMenus menus;
    private IAction exportToClipboardAction;
    private IAction sendEmailAction;
    private IAction addKonsultationAction;
    private static List<IJournalArea> allAreas;
    private Heartbeat heartbeat;
    private final ElexisUiEventListenerImpl eeli_problem = new ElexisUiEventListenerImpl(Episode.class, 36){

        public void runInUi(ElexisEvent ev) {
            switch (ev.getType()) {
                case 4: {
                    IatrixOverview.logEvent(null, "eeli_problem EVENT_UPDATE");
                    IatrixOverview.this.problemsArea.reloadAndRefresh();
                    break;
                }
                case 32: {
                    IatrixOverview.logEvent(null, "eeli_problem EVENT_DESELECTED");
                    IatrixOverview.this.problemsKTable.clearSelection();
                }
            }
        }
    };
    private final ElexisUiEventListenerImpl eeli_kons = new ElexisUiEventListenerImpl(Konsultation.class){

        public void runInUi(ElexisEvent ev) {
            Konsultation newKons = (Konsultation)ev.getObject();
            String msg = "";
            switch (ev.getType()) {
                case 16: {
                    msg = "EVENT_SELECTED";
                    break;
                }
                case 4: {
                    msg = "EVENT_UPDATE";
                    break;
                }
                case 32: {
                    msg = "EVENT_DESELECTED";
                    break;
                }
                case 8: {
                    msg = "EVENT_RELOAD";
                }
            }
            IatrixOverview.logEvent(newKons, String.format("eeli_kons type %d msg %s", ev.getType(), msg));
            if (actKons == null) {
                IatrixOverview.logEvent(newKons, "eeli_kons " + msg + " SAVE_KONS");
                Patient newPatient = newKons.getFall().getPatient();
                if (actKons != null && !newPatient.getId().equals(actKons.getFall().getPatient().getId())) {
                    IatrixOverview.this.displaySelectedPatient(newPatient, "eeli_kons newPatient");
                }
                IatrixOverview.logEvent(newKons, "eeli_kons " + msg + " ACTIVATE_KONS");
                IatrixOverview.updateAllKonsAreas(newKons, IJournalArea.KonsActions.ACTIVATE_KONS);
            } else {
                if (ev.getType() == 8) {
                    IatrixOverview.updateAllKonsAreas(newKons, IJournalArea.KonsActions.EVENT_RELOAD);
                }
                if (ev.getType() == 4) {
                    IatrixOverview.updateAllKonsAreas(newKons, IJournalArea.KonsActions.EVENT_UPDATE);
                }
                if (ev.getType() == 16) {
                    IatrixOverview.updateAllKonsAreas(newKons, IJournalArea.KonsActions.EVENT_SELECTED);
                }
            }
            actKons = newKons;
        }
    };
    private final ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        public void runInUi(ElexisEvent ev) {
            String msg = "";
            switch (ev.getType()) {
                case 16: {
                    msg = "EVENT_SELECTED";
                    break;
                }
                case 4: {
                    msg = "EVENT_UPDATE";
                    break;
                }
                case 8: {
                    msg = "EVENT_RELOAD";
                }
            }
            Patient newPat = (Patient)ev.getObject();
            log.debug(String.format("eeli_pat %d %s %s actKons null: %s", ev.getType(), msg, newPat.toString(), actKons == null));
            if (actKons != null && actKons.getFall().getPatient().getId().equals(newPat.getId())) {
                log.debug(String.format("eeli_pat %d %s %s nothing todo", ev.getType(), msg, newPat.toString()));
            } else {
                if (actPat == null || newPat.getId().contentEquals(actPat.getId())) {
                    actPat = newPat;
                    actKons = newPat.getLetzteKons(false);
                }
                IatrixOverview.this.problemsArea.setKons(actPat, actKons, IJournalArea.KonsActions.ACTIVATE_KONS);
                IatrixOverview.updateAllKonsAreas(actKons, IJournalArea.KonsActions.ACTIVATE_KONS);
                IatrixOverview.this.displaySelectedPatient(actPat, "eeli_pat " + ev.getType());
                log.debug(String.format("eeli_pat %d %s %s %s changed", ev.getType(), msg, actKons, actPat.getPersonalia()));
            }
        }
    };
    private final ElexisUiEventListenerImpl eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        public void runInUi(ElexisEvent ev) {
            IatrixOverview.logEvent(null, "runInUi eeli_user adaptMenus");
            IatrixOverview.this.adaptMenus();
        }
    };

    public void createPartControl(Composite parent) {
        Bundle bundle = Platform.getBundle((String)"org.iatrix");
        log.info("VERSION: " + bundle.getVersion().toString());
        parent.setLayout((Layout)new FillLayout());
        this.heartbeat = Heartbeat.getInstance();
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createForm(parent);
        Composite formBody = this.form.getBody();
        formBody.setLayout((Layout)new GridLayout(1, true));
        this.journalHeader = new JournalHeader(formBody);
        SashForm mainSash = new SashForm(this.form.getBody(), 512);
        mainSash.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite topArea = this.tk.createComposite((Composite)mainSash, 0);
        topArea.setLayout((Layout)new FillLayout(512));
        topArea.setBackground(topArea.getDisplay().getSystemColor(1));
        this.problemsArea = new ProblemArea(topArea, this.getPartName(), this.getViewSite());
        this.problemsKTable = this.problemsArea.getProblemKTable();
        allAreas = new ArrayList<IJournalArea>();
        allAreas.add(this.journalHeader);
        allAreas.add(this.problemsArea);
        this.makeActions();
        this.menus = new ViewMenus(this.getViewSite());
        if (CoreHub.acl.request(AccessControlDefaults.AC_PURGE)) {
            this.menus.createMenu(new IAction[]{this.addKonsultationAction, GlobalActions.redateAction, this.problemsArea.addProblemAction, GlobalActions.delKonsAction, this.problemsArea.delProblemAction, this.exportToClipboardAction, this.problemsArea.addFixmedikationAction, this.sendEmailAction});
        } else {
            this.menus.createMenu(new IAction[]{this.addKonsultationAction, GlobalActions.redateAction, this.problemsArea.addProblemAction, GlobalActions.delKonsAction, this.problemsArea.delProblemAction, this.exportToClipboardAction, this.problemsArea.addFixmedikationAction, this.sendEmailAction});
        }
        this.menus.createToolbar(new IAction[]{this.sendEmailAction, this.exportToClipboardAction, this.addKonsultationAction, this.problemsArea.getAddProblemAction()});
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        this.activateContext();
    }

    public static void updateAllKonsAreas(Konsultation newKons, IJournalArea.KonsActions op) {
        actKons = newKons;
        if (newKons == null) {
            return;
        }
        IatrixOverview.logEvent(newKons, "updateAllKonsAreas: newKons op is " + (Object)((Object)op));
        int i = 0;
        while (i < allAreas.size()) {
            IJournalArea a = allAreas.get(i);
            if (a != null) {
                a.setKons(newKons.getFall().getPatient(), newKons, op);
            }
            ++i;
        }
    }

    private void activateAllKonsAreas(boolean mode) {
        IatrixOverview.logEvent(null, "activateAllKonsAreas: " + mode);
        int i = 0;
        while (i < allAreas.size()) {
            IJournalArea a = allAreas.get(i);
            if (a != null) {
                a.activation(mode, actKons == null ? null : actKons.getFall().getPatient(), actKons);
            }
            ++i;
        }
    }

    private void visibleAllKonsAreas(boolean mode) {
        IatrixOverview.logEvent(null, "visibleAllKonsAreas: " + mode);
        int i = 0;
        while (i < allAreas.size()) {
            IJournalArea a = allAreas.get(i);
            if (a != null) {
                a.visible(mode);
            }
            ++i;
        }
    }

    private void displaySelectedPatient(Patient selectedPatient, String why) {
        if (selectedPatient == null) {
            IatrixOverview.logEvent(null, String.valueOf(why) + " displaySelectedPatient " + "no patient");
            IatrixOverview.updateAllKonsAreas(null, IJournalArea.KonsActions.ACTIVATE_KONS);
            return;
        }
        IatrixOverview.logEvent(null, String.valueOf(why) + " displaySelectedPatient " + selectedPatient.getId() + selectedPatient.getPersonalia());
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("org.iatrix.view.context");
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_problem, this.eeli_kons, this.eeli_pat, this.eeli_user});
        super.dispose();
    }

    public void setFocus() {
    }

    public void adaptMenus() {
        GlobalActions.delKonsAction.setEnabled(CoreHub.acl.request(AccessControlDefaults.KONS_DELETE));
        GlobalActions.neueKonsAction.setEnabled(CoreHub.acl.request(AccessControlDefaults.KONS_CREATE));
    }

    private void makeActions() {
        this.addKonsultationAction = new Action(GlobalActions.neueKonsAction.getText()){
            {
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.iatrix", (String)"icons/new_konsultation.ico"));
                this.setToolTipText(GlobalActions.neueKonsAction.getToolTipText());
            }

            public void run() {
                GlobalActions.neueKonsAction.run();
            }
        };
        this.addKonsultationAction.setActionDefinitionId("org.iatrix.commands.newcons");
        GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.addKonsultationAction);
        if (this.problemsArea != null) {
            GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.problemsArea.addProblemAction);
            this.problemsArea.addProblemAction.setActionDefinitionId("org.iatrix.commands.newproblem");
        }
        this.exportToClipboardAction = new Action("Export (Zwischenablage)"){
            {
                this.setImageDescriptor(Images.IMG_EXPORT.getImageDescriptor());
                this.setToolTipText("Zusammenfassung in Zwischenablage kopieren");
            }

            public void run() {
                if (actKons != null) {
                    Helpers.exportToClipboard(actKons.getFall().getPatient(), null);
                }
            }
        };
        this.exportToClipboardAction.setActionDefinitionId("org.iatrix.commands.export_clipboard");
        GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.exportToClipboardAction);
        this.sendEmailAction = new Action("E-Mail verschicken"){
            {
                this.setImageDescriptor(Images.IMG_MAIL.getImageDescriptor());
                this.setToolTipText("E-Mail Programm \u00f6ffnent (mit Medikation und allen Konsultationen)");
            }

            public void run() {
                if (actKons != null) {
                    Email.openMailApplication((String)"", null, (String)Helpers.exportToClipboard(actKons.getFall().getPatient(), null), null);
                }
            }
        };
        this.sendEmailAction.setActionDefinitionId("org.iatrix.commands.send_email");
        GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.sendEmailAction);
    }

    public void activation(boolean mode) {
        Konsultation selected_kons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
        if (selected_kons != null && actKons != null && !selected_kons.getId().equals(actKons.getId())) {
            IatrixOverview.logEvent(null, "activation " + mode + " sel: " + selected_kons.getLabel() + " act: " + actKons.getId());
            return;
        }
        this.activateAllKonsAreas(mode);
    }

    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_kons, this.eeli_problem, this.eeli_pat, this.eeli_user});
            Konsultation newKons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
            if (newKons != null) {
                String msg = String.valueOf(newKons.getId()) + " " + newKons.getLabel() + " " + newKons.getFall().getPatient().getPersonalia();
                IatrixOverview.logEvent(newKons, "visible true " + msg);
                IatrixOverview.updateAllKonsAreas(newKons, IJournalArea.KonsActions.ACTIVATE_KONS);
            } else {
                IatrixOverview.logEvent(newKons, "visible true newKons is null");
                this.displaySelectedPatient(ElexisEventDispatcher.getSelectedPatient(), "view visible");
            }
            this.visibleAllKonsAreas(mode);
            this.heartbeat.enableListener(true);
        } else {
            this.heartbeat.enableListener(false);
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_kons, this.eeli_problem, this.eeli_pat, this.eeli_user});
        }
    }

    private static void logEvent(Konsultation kons, String msg) {
        Fall f;
        StringBuilder sb = new StringBuilder(msg);
        if (kons != null && (f = kons.getFall()) != null) {
            Patient pat = f.getPatient();
            sb.append(" kons: " + kons.getId());
            sb.append(" vom " + kons.getDatum());
            sb.append(" " + pat.getId() + ": " + pat.getPersonalia());
        }
        log.debug(sb.toString());
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }
}

