/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.util;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Anschrift;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionedResource;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.iatrix.data.Problem;
import org.iatrix.util.DateComparator;

public class Helpers {
    private static final DateComparator DATE_COMPARATOR = new DateComparator();
    boolean hasRight = CoreHub.acl.request(AccessControlDefaults.ADMIN_KONS_EDIT_IF_BILLED);

    public static Konsultation getTodaysLatestKons(Fall fall) {
        Konsultation result = null;
        TimeTool today = new TimeTool();
        Konsultation[] konsultationen = fall.getBehandlungen(true);
        if (konsultationen != null) {
            long timestamp = -1L;
            Konsultation[] konsultationArray = konsultationen;
            int n = konsultationen.length;
            int n2 = 0;
            while (n2 < n) {
                VersionedResource.ResourceItem ri;
                VersionedResource vr;
                Konsultation k = konsultationArray[n2];
                if (new TimeTool(k.getDatum()).isSameDay(today) && (vr = k.getEintrag()) != null && (ri = vr.getVersion(vr.getHeadVersion())) != null && ri.timestamp > timestamp) {
                    timestamp = ri.timestamp;
                    result = k;
                }
                ++n2;
            }
        }
        return result;
    }

    public static String exportToClipboard(Patient patient, Problem p) {
        String lineSeparator = System.getProperty("line.separator");
        String fieldSeparator = "\t";
        String clipboardText = "";
        if (patient != null) {
            List<Problem> allProblems;
            StringBuffer output = new StringBuffer();
            ArrayList<Problem> problems = new ArrayList<Problem>();
            System.out.println("TODO problemAssignmentViewer");
            if (p != null) {
                problems.add(p);
            }
            StringBuffer patientLabel = new StringBuffer();
            patientLabel.append(String.valueOf(patient.getName()) + " " + patient.getVorname());
            patientLabel.append(" (");
            patientLabel.append(patient.getGeschlecht());
            patientLabel.append("), ");
            patientLabel.append(patient.getGeburtsdatum());
            patientLabel.append(", ");
            output.append(patientLabel);
            StringBuffer patientAddress = new StringBuffer();
            Anschrift anschrift = patient.getAnschrift();
            patientAddress.append(anschrift.getStrasse());
            patientAddress.append(", ");
            patientAddress.append(String.valueOf(anschrift.getPlz()) + " " + anschrift.getOrt());
            patientAddress.append(lineSeparator);
            output.append(patientAddress);
            boolean isFirst = true;
            StringBuffer patientPhones = new StringBuffer();
            String telefon1 = patient.get("Telefon1");
            String telefon2 = patient.get("Telefon2");
            String natel = patient.get("Natel");
            String eMail = patient.get("E-Mail");
            if (!StringTool.isNothing((Object)telefon1)) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    patientPhones.append(", ");
                }
                patientPhones.append("T: ");
                patientPhones.append(telefon1);
                if (!StringTool.isNothing((Object)telefon2)) {
                    patientPhones.append(", ");
                    patientPhones.append(telefon2);
                }
            }
            if (!StringTool.isNothing((Object)natel)) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    patientPhones.append(", ");
                }
                patientPhones.append("M: ");
                patientPhones.append(natel);
            }
            if (!StringTool.isNothing((Object)natel)) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    patientPhones.append(", ");
                }
                patientPhones.append(eMail);
            }
            patientPhones.append(lineSeparator);
            output.append(patientPhones);
            output.append(lineSeparator);
            ArrayList<Konsultation> konsultationen = new ArrayList<Konsultation>();
            if (problems.size() > 0) {
                for (Problem problem : problems) {
                    konsultationen.addAll(problem.getKonsultationen());
                }
            } else {
                Fall[] fallArray = patient.getFaelle();
                int n = fallArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Fall fall = fallArray[n2];
                    Konsultation[] konsultationArray = fall.getBehandlungen(false);
                    int n3 = konsultationArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Konsultation k = konsultationArray[n4];
                        konsultationen.add(k);
                        ++n4;
                    }
                    ++n2;
                }
            }
            Collections.sort(konsultationen, new Comparator<Konsultation>(){

                @Override
                public int compare(Konsultation k1, Konsultation k2) {
                    String d1 = k1.getDatum();
                    String d2 = k2.getDatum();
                    if (d1 == null) {
                        return 1;
                    }
                    if (d2 == null) {
                        return -1;
                    }
                    TimeTool date1 = new TimeTool(d1);
                    TimeTool date2 = new TimeTool(d2);
                    return -date1.compareTo((Calendar)date2);
                }
            });
            int i = 0;
            while (i < 1 && konsultationen.size() >= i + 1) {
                Konsultation konsultation = (Konsultation)konsultationen.get(i);
                StringBuffer sb = new StringBuffer();
                sb.append(konsultation.getLabel());
                List<Problem> konsProblems = Problem.getProblemsOfKonsultation(konsultation);
                if (konsProblems != null && konsProblems.size() > 0) {
                    StringBuffer problemsLabel = new StringBuffer();
                    problemsLabel.append(" (");
                    problemsLabel.append(konsProblems.get(0).getTitle());
                    int j = 1;
                    while (j < konsProblems.size()) {
                        problemsLabel.append(", ");
                        problemsLabel.append(konsProblems.get(j).getTitle());
                        ++j;
                    }
                    problemsLabel.append(")");
                    sb.append(problemsLabel);
                }
                sb.append(lineSeparator);
                Samdas samdas = new Samdas(konsultation.getEintrag().getHead());
                sb.append(samdas.getRecordText());
                sb.append(lineSeparator);
                sb.append(lineSeparator);
                output.append(sb);
                ++i;
            }
            if (problems.size() == 0 && (allProblems = Problem.getProblemsOfPatient(patient)) != null) {
                problems.addAll(allProblems);
            }
            Collections.sort(problems, DATE_COMPARATOR);
            StringBuffer problemsText = new StringBuffer();
            problemsText.append("Pers\u00f6nliche Anamnese");
            problemsText.append(lineSeparator);
            for (Problem problem : problems) {
                String date = problem.getStartDate();
                String text = problem.getTitle();
                ArrayList<String> therapy = new ArrayList<String>();
                String procedure = problem.getProcedere();
                if (!StringTool.isNothing((Object)procedure)) {
                    therapy.add(procedure.trim());
                }
                List<Prescription> prescriptions = problem.getPrescriptions();
                for (Prescription prescription : prescriptions) {
                    if (prescription != null && prescription.getArtikel() != null) {
                        StringBuffer label = new StringBuffer(prescription.getArtikel().getLabel());
                        if (label != null) {
                            label.append(" (" + prescription.getDosis() + ")");
                        }
                        therapy.add(label.toString().trim());
                        continue;
                    }
                    therapy.add("Kein Artikel");
                }
                StringBuffer sb = new StringBuffer();
                sb.append(date);
                sb.append(fieldSeparator);
                sb.append(text);
                sb.append(fieldSeparator);
                if (!therapy.isEmpty()) {
                    sb.append((String)therapy.get(0));
                }
                sb.append(lineSeparator);
                if (therapy.size() > 1) {
                    int i2 = 1;
                    while (i2 < therapy.size()) {
                        sb.append(fieldSeparator);
                        sb.append(fieldSeparator);
                        sb.append((String)therapy.get(i2));
                        sb.append(lineSeparator);
                        ++i2;
                    }
                }
                problemsText.append(sb);
            }
            output.append(problemsText);
            clipboardText = output.toString();
        }
        Clipboard clipboard = new Clipboard(UiDesk.getDisplay());
        TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] transfers = new Transfer[]{textTransfer};
        Object[] data = new Object[]{clipboardText};
        clipboard.setContents(data, transfers);
        clipboard.dispose();
        return clipboardText;
    }

    public static boolean twoKonsSamePatient(Konsultation thisKons, Konsultation otherKons) {
        if (thisKons == null && otherKons == null) {
            return true;
        }
        if (thisKons == null || otherKons == null) {
            return false;
        }
        return thisKons.getFall().getPatient().getId().equals(otherKons.getFall().getPatient().getId());
    }

    public static boolean twoKonsEqual(Konsultation thisKons, Konsultation otherKons) {
        if (thisKons == null && otherKons == null) {
            return true;
        }
        if (thisKons == null || otherKons == null) {
            return false;
        }
        return thisKons.getId().equals(otherKons.getId());
    }

    public static boolean haveSameContent(Konsultation thisKons, Konsultation otherKons) {
        if (thisKons == null && otherKons == null) {
            return true;
        }
        if (thisKons == null || otherKons == null) {
            return false;
        }
        if (!thisKons.getId().equals(otherKons.getId())) {
            return false;
        }
        if (!thisKons.getDatum().equals(otherKons.getDatum())) {
            return false;
        }
        if (thisKons.getEintrag() == null && otherKons.getEintrag() == null) {
            return true;
        }
        if (thisKons.getEintrag() == null || otherKons.getEintrag() == null) {
            return false;
        }
        VersionedResource.ResourceItem thisResource = thisKons.getEintrag().getVersion(thisKons.getHeadVersion());
        VersionedResource.ResourceItem otherResource = otherKons.getEintrag().getVersion(otherKons.getHeadVersion());
        if (thisResource == null && otherResource == null) {
            return true;
        }
        if (thisResource == null || otherResource == null) {
            return false;
        }
        String thisText = thisResource.data;
        String otherText = otherResource.data;
        return thisText.equals(otherText);
    }

    public static boolean hasRightToChangeConsultations(Konsultation kons, boolean showError) {
        return CoreHub.acl.request(AccessControlDefaults.ADMIN_KONS_EDIT_IF_BILLED) || kons.isEditable(showError);
    }

    public static String getExplantionForKonsEditIfBillet() {
        StringBuilder explanation = new StringBuilder("");
        if (CoreHub.acl.request(AccessControlDefaults.ADMIN_KONS_EDIT_IF_BILLED)) {
            explanation.append("Sie haben das Recht verrechnete Konsultation zu \u00e4ndern.");
        } else {
            explanation.append("Sie d\u00fcrfen verrechnete Konsultation nicht \u00e4ndern.");
        }
        explanation.append("\nDas \u00c4ndern von verrechneten Konsultation kann in den Einstellungen ge\u00e4ndert werden");
        explanation.append("\nUnter Gruppen und Rechten..");
        explanation.append("\n  Rollen und Rechten");
        explanation.append("\n    Recht: main:Konsultations");
        explanation.append("\n      Verrechnete \u00e4ndern");
        explanation.append("\nk\u00f6nnen Sie den gew\u00fcnschten Gruppen diese Recht erteilen");
        explanation.append("\nDieses Recht kann sinnvoll sein, wenn Sie eine Konsultation ");
        explanation.append("noch editieren wollen, nachdem sie von der MPA schon verrechnet wurde");
        return explanation.toString();
    }

    public static boolean checkActPatKons(Patient actPat, Konsultation actKons) {
        if (actPat == null && actKons != null) {
            System.out.println(String.format("Inkonsistent state of actPat %s and actKons %s", actPat, actKons));
            return false;
        }
        return true;
    }

    public static boolean userIsKonsAuthor(Konsultation kons) {
        if (kons == null) {
            return false;
        }
        return kons.getAuthor().isEmpty() || kons.getAuthor().contentEquals(CoreHub.actUser.getLabel());
    }

    public static boolean userMayEditKons(Konsultation kons) {
        return Helpers.userIsKonsAuthor(kons) && Helpers.hasRightToChangeConsultations(kons, false);
    }
}

