/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.util;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.ui.UiDesk;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Heartbeat
implements Heartbeat.HeartListener {
    private static Logger log = LoggerFactory.getLogger(Heartbeat.class);
    private boolean heartbeatActive = false;
    private boolean heartbeatProblemEnabled = true;
    private CopyOnWriteArrayList<IatrixHeartListener> iatrixListener = new CopyOnWriteArrayList();
    private static Heartbeat theHeartbeat;

    private Heartbeat() {
    }

    public static Heartbeat getInstance() {
        if (theHeartbeat == null) {
            theHeartbeat = new Heartbeat();
        }
        return theHeartbeat;
    }

    public void enableListener(boolean mode) {
        if (mode) {
            CoreHub.heart.addListener((Heartbeat.HeartListener)this);
        } else {
            CoreHub.heart.removeListener((Heartbeat.HeartListener)this);
        }
    }

    public void setHeartbeatProblemEnabled(boolean value) {
        log.debug("setHeartbeatProblemEnabled" + this.heartbeatProblemEnabled);
        this.heartbeatProblemEnabled = value;
    }

    public void heartbeat() {
        if (this.heartbeatActive) {
            return;
        }
        this.heartbeatActive = true;
        UiDesk.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                log.debug("run for " + Heartbeat.this.iatrixListener.size() + " listeners");
                Heartbeat.this.notifyListeners();
            }
        });
        this.heartbeatActive = false;
    }

    public static int getKonsTextSaverPeriod() {
        int timePeriod = CoreHub.userCfg.get("org.iatrix/auto_save_period", 120);
        if (timePeriod == 0) {
            return 0;
        }
        log.debug("TimePeriod: " + timePeriod);
        int heartbeatInterval = CoreHub.localCfg.get("ablauf/heartrate", 30);
        if (heartbeatInterval > 0 && timePeriod >= heartbeatInterval) {
            int period = timePeriod / heartbeatInterval;
            if (period > 0) {
                return period;
            }
            return 1;
        }
        return 1;
    }

    private void notifyListeners() {
        for (IatrixHeartListener name : this.iatrixListener) {
            name.heartbeat();
        }
    }

    public void addListener(IatrixHeartListener newListener) {
        this.iatrixListener.add(newListener);
    }

    public static interface IatrixHeartListener {
        public void heartbeat();
    }
}

