/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.dialogs;

import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Konsultation;
import ch.rgw.tools.VersionedResource;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.iatrix.widgets.EnhancedTextFieldRO;

public class ChooseKonsRevisionDialog
extends TitleAreaDialog {
    public static final int NONE = -1;
    private int selectedVersion = -1;
    private List<WidgetRow> widgetRows = new ArrayList<WidgetRow>();
    private Konsultation konsultation;

    public ChooseKonsRevisionDialog(Shell parent, Konsultation konsultation) {
        super(parent);
        this.konsultation = konsultation;
    }

    protected Control createDialogArea(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite mainArea = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)mainArea);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 10;
        mainArea.setLayout((Layout)gridLayout);
        this.createWidgetRows(mainArea);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinSize(mainArea.computeSize(-1, -1));
        return scrolledComposite;
    }

    private void createWidgetRows(Composite parent) {
        if (this.konsultation != null) {
            int last;
            RadioGroupListener radioGroupListener = new RadioGroupListener();
            VersionedResource vr = this.konsultation.getEintrag();
            int i = last = vr.getHeadVersion();
            while (i >= 0) {
                VersionedResource.ResourceItem ri = vr.getVersion(i);
                int version = i--;
                String label = ri.getLabel();
                String data = ri.data;
                String labelText = "Rev " + version + ": " + label;
                Composite rowComposite = new Composite(parent, 0);
                rowComposite.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
                GridLayout gridLayout = new GridLayout(1, false);
                gridLayout.verticalSpacing = 0;
                rowComposite.setLayout((Layout)gridLayout);
                Button radioButton = new Button(rowComposite, 16);
                GridData gd = SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false);
                gd.verticalAlignment = 1;
                radioButton.setLayoutData((Object)gd);
                radioButton.setText(labelText);
                radioGroupListener.addButton(radioButton);
                EnhancedTextFieldRO text = new EnhancedTextFieldRO(rowComposite);
                text.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
                text.setText(data);
                WidgetRow widgetRow = new WidgetRow(radioButton, version);
                this.widgetRows.add(widgetRow);
            }
            if (this.widgetRows.size() > 0) {
                this.widgetRows.get((int)0).radio.setSelection(true);
            }
        }
    }

    public void create() {
        super.create();
        this.setMessage("Text-Version w\u00e4hlen");
        this.setTitle("W\u00e4hlen Sie die gew\u00fcnschte Version aus.");
        this.getShell().setText("Text-Version w\u00e4hlen");
        this.setTitleImage(Images.IMG_LOGO.getImage());
    }

    protected void okPressed() {
        this.selectedVersion = -1;
        for (WidgetRow widgetRow : this.widgetRows) {
            if (!widgetRow.radio.getSelection()) continue;
            this.selectedVersion = widgetRow.version;
            break;
        }
        super.okPressed();
    }

    public int getSelectedVersion() {
        return this.selectedVersion;
    }

    class RadioGroupListener
    implements SelectionListener {
        List<Button> buttons = new ArrayList<Button>();

        RadioGroupListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            for (Button other : this.buttons) {
                if (other.equals(e.widget)) continue;
                other.setSelection(false);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void addButton(Button button) {
            this.buttons.add(button);
            button.addSelectionListener((SelectionListener)this);
        }
    }

    class WidgetRow {
        Button radio;
        int version;

        WidgetRow(Button radio, int version) {
            this.radio = radio;
            this.version = version;
        }
    }
}

