/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.data;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Artikel;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.elexis.icpc.Encounter;
import ch.elexis.icpc.Episode;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.VersionInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.iatrix.data.OldProblem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Problem
extends Episode {
    public static final String TEXT_SEPARATOR = "::";
    private static Logger log = LoggerFactory.getLogger(Problem.class);
    private static final String IATRIX_VERSION_KEY = "org.iatrix/dbversion";
    private static final String FIELD_PROCEDERE = "Procedere";
    private static final String STANDARD_PROBLEM = "Standardproblem";
    private static final String PROBLEM_BEHDL_TABLENAME = "IATRIX_PROBLEM_BEHDL_JOINT";
    private static final String PROBLEM_DG_TABLENAME = "IATRIX_PROBLEM_DG_JOINT";
    private static final String PROBLEM_DAUERMEDIKATION_TABLENAME = "IATRIX_PROBLEM_DAUERMEDIKATION_JOINT";
    private static final String FIELD_EPISODE_ID = "EpisodeID";
    private static final String FIELD_KONS_ID = "KonsID";
    private static final String IATRIX_DB_VERSION_PRE_ENCOUNTERS = "0.2.0";
    private static final String IATRIX_DB_VERSION_ENCOUNTERS = "0.3.0";
    private static final String IATRIX_DB_VERSION = "0.3.0";
    private static final String CREATE = "CREATE TABLE IATRIX_PROBLEM_BEHDL_JOINT (ID            VARCHAR(25) primary key,ProblemID     VARCHAR(25),BehandlungsID VARCHAR(25));CREATE INDEX problembehdl1 on IATRIX_PROBLEM_BEHDL_JOINT (ProblemID);CREATE TABLE IATRIX_PROBLEM_DG_JOINT (ID\t\t\t\tVARCHAR(25) primary key,ProblemID      VARCHAR(25),DiagnoseID\t\tVARCHAR(25));CREATE INDEX problemdg1 on IATRIX_PROBLEM_DG_JOINT (ProblemID);CREATE TABLE IATRIX_PROBLEM_DAUERMEDIKATION_JOINT (ID                VARCHAR(25) primary key,ProblemID         VARCHAR(25),DauermedikationID VARCHAR(25));CREATE INDEX problemdauermedikation1 on IATRIX_PROBLEM_DAUERMEDIKATION_JOINT (ProblemID);";
    private JdbcLink j = Problem.getConnection();

    static {
        Problem.init();
    }

    public Problem(Patient pat, String bezeichnung) {
        super(pat, bezeichnung);
    }

    public static Problem convertEpisodeToProblem(Episode episode) {
        if (episode == null) {
            return null;
        }
        return Problem.load(episode.getId());
    }

    private static void init() {
        VersionInfo vi;
        String version = CoreHub.globalCfg.get(IATRIX_VERSION_KEY, null);
        if (version == null) {
            OldProblem oldSetup = OldProblem.load("__SETUP__");
            if (!oldSetup.exists()) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(CREATE.getBytes("UTF-8"));
                    if (!Problem.getConnection().execScript((InputStream)bais, true, false)) {
                        MessageDialog.openError(null, (String)"Fehler bei Problem", (String)"Konnte die Tabellen f\u00fcr Probleme nicht erstellen");
                        return;
                    }
                    version = "0.3.0";
                    CoreHub.globalCfg.set(IATRIX_VERSION_KEY, "0.3.0");
                    CoreHub.globalCfg.flush();
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            } else {
                Problem.convertOldProblemsToEpisodes();
                version = IATRIX_DB_VERSION_PRE_ENCOUNTERS;
                CoreHub.globalCfg.set(IATRIX_VERSION_KEY, IATRIX_DB_VERSION_PRE_ENCOUNTERS);
                CoreHub.globalCfg.flush();
            }
        }
        if (version != null && (vi = new VersionInfo(version)).isOlder("0.3.0")) {
            SWTHelper.showInfo((String)"Aktualisierung DB Iatrix", (String)"DB Iatrix wird nachfolgend aktualisiert. Bitte Elexis nicht beenden, bis Sie informiert werden.");
            boolean success1 = Problem.convertProblemAssignmentsToEncounters();
            boolean success2 = Problem.convertIatrixDiagnosisToEpisodeDiagnosis();
            if (!success1 || !success2) {
                SWTHelper.showError((String)"Fehler bei Aktualisierung DB Iatrix", (String)"Bei der Aktualisierung der DB Iatrix sind Fehler aufgetreten. Bitte benachrichtigen Sie Ihren Elexis-Dienstleister, um das Problem zu beheben, bevor Sie weiter arbeiten. Bitte beenden Sie nun Elexis. Informationen zum Problem sind in der Log-Datei zu finden.");
            } else {
                CoreHub.globalCfg.set(IATRIX_VERSION_KEY, "0.3.0");
                CoreHub.globalCfg.flush();
                SWTHelper.showInfo((String)"Aktualisierung DB Iatrix", (String)"DB Iatrix wurde fertig aktualisiert. Sie k\u00f6nnen nun arbeiten.");
            }
        }
    }

    private static void convertOldProblemsToEpisodes() {
        List<OldProblem> oldProblems = OldProblem.getOldProblems();
        for (OldProblem oldProblem : oldProblems) {
            Patient patient;
            Problem problem = new Problem(oldProblem.getId());
            if (problem.isAvailable() || !(patient = Patient.load((String)oldProblem.get("PatientID"))).isAvailable()) continue;
            problem.create(null);
            problem.set("PatientID", patient.getId());
            String title = oldProblem.get("Bezeichnung");
            String number = oldProblem.get("Nummer");
            String startDate = oldProblem.get("Datum");
            String procedere = oldProblem.get(FIELD_PROCEDERE);
            String sStatus = oldProblem.get("Status");
            int status = sStatus != null && sStatus.equals("1") ? 1 : 0;
            problem.setTitle(title);
            problem.setNumber(number);
            problem.setStartDate(startDate);
            problem.setProcedere(procedere);
            problem.setStatus(status);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean convertProblemAssignmentsToEncounters() {
        JdbcLink j = PersistentObject.getConnection();
        StringBuilder sql = new StringBuilder(200);
        sql.append("SELECT ID, ProblemID, BehandlungsID FROM IATRIX_PROBLEM_BEHDL_JOINT");
        JdbcLink.Stm stm = j.getStatement();
        ResultSet rs = stm.query(sql.toString());
        boolean success = true;
        try {
            try {
                while (true) {
                    if (!rs.next()) {
                        rs.close();
                        return success;
                    }
                    try {
                        rs.getString(1);
                        String problemId = rs.getString(2);
                        String konsultationId = rs.getString(3);
                        Problem problem = Problem.load(problemId);
                        Konsultation konsultation = Konsultation.load((String)konsultationId);
                        if (problem == null || konsultation == null || !problem.exists() || !konsultation.exists() || problem.isAssignedToKonsultation(konsultation)) continue;
                        Encounter encounter = new Encounter(konsultation, (Episode)problem);
                        log.debug("Converted to Encounter " + encounter.getId());
                    }
                    catch (Exception ex) {
                        success = false;
                        ExHandler.handle((Throwable)ex);
                        log.error(ex.getMessage());
                    }
                }
            }
            catch (Exception ex) {
                success = false;
                ExHandler.handle((Throwable)ex);
                log.error(ex.getMessage());
                j.releaseStatement(stm);
                return success;
            }
        }
        finally {
            j.releaseStatement(stm);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean convertIatrixDiagnosisToEpisodeDiagnosis() {
        JdbcLink j = PersistentObject.getConnection();
        StringBuilder sql = new StringBuilder(200);
        sql.append("SELECT ID, ProblemID, DiagnoseID FROM IATRIX_PROBLEM_DG_JOINT");
        JdbcLink.Stm stm = j.getStatement();
        ResultSet rs = stm.query(sql.toString());
        boolean success = true;
        try {
            try {
                while (true) {
                    if (!rs.next()) {
                        rs.close();
                        return success;
                    }
                    try {
                        rs.getString(1);
                        String problemId = rs.getString(2);
                        String diagnoseId = rs.getString(3);
                        Problem problem = Problem.load(problemId);
                        IDiagnose diagnose = null;
                        JdbcLink.Stm stm2 = j.getStatement();
                        ResultSet rs2 = stm2.query("SELECT DG_CODE, KLASSE FROM DIAGNOSEN WHERE ID = " + JdbcLink.wrap((String)diagnoseId));
                        if (rs2.next()) {
                            String code = rs2.getString(1);
                            String klasse = rs2.getString(2);
                            StringBuilder sb = new StringBuilder();
                            sb.append(klasse);
                            sb.append(TEXT_SEPARATOR);
                            sb.append(code);
                            try {
                                PersistentObject dg = CoreHub.poFactory.createFromString(sb.toString());
                                if (dg instanceof IDiagnose) {
                                    diagnose = (IDiagnose)dg;
                                }
                            }
                            catch (Exception ex) {
                                ExHandler.handle((Throwable)ex);
                            }
                        }
                        rs2.close();
                        j.releaseStatement(stm2);
                        if (problem == null || diagnose == null || !problem.exists()) continue;
                        problem.addDiagnose(diagnose, false);
                    }
                    catch (Exception ex) {
                        success = false;
                        ExHandler.handle((Throwable)ex);
                        log.error(ex.getMessage());
                    }
                }
            }
            catch (Exception ex) {
                success = false;
                ExHandler.handle((Throwable)ex);
                log.error(ex.getMessage());
                j.releaseStatement(stm);
                return success;
            }
        }
        finally {
            j.releaseStatement(stm);
        }
    }

    public static Problem load(String id) {
        Problem problem = new Problem(id);
        return problem;
    }

    protected Problem() {
    }

    protected Problem(String id) {
        super(id);
    }

    public boolean remove(boolean force) {
        if (CoreHub.acl.request(AccessControlDefaults.DELETE_FORCED)) {
            ExHandler.handle((Throwable)new Exception("Alle Probleme von Konsulationen entfernen"));
            return super.delete();
        }
        return false;
    }

    public String getProcedere() {
        return Problem.checkNull((Object)this.getExtField(FIELD_PROCEDERE));
    }

    public void setProcedere(String procedere) {
        this.setExtField(FIELD_PROCEDERE, procedere);
    }

    public String toString() {
        return this.getLabel();
    }

    public boolean isAssignedToKonsultation(Konsultation konsultation) {
        Encounter encounter = this.getEncounter(konsultation);
        return encounter != null;
    }

    public Encounter getEncounter(Konsultation konsultation) {
        if (konsultation == null) {
            return null;
        }
        Query query = new Query(Encounter.class);
        query.add(FIELD_EPISODE_ID, "=", this.getId());
        query.add(FIELD_KONS_ID, "=", konsultation.getId());
        List encounters = query.execute();
        if (encounters != null && !encounters.isEmpty()) {
            return (Encounter)encounters.get(0);
        }
        return null;
    }

    public List<Encounter> getEncounters(Konsultation konsultation) {
        ArrayList<Encounter> result = new ArrayList<Encounter>();
        if (konsultation == null) {
            return result;
        }
        Query query = new Query(Encounter.class);
        query.add(FIELD_EPISODE_ID, "=", this.getId());
        query.add(FIELD_KONS_ID, "=", konsultation.getId());
        List encounters = query.execute();
        if (encounters != null && !encounters.isEmpty()) {
            result.addAll(encounters);
        }
        return result;
    }

    public void addToKonsultation(Konsultation konsultation) {
        if (!this.isAssignedToKonsultation(konsultation)) {
            new Encounter(konsultation, (Episode)this);
            ArrayList existingDiagnosen = konsultation.getDiagnosen();
            List<IDiagnose> diagnosen = this.getDiagnosen();
            for (IDiagnose diagnose : diagnosen) {
                boolean exists = false;
                for (IDiagnose dg : existingDiagnosen) {
                    if (!dg.getId().equals(diagnose.getId())) continue;
                    exists = true;
                }
                if (exists) continue;
                konsultation.addDiagnose(diagnose);
            }
        }
    }

    public void removeFromKonsultation(Konsultation konsultation) {
        Query query = new Query(Encounter.class);
        query.add(FIELD_EPISODE_ID, "=", this.getId());
        query.add(FIELD_KONS_ID, "=", konsultation.getId());
        List encounters = query.execute();
        if (encounters != null && !encounters.isEmpty()) {
            for (Encounter encounter : encounters) {
                encounter.delete();
            }
        }
        List<IDiagnose> diagnosen = this.getDiagnosen();
        this.removeDiagnosenFromKonsultation(konsultation, diagnosen);
    }

    private void removeDiagnosenFromKonsultation(Konsultation konsultation, List<IDiagnose> diagnosen) {
        ArrayList<IDiagnose> otherProblemsDiagnosen = new ArrayList<IDiagnose>();
        List<Problem> problems = Problem.getProblemsOfKonsultation(konsultation);
        for (Problem problem : problems) {
            if (problem.equals((Object)this)) continue;
            otherProblemsDiagnosen.addAll(problem.getDiagnosen());
        }
        for (IDiagnose diagnose : diagnosen) {
            if (otherProblemsDiagnosen.contains(diagnose) || !konsultation.isEditable(false)) continue;
            konsultation.removeDiagnose(diagnose);
        }
    }

    private void removeDiagnoseFromKonsultation(Konsultation konsultation, IDiagnose diagnose) {
        ArrayList<IDiagnose> diagnosen = new ArrayList<IDiagnose>();
        diagnosen.add(diagnose);
        this.removeDiagnosenFromKonsultation(konsultation, diagnosen);
    }

    public static List<Problem> getProblemsOfPatient(Patient patient) {
        Query query = new Query(Problem.class);
        query.add("PatientID", "=", patient.getId());
        List problems = query.execute();
        if (problems != null) {
            return problems;
        }
        return new ArrayList<Problem>();
    }

    public static List<Problem> getProblemsOfKonsultation(Konsultation konsultation) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Query query = new Query(Encounter.class);
        query.add(FIELD_KONS_ID, "=", konsultation.getId());
        List encounters = query.execute();
        if (encounters != null && !encounters.isEmpty()) {
            for (Encounter encounter : encounters) {
                Episode episode = encounter.getEpisode();
                Problem problem = Problem.convertEpisodeToProblem(episode);
                if (!problem.exists() || problems.contains((Object)problem)) continue;
                problems.add(problem);
            }
        }
        return problems;
    }

    public List<Konsultation> getKonsultationen() {
        ArrayList<Konsultation> konsultationen = new ArrayList<Konsultation>();
        Query query = new Query(Encounter.class);
        query.add(FIELD_EPISODE_ID, "=", this.getId());
        List encounters = query.execute();
        if (encounters != null && !encounters.isEmpty()) {
            for (Encounter encounter : encounters) {
                Konsultation konsultation = encounter.getKons();
                if (konsultation == null || !konsultation.exists() || konsultationen.contains(konsultation)) continue;
                konsultationen.add(konsultation);
            }
        }
        return konsultationen;
    }

    public List<IDiagnose> getDiagnosen() {
        return this.getDiagnoses();
    }

    public String getDiagnosenAsText() {
        StringBuilder sb = new StringBuilder();
        List<IDiagnose> diagnosen = this.getDiagnosen();
        boolean isFirst = true;
        for (IDiagnose diagnose : diagnosen) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(TEXT_SEPARATOR);
            }
            sb.append(diagnose.getLabel());
        }
        return sb.toString();
    }

    public void addDiagnose(IDiagnose dg) {
        this.addDiagnose(dg, true);
    }

    private void addDiagnose(IDiagnose dg, boolean addToKonsultation) {
        boolean exists = false;
        List existing = this.getDiagnoses();
        for (IDiagnose eDg : existing) {
            if (!eDg.getId().equals(dg.getId())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.addDiagnosis(dg);
            if (addToKonsultation) {
                this.addDiagnoseToKonsultationen(dg);
            }
        }
    }

    private void addDiagnoseToKonsultationen(IDiagnose diagnose) {
        List<Konsultation> konsultationen = this.getKonsultationen();
        for (Konsultation konsultation : konsultationen) {
            ArrayList diagnosen = konsultation.getDiagnosen();
            boolean exists = false;
            for (IDiagnose dg : diagnosen) {
                if (!dg.getId().equals(diagnose.getId())) continue;
                exists = true;
            }
            if (exists || !konsultation.isEditable(false)) continue;
            konsultation.addDiagnose(diagnose);
        }
    }

    public void removeDiagnose(IDiagnose diagnose) {
        this.removeDiagnosis(diagnose);
    }

    public boolean addPrescription(Prescription prescription) {
        String exists = this.j.queryString("SELECT ID FROM IATRIX_PROBLEM_DAUERMEDIKATION_JOINT WHERE ProblemID = " + this.getWrappedId() + " AND DauermedikationID = " + prescription.getWrappedId());
        if (StringTool.isNothing((Object)exists)) {
            String problemDaueredikationId = StringTool.unique((String)"problemdauermedikation");
            StringBuilder sql = new StringBuilder(200);
            sql.append("INSERT INTO IATRIX_PROBLEM_DAUERMEDIKATION_JOINT (ID, ProblemID, DauermedikationID) VALUES (").append(JdbcLink.wrap((String)problemDaueredikationId)).append(",").append(this.getWrappedId()).append(",").append(prescription.getWrappedId()).append(")");
            this.j.exec(sql.toString());
            return true;
        }
        return false;
    }

    public void removePrescription(Prescription prescription) {
        StringBuilder sql = new StringBuilder(200);
        sql.append("DELETE FROM IATRIX_PROBLEM_DAUERMEDIKATION_JOINT").append(" WHERE ProblemID = " + this.getWrappedId()).append(" AND").append(" DauermedikationID = " + prescription.getWrappedId());
        this.j.exec(sql.toString());
    }

    public List<Prescription> getPrescriptions() {
        ArrayList<Prescription> prescriptions = new ArrayList<Prescription>();
        StringBuilder sql = new StringBuilder(200);
        sql.append("SELECT DauermedikationID FROM IATRIX_PROBLEM_DAUERMEDIKATION_JOINT").append(" WHERE ProblemID = " + this.getWrappedId());
        JdbcLink.Stm stm = this.j.getStatement();
        ResultSet rs = stm.query(sql.toString());
        try {
            try {
                while (rs.next()) {
                    String id = rs.getString(1);
                    Prescription prescription = Prescription.load((String)id);
                    if (prescription == null || !prescription.exists()) continue;
                    prescriptions.add(prescription);
                }
                rs.close();
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                log.error(ex.getMessage());
                this.j.releaseStatement(stm);
            }
        }
        finally {
            this.j.releaseStatement(stm);
        }
        return prescriptions;
    }

    public String getPrescriptionsAsText() {
        StringBuilder sb = new StringBuilder();
        List<Prescription> prescriptions = this.getPrescriptions();
        boolean isFirst = true;
        for (Prescription prescription : prescriptions) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(TEXT_SEPARATOR);
            }
            Artikel artikel = prescription.getArtikel();
            String label = artikel != null && artikel.isAvailable() ? String.valueOf(prescription.getArtikel().getLabel()) + " (" + prescription.getDosis() + ")" : "Fehler (" + prescription.getDosis() + ")";
            sb.append(label);
        }
        return sb.toString();
    }

    public static Problem createStandardProblem(Patient patient) {
        Problem problem = new Problem(patient, STANDARD_PROBLEM);
        return problem;
    }
}

