/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.util.CreatePrescriptionHelper;
import ch.elexis.data.Anwender;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.JdbcLinkException;
import ch.rgw.tools.StringTool;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KonsTextLock {
    private final String identifier = StringTool.unique((String)"org.iatrix.views.JournalView");
    String konsultationId = null;
    String userId = null;
    String key = null;
    String label = null;
    boolean lockVar = false;
    boolean traceEnabled = CoreHub.userCfg.get("org.iatrix/use_konstext_trace", false);
    boolean useDatabaseLock = CoreHub.userCfg.get("org.iatrix/use_konstext_locking", true);
    private static final long MAX_AGE_2_HOURS = 0x6DDD00L;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.iatrix.KonsTextLock");

    public static void deleteObsoleteLocks(Konsultation konsultation) {
        int nrFound = 0;
        String sql = "SELECT param, wert FROM CONFIG WHERE param like '%_konslock_%'";
        ResultSet values = null;
        PreparedStatement pstm = PersistentObject.getDefaultConnection().getPreparedStatement(sql);
        try {
            try {
                values = pstm.executeQuery();
                long now = System.currentTimeMillis();
                StringBuilder delStm = new StringBuilder("delete from config where param in (");
                while (values.next()) {
                    String key = values.getString(1);
                    String oldlock = values.getString(2);
                    long locktime = 0L;
                    String[] tokens = oldlock.split("#");
                    if (tokens.length >= 1) {
                        try {
                            locktime = Long.parseLong(tokens[0]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            break;
                        }
                    }
                    long age = now - locktime;
                    String msg = String.valueOf(oldlock) + " " + locktime + " from " + new Date(locktime).toString();
                    logger.trace(msg);
                    if (age <= 0x6DDD00L) continue;
                    if (nrFound == 0) {
                        delStm.append(" '" + key + "' ");
                    } else {
                        delStm.append(", '" + key + "' ");
                    }
                    ++nrFound;
                }
                if (nrFound > 0) {
                    logger.info("Deleting " + nrFound + " obsolete _konslock_ from config");
                    delStm.append(")");
                    JdbcLink.Stm stm = PersistentObject.getDefaultConnection().getStatement();
                    stm.exec(delStm.toString());
                    PersistentObject.getDefaultConnection().releaseStatement(stm);
                }
            }
            catch (JdbcLinkException | SQLException e) {
                logger.info(" Error deleting " + e);
                LoggerFactory.getLogger(CreatePrescriptionHelper.class).error("Could not find any konslock", e);
                PersistentObject.getDefaultConnection().releasePreparedStatement(pstm);
            }
        }
        finally {
            PersistentObject.getDefaultConnection().releasePreparedStatement(pstm);
        }
    }

    private void trace(String msg) {
        if (this.traceEnabled) {
            logger.info(String.valueOf(msg) + this.key + " u: " + this.userId);
        }
    }

    public KonsTextLock(Konsultation konsultation, Anwender user) {
        this.konsultationId = konsultation.getId();
        this.userId = user.getId();
        StringBuffer sb = new StringBuffer();
        sb.append("org.iatrix.views.JournalView").append("_").append("konslock").append("_").append(this.konsultationId);
        this.key = sb.toString();
        this.trace("new KonsTextLock: ");
        this.lockVar = false;
    }

    public Value getLockValue() {
        String lockValue = PersistentObject.getDefaultConnection().queryString("SELECT wert from CONFIG WHERE param = " + JdbcLink.wrap((String)this.key));
        return new Value(lockValue);
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized boolean lock() {
        if (!this.useDatabaseLock) {
            this.lockVar = true;
            return this.lockVar;
        }
        this.trace("lock: start ");
        JdbcLink.Stm stm = PersistentObject.getDefaultConnection().getStatement();
        try {
            Value lockValue;
            long now = System.currentTimeMillis();
            String oldlock = stm.queryString("SELECT wert FROM CONFIG WHERE param=" + JdbcLink.wrap((String)this.key));
            if (!StringTool.isNothing((Object)oldlock)) {
                lockValue = new Value(oldlock);
                String lockIdentifier = lockValue.getIdentifier();
                if (lockIdentifier != null && lockIdentifier.equals(this.identifier)) {
                    lockValue = new Value(this.userId, this.identifier);
                    String lockstring = lockValue.getLockString();
                    StringBuilder sb = new StringBuilder();
                    sb.append("UPDATE CONFIG SET wert = ").append("'" + lockstring + "'").append(" WHERE param = ").append(JdbcLink.wrap((String)this.key));
                    stm.exec(sb.toString());
                    this.trace("lock: okay ");
                    return true;
                }
                long locktime = lockValue.getTimestamp();
                long age = now - locktime;
                if (age > 0x6DDD00L) {
                    stm.exec("DELETE FROM CONFIG WHERE param=" + JdbcLink.wrap((String)this.key));
                } else {
                    this.label = String.valueOf(this.key) + " " + oldlock + " " + locktime + " from " + new Date(locktime).toString();
                    this.trace("lock: failed " + this.label);
                    return false;
                }
            }
            lockValue = new Value(this.userId, this.identifier);
            long timestamp = lockValue.getTimestamp();
            this.label = String.valueOf(lockValue.hostName) + "_" + this.userId + " " + timestamp + " from " + new Date(timestamp).toString();
            String lockstring = lockValue.getLockString();
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO CONFIG (param, wert) VALUES (").append(JdbcLink.wrap((String)this.key)).append(",").append("'").append(lockstring).append("')");
            stm.exec(sb.toString());
            String check = stm.queryString("SELECT wert FROM CONFIG WHERE param=" + JdbcLink.wrap((String)this.key));
            if (check == null || !check.equals(lockstring)) {
                this.trace("lock: failed ");
                return false;
            }
            this.trace("lock: okay " + this.label);
            return true;
        }
        finally {
            PersistentObject.getDefaultConnection().releaseStatement(stm);
        }
    }

    public synchronized boolean isLocked() {
        if (!this.useDatabaseLock) {
            return this.lockVar;
        }
        Value lockValue = this.getLockValue();
        return this.identifier.equals(lockValue.getIdentifier());
    }

    public synchronized boolean unlock() {
        if (!this.useDatabaseLock) {
            this.lockVar = false;
            return this.lockVar;
        }
        this.trace("unlock: start ");
        String lock = PersistentObject.getDefaultConnection().queryString("SELECT wert from CONFIG WHERE param=" + JdbcLink.wrap((String)this.key));
        if (StringTool.isNothing((Object)lock)) {
            this.trace("unlock: failed ");
            return false;
        }
        Value lockValue = new Value(lock);
        String lockIdentifier = lockValue.getIdentifier();
        if (lockIdentifier != null && lockIdentifier.equals(this.identifier)) {
            PersistentObject.getDefaultConnection().exec("DELETE FROM CONFIG WHERE param=" + JdbcLink.wrap((String)this.key));
            this.trace("unlock: okay ");
            return true;
        }
        if (this.traceEnabled) {
            this.trace("unlock: failed ");
        }
        return false;
    }

    public class Value {
        private long timestamp = 0L;
        private String userId = null;
        private String identifier = null;
        private String hostName = null;

        Value(String lockValue) {
            String[] tokens;
            if (lockValue != null && (tokens = lockValue.split("#")).length >= 3) {
                try {
                    this.timestamp = Long.parseLong(tokens[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                this.userId = tokens[1];
                this.identifier = tokens[2];
                if (tokens.length >= 4) {
                    this.hostName = tokens[3];
                }
            }
        }

        Value(String userId, String identifier) {
            this.timestamp = System.currentTimeMillis();
            this.userId = userId;
            this.identifier = identifier;
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                this.hostName = null;
            }
        }

        String getLockString() {
            StringBuffer sb = new StringBuffer();
            sb.append(new Long(this.timestamp).toString()).append("#").append(this.userId).append("#").append(this.identifier).append("#").append(this.hostName);
            return sb.toString();
        }

        long getTimestamp() {
            return this.timestamp;
        }

        public Anwender getUser() {
            return Anwender.load((String)this.userId);
        }

        public String getHost() {
            return this.hostName;
        }

        String getIdentifier() {
            return this.identifier;
        }
    }
}

