/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.data;

import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.icpc.Episode;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KonsDiagnosisUpdateForIatrix
extends ExternalMaintenance {
    protected static Logger log = LoggerFactory.getLogger(KonsDiagnosisUpdateForIatrix.class);
    private static int nrItems = -1;
    private static int curItem = -1;

    private void addDiagnoseIfNotExists(Patient actPat, String newDiag) {
        if (newDiag.length() == 0 || newDiag.contentEquals(" ")) {
            log.debug("{}/{} {} skip empty diagnose {}", new Object[]{curItem, nrItems, actPat.getPersonalia(), newDiag});
            return;
        }
        String oldDiag = actPat.getDiagnosen();
        if (!oldDiag.contains(newDiag)) {
            log.debug("{}/{} {} added {}", new Object[]{curItem, nrItems, actPat.getPersonalia(), newDiag});
            if (oldDiag.length() == 0) {
                actPat.setDiagnosen(newDiag);
            } else {
                actPat.setDiagnosen(String.valueOf(oldDiag) + "\r\n" + newDiag.toString());
            }
        }
    }

    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        StringBuilder sb = new StringBuilder();
        Query query = new Query(Episode.class);
        query.clear(true);
        query.add("lastupdate", "<>", null);
        query.add("deleted", "=", "0");
        query.add("Status", "=", "1");
        List alleIatricIcpcEpisoden = query.execute();
        log.debug("Found {} items", (Object)alleIatricIcpcEpisoden.size());
        nrItems = alleIatricIcpcEpisoden.size();
        pm.beginTask("Moving (Iatrix) ICPC Episodes#Diagnosis ...", nrItems);
        curItem = 0;
        for (Episode episode : alleIatricIcpcEpisoden) {
            ++curItem;
            Patient actPat = episode.getPatient();
            if (episode.getId().contentEquals("1")) continue;
            String newDiag = episode.getTitle();
            if (episode.getStartDate().length() > 0) {
                newDiag = String.valueOf(episode.getStartDate()) + " " + episode.getTitle();
            }
            if (actPat != null) {
                List diagnoses = episode.getDiagnoses();
                if (diagnoses.size() > 0) {
                    for (IDiagnose diag : diagnoses) {
                        newDiag = newDiag.length() == 0 ? diag.getLabel() : String.valueOf(newDiag) + " " + diag.getLabel();
                        this.addDiagnoseIfNotExists(actPat, newDiag);
                        newDiag = "";
                    }
                } else {
                    this.addDiagnoseIfNotExists(actPat, String.valueOf(episode.getStartDate()) + " " + episode.getTitle());
                }
            }
            pm.worked(1);
        }
        pm.done();
        return sb.toString();
    }

    public String getMaintenanceDescription() {
        return "[14971] \u00dcbertragung Diagnose aus Iatrix zur Patienten\u00fcbersicht";
    }
}

