/*
 * Decompiled with CFR 0.152.
 */
package net.medshare.connector.viollier.handlers;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import java.awt.Desktop;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import net.medshare.connector.viollier.Messages;
import net.medshare.connector.viollier.data.ViollierConnectorSettings;
import net.medshare.connector.viollier.ses.PortalCookieService;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderStateHandler
extends AbstractHandler {
    private static Logger log = LoggerFactory.getLogger(OrderStateHandler.class);
    private ViollierConnectorSettings mySettings;
    private String httpsUrl;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String vorname = "";
        String name = "";
        String geburtsdatum = "";
        String doctor = "";
        String cookie = "";
        this.mySettings = new ViollierConnectorSettings((Mandant)ElexisEventDispatcher.getSelected(Mandant.class));
        this.httpsUrl = this.mySettings.getGlobalLoginUrl();
        try {
            cookie = new PortalCookieService().getCookie();
        }
        catch (IOException e) {
            log.error("Error getting cookie", (Throwable)e);
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleGetCookie, (String)(String.valueOf(Messages.Handler_errorMessageGetCookie) + e.getMessage()));
        }
        catch (ElexisException e) {
            log.error("No username/password defined", (Throwable)e);
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Exception_errorTitleNoUserPasswordDefined, (String)e.getMessage());
        }
        this.httpsUrl = String.valueOf(this.httpsUrl) + "&RCSession=" + cookie;
        Patient patient = ElexisEventDispatcher.getSelectedPatient();
        if (patient != null) {
            try {
                this.httpsUrl = String.valueOf(this.httpsUrl) + "&appPath=" + URLEncoder.encode("/orderit/viewOrderStatusFromGP?", "UTF-8");
                vorname = patient.getVorname();
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&firstname=" + vorname, "UTF-8");
                name = patient.getName();
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&surname=" + name, "UTF-8");
                geburtsdatum = this.convertDate(patient.getGeburtsdatum());
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&dateOfBirth=" + geburtsdatum, "UTF-8");
                doctor = this.mySettings.getMandantUseGlobalSettings() != false ? this.mySettings.getGlobalViollierClientId() : this.mySettings.getMandantViollierClientId();
                if (!doctor.isEmpty()) {
                    this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&doctor=" + doctor, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error("Encoding not supported", (Throwable)e);
            }
        }
        try {
            Desktop.getDesktop().browse(new URI(this.httpsUrl));
        }
        catch (URISyntaxException e) {
            log.error("Could not resolve URI: " + this.httpsUrl, (Throwable)e);
        }
        catch (IOException e) {
            log.error("IO Exception while trying to get order state", (Throwable)e);
        }
        return null;
    }

    private String convertDate(String gebDat) {
        if (gebDat.isEmpty()) {
            return "";
        }
        String tempDay = gebDat.substring(0, 2);
        String tempMonth = gebDat.substring(3, 5);
        String tempYear = gebDat.substring(6);
        return String.valueOf(tempYear) + "-" + tempMonth + "-" + tempDay;
    }
}

