/*
 * Decompiled with CFR 0.152.
 */
package net.medshare.connector.viollier.handlers;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Xid;
import java.awt.Desktop;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.List;
import net.medshare.connector.viollier.Messages;
import net.medshare.connector.viollier.data.ViollierConnectorSettings;
import net.medshare.connector.viollier.ses.PortalCookieService;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnoseQueryPatientHandler
extends AbstractHandler {
    private static Logger log = LoggerFactory.getLogger(DiagnoseQueryPatientHandler.class);
    private static String DOMAIN_VIONR = "viollier.ch/vioNumber";
    private ViollierConnectorSettings mySettings;
    private String httpsUrl;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String cookie = "";
        String vioNumber = "";
        this.mySettings = new ViollierConnectorSettings((Mandant)ElexisEventDispatcher.getSelected(Mandant.class));
        this.httpsUrl = this.mySettings.getGlobalLoginUrl();
        try {
            cookie = new PortalCookieService().getCookie();
        }
        catch (IOException e) {
            log.error("Error getting cookie", (Throwable)e);
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleGetCookie, (String)(String.valueOf(Messages.Handler_errorMessageGetCookie) + e.getMessage()));
        }
        catch (ElexisException e) {
            log.error("No password/user defined", (Throwable)e);
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleGetCookie, (String)e.getMessage());
        }
        this.httpsUrl = String.valueOf(this.httpsUrl) + "&RCSession=" + cookie;
        try {
            this.httpsUrl = String.valueOf(this.httpsUrl) + "&appPath=" + URLEncoder.encode("/consultit/signon.aspx", "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            log.error("Enoding not supported", (Throwable)e1);
        }
        Patient patient = ElexisEventDispatcher.getSelectedPatient();
        if (patient == null) {
            log.warn("No patient selected - exit execution of DiagnoseQueryPatientHandler");
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleNoPatientSelected, (String)Messages.Handler_errorMessageNoPatientSelected);
            return null;
        }
        vioNumber = DiagnoseQueryPatientHandler.getVioNr(patient);
        Boolean preferedPresentation = false;
        preferedPresentation = this.mySettings.getMachineUseGlobalSettings() != false ? this.mySettings.getMachinePreferedPresentation() : this.mySettings.getGlobalPreferedPresentation();
        if (!vioNumber.isEmpty()) {
            try {
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("?sgs.cortex.nanr=" + vioNumber, "UTF-8");
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&sgs.cortex.cumulative=" + preferedPresentation.toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("Enoding not supported", (Throwable)e);
            }
        }
        try {
            Desktop.getDesktop().browse(new URI(this.httpsUrl));
        }
        catch (URISyntaxException e) {
            log.error("Could not resolve URI: " + this.httpsUrl, (Throwable)e);
        }
        catch (IOException e) {
            log.error("IO exception while trying to create order", (Throwable)e);
        }
        return null;
    }

    private static String getVioNr(Patient patient) {
        Query patientVioNrQuery = new Query(Xid.class);
        patientVioNrQuery.add("object", "=", patient.getId());
        patientVioNrQuery.add("domain", "=", DOMAIN_VIONR);
        List patienten = patientVioNrQuery.execute();
        if (patienten.isEmpty()) {
            return "";
        }
        return ((Xid)patienten.get(0)).getDomainId();
    }
}

