/*
 * Decompiled with CFR 0.152.
 */
package net.medshare.connector.viollier.handlers;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.data.Mandant;
import java.awt.Desktop;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import net.medshare.connector.viollier.Messages;
import net.medshare.connector.viollier.data.ViollierConnectorSettings;
import net.medshare.connector.viollier.ses.PortalCookieService;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnoseQueryDoctorHandler
extends AbstractHandler {
    private static Logger log = LoggerFactory.getLogger(DiagnoseQueryDoctorHandler.class);
    private ViollierConnectorSettings mySettings;
    private String httpsUrl;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String cookie = "";
        this.mySettings = new ViollierConnectorSettings((Mandant)ElexisEventDispatcher.getSelected(Mandant.class));
        this.httpsUrl = this.mySettings.getGlobalLoginUrl();
        try {
            cookie = new PortalCookieService().getCookie();
        }
        catch (IOException e) {
            log.error("Error getting cookie", (Throwable)e);
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleGetCookie, (String)(String.valueOf(Messages.Handler_errorMessageGetCookie) + e.getMessage()));
        }
        catch (ElexisException e) {
            log.error("No user/password defined", (Throwable)e);
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Exception_errorTitleNoUserPasswordDefined, (String)e.getMessage());
        }
        this.httpsUrl = String.valueOf(this.httpsUrl) + "&RCSession=" + cookie;
        try {
            this.httpsUrl = String.valueOf(this.httpsUrl) + "&appPath=" + URLEncoder.encode("/consultit/signon.aspx", "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            log.error("Enoding not supported", (Throwable)e1);
        }
        try {
            Desktop.getDesktop().browse(new URI(this.httpsUrl));
        }
        catch (URISyntaxException e) {
            log.error("Could not resolve URI: " + this.httpsUrl, (Throwable)e);
        }
        catch (IOException e) {
            log.error("IO exception getting diagnoses via doctor", (Throwable)e);
        }
        return null;
    }
}

