/*
 * Decompiled with CFR 0.152.
 */
package net.medshare.connector.viollier.handlers;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.data.Anschrift;
import ch.elexis.data.Fall;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Xid;
import java.awt.Desktop;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.List;
import net.medshare.connector.viollier.Messages;
import net.medshare.connector.viollier.data.ViollierConnectorSettings;
import net.medshare.connector.viollier.ses.PortalCookieService;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateOrderHandler
extends AbstractHandler {
    private static Logger log = LoggerFactory.getLogger(CreateOrderHandler.class);
    private static String DOMAIN_VIONR = "viollier.ch/vioNumber";
    private ViollierConnectorSettings mySettings;
    private String httpsUrl;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String cookie = "";
        String vioNumber = "";
        String vorname = "";
        String name = "";
        String geburtsdatum = "";
        String gender = "";
        String address = "";
        String plz = "";
        String ort = "";
        String land = "";
        String socialSecurityNumber = "";
        String insuranceCardNumber = "";
        boolean hasVioNumber = true;
        Patient patient = ElexisEventDispatcher.getSelectedPatient();
        if (patient == null) {
            log.warn("No patient selected - exit CreateOrderHandler execution");
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleNoPatientSelected, (String)Messages.Handler_errorMessageNoPatientSelected);
            return null;
        }
        vioNumber = CreateOrderHandler.getVioNr(patient);
        if (vioNumber.isEmpty()) {
            hasVioNumber = false;
            vorname = patient.getVorname();
            name = patient.getName();
            geburtsdatum = this.convertDate(patient.getGeburtsdatum());
            gender = this.parseGender(patient);
            Anschrift tempAdr = patient.getAnschrift();
            address = tempAdr.getStrasse();
            plz = tempAdr.getPlz();
            ort = tempAdr.getOrt();
            land = tempAdr.getLand();
            socialSecurityNumber = patient.getXid("www.ahv.ch/xid");
            Fall currentFall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
            if (currentFall != null && socialSecurityNumber.length() == 0) {
                socialSecurityNumber = currentFall.getRequiredString("AHV-Nummer");
            }
            if (currentFall != null) {
                insuranceCardNumber = currentFall.getRequiredString("Versicherten-Nummer");
            }
        }
        this.mySettings = new ViollierConnectorSettings((Mandant)ElexisEventDispatcher.getSelected(Mandant.class));
        this.httpsUrl = this.mySettings.getGlobalLoginUrl();
        try {
            cookie = new PortalCookieService().getCookie();
        }
        catch (IOException e) {
            log.error("Error getting cookie", (Throwable)e);
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleGetCookie, (String)(String.valueOf(Messages.Handler_errorMessageGetCookie) + e.getMessage()));
        }
        catch (ElexisException e) {
            log.error("No password/user defined", (Throwable)e);
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleGetCookie, (String)e.getMessage());
        }
        this.httpsUrl = String.valueOf(this.httpsUrl) + "&RCSession=" + cookie;
        try {
            this.httpsUrl = String.valueOf(this.httpsUrl) + "&appPath=" + URLEncoder.encode("/orderit/createOrderFromGP?", "UTF-8");
            if (hasVioNumber) {
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("vioNumber=" + vioNumber, "UTF-8");
            } else {
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("firstname=" + vorname, "UTF-8");
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&surname=" + name, "UTF-8");
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&dateOfBirth=" + geburtsdatum, "UTF-8");
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&gender=" + gender, "UTF-8");
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&address=" + address, "UTF-8");
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&zip=" + plz, "UTF-8");
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&city=" + ort, "UTF-8");
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&country=" + land, "UTF-8");
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&patientReference=" + patient.getPatCode(), "UTF-8");
                if (socialSecurityNumber.length() > 0) {
                    this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&socialSecurityNumber=" + socialSecurityNumber, "UTF-8");
                }
                if (insuranceCardNumber.length() > 0) {
                    this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&insuranceCardNumber=" + insuranceCardNumber, "UTF-8");
                }
            }
        }
        catch (UnsupportedEncodingException e1) {
            log.error("Enoding not supported", (Throwable)e1);
        }
        try {
            Desktop.getDesktop().browse(new URI(this.httpsUrl));
        }
        catch (URISyntaxException e) {
            log.error("Could not resolve URI: " + this.httpsUrl, (Throwable)e);
        }
        catch (IOException e) {
            log.error("IO exception while trying to create order", (Throwable)e);
        }
        return null;
    }

    private String parseGender(Patient patient) {
        String sexRaw = patient.getGeschlecht();
        if (sexRaw.length() > 0) {
            if (sexRaw.equalsIgnoreCase("m")) {
                return "M";
            }
            return "F";
        }
        return "X";
    }

    private String convertDate(String gebDat) {
        if (gebDat.isEmpty()) {
            return "";
        }
        String tempDay = gebDat.substring(0, 2);
        String tempMonth = gebDat.substring(3, 5);
        String tempYear = gebDat.substring(6);
        return String.valueOf(tempYear) + "-" + tempMonth + "-" + tempDay;
    }

    private static String getVioNr(Patient patient) {
        Query patientVioNrQuery = new Query(Xid.class);
        patientVioNrQuery.add("object", "=", patient.getId());
        patientVioNrQuery.add("domain", "=", DOMAIN_VIONR);
        List patienten = patientVioNrQuery.execute();
        if (patienten.isEmpty()) {
            return "";
        }
        return ((Xid)patienten.get(0)).getDomainId();
    }
}

