/*
 * Decompiled with CFR 0.152.
 */
package net.medshare.connector.aerztekasse.view;

import ch.elexis.core.data.activator.CoreHub;
import java.net.InetAddress;
import java.text.MessageFormat;
import net.medshare.connector.aerztekasse.Messages;
import net.medshare.connector.aerztekasse.data.AerztekasseSettings;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Preferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private AerztekasseSettings aerztekasseSettings;
    private GridData gridDataForLabels;
    private GridData gridDataForInputs;
    private Group gGlobalSettings;
    private Text tGlobalUsername;
    private Text tGlobalPassword;
    private Text tGlobalUrl;
    private Group gMandantSettings;
    private Button bMandantUseGlobalSettings;
    private Text tMandantUsername;
    private Text tMandantPassword;
    private Group gMachineSettings;
    private Button bMachineUseGlobalSettings;
    private Text tMachineUrl;
    private Boolean isInitializing = true;

    public Preferences() {
        super(1);
    }

    public boolean performOk() {
        this.aerztekasseSettings.setGlobalUsername(this.tGlobalUsername.getText());
        this.aerztekasseSettings.setGlobalPassword(this.tGlobalPassword.getText());
        this.aerztekasseSettings.setGlobalUrl(this.tGlobalUrl.getText());
        this.aerztekasseSettings.setMandantUsingGlobalSettings(this.bMandantUseGlobalSettings.getSelection());
        this.aerztekasseSettings.setMandantUsername(this.tMandantUsername.getText());
        this.aerztekasseSettings.setMandantPassword(this.tMandantPassword.getText());
        this.aerztekasseSettings.setMachineUsingGlobalSettings(this.bMachineUseGlobalSettings.getSelection());
        this.aerztekasseSettings.setMachineUrl(this.tMachineUrl.getText());
        this.aerztekasseSettings.saveSettings();
        return true;
    }

    public void init(IWorkbench workbench) {
        if (this.aerztekasseSettings == null) {
            this.aerztekasseSettings = new AerztekasseSettings(CoreHub.actMandant);
        }
    }

    protected void createFieldEditors() {
    }

    protected Control createContents(Composite parent) {
        String undefined = Messages.Preferences_undefiniert;
        Text dummy = new Text(parent, 0);
        dummy.setText(Messages.Preferences_UseGlobalSettings);
        dummy.pack();
        this.gridDataForLabels = new GridData(dummy.getSize().x, dummy.getLineHeight());
        this.gridDataForInputs = new GridData(768);
        this.aerztekasseSettings = new AerztekasseSettings(CoreHub.actMandant);
        dummy.dispose();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        Group grp = this.gGlobalSettings = new Group(comp, 0);
        grp.setText(Messages.Preferences_GlobalSettings);
        grp.setLayout((Layout)new GridLayout(2, false));
        grp.setLayoutData((Object)new GridData(768));
        Label lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_Username);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.tGlobalUsername = new Text((Composite)grp, 2052);
        this.tGlobalUsername.setLayoutData((Object)this.gridDataForInputs);
        this.tGlobalUsername.setText(undefined);
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_Password);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.tGlobalPassword = new Text((Composite)grp, 0x400804);
        this.tGlobalPassword.setLayoutData((Object)this.gridDataForInputs);
        this.tGlobalPassword.setText(undefined);
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_URL);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.tGlobalUrl = new Text((Composite)grp, 2052);
        this.tGlobalUrl.setLayoutData((Object)this.gridDataForInputs);
        this.tGlobalUrl.setText(undefined);
        grp = this.gMandantSettings = new Group(comp, 0);
        grp.setText(Messages.Preferences_MandantSettingsFor);
        grp.setLayout((Layout)new GridLayout(2, false));
        grp.setLayoutData((Object)new GridData(768));
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_UseGlobalSettings);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.bMandantUseGlobalSettings = new Button((Composite)grp, 32);
        this.bMandantUseGlobalSettings.setSelection(false);
        this.bMandantUseGlobalSettings.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (Preferences.this.isInitializing.booleanValue()) {
                    return;
                }
                Button c = (Button)e.widget;
                Boolean mandantUseGlobalSettings = c.getSelection();
                Preferences.this.aerztekasseSettings.setMandantUsingGlobalSettings(mandantUseGlobalSettings);
                Preferences.this.showMandantSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_Username);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.tMandantUsername = new Text((Composite)grp, 2052);
        this.tMandantUsername.setLayoutData((Object)this.gridDataForInputs);
        this.tMandantUsername.setText(undefined);
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_Password);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.tMandantPassword = new Text((Composite)grp, 0x400804);
        this.tMandantPassword.setLayoutData((Object)this.gridDataForInputs);
        this.tMandantPassword.setText(undefined);
        grp = this.gMachineSettings = new Group(comp, 0);
        grp.setText(Messages.Preferences_LocalSettingsFor);
        grp.setLayout((Layout)new GridLayout(2, false));
        grp.setLayoutData((Object)new GridData(768));
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_UseGlobalSettings);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.bMachineUseGlobalSettings = new Button((Composite)grp, 32);
        this.bMachineUseGlobalSettings.setSelection(false);
        this.bMachineUseGlobalSettings.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (Preferences.this.isInitializing.booleanValue()) {
                    return;
                }
                Button c = (Button)e.widget;
                Boolean machineUseGlobalSettings = c.getSelection();
                Preferences.this.aerztekasseSettings.setMachineUsingGlobalSettings(machineUseGlobalSettings);
                Preferences.this.showMachineSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_URL);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.tMachineUrl = new Text((Composite)grp, 2052);
        this.tMachineUrl.setLayoutData((Object)this.gridDataForInputs);
        this.tMachineUrl.setText(undefined);
        this.showSettings();
        this.isInitializing = false;
        return comp;
    }

    private void showSettings() {
        this.tGlobalUsername.setText(this.aerztekasseSettings.getGlobalUsername());
        this.tGlobalPassword.setText(this.aerztekasseSettings.getGlobalPassword());
        this.tGlobalUrl.setText(this.aerztekasseSettings.getGlobalUrl());
        this.showMandantSettings();
        this.showMachineSettings();
    }

    private void showMandantSettings() {
        Boolean mandantUseGlobalSettings = this.aerztekasseSettings.isMandantUsingGlobalSettings();
        String mandantname = "";
        try {
            mandantname = this.aerztekasseSettings.getMandant().getLabel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gMandantSettings.setText(MessageFormat.format(Messages.Preferences_MandantSettingsFor, mandantname));
        this.bMandantUseGlobalSettings.setSelection(mandantUseGlobalSettings.booleanValue());
        this.tMandantUsername.setEditable(mandantUseGlobalSettings == false);
        this.tMandantPassword.setEditable(mandantUseGlobalSettings == false);
        this.tMandantUsername.setText(this.aerztekasseSettings.getMandantUsername());
        this.tMandantPassword.setText(this.aerztekasseSettings.getMandantPasword());
    }

    private void showMachineSettings() {
        Boolean machineUseGlobalSettings = this.aerztekasseSettings.isMachineUsingGlobalSettings();
        String hostname = "localhost";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gMachineSettings.setText(MessageFormat.format(Messages.Preferences_LocalSettingsFor, hostname));
        this.bMachineUseGlobalSettings.setSelection(machineUseGlobalSettings.booleanValue());
        this.tMachineUrl.setEditable(machineUseGlobalSettings == false);
        this.tMachineUrl.setText(this.aerztekasseSettings.getMachineUrl());
    }
}

