/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.messwerte.v2.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import com.hilotec.elexis.messwerte.v2.data.ExportData;
import com.hilotec.elexis.messwerte.v2.data.Messung;
import com.hilotec.elexis.messwerte.v2.data.MessungKonfiguration;
import com.hilotec.elexis.messwerte.v2.data.MessungTyp;
import com.hilotec.elexis.messwerte.v2.data.Messwert;
import com.hilotec.elexis.messwerte.v2.data.typen.IMesswertTyp;
import com.hilotec.elexis.messwerte.v2.views.ExportDialog;
import com.hilotec.elexis.messwerte.v2.views.Messages;
import com.hilotec.elexis.messwerte.v2.views.MessungBearbeiten;
import com.hilotec.elexis.messwerte.v2.views.MessungenComparator;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class MessungenUebersichtV21
extends ViewPart
implements ElexisEventListener {
    private static int DEFAULT_COL_WIDTH = 80;
    private static String DATA_PATIENT = "patient";
    private static String DATA_TYP = "typ";
    private static String DATA_VIEWER = "viewer";
    private MessungKonfiguration config;
    private ScrolledForm form;
    private CTabFolder tabfolder;
    private final ArrayList<TableViewer> tableViewers;
    private Action neuAktion;
    private Action editAktion;
    private Action copyAktion;
    private Action loeschenAktion;
    private Action exportAktion;
    private Action reloadXMLAction;
    private final ElexisEvent eetmpl = new ElexisEvent(null, Patient.class, 48);

    public MessungenUebersichtV21() {
        this.config = MessungKonfiguration.getInstance();
        this.tableViewers = new ArrayList();
    }

    private void setCurPatient(Patient patient) {
        if (patient == null) {
            this.form.setText(Messages.MessungenUebersicht_kein_Patient);
        } else {
            this.form.setText(patient.getLabel());
        }
        CTabItem tab = this.tabfolder.getSelection();
        if (tab == null) {
            this.refreshContent(patient, null);
        } else {
            Control c = tab.getControl();
            MessungTyp t = (MessungTyp)c.getData(DATA_TYP);
            this.refreshContent(patient, t);
        }
    }

    public void catchElexisEvent(final ElexisEvent ev) {
        UiDesk.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ev.getType() == 16) {
                    MessungenUebersichtV21.this.setCurPatient((Patient)ev.getObject());
                } else if (ev.getType() == 32) {
                    MessungenUebersichtV21.this.setCurPatient(null);
                }
            }
        });
    }

    public ElexisEvent getElexisEventFilter() {
        return this.eetmpl;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.intializeView(parent);
        if (this.form.getCursor() == null) {
            this.form.setCursor(new Cursor((Device)this.form.getShell().getDisplay(), 1));
        }
        this.config = MessungKonfiguration.getInstance();
        this.erstelleAktionen();
        this.erstelleMenu(this.getViewSite());
        this.initializeContent();
        if (this.form.getCursor() != null) {
            this.form.setCursor(null);
        }
    }

    public void setFocus() {
        CTabItem tab = this.tabfolder.getSelection();
        if (tab == null) {
            return;
        }
        Control c = tab.getControl();
        TableViewer tv = (TableViewer)c.getData(DATA_VIEWER);
        if (tv != null && tv.getInput() == null) {
            Patient p = (Patient)this.tabfolder.getData(DATA_PATIENT);
            if (p == null) {
                p = ElexisEventDispatcher.getSelectedPatient();
            }
            MessungTyp t = (MessungTyp)c.getData(DATA_TYP);
            this.refreshContent(p, t);
        }
    }

    private void intializeView(Composite parent) {
        this.form = UiDesk.getToolkit().createScrolledForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.form.setText(Messages.MessungenUebersicht_kein_Patient);
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        this.tabfolder = new CTabFolder(body, 0);
        this.tabfolder.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tabfolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CTabFolder tf = (CTabFolder)e.widget;
                Patient p = (Patient)tf.getData(DATA_PATIENT);
                if (p == null) {
                    return;
                }
                CTabItem tab = tf.getSelection();
                Control c = tab.getControl();
                MessungTyp t = (MessungTyp)c.getData(DATA_TYP);
                MessungenUebersichtV21.this.refreshContent(p, t);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this});
    }

    private void initializeContent() {
        this.tableViewers.clear();
        this.config.readFromXML();
        for (MessungTyp t : this.config.getTypes()) {
            TableViewer tv = this.createTableViewer((Composite)this.tabfolder, t);
            Control c = tv.getControl();
            c.setData(DATA_TYP, (Object)t);
            c.setData(DATA_VIEWER, (Object)tv);
            this.tableViewers.add(tv);
            CTabItem ti = new CTabItem(this.tabfolder, 0);
            ti.setText(t.getTitle());
            ti.setControl(c);
            tv.setInput(null);
            tv.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    MessungenUebersichtV21.this.editAktion.run();
                }
            });
            ViewMenus menu = new ViewMenus(this.getViewSite());
            menu.createControlContextMenu(tv.getControl(), new IAction[]{this.editAktion, this.copyAktion, this.loeschenAktion, this.neuAktion, this.exportAktion});
        }
        this.tabfolder.setSelection(0);
    }

    private void refreshContent(Patient patient, MessungTyp requestedTyp) {
        if (patient != null) {
            if (this.form.getCursor() == null) {
                this.form.setCursor(new Cursor((Device)this.form.getShell().getDisplay(), 1));
            }
            this.form.setText(patient.getLabel());
            this.tabfolder.setData(DATA_PATIENT, (Object)patient);
            MessungTyp typToRefresh = requestedTyp;
            TableViewer viewerToRefresh = null;
            for (TableViewer tv : this.tableViewers) {
                Control c = tv.getControl();
                if (c.isDisposed()) continue;
                MessungTyp typ = (MessungTyp)c.getData(DATA_TYP);
                if (typToRefresh == null) {
                    typToRefresh = typ;
                    viewerToRefresh = tv;
                    break;
                }
                if (!requestedTyp.getName().equals(typ.getName())) continue;
                typToRefresh = typ;
                viewerToRefresh = tv;
                break;
            }
            if (viewerToRefresh != null) {
                viewerToRefresh.setInput(Messung.getPatientMessungen(patient, typToRefresh));
            }
            if (this.form.getCursor() != null) {
                this.form.setCursor(null);
            }
        }
    }

    private TableViewer createTableViewer(Composite parent, MessungTyp t) {
        TableViewer viewer = new TableViewer(parent, 68354);
        this.createColumns(parent, viewer, t);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        viewer.getControl().setLayoutData((Object)gridData);
        viewer.setComparator((ViewerComparator)new MessungenComparator());
        return viewer;
    }

    private void createColumns(Composite parent, TableViewer viewer, MessungTyp t) {
        TableViewerColumn col = this.createTableViewerColumn(viewer, Messages.MessungenUebersicht_Table_Datum, DEFAULT_COL_WIDTH, 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Messung m = (Messung)((Object)element);
                return m.getDatum();
            }
        });
        int i = 0;
        for (IMesswertTyp dft : t.getMesswertTypen()) {
            String colTitle = dft.getTitle();
            if (!dft.getUnit().equals("")) {
                colTitle = String.valueOf(colTitle) + " [" + dft.getUnit() + "]";
            }
            col = this.createTableViewerColumn(viewer, colTitle, DEFAULT_COL_WIDTH, 0);
            col.setLabelProvider((CellLabelProvider)new CustomColumnLabelProvider(i, dft.getName()));
            ++i;
        }
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)this.getSelectionAdapter(viewer, column, colNumber));
        return viewerColumn;
    }

    private SelectionAdapter getSelectionAdapter(final TableViewer viewer, TableColumn column, int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessungenComparator comparator = (MessungenComparator)viewer.getComparator();
                comparator.setColumn(0);
                int dir = comparator.getDirection();
                viewer.getTable().setSortDirection(dir);
                viewer.getTable().setSortColumn(viewer.getTable().getColumn(0));
                viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    private void erstelleAktionen() {
        this.neuAktion = new Action(Messages.MessungenUebersicht_action_neu){
            {
                this.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
                this.setToolTipText(Messages.MessungenUebersicht_action_neu_ToolTip);
            }

            public void run() {
                Patient p = (Patient)MessungenUebersichtV21.this.tabfolder.getData(DATA_PATIENT);
                if (p == null) {
                    return;
                }
                CTabItem tab = MessungenUebersichtV21.this.tabfolder.getSelection();
                Control c = tab.getControl();
                MessungTyp t = (MessungTyp)c.getData(DATA_TYP);
                Messung messung = new Messung(p, t);
                MessungBearbeiten dialog = new MessungBearbeiten(MessungenUebersichtV21.this.getSite().getShell(), messung);
                if (dialog.open() != 0) {
                    messung.delete();
                }
                MessungenUebersichtV21.this.refreshContent(p, t);
            }
        };
        this.editAktion = new Action(Messages.MessungenUebersicht_action_edit){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.MessungenUebersicht_action_edit_ToolTip);
            }

            public void run() {
                Patient p = (Patient)MessungenUebersichtV21.this.tabfolder.getData(DATA_PATIENT);
                if (p == null) {
                    return;
                }
                CTabItem tab = MessungenUebersichtV21.this.tabfolder.getSelection();
                Control c = tab.getControl();
                MessungTyp t = (MessungTyp)c.getData(DATA_TYP);
                TableItem[] tableitems = ((Table)c).getSelection();
                if (tableitems.length == 1) {
                    Messung messung = (Messung)((Object)tableitems[0].getData());
                    MessungBearbeiten dialog = new MessungBearbeiten(MessungenUebersichtV21.this.getSite().getShell(), messung);
                    if (dialog.open() == 0) {
                        MessungenUebersichtV21.this.refreshContent(p, t);
                    }
                }
            }
        };
        this.copyAktion = new Action(Messages.MessungenUebersicht_action_copy){
            {
                this.setImageDescriptor(Images.IMG_CLIPBOARD.getImageDescriptor());
                this.setToolTipText(Messages.MessungenUebersicht_action_copy_ToolTip);
            }

            public void run() {
                Patient p = (Patient)MessungenUebersichtV21.this.tabfolder.getData(DATA_PATIENT);
                if (p == null) {
                    return;
                }
                CTabItem tab = MessungenUebersichtV21.this.tabfolder.getSelection();
                Control c = tab.getControl();
                MessungTyp t = (MessungTyp)c.getData(DATA_TYP);
                TableItem[] tableitems = ((Table)c).getSelection();
                if (tableitems.length == 1) {
                    TimeTool date;
                    String newdatum;
                    Messung messung = (Messung)((Object)tableitems[0].getData());
                    String messungsdatum = messung.getDatum();
                    if (!messungsdatum.equalsIgnoreCase(newdatum = (date = new TimeTool()).toString(4))) {
                        System.out.println(messung.getDatum());
                        System.out.println(date.toString(4));
                        Messung messungnew = new Messung(messung.getPatient(), messung.getTyp());
                        messungnew.setDatum(date.toString(4));
                        for (Messwert messwert : messung.getMesswerte()) {
                            Messwert copytemp = messungnew.getMesswert(messwert.getName());
                            copytemp.setWert(messwert.getWert());
                        }
                        messungnew.set("deleted", "0");
                        MessungenUebersichtV21.this.refreshContent(p, t);
                    } else {
                        SWTHelper.showError((String)Messages.MessungenUebersicht_action_copy_error, (String)Messages.MessungenUebersicht_action_copy_errorMessage);
                    }
                }
            }
        };
        this.loeschenAktion = new Action(Messages.MessungenUebersicht_action_loeschen){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.MessungenUebersicht_action_loeschen_ToolTip);
            }

            public void run() {
                Patient p = (Patient)MessungenUebersichtV21.this.tabfolder.getData(DATA_PATIENT);
                if (p == null) {
                    return;
                }
                CTabItem tab = MessungenUebersichtV21.this.tabfolder.getSelection();
                Control c = tab.getControl();
                MessungTyp t = (MessungTyp)c.getData(DATA_TYP);
                TableItem[] tableitems = ((Table)c).getSelection();
                if (tableitems.length > 0 && SWTHelper.askYesNo((String)Messages.MessungenUebersicht_action_loeschen_delete_0, (String)Messages.MessungenUebersicht_action_loeschen_delete_1)) {
                    TableItem[] tableItemArray = tableitems;
                    int n = tableitems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem ti = tableItemArray[n2];
                        Messung messung = (Messung)((Object)ti.getData());
                        messung.delete();
                        ++n2;
                    }
                    MessungenUebersichtV21.this.refreshContent(p, t);
                }
            }
        };
        this.exportAktion = new Action(Messages.MessungenUebersicht_action_export){
            {
                this.setImageDescriptor(Images.IMG_EXPORT.getImageDescriptor());
                this.setToolTipText(Messages.MessungenUebersicht_action_export_ToolTip);
            }

            public void run() {
                block8: {
                    ExportDialog expDialog;
                    Patient p = (Patient)MessungenUebersichtV21.this.tabfolder.getData(DATA_PATIENT);
                    CTabItem tab = MessungenUebersichtV21.this.tabfolder.getSelection();
                    Control c = tab.getControl();
                    MessungTyp t = (MessungTyp)c.getData(DATA_TYP);
                    ExportData expData = new ExportData();
                    if (p != null) {
                        expData.setPatientNumberFrom(Integer.parseInt(p.getPatCode()));
                        expData.setPatientNumberTo(Integer.parseInt(p.getPatCode()));
                    }
                    if ((expDialog = new ExportDialog(MessungenUebersichtV21.this.form.getShell(), expData)).open() == 0) {
                        String label = t.getTitle();
                        String date = new TimeTool().toString(9);
                        String filename = String.valueOf(label) + "-export-" + date + ".csv";
                        FileDialog fd = new FileDialog(MessungenUebersichtV21.this.getSite().getShell(), 8192);
                        String[] extensions = new String[]{"*.csv"};
                        fd.setOverwrite(true);
                        fd.setFilterExtensions(extensions);
                        fd.setFileName(filename);
                        fd.setFilterPath(System.getProperty("user.home"));
                        String filepath = fd.open();
                        if (filepath != null) {
                            try {
                                Exporter exporter = new Exporter(expData, t, filepath);
                                new ProgressMonitorDialog(MessungenUebersichtV21.this.form.getShell()).run(true, true, (IRunnableWithProgress)exporter);
                                if (!exporter.wasAborted().booleanValue()) {
                                    SWTHelper.showInfo((String)MessageFormat.format(Messages.MessungenUebersicht_action_export_title, label), (String)MessageFormat.format(Messages.MessungenUebersicht_action_export_success, label, filepath));
                                    break block8;
                                }
                                SWTHelper.showError((String)MessageFormat.format(Messages.MessungenUebersicht_action_export_title, label), (String)MessageFormat.format(Messages.MessungenUebersicht_action_export_aborted, label, filepath));
                            }
                            catch (InvocationTargetException e) {
                                SWTHelper.showError((String)Messages.MessungenUebersichtV21_Error, (String)e.getMessage());
                            }
                            catch (InterruptedException e) {
                                SWTHelper.showInfo((String)Messages.MessungenUebersichtV21_Cancelled, (String)e.getMessage());
                            }
                        } else {
                            SWTHelper.showInfo((String)Messages.MessungenUebersichtV21_Information, (String)Messages.MessungenUebersicht_action_export_filepath_error);
                        }
                    }
                }
            }
        };
        this.reloadXMLAction = new Action(Messages.MessungenUebersicht_action_reload){
            {
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
                this.setToolTipText(Messages.MessungenUebersicht_action_reload_ToolTip);
            }

            public void run() {
                Patient p = (Patient)MessungenUebersichtV21.this.tabfolder.getData(DATA_PATIENT);
                if (p == null) {
                    return;
                }
                CTabItem[] cTabItemArray = MessungenUebersichtV21.this.tabfolder.getItems();
                int n = cTabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem ci = cTabItemArray[n2];
                    ci.getControl().dispose();
                    ci.dispose();
                    ++n2;
                }
                cTabItemArray = MessungenUebersichtV21.this.tabfolder.getChildren();
                n = cTabItemArray.length;
                n2 = 0;
                while (n2 < n) {
                    CTabItem ctrl = cTabItemArray[n2];
                    ctrl.dispose();
                    ++n2;
                }
                if (MessungenUebersichtV21.this.form.getCursor() == null) {
                    MessungenUebersichtV21.this.form.setCursor(new Cursor((Device)MessungenUebersichtV21.this.form.getShell().getDisplay(), 1));
                }
                MessungenUebersichtV21.this.initializeContent();
                MessungenUebersichtV21.this.refreshContent(p, null);
                if (MessungenUebersichtV21.this.form.getCursor() != null) {
                    MessungenUebersichtV21.this.form.setCursor(null);
                }
            }
        };
    }

    private ViewMenus erstelleMenu(IViewSite site) {
        ViewMenus menu = new ViewMenus(site);
        menu.createToolbar(new IAction[]{this.neuAktion, this.editAktion, this.copyAktion, this.loeschenAktion, this.exportAktion});
        menu.createMenu(new IAction[]{this.reloadXMLAction});
        return menu;
    }

    private class CustomColumnLabelProvider
    extends ColumnLabelProvider {
        private final String messwertName;

        public CustomColumnLabelProvider(int columnIndex, String name) {
            this.messwertName = name;
        }

        public String getText(Object element) {
            Messung m = (Messung)((Object)element);
            return m.getMesswert(this.messwertName).getDarstellungswert();
        }
    }

    class Exporter
    implements IRunnableWithProgress {
        private final ExportData expData;
        private final MessungTyp typ;
        private final String filepath;
        private Boolean aborted = false;

        public Exporter(ExportData xpd, MessungTyp t, String fp) {
            this.expData = xpd;
            this.typ = t;
            this.filepath = fp;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.MessungenUebersichtV21_Initializing, -1);
            try {
                FileOutputStream fout = new FileOutputStream(this.filepath);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fout, "ISO-8859-1");
                ArrayList<IMesswertTyp> messwertTypen = this.typ.getMesswertTypen();
                String headerstring = "PatientenNr;Name;Vorname;Geburtsdatum;Geschlecht;datum;";
                for (IMesswertTyp messwertTyp : messwertTypen) {
                    headerstring = String.valueOf(headerstring) + messwertTyp.getName();
                    String unit = messwertTyp.getUnit();
                    if (!"".equals(unit)) {
                        headerstring = String.valueOf(headerstring) + "(" + messwertTyp.getUnit() + ")";
                    }
                    headerstring = String.valueOf(headerstring) + ";";
                }
                headerstring = headerstring.substring(0, headerstring.length() - 1);
                writer.append(String.valueOf(headerstring) + "\n");
                List<Messung> messungen = Messung.getMessungenForExport(this.typ, this.expData.getDateFrom(), this.expData.getDateTo());
                monitor.beginTask(Messages.MessungenUebersicht_action_export_progress, messungen.size());
                for (Messung m : messungen) {
                    Patient p = Patient.load((String)m.getPatient().getId());
                    int curPatNr = -1;
                    try {
                        curPatNr = Integer.parseInt(p.getPatCode());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (curPatNr >= this.expData.getPatientNumberFrom() && curPatNr <= this.expData.getPatientNumberTo()) {
                        monitor.subTask(String.valueOf(p.getLabel()) + " - " + m.getDatum());
                        String messungstring = String.valueOf(m.getPatient().getPatCode()) + ";";
                        messungstring = String.valueOf(messungstring) + m.getPatient().getName() + ";";
                        messungstring = String.valueOf(messungstring) + m.getPatient().getVorname() + ";";
                        messungstring = String.valueOf(messungstring) + m.getPatient().getGeburtsdatum() + ";";
                        messungstring = String.valueOf(messungstring) + m.getPatient().getGeschlecht() + ";";
                        messungstring = String.valueOf(messungstring) + m.getDatum() + ";";
                        for (Messwert messwert : m.getMesswerte()) {
                            messungstring = String.valueOf(messungstring) + messwert.getWert() + ";";
                        }
                        messungstring = messungstring.substring(0, messungstring.length() - 1);
                        writer.append(String.valueOf(messungstring) + "\n");
                    }
                    monitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    this.aborted = true;
                    break;
                }
                writer.flush();
                writer.close();
                fout.flush();
                fout.close();
            }
            catch (Exception e) {
                SWTHelper.showError((String)Messages.MessungenUebersicht_action_export_error, (String)e.toString());
            }
            monitor.done();
        }

        private Boolean wasAborted() {
            return this.aborted;
        }
    }
}

