/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.messwerte.v2.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import com.hilotec.elexis.messwerte.v2.data.Messung;
import com.hilotec.elexis.messwerte.v2.data.MessungKonfiguration;
import com.hilotec.elexis.messwerte.v2.data.MessungTyp;
import com.hilotec.elexis.messwerte.v2.data.Messwert;
import com.hilotec.elexis.messwerte.v2.data.typen.IMesswertTyp;
import com.hilotec.elexis.messwerte.v2.views.Messages;
import com.hilotec.elexis.messwerte.v2.views.MessungBearbeiten;
import java.io.File;
import java.io.FileWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class MessungenUebersichtV20
extends ViewPart
implements ElexisEventListener {
    private final MessungKonfiguration config;
    private ScrolledForm form;
    private final ArrayList<MessungstypSeite> seiten;
    private CTabFolder tabsfolder;
    private Action neuAktion;
    private Action editAktion;
    private Action copyAktion;
    private Action loeschenAktion;
    private Action exportAktion;
    private Action reloadXMLAction;
    private final ElexisEvent eetmpl = new ElexisEvent(null, Patient.class, 48);

    public MessungenUebersichtV20() {
        this.config = MessungKonfiguration.getInstance();
        this.config.readFromXML(null);
        this.seiten = new ArrayList();
    }

    private void erstelleAktionen() {
        this.neuAktion = new Action(Messages.MessungenUebersicht_action_neu){
            {
                this.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
                this.setToolTipText(Messages.MessungenUebersicht_action_neu_ToolTip);
            }

            public void run() {
                Patient p = ElexisEventDispatcher.getSelectedPatient();
                if (p == null) {
                    return;
                }
                CTabItem tab = MessungenUebersichtV20.this.tabsfolder.getSelection();
                MessungstypSeite mts = (MessungstypSeite)tab.getControl();
                Messung messung = new Messung(p, mts.getTyp());
                MessungBearbeiten dialog = new MessungBearbeiten(MessungenUebersichtV20.this.getSite().getShell(), messung);
                if (dialog.open() != 0) {
                    messung.delete();
                }
                MessungenUebersichtV20.this.aktualisieren();
            }
        };
        this.editAktion = new Action(Messages.MessungenUebersicht_action_edit){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.MessungenUebersicht_action_edit_ToolTip);
            }

            public void run() {
                CTabItem ci = MessungenUebersichtV20.this.tabsfolder.getSelection();
                if (ci == null) {
                    return;
                }
                MessungstypSeite seite = (MessungstypSeite)ci.getControl();
                TableItem[] tableitems = seite.table.getSelection();
                if (tableitems.length == 1) {
                    Messung messung = (Messung)((Object)tableitems[0].getData());
                    MessungBearbeiten dialog = new MessungBearbeiten(MessungenUebersichtV20.this.getSite().getShell(), messung);
                    dialog.open();
                    MessungenUebersichtV20.this.aktualisieren();
                }
            }
        };
        this.copyAktion = new Action(Messages.MessungenUebersicht_action_copy){
            {
                this.setImageDescriptor(Images.IMG_CLIPBOARD.getImageDescriptor());
                this.setToolTipText(Messages.MessungenUebersicht_action_copy_ToolTip);
            }

            public void run() {
                CTabItem ci = MessungenUebersichtV20.this.tabsfolder.getSelection();
                if (ci == null) {
                    return;
                }
                MessungstypSeite seite = (MessungstypSeite)ci.getControl();
                TableItem[] tableitems = seite.table.getSelection();
                if (tableitems.length == 1) {
                    TimeTool date;
                    String newdatum;
                    Messung messung = (Messung)((Object)tableitems[0].getData());
                    String messungsdatum = messung.getDatum();
                    if (!messungsdatum.equalsIgnoreCase(newdatum = (date = new TimeTool()).toString(4))) {
                        System.out.println(messung.getDatum());
                        System.out.println(date.toString(4));
                        Messung messungnew = new Messung(messung.getPatient(), messung.getTyp());
                        messungnew.setDatum(date.toString(4));
                        for (Messwert messwert : messung.getMesswerte()) {
                            Messwert copytemp = messungnew.getMesswert(messwert.getName());
                            copytemp.setWert(messwert.getWert());
                        }
                        MessungenUebersichtV20.this.aktualisieren();
                    } else {
                        SWTHelper.showError((String)Messages.MessungenUebersicht_action_copy_error, (String)Messages.MessungenUebersicht_action_copy_errorMessage);
                    }
                }
            }
        };
        this.exportAktion = new Action(Messages.MessungenUebersicht_action_export){
            {
                this.setImageDescriptor(Images.IMG_EXPORT.getImageDescriptor());
                this.setToolTipText(Messages.MessungenUebersicht_action_export_ToolTip);
            }

            public void run() {
                CTabItem ci = MessungenUebersichtV20.this.tabsfolder.getSelection();
                if (ci == null) {
                    return;
                }
                MessungstypSeite seite = (MessungstypSeite)ci.getControl();
                TableItem[] tableitems = seite.table.getItems();
                try {
                    String date = new TimeTool().toString(9);
                    String filename = String.valueOf(ci.getText()) + "-export-" + date + ".csv";
                    String fqfilename = String.valueOf(System.getProperty("user.home")) + File.separatorChar + filename;
                    FileWriter writer = new FileWriter(fqfilename);
                    Messung headermessung = (Messung)((Object)tableitems[0].getData());
                    String headerstring = "datum;";
                    for (Messwert messwert : headermessung.getMesswerte()) {
                        headerstring = String.valueOf(headerstring) + messwert.getTyp().getName() + "(" + messwert.getTyp().getUnit() + ")" + ";";
                    }
                    headerstring = headerstring.substring(0, headerstring.length() - 1);
                    writer.append(String.valueOf(headerstring) + "\n");
                    int i = 0;
                    while (i < tableitems.length) {
                        Messung messung = (Messung)((Object)tableitems[i].getData());
                        String messungstring = String.valueOf(messung.getDatum()) + ";";
                        for (Messwert messwert : messung.getMesswerte()) {
                            messungstring = String.valueOf(messungstring) + messwert.getTyp().erstelleDarstellungswert(messwert) + ";";
                        }
                        messungstring = messungstring.substring(0, messungstring.length() - 1);
                        writer.append(String.valueOf(messungstring) + "\n");
                        ++i;
                    }
                    writer.flush();
                    writer.close();
                    SWTHelper.showInfo((String)MessageFormat.format(Messages.MessungenUebersicht_action_export_title, ci.getText()), (String)MessageFormat.format(Messages.MessungenUebersicht_action_export_success, fqfilename));
                }
                catch (Exception e) {
                    SWTHelper.showError((String)Messages.MessungenUebersicht_action_export_error, (String)e.toString());
                }
            }
        };
        this.loeschenAktion = new Action(Messages.MessungenUebersicht_action_loeschen){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.MessungenUebersicht_action_loeschen_ToolTip);
            }

            public void run() {
                CTabItem ci = MessungenUebersichtV20.this.tabsfolder.getSelection();
                if (ci == null) {
                    return;
                }
                MessungstypSeite seite = (MessungstypSeite)ci.getControl();
                TableItem[] tableitems = seite.table.getSelection();
                if (tableitems.length > 0 && SWTHelper.askYesNo((String)Messages.MessungenUebersicht_action_loeschen_delete_0, (String)Messages.MessungenUebersicht_action_loeschen_delete_1)) {
                    TableItem[] tableItemArray = tableitems;
                    int n = tableitems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem ti = tableItemArray[n2];
                        Messung messung = (Messung)((Object)ti.getData());
                        messung.delete();
                        ++n2;
                    }
                    MessungenUebersichtV20.this.aktualisieren();
                }
            }
        };
        this.reloadXMLAction = new Action(Messages.MessungenUebersicht_action_reload){
            {
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
                this.setToolTipText(Messages.MessungenUebersicht_action_reload_ToolTip);
            }

            public void run() {
                CTabItem[] cTabItemArray = MessungenUebersichtV20.this.tabsfolder.getItems();
                int n = cTabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem ci = cTabItemArray[n2];
                    ci.getControl().dispose();
                    ci.dispose();
                    ++n2;
                }
                cTabItemArray = MessungenUebersichtV20.this.tabsfolder.getChildren();
                n = cTabItemArray.length;
                n2 = 0;
                while (n2 < n) {
                    CTabItem c = cTabItemArray[n2];
                    c.dispose();
                    ++n2;
                }
                MessungenUebersichtV20.this.config.readFromXML(null);
                MessungenUebersichtV20.this.erstelleSeiten();
                MessungenUebersichtV20.this.aktualisieren();
            }
        };
    }

    private ViewMenus erstelleMenu(IViewSite site) {
        ViewMenus menu = new ViewMenus(site);
        this.erstelleAktionen();
        menu.createToolbar(new IAction[]{this.neuAktion, this.editAktion, this.copyAktion, this.loeschenAktion, this.exportAktion});
        menu.createMenu(new IAction[]{this.reloadXMLAction});
        return menu;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.form = UiDesk.getToolkit().createScrolledForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite body = this.form.getBody();
        body.setLayout((Layout)new FillLayout());
        this.tabsfolder = new CTabFolder(body, 0);
        this.tabsfolder.setLayout((Layout)new FillLayout());
        this.erstelleMenu(this.getViewSite());
        this.erstelleSeiten();
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this});
    }

    void erstelleSeiten() {
        for (MessungTyp t : this.config.getTypes()) {
            CTabItem cti = new CTabItem(this.tabsfolder, 0);
            cti.setText(t.getTitle());
            MessungstypSeite mts = new MessungstypSeite((Composite)this.tabsfolder, t);
            this.seiten.add(mts);
            cti.setControl((Control)mts);
        }
        this.tabsfolder.setSelection(0);
        this.setCurPatient(ElexisEventDispatcher.getSelectedPatient());
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this});
    }

    public void setFocus() {
    }

    private void setCurPatient(Patient patient) {
        if (patient == null) {
            this.form.setText(Messages.MessungenUebersicht_kein_Patient);
        } else {
            this.form.setText(patient.getLabel());
        }
        for (MessungstypSeite mts : this.seiten) {
            mts.setCurPatient(patient);
        }
    }

    private void aktualisieren() {
        for (MessungstypSeite mts : this.seiten) {
            mts.aktualisieren();
        }
    }

    public void catchElexisEvent(final ElexisEvent ev) {
        UiDesk.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ev.getType() == 16) {
                    MessungenUebersichtV20.this.setCurPatient((Patient)ev.getObject());
                } else if (ev.getType() == 32) {
                    MessungenUebersichtV20.this.setCurPatient(null);
                }
            }
        });
    }

    public ElexisEvent getElexisEventFilter() {
        return this.eetmpl;
    }

    class MessungstypSeite
    extends Composite {
        private final MessungTyp typ;
        private final Table table;
        private final TableColumn[] cols;
        private Patient patient;

        public MessungstypSeite(Composite parent, MessungTyp dt) {
            super(parent, 0);
            this.typ = dt;
            parent.setLayout((Layout)new FillLayout());
            this.setLayout((Layout)new GridLayout());
            this.table = new Table((Composite)this, 66048);
            this.table.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            this.cols = new TableColumn[this.typ.getMesswertTypen().size() + 1];
            int i = 0;
            this.cols[i] = new TableColumn(this.table, 0);
            this.cols[i].setText(Messages.MessungenUebersicht_Table_Datum);
            this.cols[i].setWidth(80);
            ++i;
            for (IMesswertTyp dft : this.typ.getMesswertTypen()) {
                this.cols[i] = new TableColumn(this.table, 0);
                if (dft.getUnit().equals("")) {
                    this.cols[i].setText(dft.getTitle());
                } else {
                    this.cols[i].setText(String.valueOf(dft.getTitle()) + " [" + dft.getUnit() + "]");
                }
                this.cols[i].setWidth(80);
                ++i;
            }
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    MessungenUebersichtV20.this.editAktion.run();
                }
            });
            ViewMenus menu = new ViewMenus(MessungenUebersichtV20.this.getViewSite());
            menu.createControlContextMenu((Control)this.table, new IAction[]{MessungenUebersichtV20.this.editAktion, MessungenUebersichtV20.this.copyAktion, MessungenUebersichtV20.this.loeschenAktion, MessungenUebersichtV20.this.neuAktion, MessungenUebersichtV20.this.exportAktion});
        }

        public void aktualisieren() {
            if (!this.table.isDisposed()) {
                this.table.removeAll();
                if (this.patient == null) {
                    return;
                }
                for (Messung messung : Messung.getPatientMessungen(this.patient, this.typ)) {
                    TableItem ti = new TableItem(this.table, 0);
                    ti.setData((Object)messung);
                    int i = 0;
                    ti.setText(i++, messung.getDatum());
                    for (Messwert mwrt : messung.getMesswerte()) {
                        ti.setText(i++, mwrt.getDarstellungswert());
                    }
                }
            }
        }

        public void setCurPatient(Patient p) {
            this.patient = p;
            this.aktualisieren();
        }

        public MessungTyp getTyp() {
            return this.typ;
        }
    }
}

