/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.messwerte.v2.views;

import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import com.hilotec.elexis.messwerte.v2.data.ExportData;
import com.hilotec.elexis.messwerte.v2.views.Messages;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportDialog
extends Dialog {
    private ExportData expData;
    private Text patNumberFrom;
    private Text patNumberTo;
    private DatePickerCombo dateFrom;
    private DatePickerCombo dateTo;
    private Button btnPatAll;
    private Button btnPatFromTo;
    private Button btnDateAll;
    private Button btnDateFromTo;
    private final Shell parent;
    private int patNrMin = -1;
    private int patNrMax = -1;

    public ExportDialog(Shell parent) {
        super(parent);
        this.parent = parent;
    }

    public ExportDialog(Shell parent, ExportData exportData) {
        super(parent);
        this.parent = parent;
        this.expData = exportData;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, true));
        Label lblPatient = new Label(composite, 0);
        lblPatient.setText(Messages.ExportDialog_lblPatient);
        Composite compPatient = new Composite(composite, 0);
        compPatient.setLayout((Layout)new RowLayout(256));
        this.btnPatAll = new Button(compPatient, 16);
        this.btnPatAll.setLayoutData((Object)new RowData(110, -1));
        this.btnPatAll.setText(Messages.ExportDialog_btnPatAll);
        this.btnPatFromTo = new Button(compPatient, 16);
        this.btnPatFromTo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExportDialog.this.btnPatFromTo.getSelection()) {
                    ExportDialog.this.patNumberFrom.setEnabled(true);
                    ExportDialog.this.patNumberTo.setEnabled(true);
                    ExportDialog.this.patNumberFrom.setText(Integer.toString(ExportDialog.this.expData.getPatientNumberFrom()));
                    ExportDialog.this.patNumberTo.setText(Integer.toString(ExportDialog.this.expData.getPatientNumberTo()));
                } else {
                    ExportDialog.this.patNumberFrom.setEnabled(false);
                    ExportDialog.this.patNumberTo.setEnabled(false);
                    if (ExportDialog.this.patNrMin == -1 || ExportDialog.this.patNrMax == -1) {
                        ExportDialog.this.calcMinMaxPatNumbers();
                    }
                    ExportDialog.this.patNumberFrom.setText(Integer.toString(ExportDialog.this.patNrMin));
                    ExportDialog.this.patNumberTo.setText(Integer.toString(ExportDialog.this.patNrMax));
                }
            }
        });
        this.btnPatFromTo.setLayoutData((Object)new RowData(140, -1));
        this.btnPatFromTo.setText(Messages.ExportDialog_btnPatFromTo);
        this.btnPatFromTo.setSelection(true);
        this.patNumberFrom = new Text(compPatient, 133120);
        this.patNumberFrom.setLayoutData((Object)new RowData(74, -1));
        this.patNumberFrom.setText(Integer.toString(this.expData.getPatientNumberFrom()));
        Label lblPatTo = new Label(compPatient, 0x1000000);
        lblPatTo.setLayoutData((Object)new RowData(30, -1));
        lblPatTo.setText(Messages.ExportDialog_lblPatTo);
        this.patNumberTo = new Text(compPatient, 133120);
        this.patNumberTo.setLayoutData((Object)new RowData(74, -1));
        this.patNumberTo.setText(Integer.toString(this.expData.getPatientNumberTo()));
        Label lblDate = new Label(composite, 0);
        lblDate.setText(Messages.ExportDialog_lblDate);
        Composite compDate = new Composite(composite, 0);
        compDate.setLayout((Layout)new RowLayout(256));
        this.btnDateAll = new Button(compDate, 16);
        this.btnDateAll.setLayoutData((Object)new RowData(110, -1));
        this.btnDateAll.setSelection(true);
        this.btnDateAll.setText(Messages.ExportDialog_btnDateAll);
        this.btnDateFromTo = new Button(compDate, 16);
        this.btnDateFromTo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExportDialog.this.btnDateFromTo.getSelection()) {
                    ExportDialog.this.dateFrom.setEnabled(true);
                    ExportDialog.this.dateTo.setEnabled(true);
                    ExportDialog.this.dateFrom.setDate(ExportDialog.this.expData.getDateFrom().getTime());
                    ExportDialog.this.dateTo.setDate(ExportDialog.this.expData.getDateTo().getTime());
                } else {
                    ExportDialog.this.dateFrom.setEnabled(false);
                    ExportDialog.this.dateTo.setEnabled(false);
                    ExportDialog.this.expData.setDateFrom(new TimeTool(ExportDialog.this.dateFrom.getDate().getTime()));
                    ExportDialog.this.expData.setDateTo(new TimeTool(ExportDialog.this.dateTo.getDate().getTime()));
                    ExportDialog.this.dateFrom.setDate(null);
                    ExportDialog.this.dateTo.setDate(null);
                }
            }
        });
        this.btnDateFromTo.setLayoutData((Object)new RowData(140, -1));
        this.btnDateFromTo.setText(Messages.ExportDialog_btnDateFromTo);
        this.btnDateFromTo.setSelection(false);
        TimeTool date = new TimeTool();
        this.expData.setDateFrom(date);
        this.expData.setDateTo(date);
        this.dateFrom = new DatePickerCombo(compDate, 2048);
        this.dateFrom.setEnabled(false);
        this.dateFrom.setLayoutData((Object)new RowData(60, -1));
        this.dateFrom.setFormat((DateFormat)new SimpleDateFormat("dd.MM.yyyy"));
        Label lblDatetTo = new Label(compDate, 0x1000000);
        lblDatetTo.setLayoutData((Object)new RowData(30, -1));
        lblDatetTo.setText(Messages.ExportDialog_lblDateTo);
        this.dateTo = new DatePickerCombo(compDate, 2048);
        this.dateTo.setEnabled(false);
        this.dateTo.setLayoutData((Object)new RowData(60, -1));
        this.dateTo.setFormat((DateFormat)new SimpleDateFormat("dd.MM.yyyy"));
        return composite;
    }

    protected void okPressed() {
        try {
            if (this.btnPatFromTo.getSelection()) {
                int from = Integer.parseInt(this.patNumberFrom.getText());
                int to = Integer.parseInt(this.patNumberTo.getText());
                if (to < from) {
                    throw new Exception(Messages.ExportDialog_Exception_PatNumber);
                }
                this.expData.setPatientNumberFrom(from);
                this.expData.setPatientNumberTo(to);
            } else {
                if (this.patNrMin == -1 || this.patNrMax == -1) {
                    this.calcMinMaxPatNumbers();
                }
                this.expData.setPatientNumberFrom(this.patNrMin);
                this.expData.setPatientNumberTo(this.patNrMax);
            }
            if (this.btnDateFromTo.getSelection()) {
                Date from = this.dateFrom.getDate();
                Date to = this.dateTo.getDate();
                if (to.before(from)) {
                    throw new Exception(Messages.ExportDialog_Exception_Datum);
                }
                this.expData.setDateFrom(new TimeTool(from.getTime()));
                this.expData.setDateTo(new TimeTool(to.getTime()));
                this.expData.setCheckDate(true);
            } else {
                this.expData.setDateFrom(new TimeTool("19700101"));
                this.expData.setDateTo(new TimeTool("20380118"));
                this.expData.setCheckDate(false);
            }
            this.close();
        }
        catch (Exception e) {
            MessageDialog md = new MessageDialog(this.parent, Messages.ExportDialog_ExceptionDialog, null, e.getMessage(), 4, new String[]{"Ok"}, 0);
            md.open();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ExportDialog_CSV_Export);
    }

    private void calcMinMaxPatNumbers() {
        this.getShell().setCursor(new Cursor((Device)Display.getCurrent(), 1));
        Query qpat = new Query(Patient.class);
        qpat.add("PatientNr", "<>", "");
        List listPatient = qpat.execute();
        if (listPatient != null) {
            int minPatNr = Integer.MAX_VALUE;
            int maxPatNr = 0;
            for (Patient patient : listPatient) {
                int patNr = Integer.parseInt(patient.getPatCode());
                if (patNr < minPatNr) {
                    minPatNr = patNr;
                }
                if (patNr <= maxPatNr) continue;
                maxPatNr = patNr;
            }
            this.patNrMin = minPatNr;
            this.patNrMax = maxPatNr;
        } else {
            this.patNrMin = -1;
            this.patNrMax = -1;
        }
        this.getShell().setCursor(null);
    }
}

