/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.messwerte.v2.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.scripting.Interpreter;
import ch.elexis.core.data.util.PlatformHelper;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Script;
import ch.rgw.tools.Log;
import ch.rgw.tools.TimeTool;
import com.hilotec.elexis.messwerte.v2.data.Messages;
import com.hilotec.elexis.messwerte.v2.data.Messung;
import com.hilotec.elexis.messwerte.v2.data.Messwert;
import com.hilotec.elexis.messwerte.v2.data.typen.IMesswertTyp;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypBool;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypCalc;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypData;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypDate;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypEnum;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypNum;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypStr;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class MesswertBase {
    public static String ICON_TRANSPARENT = "transparent.png";
    protected static String ICON_RED = "pin_red.png";
    protected static String ICON_YELLOW = "pin_yellow.png";
    protected static String ICON_GREEN = "pin_green.png";
    protected static String ICON_BLUE = "pin_blue.png";
    protected static String ICON_BLACK = "pin_black.png";
    protected final Log log = Log.get((String)"Messwerte");
    private final String name;
    private final String title;
    private final String unit;
    protected boolean editable = true;
    private String validpattern;
    private String invalidmessage;
    private String size;
    private boolean isShown = false;
    protected Widget widget;
    private Boolean alerts = false;
    private Double highAlert = Double.MAX_VALUE;
    private Double highWarning = Double.MAX_VALUE;
    private Double lowWarning = Double.MIN_VALUE;
    private Double lowAlert = Double.MIN_VALUE;
    public static final int SEVERITY_LEVEL_UNDEFINED = Integer.MAX_VALUE;
    public static final int SEVERITY_LEVEL_LOW_ALERT = -2;
    public static final int SEVERITY_LEVEL_LOW_WARNING = -1;
    public static final int SEVERITY_LEVEL_NORMAL = 0;
    public static final int SEVERITY_LEVEL_HIGH_WARNING = 1;
    public static final int SEVERITY_LEVEL_HIGH_ALERT = 2;
    protected String formula;
    protected String interpreter;
    protected final ArrayList<CalcVar> variables = new ArrayList();

    public MesswertBase(String n, String t, String u) {
        this.name = n;
        this.title = t;
        this.unit = u;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUnit() {
        return this.unit;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String getValidpattern() {
        return this.validpattern;
    }

    public void setValidpattern(String validpattern) {
        this.validpattern = validpattern;
    }

    public String getInvalidmessage() {
        return this.invalidmessage;
    }

    public void setInvalidmessage(String invalidmessage) {
        this.invalidmessage = invalidmessage;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void saveInput(Messwert messwert) {
    }

    public boolean checkInput(Messwert messwert, String pattern) {
        IMesswertTyp typ = messwert.getTyp();
        if (typ.isAlertEnabled().booleanValue()) {
            String path = String.valueOf(PlatformHelper.getBasePath((String)"com.hilotec.elexis.messwerte.v2")) + File.separator + "rsc" + File.separator;
            Label lab = messwert.getIconLabel();
            Image image = null;
            switch (typ.getSeverityLevel(this.widget)) {
                case 0x7FFFFFFF: {
                    image = new Image((Device)lab.getDisplay(), String.valueOf(path) + ICON_TRANSPARENT);
                    break;
                }
                case 2: {
                    image = new Image((Device)lab.getDisplay(), String.valueOf(path) + ICON_RED);
                    break;
                }
                case 1: {
                    image = new Image((Device)lab.getDisplay(), String.valueOf(path) + ICON_YELLOW);
                    break;
                }
                case 0: {
                    image = new Image((Device)lab.getDisplay(), String.valueOf(path) + ICON_GREEN);
                    break;
                }
                case -1: {
                    image = new Image((Device)lab.getDisplay(), String.valueOf(path) + ICON_BLUE);
                    break;
                }
                case -2: {
                    image = new Image((Device)lab.getDisplay(), String.valueOf(path) + ICON_BLACK);
                }
            }
            if (image != null) {
                lab.setImage(image);
            }
        }
        return true;
    }

    public String getActualValue() {
        return "";
    }

    public boolean isShown() {
        return this.isShown;
    }

    public void setShown(boolean isShown) {
        this.isShown = isShown;
    }

    protected void interpreterSetzeKontext(Interpreter interpreter, Messung messung) throws ElexisException {
        for (CalcVar cv : this.variables) {
            Object wert = this.holeVariable(messung, cv.getName(), cv.getSource());
            if (wert == null) continue;
            interpreter.setValue(cv.getName(), wert);
        }
        interpreter.setValue("actPatient", (Object)ElexisEventDispatcher.getSelectedPatient());
        interpreter.setValue("actFall", (Object)ElexisEventDispatcher.getSelected(Fall.class));
        interpreter.setValue("actKons", (Object)ElexisEventDispatcher.getSelected(Konsultation.class));
        interpreter.setValue("actMandant", (Object)CoreHub.actMandant);
        interpreter.setValue("actUser", (Object)CoreHub.actUser);
        interpreter.setValue("Elexis", (Object)Hub.plugin);
    }

    protected Object holeVariable(Messung messung, String name, String source) {
        if (messung == null) {
            return "messung?";
        }
        if (source == null) {
            return "source?";
        }
        String[] parts = source.split("\\.");
        Messwert messwert = messung.getMesswert(parts[0]);
        IMesswertTyp typ = messwert.getTyp();
        if (parts.length == 1) {
            if (typ instanceof MesswertTypNum) {
                if (typ.isShown()) {
                    return Double.parseDouble(typ.getActualValue());
                }
                return Double.parseDouble(messwert.getWert());
            }
            if (typ instanceof MesswertTypBool) {
                if (typ.isShown()) {
                    return Boolean.parseBoolean(typ.getActualValue());
                }
                return Boolean.parseBoolean(messwert.getWert());
            }
            if (typ instanceof MesswertTypStr) {
                if (typ.isShown()) {
                    return typ.getActualValue();
                }
                return messwert.getWert();
            }
            if (typ instanceof MesswertTypCalc) {
                if (typ.isShown()) {
                    return Double.parseDouble(typ.getActualValue());
                }
                return Double.parseDouble(messwert.getDarstellungswert());
            }
            if (typ instanceof MesswertTypEnum) {
                if (typ.isShown()) {
                    return Integer.parseInt(typ.getActualValue());
                }
                return Integer.parseInt(messwert.getWert());
            }
            if (typ instanceof MesswertTypDate) {
                TimeTool tt = typ.isShown() ? new TimeTool(typ.getActualValue()) : new TimeTool(messwert.getWert());
                return tt.getTimeInMillis();
            }
            if (typ instanceof MesswertTypData) {
                this.log.log(MessageFormat.format(Messages.MesswertBase_Failure1, name, Messages.MesswertBase_DataField), 2);
                return null;
            }
        }
        if (!(typ instanceof MesswertTypData)) {
            this.log.log(MessageFormat.format(Messages.MesswertBase_Failure1, name, Messages.MesswertBase_NoData), 2);
            return null;
        }
        MesswertTypData t = (MesswertTypData)typ;
        Messung dm = t.getMessung(messwert);
        return this.holeVariable(dm, String.valueOf(name) + "." + parts[0], source.substring(source.indexOf(".") + 1));
    }

    public void addVariable(String name, String source) {
        this.variables.add(new CalcVar(name, source));
    }

    public void setFormula(String f, String i) {
        this.formula = f;
        this.interpreter = i;
    }

    public String evalateFormula(String formula, Messwert messwert) {
        return this.evalateFormula(formula, messwert, "");
    }

    public String evalateFormula(String formula, Messwert messwert, String defaultValue) {
        try {
            Interpreter interpreter = Script.getInterpreterFor((String)formula);
            Messung messung = null;
            if (messwert != null) {
                messung = messwert.getMessung();
            }
            this.interpreterSetzeKontext(interpreter, messung);
            Object wert = interpreter.run(formula, false);
            if (wert == null) {
                wert = defaultValue;
            }
            return String.valueOf(wert);
        }
        catch (ElexisException e) {
            e.printStackTrace();
            String message = MessageFormat.format(Messages.MesswertBase_Failure2, formula.trim(), e.getMessage());
            this.log.log(message, 2);
            if (System.getProperty("com.hilotec.unitests") == null || !System.getProperty("com.hilotec.unitests").equals("1")) {
                SWTHelper.showError((String)Messages.DataAccessor_Title, (String)message);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public void setLowAlertValue(String value) {
        this.alerts = true;
        this.lowAlert = Double.MIN_VALUE;
        this.lowAlert = Double.parseDouble(value);
    }

    public void setLowWarningValue(String value) {
        this.alerts = true;
        this.lowWarning = Double.MIN_VALUE;
        this.lowWarning = Double.parseDouble(value);
    }

    public void setHighAlertValue(String value) {
        this.alerts = true;
        this.highAlert = Double.MAX_VALUE;
        this.highAlert = Double.parseDouble(value);
    }

    public void setHighWarningValue(String value) {
        this.alerts = true;
        this.highWarning = Double.MAX_VALUE;
        this.highWarning = Double.parseDouble(value);
    }

    public Boolean isAlertEnabled() {
        return this.alerts;
    }

    public int getSeverityLevel(Widget widget) {
        int retVal = Integer.MAX_VALUE;
        try {
            String strValue = ((Text)widget).getText();
            Double value = Double.parseDouble(strValue);
            retVal = 0;
            if (value > this.highAlert) {
                retVal = 2;
            } else if (value > this.highWarning) {
                retVal = 1;
            } else if (value < this.lowAlert) {
                retVal = -2;
            } else if (value < this.lowWarning) {
                retVal = -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private class CalcVar {
        private final String name;
        private final String source;

        CalcVar(String n, String s) {
            this.name = n;
            this.source = s;
        }

        String getName() {
            return this.name;
        }

        String getSource() {
            return this.source;
        }
    }
}

