/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.messwerte.v2.data;

import ch.elexis.core.data.interfaces.IDataAccess;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import com.hilotec.elexis.messwerte.v2.data.Messages;
import com.hilotec.elexis.messwerte.v2.data.Messung;
import com.hilotec.elexis.messwerte.v2.data.MessungKonfiguration;
import com.hilotec.elexis.messwerte.v2.data.MessungTyp;
import com.hilotec.elexis.messwerte.v2.data.Messwert;
import com.hilotec.elexis.messwerte.v2.data.typen.IMesswertTyp;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypData;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class DataAccessor
implements IDataAccess {
    MessungKonfiguration config = MessungKonfiguration.getInstance();

    private String getPlatzhalter(MessungTyp typ) {
        return typ.getName();
    }

    public List<IDataAccess.Element> getList() {
        ArrayList<IDataAccess.Element> ret = new ArrayList<IDataAccess.Element>();
        for (MessungTyp typ : this.config.getTypes()) {
            ret.add(new IDataAccess.Element(IDataAccess.TYPE.STRING, typ.getName(), this.getPlatzhalter(typ), Patient.class, 1));
        }
        return ret;
    }

    private void spaltentitelEintragen(MessungTyp typ, String[] ziel) {
        ArrayList<IMesswertTyp> feldtypen = typ.getMesswertTypen();
        int i = 0;
        for (IMesswertTyp dft : feldtypen) {
            ziel[i++] = dft.getTitle();
        }
    }

    private Result<Object> erstelleResultTabelle(MessungTyp typ, List<Messung> messungen) {
        String[][] values = new String[messungen.size() + 1][typ.getMesswertTypen().size() + 1];
        this.spaltentitelEintragen(typ, values[0]);
        int i = 1;
        for (Messung messung : messungen) {
            int j = 0;
            values[i][j++] = messung.getDatum();
            for (Messwert wert : messung.getMesswerte()) {
                values[i][j++] = wert.getDarstellungswert();
            }
            ++i;
        }
        return new Result((Object)values);
    }

    private Messung sucheMessung(List<Messung> messungen, String suchbegriff) {
        Messung messung = null;
        if (messungen.size() == 0) {
            return null;
        }
        if (suchbegriff.matches(Messages.DataAccessor_FilterLast) || suchbegriff.matches(Messages.DataAccessor_FilterFirst)) {
            TimeTool lowerbound = new TimeTool("19700101");
            TimeTool upperbound = new TimeTool("20380118");
            int factor = 1;
            if (suchbegriff.matches(Messages.DataAccessor_FilterLast)) {
                if (suchbegriff.matches(Messages.DataAccessor_FilterLastBefore)) {
                    upperbound = new TimeTool(suchbegriff.substring(11));
                    upperbound.addSeconds(-1);
                }
            } else {
                factor = -1;
                if (suchbegriff.matches(Messages.DataAccessor_FilterFirstSince)) {
                    lowerbound = new TimeTool(suchbegriff.substring(11));
                }
            }
            TimeTool cur = null;
            for (Messung m : messungen) {
                TimeTool vgl = new TimeTool(m.getDatum());
                if (vgl.compareTo((Calendar)lowerbound) < 0 || vgl.compareTo((Calendar)upperbound) > 0 || cur != null && cur.compareTo((Calendar)vgl) * factor > 0) continue;
                messung = m;
                cur = vgl;
            }
        } else {
            TimeTool find = new TimeTool();
            if (!find.set(suchbegriff)) {
                return null;
            }
            for (Messung m : messungen) {
                TimeTool vgl = new TimeTool(m.getDatum());
                if (!vgl.isEqual(find)) continue;
                messung = m;
                break;
            }
        }
        return messung;
    }

    public Result<Object> getObject(String descriptor, PersistentObject dependentObject, String dates, String[] params) {
        MessungTyp typ;
        if (!(dependentObject instanceof Patient)) {
            return new Result(Result.SEVERITY.ERROR, 1, Messages.DataAccessor_InvalidParameter, (Object)dependentObject, true);
        }
        Patient patient = (Patient)dependentObject;
        String[] parts = descriptor.split("\\.");
        String messungsname = parts[0];
        String[] feldnamen = null;
        if (parts.length > 1) {
            feldnamen = new String[parts.length - 1];
            int i = 0;
            while (i < feldnamen.length) {
                feldnamen[i] = parts[i + 1];
                ++i;
            }
        }
        if ((typ = this.config.getTypeByName(messungsname)) == null) {
            return new Result(Result.SEVERITY.ERROR, 2, String.valueOf(Messages.DataAccessor_InvalidMeasureType) + messungsname, (Object)messungsname, true);
        }
        List<Messung> messungen = Messung.getPatientMessungen(patient, typ);
        Messung messung = null;
        if (dates.equals(Messages.DataAccessor_FilterAll)) {
            return this.erstelleResultTabelle(typ, messungen);
        }
        messung = this.sucheMessung(messungen, dates);
        if (messung == null) {
            return new Result(Result.SEVERITY.ERROR, 2, String.valueOf(Messages.DataAccessor_NotFound) + descriptor + "." + dates, (Object)params, true);
        }
        if (feldnamen == null) {
            ArrayList<Messung> liste = new ArrayList<Messung>();
            liste.add(messung);
            return this.erstelleResultTabelle(typ, liste);
        }
        if ("record_date".equals(feldnamen[0])) {
            return new Result((Object)messung.getDatum());
        }
        Messwert messwert = messung.getMesswert(feldnamen[0]);
        int i = 1;
        while (i < feldnamen.length && messwert != null) {
            if (!(messwert.getTyp() instanceof MesswertTypData)) {
                return new Result(Result.SEVERITY.ERROR, 2, Messages.DataAccessor_NoDataField, (Object)params, true);
            }
            MesswertTypData t = (MesswertTypData)messwert.getTyp();
            Messung m = t.getMessung(messwert);
            messwert = m.getMesswert(feldnamen[i]);
            ++i;
        }
        if (messwert == null) {
            return new Result(Result.SEVERITY.ERROR, 2, Messages.DataAccessor_InvalidFieldName, (Object)params, true);
        }
        return new Result((Object)messwert.getDarstellungswert());
    }

    public String getDescription() {
        return Messages.DataAccessor_DataDescription;
    }

    public String getName() {
        return Messages.DataAccessor_Title;
    }
}

