/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview.medikarte;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import ch.rgw.tools.TimeTool;
import com.hilotec.elexis.kgview.Preferences;
import com.hilotec.elexis.kgview.data.FavMedikament;
import com.hilotec.elexis.kgview.medikarte.MedikarteHelpers;
import java.util.Calendar;
import java.util.HashMap;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MedikarteEintragDialog
extends TitleAreaDialog {
    private Patient pat;
    private FavMedikament fm;
    private Prescription presc;
    private Text tOrd;
    private Text tDoMorgen;
    private Text tDoMittag;
    private Text tDoAbend;
    private Text tDoNacht;
    private Text tVon;
    private Text tBis;
    private Combo cEV;
    private Text tZweck;

    public MedikarteEintragDialog(Shell parentShell, Patient patient, FavMedikament med) {
        super(parentShell);
        this.fm = med;
        this.pat = patient;
        this.presc = null;
    }

    public MedikarteEintragDialog(Shell parentShell, Patient patient, Prescription prescription) {
        super(parentShell);
        this.fm = FavMedikament.load(prescription.getArtikel());
        this.pat = patient;
        this.presc = prescription;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.setTitle("Neues Medikament fuer " + this.pat.getName() + ", " + this.pat.getGeburtsdatum());
        Label lLMed = new Label(comp, 0);
        lLMed.setText("Medikament");
        Label lMed = new Label(comp, 2048);
        lMed.setText(this.fm.getBezeichnung());
        Label lLOMed = new Label(comp, 0);
        lLOMed.setText("Original");
        Label lOMed = new Label(comp, 2048);
        lOMed.setText(this.fm.getArtikel().getName());
        Label lOrd = new Label(comp, 0);
        lOrd.setText("Ordnungszahl");
        this.tOrd = SWTHelper.createText((Composite)comp, (int)1, (int)0);
        Label lVon = new Label(comp, 0);
        lVon.setText("Von");
        this.tVon = SWTHelper.createText((Composite)comp, (int)1, (int)0);
        Label lBis = new Label(comp, 0);
        lBis.setText("Bis");
        this.tBis = SWTHelper.createText((Composite)comp, (int)1, (int)0);
        Label lDosierung = new Label(comp, 0);
        lDosierung.setText("Dosierung");
        Composite cDos = new Composite(comp, 0);
        cDos.setLayout((Layout)new RowLayout());
        this.tDoMorgen = new Text(cDos, 2048);
        this.tDoMorgen.setLayoutData((Object)new RowData(30, -1));
        this.tDoMittag = new Text(cDos, 2048);
        this.tDoMittag.setLayoutData((Object)new RowData(30, -1));
        this.tDoAbend = new Text(cDos, 2048);
        this.tDoAbend.setLayoutData((Object)new RowData(30, -1));
        this.tDoNacht = new Text(cDos, 2048);
        this.tDoNacht.setLayoutData((Object)new RowData(30, -1));
        Label lEV = new Label(comp, 0);
        lEV.setText("Einnahmevorschrift");
        this.cEV = new Combo(comp, 2052);
        HashMap<String, Integer> evMap = new HashMap<String, Integer>();
        int evIndex = 0;
        this.cEV.add("");
        this.cEV.select(0);
        evMap.put("", evIndex++);
        String[] stringArray = Preferences.getEinnahmevorschriften();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ev = stringArray[n2];
            if (!evMap.containsKey(ev)) {
                this.cEV.add(ev);
                evMap.put(ev, evIndex++);
            }
            ++n2;
        }
        Label lZweck = new Label(comp, 0);
        lZweck.setText("Zweck");
        this.tZweck = SWTHelper.createText((Composite)comp, (int)2, (int)0);
        Label lEinheit = new Label(comp, 0);
        lEinheit.setText("Einheit");
        Label lEinheitText = new Label(comp, 2048);
        lEinheitText.setText(this.fm.getEinheit());
        this.tVon.setText(new TimeTool().toString(4));
        if (this.presc != null) {
            int o = MedikarteHelpers.getOrdnungszahl(this.presc);
            this.tOrd.setText(Integer.toString(o));
            this.tBis.setText(this.presc.getEndDate());
            String[] dos = this.presc.getDosis().split("-");
            this.tDoMorgen.setText(dos[0]);
            this.tDoMittag.setText(dos[1]);
            this.tDoAbend.setText(dos[2]);
            this.tDoNacht.setText(dos[3]);
            this.tZweck.setText(MedikarteHelpers.getPZweck(this.presc));
            String ev = this.presc.getBemerkung();
            if (evMap.containsKey(ev)) {
                this.cEV.select(((Integer)evMap.get(ev)).intValue());
            } else {
                this.cEV.add(ev);
                this.cEV.select(evIndex);
            }
        } else {
            this.tOrd.setText(Integer.toString(this.fm.getOrdnungszahl()));
            this.tDoMorgen.setText("0");
            this.tDoMittag.setText("0");
            this.tDoAbend.setText("0");
            this.tDoNacht.setText("0");
            this.tZweck.setText(this.fm.getZweck());
        }
        return comp;
    }

    private boolean validateDate(String s, boolean allowempty) {
        TimeTool tt = new TimeTool();
        return s.isEmpty() && allowempty || tt.setDate(s);
    }

    private boolean validateDosierung(String s) {
        String[] parts;
        if ((s = s.toUpperCase()).equals("X")) {
            return true;
        }
        if (s.matches("[0-9]+")) {
            return true;
        }
        if (s.matches("[0-9]+ .*")) {
            parts = (s = s.replaceAll("[ \t]+", " ")).split(" ");
            if (parts.length != 2) {
                return false;
            }
            s = parts[1];
        }
        if (s.matches("[0-9]+/[0-9]+")) {
            int n;
            int z;
            parts = s.split("/");
            try {
                z = Integer.parseInt(parts[0]);
                n = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            return z > 0 && n > 0 && n > z;
        }
        return false;
    }

    private boolean validateInput() {
        this.setMessage("");
        if (!this.validateDate(this.tVon.getText(), false) || !this.validateDate(this.tBis.getText(), true)) {
            this.setMessage("Fehler: Ung\u00fcltiges Datum. Erwarte Format dd.mm.jjjj, oder leer (nur Bis).");
            return false;
        }
        try {
            Integer.parseInt(this.tOrd.getText());
        }
        catch (NumberFormatException nfe) {
            this.setMessage("Fehler: Ung\u00fcltige Ordnungszahl. Erwarte Ganzzahl.");
            return false;
        }
        if (!(this.validateDosierung(this.tDoMorgen.getText()) && this.validateDosierung(this.tDoMittag.getText()) && this.validateDosierung(this.tDoAbend.getText()) && this.validateDosierung(this.tDoNacht.getText()))) {
            this.setMessage("Fehler: Ung\u00fcltige Dosierung. Erwarte nicht-negative Ganzzahl, Bruch mit positivem, ganzzahligem Z\u00e4hler und Nenner, oder x f\u00fcr Einnahme gem\u00e4ss separater Verschreibungskarte.");
            return false;
        }
        return true;
    }

    public void okPressed() {
        if (!this.validateInput()) {
            return;
        }
        String dosierung = String.valueOf(this.tDoMorgen.getText()) + "-" + this.tDoMittag.getText() + "-" + this.tDoAbend.getText() + "-" + this.tDoNacht.getText();
        dosierung = dosierung.toUpperCase();
        String bemerkung = this.cEV.getItem(this.cEV.getSelectionIndex());
        int ordnungszahl = Integer.parseInt(this.tOrd.getText());
        if (this.presc != null && this.presc.getDosis().equals(dosierung) && this.presc.getBeginDate().equals(this.tVon.getText()) && this.presc.getEndDate().equals(this.tBis.getText()) && this.presc.getBemerkung().equals(bemerkung) && MedikarteHelpers.getPZweck(this.presc).equals(this.tZweck.getText())) {
            MedikarteHelpers.setOrdnungszahl(this.presc, ordnungszahl);
            this.close();
            return;
        }
        if (this.presc != null && !this.presc.isDeleted() && this.presc.getEndDate().equals("")) {
            TimeTool ttNew;
            TimeTool ttOld = new TimeTool(this.presc.getBeginDate());
            int cmp = ttOld.compareTo((Calendar)(ttNew = new TimeTool(this.tVon.getText())));
            if (cmp == 0) {
                this.presc.remove();
            } else if (cmp < 0) {
                this.presc.setEndDate(this.tVon.getText());
            }
        }
        this.presc = new Prescription(this.fm.getArtikel(), this.pat, dosierung, bemerkung);
        this.presc.setBeginDate(this.tVon.getText());
        this.presc.setEndDate(this.tBis.getText());
        MedikarteHelpers.setOrdnungszahl(this.presc, Integer.parseInt(this.tOrd.getText()));
        MedikarteHelpers.setPZweck(this.presc, this.tZweck.getText());
        this.close();
    }
}

