/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview.diagnoseliste;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.icpc.IcpcCode;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import com.hilotec.elexis.kgview.diagnoseliste.DiagnoselisteItem;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DiagnoseDialog
extends TitleAreaDialog {
    private DiagnoselisteItem di;
    private DatePickerCombo date;
    private Text text;
    private boolean showDate;
    private boolean showICPC;

    public DiagnoseDialog(Shell parentShell, DiagnoselisteItem di, boolean showDate, boolean showICPC) {
        super(parentShell);
        this.di = di;
        this.showDate = showDate;
        this.showICPC = showICPC;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Eintrag bearbeiten");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)SWTHelper.getFillGridData());
        Label lblText = new Label(comp, 0);
        lblText.setText("Text");
        this.text = SWTHelper.createText((Composite)comp, (int)5, (int)2);
        this.text.setText(this.di.getText());
        this.text.setLayoutData((Object)SWTHelper.getFillGridData());
        if (this.showDate) {
            Label lblDate = new Label(comp, 0);
            lblDate.setText("Datum");
            this.date = new DatePickerCombo(comp, 0);
            TimeTool tt = new TimeTool(this.di.getDatum());
            this.date.setDate(tt.getTime());
        }
        if (this.showICPC) {
            Label lblICPC = new Label(comp, 0);
            lblICPC.setText("ICPC");
            Label icpc = new Label(comp, 0);
            String code = this.di.getICPC();
            if (!StringTool.isNothing((Object)code)) {
                IcpcCode c = IcpcCode.load((String)code);
                icpc.setText(c.getLabel());
            }
        }
        return comp;
    }

    protected void okPressed() {
        this.di.setText(this.text.getText());
        if (this.showDate) {
            this.di.setDatum(new TimeTool(this.date.getDate().getTime()).toString(4));
        }
        this.close();
    }
}

