/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.StringTool;
import com.hilotec.elexis.kgview.ArchivKG;
import com.hilotec.elexis.kgview.POSelectionListener;
import com.hilotec.elexis.kgview.data.KonsData;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;

public class Therapieliste
extends ViewPart
implements ElexisEventListener {
    public static final String ID = "com.hilotec.elexis.kgview.Therapieliste";
    private TableViewer tv;
    private ElexisEvent eetmpl = new ElexisEvent(null, Konsultation.class, 7);

    public void createPartControl(Composite parent) {
        this.tv = new TableViewer(parent);
        Table t = this.tv.getTable();
        t.setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(70));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(70));
        t.setLayout((Layout)layout);
        TableColumn tc = new TableColumn(t, 0);
        tc.setText("Datum");
        tc = new TableColumn(t, 0);
        tc.setText("Therapie");
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Patient pat;

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.pat = (Patient)newInput;
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                ArrayList<Konsultation> kl = ArchivKG.getKonsultationen(this.pat, false);
                ArrayList<KonsData> list = new ArrayList<KonsData>(kl.size());
                for (Konsultation k : kl) {
                    KonsData kd = KonsData.load(k);
                    if (kd == null || StringTool.isNothing((Object)kd.getTherapie())) continue;
                    list.add(kd);
                }
                return list.toArray();
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new OwnerDrawLabelProvider(){

            private String getText(KonsData kd, Event event) {
                if (event.index == 0) {
                    return kd.getKonsultation().getDatum();
                }
                return StringTool.unNull((String)kd.getTherapie());
            }

            protected void paint(Event event, Object element) {
                KonsData kd = (KonsData)((Object)element);
                String text = this.getText(kd, event);
                event.gc.drawText(text, event.x, event.y, true);
            }

            protected void measure(Event event, Object element) {
                KonsData kd = (KonsData)((Object)element);
                String text = this.getText(kd, event);
                Point size = event.gc.textExtent(text);
                event.width = Therapieliste.this.tv.getTable().getColumn(event.index).getWidth();
                if (event.width == 0) {
                    event.width = 1;
                }
                int lines = size.x / event.width + 1;
                event.height = size.y * lines;
            }
        });
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableItem[] tis = Therapieliste.this.tv.getTable().getSelection();
                if (tis.length != 1) {
                    return;
                }
                KonsData kd = (KonsData)((Object)tis[0].getData());
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)kd.getKonsultation());
            }
        });
        new PersistentObjectDragSource((StructuredViewer)this.tv);
        this.tv.setInput((Object)ElexisEventDispatcher.getSelectedPatient());
        new SelListener().init();
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this});
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this});
        super.dispose();
    }

    public void setFocus() {
    }

    public void catchElexisEvent(ElexisEvent ev) {
        UiDesk.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Therapieliste.this.tv.refresh();
            }
        });
    }

    public ElexisEvent getElexisEventFilter() {
        return this.eetmpl;
    }

    private class SelListener
    extends POSelectionListener<Patient> {
        private SelListener() {
        }

        @Override
        protected void deselected(Patient p) {
            if (Therapieliste.this.tv.getControl() != null && !Therapieliste.this.tv.getControl().isDisposed()) {
                Therapieliste.this.tv.setInput(null);
            }
        }

        @Override
        protected void selected(Patient p) {
            if (Therapieliste.this.tv.getControl() != null && !Therapieliste.this.tv.getControl().isDisposed()) {
                Therapieliste.this.tv.setInput((Object)p);
            }
        }
    }
}

