/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.preferences.inputs.MultilineFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Preferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static SettingsPreferenceStore store = new SettingsPreferenceStore(CoreHub.mandantCfg);
    public static final String CFG_EVLISTE = "hilotec/kgview/einnahmevorschriften";
    public static final String CFG_FLORDZ = "hilotec/kgview/ordnungszahlfavliste";
    public static final String CFG_MK_INCSTOP = "hilotec/kgview/mkincludestopdate";
    public static final String CFG_AKG_HEARTBEAT = "hilotec/kgview/archivkgheartbaeat";
    public static final String CFG_AKG_SCROLLPERIOD = "hilotec/kgview/archivkgscrollperiod";
    public static final String CFG_AKG_SCROLLDIST_UP = "hilotec/kgview/archivkgscrolldistup";
    public static final String CFG_AKG_SCROLLDIST_DOWN = "hilotec/kgview/archivkgscrolldistdown";

    static {
        store.setDefault(CFG_FLORDZ, false);
        store.setDefault(CFG_MK_INCSTOP, false);
        store.setDefault(CFG_AKG_HEARTBEAT, 10);
        store.setDefault(CFG_AKG_SCROLLPERIOD, 200);
        store.setDefault(CFG_AKG_SCROLLDIST_UP, 5);
        store.setDefault(CFG_AKG_SCROLLDIST_DOWN, 5);
    }

    public Preferences() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)store);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new MultilineFieldEditor(CFG_EVLISTE, "Einnahmevorschriften", 5, 512, true, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(CFG_FLORDZ, "Ordnungszahl in FML anzeigen", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(CFG_MK_INCSTOP, "In Medikarte bis/mit Stoppdatum anzeigen?", this.getFieldEditorParent()));
        this.addField((FieldEditor)new IntegerFieldEditor(CFG_AKG_HEARTBEAT, "Archiv KG Heartbeat", this.getFieldEditorParent()));
        this.addField((FieldEditor)new IntegerFieldEditor(CFG_AKG_SCROLLPERIOD, "Archiv KG Scroll Periode [ms]", this.getFieldEditorParent()));
        this.addField((FieldEditor)new IntegerFieldEditor(CFG_AKG_SCROLLDIST_UP, "Archiv KG Scroll Distanz hoch [px]", this.getFieldEditorParent()));
        this.addField((FieldEditor)new IntegerFieldEditor(CFG_AKG_SCROLLDIST_DOWN, "Archiv KG Scroll Distanz runter [px]", this.getFieldEditorParent()));
    }

    public static String[] getEinnahmevorschriften() {
        String s = CoreHub.mandantCfg.get(CFG_EVLISTE, "");
        return s.split(",");
    }

    public static boolean getOrdnungszahlInFML() {
        boolean oz = CoreHub.mandantCfg.get(CFG_FLORDZ, false);
        return oz;
    }

    public static boolean getMedikarteStopdatumInkl() {
        return store.getBoolean(CFG_MK_INCSTOP);
    }

    public int getArchivKGHeartbeat() {
        int n = store.getInt(CFG_AKG_HEARTBEAT);
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    public static int getArchivKGScrollPeriod() {
        int n = store.getInt(CFG_AKG_SCROLLPERIOD);
        if (n < 50) {
            n = 50;
        }
        return n;
    }

    public static int getArchivKGScrollDistUp() {
        int n = store.getInt(CFG_AKG_SCROLLDIST_UP);
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    public static int getArchivKGScrollDistDown() {
        int n = store.getInt(CFG_AKG_SCROLLDIST_DOWN);
        if (n < 1) {
            n = 1;
        }
        return n;
    }
}

