/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import com.hilotec.elexis.kgview.ArchivKG;
import com.hilotec.elexis.kgview.POSelectionListener;
import com.hilotec.elexis.kgview.data.KonsData;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Konsliste
extends ViewPart
implements ElexisEventListener {
    protected TableViewer tv;
    protected SelListener sl;
    private ElexisEvent eetmpl = new ElexisEvent(null, Konsultation.class, 7);

    public void createPartControl(Composite parent) {
        this.tv = new TableViewer(parent, 68100);
        Table t = this.tv.getTable();
        t.setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(20));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(70));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(50));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        t.setLayout((Layout)layout);
        TableColumn tc = new TableColumn(t, 0);
        tc = new TableColumn(t, 0);
        tc.setText("Datum");
        tc = new TableColumn(t, 0);
        tc.setText("Zeit");
        tc = new TableColumn(t, 0);
        tc.setText("Fall");
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Patient pat;

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.pat = (Patient)newInput;
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ArchivKG.getKonsultationen(this.pat, false).toArray();
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            private Color mandantColor(Mandant m) {
                return UiDesk.getColorFromRGB((String)CoreHub.globalCfg.get("mandanten/farben/" + m.getLabel(), "ffffff"));
            }

            public void update(ViewerCell cell) {
                Konsultation k = (Konsultation)cell.getElement();
                KonsData kd = KonsData.load(k);
                String s = "";
                switch (cell.getColumnIndex()) {
                    case 0: {
                        int typ = kd.getKonsTyp();
                        ImageDescriptor desc = null;
                        if (typ == 1) {
                            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.hilotec.elexis.kgview", (String)"rsc/phone.png");
                        } else if (typ == 2) {
                            desc = Images.IMG_HOME.getImageDescriptor();
                        }
                        if (desc == null) break;
                        cell.setImage(desc.createImage());
                        break;
                    }
                    case 1: {
                        s = k.getDatum();
                        break;
                    }
                    case 2: {
                        s = kd == null ? "" : kd.getKonsBeginn();
                        break;
                    }
                    case 3: {
                        s = k.getFall().getLabel();
                    }
                }
                cell.setBackground(this.mandantColor(k.getMandant()));
                cell.setText(s);
            }
        });
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableItem[] tis = Konsliste.this.tv.getTable().getSelection();
                if (tis.length != 1) {
                    return;
                }
                Konsultation k = (Konsultation)tis[0].getData();
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)k);
            }
        });
        ViewMenus menus = new ViewMenus(this.getViewSite());
        menus.createToolbar(new IAction[]{new ArchivKG.NeueKonsAct(0), new ArchivKG.NeueKonsAct(1), new ArchivKG.NeueKonsAct(2), null, new ArchivKG.KonsAendernAct(), new KonsLoeschenAct()});
        this.tv.setInput((Object)ElexisEventDispatcher.getSelectedPatient());
        this.sl = new SelListener();
        this.sl.init();
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this});
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this});
        this.sl.destroy();
        super.dispose();
    }

    public void setFocus() {
    }

    public void catchElexisEvent(ElexisEvent ev) {
        UiDesk.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Konsliste.this.tv.refresh();
            }
        });
    }

    public ElexisEvent getElexisEventFilter() {
        return this.eetmpl;
    }

    class KonsLoeschenAct
    extends Action {
        public KonsLoeschenAct() {
            this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            this.setText("Konsultation l\u00f6schen");
            this.setToolTipText("Aktuell ausgew\u00e4hlte Konsultation l\u00f6schen");
        }

        public void run() {
            Konsultation k = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
            if (k != null && SWTHelper.askYesNo((String)"Konsultation l\u00f6schen", (String)"Soll die aktuell ausgew\u00e4hlte Konsultation wirklich gel\u00f6scht werden?\nDieser Vorgang kann nicht R\u00fcckg\u00e4ngiggemacht werden.")) {
                GlobalActions.delKonsAction.run();
            }
        }
    }

    private class SelListener
    extends POSelectionListener<Patient> {
        private SelListener() {
        }

        @Override
        protected void deselected(Patient p) {
            Konsliste.this.tv.setInput(null);
        }

        @Override
        protected void selected(Patient p) {
            Konsliste.this.tv.setInput((Object)p);
        }
    }
}

