/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.data.Konsultation;
import com.hilotec.elexis.kgview.POSelectionListener;
import com.hilotec.elexis.kgview.data.KonsData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class KonsTimeView
extends ViewPart {
    public static final String ID = "com.hilotec.elexis.kgview.KonsTimeView";
    Label timerLbl;
    MySelListener msl;
    KonsData konsData;
    long time;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.timerLbl = new Label(comp, 0);
        this.createButtonControl(comp);
        this.setEnabled(false);
        this.msl = new MySelListener();
    }

    public void setFocus() {
    }

    protected void createButtonControl(Composite parent) {
    }

    protected void setEnabled(boolean en) {
    }

    protected void stopTimer() {
    }

    private void konsDeselected(Konsultation kons) {
        this.stopTimer();
        this.konsData.setKonsZeit(this.time);
        this.setEnabled(false);
        this.konsData = null;
        this.time = 0L;
        this.updateLabel();
    }

    private void konsSelected(Konsultation kons) {
        this.konsData = new KonsData(kons);
        this.time = this.konsData.getKonsZeit();
        this.setEnabled(true);
        this.updateLabel();
    }

    protected void updateLabel() {
        if (this.timerLbl.isDisposed()) {
            return;
        }
        long secs = this.time / 1000L;
        String text = String.format("%02d:%02d:%02d", secs / 3600L, secs % 3600L / 60L, secs % 60L);
        this.timerLbl.setText(text);
        this.timerLbl.pack();
        this.timerLbl.update();
    }

    public void dispose() {
        this.msl.destroy();
        super.dispose();
    }

    private class MySelListener
    extends POSelectionListener<Konsultation> {
        public MySelListener() {
            this.init();
        }

        @Override
        protected void deselected(Konsultation kons) {
            KonsTimeView.this.konsDeselected(kons);
        }

        @Override
        protected void selected(Konsultation kons) {
            KonsTimeView.this.konsSelected(kons);
        }
    }
}

