/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.Messages;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.data.Anwender;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import com.hilotec.elexis.kgview.ArchivKGPrintView;
import com.hilotec.elexis.kgview.NeueKonsDialog;
import com.hilotec.elexis.kgview.ScrollHelper;
import com.hilotec.elexis.kgview.data.KonsData;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ScrolledFormText;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;

public class ArchivKG
extends ViewPart
implements ElexisEventListener,
Heartbeat.HeartListener {
    public static final String ID = "com.hilotec.elexis.kgview.ArchivKG";
    ScrolledFormText text;
    private Action actNeueKons;
    private Action actNeueTelKons;
    private Action actNeuerHausbesuch;
    private Action actKonsAendern;
    private Action actAutoAkt;
    private Action actSortierungUmk;
    private Action actDrucken;
    private boolean sortRev;
    private final ElexisEvent eetmpl = new ElexisEvent(null, Patient.class, 48);

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.text = new ScrolledFormText(parent, true);
        this.text.getFormText().addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                if (!(e.getHref() instanceof String)) {
                    return;
                }
                String href = (String)e.getHref();
                if (href.startsWith("kons:")) {
                    Konsultation kons = Konsultation.load((String)href.substring(5));
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)kons);
                }
            }
        });
        new ScrollHelper(this.text);
        this.sortRev = false;
        this.createActions();
        ViewMenus menus = new ViewMenus(this.getViewSite());
        menus.createToolbar(new IAction[]{this.actNeueKons, this.actNeueTelKons, this.actNeuerHausbesuch, null, this.actKonsAendern, this.actAutoAkt, this.actSortierungUmk, null, this.actDrucken});
        Patient pat = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
        this.loadPatient(pat);
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this});
    }

    public static ArrayList<Konsultation> getKonsultationen(Patient pat, final boolean reversed) {
        ArrayList<Konsultation> konsliste = new ArrayList<Konsultation>();
        Fall[] fallArray = pat.getFaelle();
        int n = fallArray.length;
        int n2 = 0;
        while (n2 < n) {
            Fall f = fallArray[n2];
            Konsultation[] konsultationArray = f.getBehandlungen(true);
            int n3 = konsultationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Konsultation k = konsultationArray[n4];
                konsliste.add(k);
                ++n4;
            }
            ++n2;
        }
        Comparator<Konsultation> comp = new Comparator<Konsultation>(){

            @Override
            public int compare(Konsultation k0, Konsultation k1) {
                KonsData kd0 = KonsData.load(k0);
                TimeTool tt0 = new TimeTool(k0.getDatum());
                tt0.setTime(new TimeTool(kd0.getKonsBeginn()));
                KonsData kd1 = KonsData.load(k1);
                TimeTool tt1 = new TimeTool(k1.getDatum());
                tt1.setTime(new TimeTool(kd1.getKonsBeginn()));
                if (reversed) {
                    return tt0.compareTo((Calendar)tt1);
                }
                return tt1.compareTo((Calendar)tt0);
            }
        };
        Collections.sort(konsliste, comp);
        return konsliste;
    }

    private void loadPatient(Patient pat) {
        if (pat == null) {
            this.text.setText("Kein Patient ausgew\u00e4hlt!");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<form>");
        for (Konsultation k : ArchivKG.getKonsultationen(pat, this.sortRev)) {
            this.processKonsultation(k, sb);
        }
        sb.append("</form>");
        this.text.setText(sb.toString());
    }

    private void refresh() {
        this.loadPatient(ElexisEventDispatcher.getSelectedPatient());
    }

    private void processKonsultation(Konsultation k, StringBuilder sb) {
        KonsData kd = KonsData.load(k);
        sb.append("<p>");
        int typ = kd.getKonsTyp();
        if (typ == 1) {
            sb.append("<b>Telefon</b> ");
        } else if (typ == 2) {
            sb.append("<b>Hausbesuch</b> ");
        } else {
            sb.append("<b>Konsultation</b> ");
        }
        sb.append("<a href=\"kons:" + k.getId() + "\">");
        sb.append(String.valueOf(k.getDatum()) + " " + kd.getKonsBeginn() + "</a>");
        if (k.getFall() != null) {
            sb.append(" " + k.getFall().getAbrechnungsSystem());
        }
        String sAutor = "";
        Anwender autor = kd.getAutor();
        if (autor != null && StringTool.isNothing((Object)(sAutor = autor.getKuerzel()))) {
            sAutor = autor.getLabel();
        }
        sb.append(" (" + sAutor + ")");
        sb.append("<br/>");
        this.addParagraph("Jetziges Leiden", kd.getJetzigesLeiden(), kd.getJetzigesLeidenICPC(), sb);
        this.addParagraph("Status", kd.getLokalstatus(), sb);
        this.addParagraph("R\u00f6ntgen", kd.getRoentgen(), sb);
        this.addParagraph("EKG", kd.getEKG(), sb);
        this.addParagraph("Diagnose", kd.getDiagnose(), kd.getDiagnoseICPC(), sb);
        this.addParagraph("Therapie", kd.getTherapie(), sb);
        this.addParagraph("Verlauf", kd.getVerlauf(), sb);
        this.addParagraph("Procedere", kd.getProzedere(), kd.getProzedereICPC(), sb);
        sb.append("</p>");
    }

    private void addParagraph(String titel, String text, StringBuilder sb) {
        this.addParagraph(titel, text, null, sb);
    }

    private void addParagraph(String titel, String text, String icpc, StringBuilder sb) {
        if ((text == null || text.isEmpty()) && (icpc == null || icpc.isEmpty())) {
            return;
        }
        sb.append("<b>" + titel + "</b><br/>");
        if (icpc != null && !icpc.isEmpty()) {
            sb.append("ICPC: " + icpc.replace(",", ", ") + "<br/>");
        }
        sb.append(this.cleanUp(text));
        sb.append("<br/><br/>");
    }

    private String cleanUp(String text) {
        return text.replace(">", "&gt;").replace("<", "&lt;").replace("\n", "<br/>");
    }

    public void catchElexisEvent(final ElexisEvent ev) {
        UiDesk.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Patient p = (Patient)ev.getObject();
                if (ev.getType() == 16) {
                    ArchivKG.this.loadPatient(p);
                } else if (ev.getType() == 32) {
                    ArchivKG.this.loadPatient(null);
                }
            }
        });
    }

    public ElexisEvent getElexisEventFilter() {
        return this.eetmpl;
    }

    public void setFocus() {
    }

    private void createActions() {
        this.actNeueKons = new NeueKonsAct(0);
        this.actNeueTelKons = new NeueKonsAct(1);
        this.actNeuerHausbesuch = new NeueKonsAct(2);
        this.actKonsAendern = new KonsAendernAct();
        final ArchivKG akg = this;
        this.actAutoAkt = new Action("Automatisch aktualisieren", 2){
            {
                super($anonymous0, $anonymous1);
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
                this.setToolTipText("Automatisch aktualisieren");
            }

            public void run() {
                boolean ch = this.isChecked();
                if (ch) {
                    CoreHub.heart.addListener((Heartbeat.HeartListener)akg);
                } else {
                    CoreHub.heart.removeListener((Heartbeat.HeartListener)akg);
                }
            }
        };
        this.actSortierungUmk = new Action("Sortierung umkehren", 2){
            {
                this.setImageDescriptor(Images.IMG_ARROWUP.getImageDescriptor());
                this.setToolTipText("Sortierung umkehren, \u00e4lteste zuoberst");
            }

            public void run() {
                ArchivKG.this.sortRev = this.isChecked();
                ArchivKG.this.refresh();
            }
        };
        this.actDrucken = new Action("KG Drucken"){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText("Krankengeschichte zum Drucken vorbereiten");
            }

            public void run() {
                IWorkbenchPage p = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                ArchivKGPrintView apv = null;
                try {
                    apv = (ArchivKGPrintView)p.showView("com.hilotec.elexis.kgview.ArvchivKGPrintView");
                }
                catch (PartInitException ex) {
                    ElexisStatus status = new ElexisStatus(2, "ch.elexis.core.ui", 0, "Error opening part", (Exception)((Object)ex), 3);
                    StatusManager.getManager().handle((IStatus)status, 2);
                    return;
                }
                Konsultation kons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
                if (kons == null) {
                    SWTHelper.showError((String)"Keine Konsultation aktiv", (String)"Es wirdeine aktive Konsultation ben\u00f6tigt um die KG drucken und ablegen zu k\u00f6nnen.");
                    return;
                }
                apv.doPrint(kons, null, ArchivKG.this.sortRev);
                p.hideView((IViewPart)apv);
            }
        };
    }

    public void dispose() {
        if (this.actAutoAkt.isChecked()) {
            CoreHub.heart.removeListener((Heartbeat.HeartListener)this);
        }
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this});
        super.dispose();
    }

    public void heartbeat() {
        this.refresh();
    }

    public static class KonsAendernAct
    extends Action {
        KonsAendernAct() {
            super("Konsultations Datum/Zeit \u00e4ndern");
            this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
            this.setToolTipText("Konsultations Datum/Zeit \u00e4ndern");
        }

        public void run() {
            Konsultation kons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
            if (kons == null || !kons.isEditable(false)) {
                MessageDialog.openError(null, (String)"Keine/Ung\u00fcltige Konsultation ausgew\u00e4hlt", (String)"Es muss eine ver\u00e4nderbare Konsultation ausgew\u00e4hlt sein.");
                return;
            }
            new NeueKonsDialog(Hub.getActiveShell(), kons).open();
        }
    }

    public static class NeueKonsAct
    extends Action {
        private int typ;

        public NeueKonsAct(int typ) {
            super(Messages.GlobalActions_NewKons);
            this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
            if (typ == 1) {
                this.setText("Neue Telefonkonsultation");
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.hilotec.elexis.kgview", (String)"rsc/phone.png"));
                this.setToolTipText("Neue Telefonkonsultation anlegen");
            } else if (typ == 2) {
                this.setText("Neuer Hausbesuch");
                this.setImageDescriptor(Images.IMG_HOME.getImageDescriptor());
                this.setToolTipText("Neuen Hausbesuch anlegen");
            } else {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.GlobalActions_NewKonsToolTip);
            }
            this.typ = typ;
        }

        public void run() {
            Fall fall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
            Patient pat = ElexisEventDispatcher.getSelectedPatient();
            if (fall == null || !fall.isOpen() || !fall.getPatient().equals((Object)pat)) {
                MessageDialog.openError(null, (String)"Kein offener Fall ausgew\u00e4hlt", (String)"Um eine neue Konsultation erstellen zu k\u00f6nnen, muss ein offener Fall ausgew\u00e4hlt werden");
                return;
            }
            new NeueKonsDialog(Hub.getActiveShell(), fall, this.typ).open();
        }
    }
}

