/*
 * Decompiled with CFR 0.152.
 */
package ch.weirich.templator.pages;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.medelexis.templator.model.IProcessor;
import ch.medelexis.templator.model.ProcessingSchema;
import ch.medelexis.templator.model.SchemaFilterOutputStream;
import ch.medelexis.templator.model.StorageController;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.weirich.templator.pages.Preferences;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class PagesProcessor
implements IProcessor {
    private ProcessingSchema proc;

    public String getName() {
        return "Apple(tm) iWork(tm) Pages(tm)";
    }

    public boolean doOutput(ProcessingSchema schema) {
        this.proc = schema;
        File tmpl = schema.getTemplateFile();
        if (!tmpl.exists()) {
            SWTHelper.alert((String)"Template missing", (String)MessageFormat.format("Konnte Vorlagedatei {0} nicht \u00f6ffnen", tmpl.getAbsolutePath()));
            return false;
        }
        try {
            Process process;
            ZipEntry ze;
            ZipInputStream zis = new ZipInputStream(new FileInputStream(tmpl));
            Patient actPatient = ElexisEventDispatcher.getSelectedPatient();
            StorageController sc = StorageController.getInstance();
            File output = null;
            output = sc.createFile(actPatient, tmpl.getName());
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(output));
            while ((ze = zis.getNextEntry()) != null) {
                ZipEntry zo = new ZipEntry(ze.getName());
                zos.putNextEntry(zo);
                zo.setMethod(8);
                if (ze.getName().equals("index.xml")) {
                    SchemaFilterOutputStream sfo = new SchemaFilterOutputStream(this.proc, (OutputStream)zos, (IProcessor)this);
                    FileTool.copyStreams((InputStream)zis, (OutputStream)sfo);
                    continue;
                }
                FileTool.copyStreams((InputStream)zis, (OutputStream)zos);
            }
            zos.finish();
            zis.close();
            zos.close();
            String cmd = CoreHub.localCfg.get(String.valueOf(Preferences.PREFERENCE_BRANCH) + "cmd", "open");
            String param = CoreHub.localCfg.get("briefe/medelexis-templator/oooprocessor/param", "%");
            int i = param.indexOf(37);
            if (i != -1) {
                param = String.valueOf(param.substring(0, i)) + output.getAbsolutePath() + param.substring(i + 1);
            }
            return (process = Runtime.getRuntime().exec(new String[]{cmd, param})).waitFor() == 0;
        }
        catch (Exception e) {
            ExHandler.handle((Throwable)e);
            SWTHelper.alert((String)"Pages Processor", (String)("Problem mit dem Erstellen des Dokuments " + e.getMessage()));
            return false;
        }
    }

    public String convert(String input) {
        String replacement = input.replaceAll("\\t", "<sf:tab/>");
        replacement = replacement.replaceAll("\\n", "<sf:br/>");
        return replacement;
    }
}

