/*
 * Decompiled with CFR 0.152.
 */
package ch.pharmed.phmprescriber;

import ch.elexis.core.data.activator.CoreHub;
import ch.pharmed.phmprescriber.Physician;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PhMPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Physician ph;
    private Text textboxZSRid;
    private Text textboxTitle;
    private Text textboxFirstname;
    private Text textboxLastname;
    private Text textboxStreet;
    private Text textboxPostbox;
    private Text textboxZip;
    private Text textboxCity;
    private Text textboxPhone;
    private Text textboxFax;
    private Text textboxSpecialty1;
    private Text textboxSpecialty2;
    private Text textboxGLNid;
    private Composite compAddress;
    private Composite compInteraction;
    private Button btngetAddress;
    private Button btnCboInteraction;
    private ResourceBundle messages;

    public PhMPreferencePage() {
        String language = "de";
        String country = "CH";
        Locale currentLocale = new Locale(language, country);
        this.messages = ResourceBundle.getBundle("ch.pharmed.phmprescriber.MessagesBundle", currentLocale);
    }

    public void init(IWorkbench workbench) {
        this.ph = new Physician();
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Group zsrgroup = new Group(container, 0);
        zsrgroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        zsrgroup.setLayout((Layout)new GridLayout(2, false));
        zsrgroup.setText(this.messages.getString("PhMPreferencePage_0"));
        Label lblZSR = new Label((Composite)zsrgroup, 0);
        lblZSR.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblZSR.setText(this.messages.getString("PhMPreferencePage_1"));
        this.textboxZSRid = new Text((Composite)zsrgroup, 2048);
        this.textboxZSRid.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.textboxZSRid.setMessage(this.messages.getString("PhMPreferencePage_2"));
        this.compAddress = new Composite(container, 0);
        this.compAddress.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.compAddress.setLayout((Layout)new GridLayout(3, false));
        AddressSelectionButtonListener AddressSL = new AddressSelectionButtonListener();
        this.btngetAddress = new Button(this.compAddress, 8);
        this.btngetAddress.setText(this.messages.getString("PhMPreferencePage_3"));
        this.btngetAddress.addSelectionListener((SelectionListener)AddressSL);
        Group addressgroup = new Group(container, 0);
        addressgroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        addressgroup.setLayout((Layout)new GridLayout(4, false));
        addressgroup.setText(this.messages.getString("PhMPreferencePage_4"));
        Label lblAnrede = new Label((Composite)addressgroup, 0);
        lblAnrede.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAnrede.setText(this.messages.getString("PhMPreferencePage_5"));
        this.textboxTitle = new Text((Composite)addressgroup, 2048);
        this.textboxTitle.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.textboxTitle.setMessage(this.messages.getString("PhMPreferencePage_6"));
        Label lblFirstname = new Label((Composite)addressgroup, 0);
        lblFirstname.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFirstname.setText(this.messages.getString("PhMPreferencePage_7"));
        this.textboxFirstname = new Text((Composite)addressgroup, 2048);
        this.textboxFirstname.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblLastname = new Label((Composite)addressgroup, 0);
        lblLastname.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLastname.setText(this.messages.getString("PhMPreferencePage_8"));
        this.textboxLastname = new Text((Composite)addressgroup, 2048);
        this.textboxLastname.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblStreet = new Label((Composite)addressgroup, 0);
        lblStreet.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblStreet.setText(this.messages.getString("PhMPreferencePage_9"));
        this.textboxStreet = new Text((Composite)addressgroup, 2048);
        this.textboxStreet.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblPobo = new Label((Composite)addressgroup, 0);
        lblPobo.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPobo.setText(this.messages.getString("PhMPreferencePage_10"));
        this.textboxPostbox = new Text((Composite)addressgroup, 2048);
        this.textboxPostbox.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblZip = new Label((Composite)addressgroup, 0);
        lblZip.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblZip.setText(this.messages.getString("PhMPreferencePage_11"));
        this.textboxZip = new Text((Composite)addressgroup, 2048);
        this.textboxZip.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblCity = new Label((Composite)addressgroup, 0);
        lblCity.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCity.setText(this.messages.getString("PhMPreferencePage_12"));
        this.textboxCity = new Text((Composite)addressgroup, 2048);
        this.textboxCity.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblPhone = new Label((Composite)addressgroup, 0);
        lblPhone.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPhone.setText(this.messages.getString("PhMPreferencePage_13"));
        this.textboxPhone = new Text((Composite)addressgroup, 2048);
        this.textboxPhone.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblFax = new Label((Composite)addressgroup, 0);
        lblFax.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFax.setText(this.messages.getString("PhMPreferencePage_14"));
        this.textboxFax = new Text((Composite)addressgroup, 2048);
        this.textboxFax.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblGLNid = new Label((Composite)addressgroup, 0);
        lblGLNid.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblGLNid.setText(this.messages.getString("PhMPreferencePage_15"));
        this.textboxGLNid = new Text((Composite)addressgroup, 2048);
        this.textboxGLNid.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblSpecialty1 = new Label((Composite)addressgroup, 0);
        lblSpecialty1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSpecialty1.setText(this.messages.getString("PhMPreferencePage_16"));
        this.textboxSpecialty1 = new Text((Composite)addressgroup, 2048);
        this.textboxSpecialty1.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblSpecialty2 = new Label((Composite)addressgroup, 0);
        lblSpecialty2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSpecialty2.setText(this.messages.getString("PhMPreferencePage_17"));
        this.textboxSpecialty2 = new Text((Composite)addressgroup, 2048);
        this.textboxSpecialty2.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.compInteraction = new Composite(container, 0);
        this.compInteraction.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.compInteraction.setLayout((Layout)new GridLayout(3, false));
        InteractionSelectionButtonListener interactionSL = new InteractionSelectionButtonListener();
        this.btnCboInteraction = new Button(this.compInteraction, 32);
        this.btnCboInteraction.setData((Object)"ch.pharmed.phmprescriber/check_interactions");
        this.btnCboInteraction.setText(this.messages.getString("PhMPreferencePage_18"));
        this.btnCboInteraction.addSelectionListener((SelectionListener)interactionSL);
        String interactionsEnabled = CoreHub.globalCfg.get("ch.pharmed.phmprescriber/check_interactions", "ch.pharmed.phmprescriber/check_interactions");
        if (interactionsEnabled.equals("true")) {
            this.btnCboInteraction.setSelection(true);
        }
        this.bindData();
        return container;
    }

    protected void bindData() {
        this.textboxZSRid.setText(this.ph.getZsrid());
        this.textboxTitle.setText(this.ph.getTitle());
        this.textboxFirstname.setText(this.ph.getFirstname());
        this.textboxLastname.setText(this.ph.getLastname());
        this.textboxStreet.setText(this.ph.getStreet());
        this.textboxPostbox.setText(this.ph.getPostbox());
        this.textboxZip.setText(this.ph.getZip());
        this.textboxCity.setText(this.ph.getCity());
        this.textboxPhone.setText(this.ph.getPhone());
        this.textboxFax.setText(this.ph.getFax());
        this.textboxSpecialty1.setText(this.ph.getSpecialty1());
        this.textboxSpecialty2.setText(this.ph.getSpecialty2());
        this.textboxGLNid.setText(this.ph.getGlnid());
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void performApply() {
        String strCfg = this.createCFGString();
        CoreHub.globalCfg.set("ch.pharmed.phmprescriber/global_physician", strCfg.toString());
        CoreHub.globalCfg.flush();
    }

    private String createCFGString() {
        String returnValue = "";
        returnValue = String.valueOf(returnValue) + this.textboxZSRid.getText().replace(";", "") + ";";
        returnValue = String.valueOf(returnValue) + this.textboxGLNid.getText().replace(";", "") + ";";
        returnValue = String.valueOf(returnValue) + this.textboxTitle.getText().replace(";", "") + ";";
        returnValue = String.valueOf(returnValue) + this.textboxFirstname.getText().replace(";", "") + ";";
        returnValue = String.valueOf(returnValue) + this.textboxLastname.getText().replace(";", "") + ";";
        returnValue = String.valueOf(returnValue) + this.textboxStreet.getText().replace(";", "") + ";";
        returnValue = String.valueOf(returnValue) + this.textboxPostbox.getText().replace(";", "") + ";";
        returnValue = String.valueOf(returnValue) + this.textboxZip.getText().replace(";", "") + ";";
        returnValue = String.valueOf(returnValue) + this.textboxCity.getText().replace(";", "") + ";";
        returnValue = String.valueOf(returnValue) + this.textboxPhone.getText().replace(";", "") + ";";
        returnValue = String.valueOf(returnValue) + this.textboxFax.getText().replace(";", "") + ";";
        returnValue = String.valueOf(returnValue) + this.textboxSpecialty1.getText().replace(";", "") + ";";
        returnValue = String.valueOf(returnValue) + this.textboxSpecialty2.getText().replace(";", "");
        return returnValue;
    }

    private class AddressSelectionButtonListener
    extends SelectionAdapter {
        private AddressSelectionButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String zsrid = PhMPreferencePage.this.textboxZSRid.getText();
            PhMPreferencePage.this.ph.getAttributesFromWeb(zsrid);
            PhMPreferencePage.this.bindData();
        }
    }

    private class InteractionSelectionButtonListener
    extends SelectionAdapter {
        private InteractionSelectionButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String interactionEnabled = "true";
            if (!((Button)e.widget).getSelection()) {
                interactionEnabled = "false";
            }
            CoreHub.globalCfg.set("ch.pharmed.phmprescriber/check_interactions", interactionEnabled);
        }
    }
}

