/*
 * Decompiled with CFR 0.152.
 */
package ch.novcom.elexis.mednet.plugin.data;

import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.data.services.IDocumentManager;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.types.PathologicDescription;
import ch.elexis.core.ui.text.GenericDocument;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.novcom.elexis.mednet.plugin.MedNet;
import ch.novcom.elexis.mednet.plugin.data.ContactLinkRecord;
import ch.novcom.elexis.mednet.plugin.data.DocumentImporter;
import ch.novcom.elexis.mednet.plugin.messages.MedNetMessages;
import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatientDocumentManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DocumentImporter.class.getName());
    public static String DEFAULT_PRIO = "1";
    public static String DEFAULT_PRIO_DOCUMENT = "0";
    private static String FLD_ORGIN = "Quelle";
    private static int MAX_LEN_RESULT = 80;
    private final Patient patient;
    private IDocumentManager omnivoreDocManager;
    private boolean overwriteResults = false;
    private static SimpleDateFormat LABRESULT_TIMESTAMP_FORMATTER = new SimpleDateFormat("yyyyMMddHHmmss");
    private static SimpleDateFormat LABRESULT_TIME_FORMATTER = new SimpleDateFormat("HHmmss");

    public PatientDocumentManager(Patient patient) {
        this.patient = patient;
        this.initDocumentManager();
    }

    private void initDocumentManager() {
        String logPrefix = "initDocumentManager() - ";
        Object omnivore = Extensions.findBestService((String)"DocumentManagement");
        if (omnivore != null) {
            this.omnivoreDocManager = (IDocumentManager)omnivore;
        } else {
            LOGGER.error(String.valueOf(logPrefix) + "Omnivore has not been loaded");
        }
    }

    private void checkCreateCategory(String category) {
        String logPrefix = "checkCreateCategory() - ";
        if (category != null) {
            boolean catExists = false;
            String[] categories = this.omnivoreDocManager.getCategories();
            if (categories != null) {
                String[] stringArray = categories;
                int n = categories.length;
                int n2 = 0;
                while (n2 < n) {
                    String cat = stringArray[n2];
                    if (category.equals(cat)) {
                        catExists = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!catExists) {
                Boolean success = this.omnivoreDocManager.addCategorie(category);
                if (success.booleanValue()) {
                    LOGGER.info(String.valueOf(logPrefix) + "New Document category created in Omnivore: " + category);
                } else {
                    LOGGER.error(String.valueOf(logPrefix) + "Failed creating new document category in Omnivore: " + category);
                }
            }
        }
    }

    private boolean addDocumentToOmnivore(String title, String category, String dateStr, Path file, String keywords) throws IOException, ElexisException {
        String logPrefix = "addDocumentToOmnivore() - ";
        this.checkCreateCategory(category);
        List documentList = this.omnivoreDocManager.listDocuments(this.patient, category, title, null, new TimeSpan(String.valueOf(dateStr) + "-" + dateStr), null);
        if (documentList == null || documentList.size() == 0) {
            String mimeType = null;
            try {
                mimeType = Files.probeContentType(file);
                LOGGER.debug(String.valueOf(logPrefix) + "Mimetype for " + file.toString() + "  is " + mimeType);
            }
            catch (IOException | SecurityException e) {
                LOGGER.warn(String.valueOf(logPrefix) + "Unable to find the mimetype of the following file " + file.toString());
            }
            this.omnivoreDocManager.addDocument((IOpaqueDocument)new GenericDocument(this.patient, title, category, file.toFile(), dateStr, keywords, mimeType));
            LOGGER.debug(String.valueOf(logPrefix) + "This document has successfully been added to the omnivore database." + file.toString());
            return true;
        }
        LOGGER.warn(String.valueOf(logPrefix) + "This document already exists in the omnivore database. It will not be imported: " + title + " " + file.toString());
        return false;
    }

    private LabItem getLabItem(String institutionId, String shortname, LabItemTyp type) {
        Query qli = new Query(LabItem.class);
        qli.add("kuerzel", "=", shortname);
        qli.and();
        qli.add("LaborID", "=", institutionId);
        qli.and();
        qli.add("Typ", "=", new Integer(type.ordinal()).toString());
        LabItem labItem = null;
        List itemList = qli.execute();
        if (itemList.size() > 0) {
            labItem = (LabItem)itemList.get(0);
        }
        return labItem;
    }

    private LabResult getLabResult(LabItem labItem, String value, Date date) {
        Query qli = new Query(LabResult.class);
        qli.add("ItemID", "=", labItem.getId());
        qli.and();
        qli.add("observationtime", "=", LABRESULT_TIMESTAMP_FORMATTER.format(date));
        qli.and();
        qli.add("PatientID", "=", this.patient.getId());
        qli.and();
        qli.add("Resultat", "=", value);
        LabResult labResult = null;
        List resultList = qli.execute();
        if (resultList.size() > 0) {
            labResult = (LabResult)resultList.get(0);
        }
        return labResult;
    }

    public void addDocument(ContactLinkRecord contactLink, Kontakt institution, String orderId, Path file, Date documentDateTime, String keywords) throws IOException {
        SimpleDateFormat dateTimeFormatter;
        String title;
        String logPrefix = "addDocument() - ";
        if (this.omnivoreDocManager == null) {
            throw new IOException(MessageFormat.format(MedNetMessages.PatientDocumentManager_omnivoreNotInitialized, file.toString(), this.patient.getLabel()));
        }
        LabItem labItem = this.getLabItem(institution.getId(), MedNetMessages.PatientDocumentManager_documentId, LabItemTyp.DOCUMENT);
        if (labItem == null) {
            labItem = new LabItem(MedNetMessages.PatientDocumentManager_documentId, MedNetMessages.PatientDocumentManager_documentTitel, institution, "", "", "pdf", LabItemTyp.DOCUMENT, institution.getLabel(true), DEFAULT_PRIO_DOCUMENT);
        }
        if ((title = MessageFormat.format(MedNetMessages.PatientDocumentManager_LabResultTitle, orderId, (dateTimeFormatter = new SimpleDateFormat(MedNetMessages.PatientDocumentManager_LabResultTitleTransactionFormat)).format(documentDateTime), DocumentImporter.getBaseName(file), DocumentImporter.getExtension(file))).length() > MAX_LEN_RESULT) {
            title = String.valueOf(title.substring(0, title.length() - MAX_LEN_RESULT - 3)) + "...";
        }
        TimeTool documentDate = new TimeTool();
        documentDate.setTime(documentDateTime);
        String documentTime = LABRESULT_TIME_FORMATTER.format(documentDateTime);
        boolean saved = false;
        LabResult labResult = this.getLabResult(labItem, title, documentDateTime);
        if (labResult == null) {
            labResult = new LabResult(this.patient, documentDate, labItem, title, null);
            labResult.set(FLD_ORGIN, orderId);
            labResult.set("Zeit", documentTime);
            labResult.setObservationTime(documentDate);
            labResult.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_IMPORT));
            saved = true;
        } else if (this.overwriteResults || labResult.getObservationTime().getTimeInMillis() < documentDate.getTimeInMillis()) {
            LOGGER.warn(String.valueOf(logPrefix) + "An older version of this document will be overwritten:" + labItem.getKuerzel() + "-" + labItem.getName() + " " + labResult.getObservationTime().toDBString(true) + " " + documentDate.toDBString(true) + " " + labResult.getResult() + " " + title + " ");
            labResult.setResult(title);
            labResult.set("Zeit", documentTime);
            labResult.setObservationTime(documentDate);
            labResult.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_IMPORT));
            saved = true;
        } else {
            LOGGER.warn(String.valueOf(logPrefix) + "An new version of this document is still in the database:" + labItem.getKuerzel() + "-" + labItem.getName() + " " + labResult.getObservationTime().toDBString(true) + " " + documentDate.toDBString(true) + " " + labResult.getResult() + " " + title + " ");
        }
        if (saved) {
            try {
                String dateTimeDocumentString = documentDate.toString(4);
                String categorylabel = null;
                if (contactLink != null) {
                    String category;
                    Kontakt kontakt = Kontakt.load((String)contactLink.getContactID());
                    String name = kontakt.getLabel(true);
                    if (name == null || name.isEmpty()) {
                        name = MedNet.getSettings().getInstitutions().get(contactLink.getMedNetID());
                    }
                    categorylabel = (category = contactLink.getCategoryDoc()) == null || category.isEmpty() ? name : MessageFormat.format(MedNetMessages.Omnivore_category_formlabel, name, category);
                } else {
                    categorylabel = institution.getLabel(true);
                }
                this.addDocumentToOmnivore(title, categorylabel, dateTimeDocumentString, file, keywords);
                LOGGER.info(String.valueOf(logPrefix) + "Document successfully saved to omnivore:" + title);
            }
            catch (ElexisException e) {
                throw new IOException(MessageFormat.format(MedNetMessages.PatientLabor_errorAddingDocumentToOmnivore, file.toString()), e);
            }
        }
    }

    public void addForm(ContactLinkRecord contactLink, String institutionName, String formularName, String orderId, Path file, Date documentDateTime, String keywords) throws IOException {
        String logPrefix = "addForm() - ";
        if (this.omnivoreDocManager == null) {
            throw new IOException(MessageFormat.format(MedNetMessages.PatientDocumentManager_omnivoreNotInitialized, file.toString(), this.patient.getLabel()));
        }
        String categorylabel = null;
        if (contactLink != null) {
            String category;
            Kontakt kontakt = Kontakt.load((String)contactLink.getContactID());
            String name = kontakt.getLabel(true);
            if (name == null || name.isEmpty()) {
                name = MedNet.getSettings().getInstitutions().get(contactLink.getMedNetID());
            }
            categorylabel = (category = contactLink.getCategoryForm()) == null || category.isEmpty() ? name : MessageFormat.format(MedNetMessages.Omnivore_category_formlabel, name, category);
        } else {
            categorylabel = institutionName;
        }
        SimpleDateFormat dateTimeFormatter = new SimpleDateFormat(MedNetMessages.PatientDocumentManager_LabResultTitleTransactionFormat);
        String title = MessageFormat.format(MedNetMessages.PatientDocumentManager_FormTitle, formularName, orderId, dateTimeFormatter.format(documentDateTime), DocumentImporter.getBaseName(file), DocumentImporter.getExtension(file));
        if (title.length() > MAX_LEN_RESULT) {
            title = String.valueOf(title.substring(0, title.length() - MAX_LEN_RESULT - 3)) + "...";
        }
        TimeTool documentDate = new TimeTool();
        documentDate.setTime(documentDateTime);
        try {
            String dateTimeDocumentString = documentDate.toString(4);
            this.addDocumentToOmnivore(title, categorylabel, dateTimeDocumentString, file, keywords);
            LOGGER.info(String.valueOf(logPrefix) + "Document successfully saved to omnivore:" + title);
        }
        catch (ElexisException e) {
            throw new IOException(MessageFormat.format(MedNetMessages.PatientLabor_errorAddingDocumentToOmnivore, file.toString()), e);
        }
    }
}

