/*
 * Decompiled with CFR 0.152.
 */
package ch.novcom.elexis.mednet.plugin;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MedNetConfigDocumentPath
implements Comparable<MedNetConfigDocumentPath> {
    private static final Pattern csvLinePattern = Pattern.compile("^\"(?<accountID>[^\"]*)\";\"(?<accountTitle>[^\"]*)\";\"(?<accountLastname>[^\"]*)\";\"(?<accountFirstname>[^\"]*)\";\"(?<institutionID>[^\"]*)\";\"(?<institutionName>[^\"]*)\";\"(?<type>[^\"]*)\";\"(?<path>[^\"]*)\"$");
    private String accountID;
    private String accountTitle;
    private String accountLastname;
    private String accountFirstname;
    private String institutionID;
    private String institutionName;
    private Path path;

    public MedNetConfigDocumentPath(String fileLine) {
        Matcher matcher = csvLinePattern.matcher(fileLine);
        if (matcher.matches()) {
            this.accountID = matcher.group("accountID");
            this.accountTitle = matcher.group("accountTitle");
            this.accountLastname = matcher.group("accountLastname");
            this.accountFirstname = matcher.group("accountFirstname");
            this.institutionID = matcher.group("institutionID");
            this.institutionName = matcher.group("institutionName");
            this.path = Paths.get(matcher.group("path"), new String[0]);
        }
    }

    public String getKey() {
        return String.valueOf(this.accountID) + "_" + this.institutionID;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public String getAccountTitle() {
        return this.accountTitle;
    }

    public String getAccountLastname() {
        return this.accountLastname;
    }

    public String getAccountFirstname() {
        return this.accountFirstname;
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public int compareTo(MedNetConfigDocumentPath other) {
        if (other == null) {
            return -1;
        }
        if (this.getAccountID() != null && other.getAccountID() == null) {
            return -1;
        }
        if (this.getAccountID() == null && other.getAccountID() != null) {
            return 1;
        }
        int comparator = this.getAccountID().compareTo(other.getAccountID());
        if (comparator != 0) {
            return comparator;
        }
        if (this.getInstitutionID() != null && other.getInstitutionID() == null) {
            return -1;
        }
        if (this.getInstitutionID() == null && other.getInstitutionID() != null) {
            return 1;
        }
        return this.getInstitutionID().compareTo(other.getInstitutionID());
    }
}

