/*
 * Decompiled with CFR 0.152.
 */
package ch.novcom.elexis.mednet.plugin;

import ch.novcom.elexis.mednet.plugin.MedNet;
import ch.novcom.elexis.mednet.plugin.MedNetConfigFormPath;
import ch.novcom.elexis.mednet.plugin.data.DocumentImporter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)FormWatcher.class.getName());
    private final WatchService watcher;

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    public FormWatcher() throws IOException {
        String logPrefix = "constructor() - ";
        Map<String, MedNetConfigFormPath> configFormPaths = MedNet.getSettings().getConfigFormPaths();
        if (configFormPaths != null && configFormPaths.size() > 0) {
            TreeSet<Path> toWatch = new TreeSet<Path>();
            for (MedNetConfigFormPath configFormPath : configFormPaths.values()) {
                Path path = configFormPath.getPath();
                if (Files.isDirectory(path, new LinkOption[0])) {
                    toWatch.add(path);
                    continue;
                }
                LOGGER.warn(String.valueOf(logPrefix) + "Configured Form Path is not a valid directory: " + path.toString());
            }
            if (toWatch.size() > 0) {
                this.watcher = FileSystems.getDefault().newWatchService();
                for (Path path : toWatch) {
                    LOGGER.info(String.valueOf(logPrefix) + "Following path will be monitored: " + path.toString());
                    path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE);
                }
            } else {
                LOGGER.warn(String.valueOf(logPrefix) + "no valid Form Path configured");
                this.watcher = null;
            }
        } else {
            LOGGER.warn(String.valueOf(logPrefix) + "MedNet is not configured");
            this.watcher = null;
        }
    }

    void processEvents() {
        WatchKey key;
        boolean valid;
        if (this.watcher == null) {
            return;
        }
        ArrayList<Path> files = new ArrayList<Path>();
        Map<String, MedNetConfigFormPath> configFormPaths = MedNet.getSettings().getConfigFormPaths();
        if (configFormPaths != null && configFormPaths.size() > 0) {
            for (MedNetConfigFormPath configFormPath : configFormPaths.values()) {
                Path path = configFormPath.getPath();
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                try {
                    Throwable throwable = null;
                    Object var7_12 = null;
                    try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                        for (Path file : directoryStream) {
                            if (!Files.isReadable(file) || !Files.isRegularFile(file, new LinkOption[0]) || !file.getFileName().toString().toLowerCase().endsWith(".pdf")) continue;
                            files.add(file);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        Collections.sort(files, new DateTimeAscending());
        for (Path file : files) {
            this.importForm(file);
        }
        do {
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException x) {
                return;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent ev = FormWatcher.cast(event);
                Path name = (Path)ev.context();
                Path dir = (Path)key.watchable();
                Path file = dir.resolve(name);
                if (!file.getFileName().toString().toLowerCase().endsWith(".pdf")) continue;
                this.importForm(file);
            }
        } while (valid = key.reset());
    }

    private void importForm(Path file) {
        block25: {
            String logPrefix = "importForm() - ";
            if (file != null && Files.isReadable(file) && Files.isRegularFile(file, new LinkOption[0]) && file.getFileName().toString().toLowerCase().endsWith(".pdf")) {
                try {
                    Path tempDir = Files.createTempDirectory("ch.novcom.elexis.mednet.plugin", new FileAttribute[0]);
                    Path tempFile = tempDir.resolve(file.getFileName());
                    Path errorDir = file.getParent().resolve("error");
                    Path archiveDir = file.getParent().resolve("archive");
                    if (!Files.exists(errorDir, new LinkOption[0])) {
                        LOGGER.info(String.valueOf(logPrefix) + "Error directory doesn't exist, create it. " + errorDir.toString());
                        try {
                            Files.createDirectory(errorDir, new FileAttribute[0]);
                        }
                        catch (IOException | SecurityException ex) {
                            LOGGER.error(String.valueOf(logPrefix) + "Unable to create the error directory. Abort import. " + errorDir.toString(), (Throwable)ex);
                            return;
                        }
                    } else if (!Files.isDirectory(errorDir, new LinkOption[0])) {
                        LOGGER.error(String.valueOf(logPrefix) + "Error directory is not a valid directory. Abort import. " + errorDir.toString());
                        return;
                    }
                    if (!Files.exists(archiveDir, new LinkOption[0])) {
                        LOGGER.info(String.valueOf(logPrefix) + "Archive directory doesn't exist, create it. " + archiveDir.toString());
                        try {
                            Files.createDirectory(archiveDir, new FileAttribute[0]);
                        }
                        catch (IOException | SecurityException ex) {
                            LOGGER.error(String.valueOf(logPrefix) + "Unable to create the archive directory. Abort import. " + archiveDir.toString(), (Throwable)ex);
                            return;
                        }
                    } else if (!Files.isDirectory(archiveDir, new LinkOption[0])) {
                        LOGGER.error(String.valueOf(logPrefix) + "Archive directory is not a valid directory. Abort import. " + errorDir.toString());
                        return;
                    }
                    int trying = 0;
                    while (trying < 50) {
                        try {
                            Files.move(file, tempFile, StandardCopyOption.REPLACE_EXISTING);
                            break;
                        }
                        catch (IOException iOException) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                LOGGER.error(String.valueOf(logPrefix) + "waiting the file to be moved interrupted");
                                return;
                            }
                        }
                    }
                    if (trying >= 50) {
                        return;
                    }
                    boolean success = DocumentImporter.processForm(tempFile, true);
                    if (success) {
                        LOGGER.info(String.valueOf(logPrefix) + "Successfully imported document: " + file.toString());
                        Files.move(tempFile, archiveDir.resolve(file.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
                        break block25;
                    }
                    LOGGER.error(String.valueOf(logPrefix) + "Failed importing document: " + file.toString());
                    Files.move(tempFile, errorDir.resolve(file.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    LOGGER.error(String.valueOf(logPrefix) + "IOException importing document: " + file.toString() + " ", (Throwable)e);
                }
            } else if (file != null && !Files.isReadable(file)) {
                LOGGER.warn(String.valueOf(logPrefix) + "Following file is not readable: " + file.toString());
            } else if (file != null) {
                LOGGER.warn(String.valueOf(logPrefix) + "Following file is not valid: " + file.toString());
            } else {
                LOGGER.warn(String.valueOf(logPrefix) + "The file is null ");
            }
        }
    }

    private final class DateTimeAscending
    implements Comparator<Path> {
        private DateTimeAscending() {
        }

        @Override
        public int compare(Path arg0, Path arg1) {
            try {
                return Files.getLastModifiedTime(arg0, new LinkOption[0]).compareTo(Files.getLastModifiedTime(arg1, new LinkOption[0]));
            }
            catch (IOException e) {
                return 0;
            }
        }
    }
}

