/*
 * Decompiled with CFR 0.152.
 */
package ch.novcom.elexis.mednet.plugin;

import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.novcom.elexis.mednet.plugin.MedNet;
import ch.novcom.elexis.mednet.plugin.MedNetConfigDocumentPath;
import ch.novcom.elexis.mednet.plugin.data.ContactLinkRecord;
import ch.novcom.elexis.mednet.plugin.data.DocumentImporter;
import ch.novcom.elexis.mednet.plugin.messages.MedNetMessages;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentImporterPage
extends ImporterPage {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DocumentImporterPage.class.getName());
    private static final boolean OVERWRITEOLDERENTRIES = true;
    private static final Pattern hl7FilenamePattern = Pattern.compile("^([^_]*_)*(?<transactionDateTime>[^_]+)_(?<orderNr>[^_]+)_(?<recipient>\\d+)$");
    private static final Pattern pdfFilenamePattern = Pattern.compile("^([^_]*_)*(?<uniqueMessageId>[^_]+)_(?<caseNr>[^_]*)_(?<transactionDateTime>[^_]*)_(?<orderNr>[^_]+)_(?<samplingDateTime>[^_]*)_(?<PatientLastName>[^_]*)_(?<PatientBirthdate>[^_]*)_(?<PatientId>[^_]*)_(?<recipient>\\d+)$");

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        String logPrefix = "doImport() - ";
        Set<MedNetConfigDocumentPath> configFormPaths = MedNet.getSettings().getConfigDocumentPaths();
        if (monitor != null) {
            monitor.beginTask(MedNetMessages.DocumentImporterPage_callMedNet, (configFormPaths.size() + 1) * 100);
        }
        LOGGER.info(String.valueOf(logPrefix) + "call MedNet getResults()");
        MedNet.getDocuments();
        if (monitor != null) {
            monitor.worked(100);
        }
        ArrayList<String> importFailures = new ArrayList<String>();
        ArrayList<String> importSuccess = new ArrayList<String>();
        for (MedNetConfigDocumentPath configFormPath : configFormPaths) {
            FilePair pair;
            String hl7FileName;
            Path hl7File;
            Path archiveDir;
            Path errorDir;
            Path directory;
            Kontakt institutionKontakt;
            ContactLinkRecord contactLink;
            block52: {
                block51: {
                    contactLink = null;
                    institutionKontakt = null;
                    List<ContactLinkRecord> list = ContactLinkRecord.getContactLinkRecord(null, configFormPath.getInstitutionID());
                    if (list == null || list.size() <= 0) {
                        LOGGER.warn(String.valueOf(logPrefix) + "Following institution is not configured " + configFormPath.getInstitutionName() + " " + configFormPath.getInstitutionID());
                        continue;
                    }
                    contactLink = list.get(0);
                    institutionKontakt = Kontakt.load((String)contactLink.getContactID());
                    if (contactLink == null || institutionKontakt == null) {
                        LOGGER.warn(String.valueOf(logPrefix) + "No contact found for " + configFormPath.getInstitutionName() + " " + configFormPath.getInstitutionID());
                        continue;
                    }
                    if (!contactLink.docImport_isActive()) {
                        LOGGER.info(String.valueOf(logPrefix) + "import ignored for " + institutionKontakt.getLabel(true));
                        continue;
                    }
                    if (monitor != null && monitor.isCanceled()) {
                        LOGGER.info(String.valueOf(logPrefix) + "import canceled");
                        break;
                    }
                    LOGGER.info(String.valueOf(logPrefix) + "Processing Institution " + institutionKontakt.getLabel(true));
                    if (monitor != null) {
                        monitor.subTask(MessageFormat.format(MedNetMessages.DocumentImporterPage_checkInstitution, configFormPath.getInstitutionName()));
                    }
                    directory = configFormPath.getPath();
                    errorDir = directory.resolve("error");
                    archiveDir = directory.resolve("archive");
                    if (!Files.exists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
                        LOGGER.warn(String.valueOf(logPrefix) + "The following directory is not valid:" + directory.toString());
                        if (monitor == null) continue;
                        monitor.worked(100);
                        continue;
                    }
                    if (!Files.exists(errorDir, new LinkOption[0])) {
                        LOGGER.info(String.valueOf(logPrefix) + "Error directory doesn't exist, create it. " + errorDir.toString());
                        try {
                            Files.createDirectory(errorDir, new FileAttribute[0]);
                            break block51;
                        }
                        catch (IOException | SecurityException ex) {
                            LOGGER.error(String.valueOf(logPrefix) + "Unable to create the error directory. Abort import. " + errorDir.toString(), (Throwable)ex);
                            if (monitor == null) continue;
                            monitor.worked(100);
                            continue;
                        }
                    }
                    if (!Files.isDirectory(errorDir, new LinkOption[0])) {
                        LOGGER.error(String.valueOf(logPrefix) + "Error directory is not a valid directory. Abort import. " + errorDir.toString());
                        if (monitor == null) continue;
                        monitor.worked(100);
                        continue;
                    }
                }
                if (!Files.exists(archiveDir, new LinkOption[0])) {
                    LOGGER.info(String.valueOf(logPrefix) + "Archive directory doesn't exist, create it. " + archiveDir.toString());
                    try {
                        Files.createDirectory(archiveDir, new FileAttribute[0]);
                        break block52;
                    }
                    catch (IOException | SecurityException ex) {
                        LOGGER.error(String.valueOf(logPrefix) + "Unable to create the archive directory. Abort import. " + archiveDir.toString(), (Throwable)ex);
                        if (monitor == null) continue;
                        monitor.worked(100);
                        continue;
                    }
                }
                if (!Files.isDirectory(archiveDir, new LinkOption[0])) {
                    LOGGER.error(String.valueOf(logPrefix) + "Archive directory is not a valid directory. Abort import. " + errorDir.toString());
                    if (monitor == null) continue;
                    monitor.worked(100);
                    continue;
                }
            }
            DirectoryStream<Path> hl7Stream = Files.newDirectoryStream(directory, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) throws IOException {
                    return Files.isRegularFile(entry, new LinkOption[0]) && entry.getFileName().toString().toLowerCase().endsWith(".hl7");
                }
            });
            ArrayList<Path> hl7Files = new ArrayList<Path>();
            for (Path file : hl7Stream) {
                hl7Files.add(file);
            }
            DirectoryStream<Path> pdfStream = Files.newDirectoryStream(directory, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) throws IOException {
                    return Files.isRegularFile(entry, new LinkOption[0]) && entry.getFileName().toString().toLowerCase().endsWith(".pdf");
                }
            });
            ArrayList<Path> pdfFiles = new ArrayList<Path>();
            for (Path file : pdfStream) {
                pdfFiles.add(file);
            }
            ArrayList<FilePair> pairList = new ArrayList<FilePair>();
            ListIterator hl7FilesIterator = hl7Files.listIterator();
            block15: while (hl7FilesIterator.hasNext()) {
                if (monitor != null && monitor.isCanceled()) break;
                hl7File = (Path)hl7FilesIterator.next();
                hl7FileName = DocumentImporter.getBaseName(hl7File);
                ListIterator pdfFilesIterator = pdfFiles.listIterator();
                while (pdfFilesIterator.hasNext()) {
                    if (monitor != null && monitor.isCanceled()) break block15;
                    Path pdfFile = (Path)pdfFilesIterator.next();
                    String pdfFileName = DocumentImporter.getBaseName(pdfFile);
                    if (!hl7FileName.equals(pdfFileName)) continue;
                    FilePair pair2 = new FilePair();
                    pair2.hl7 = hl7File;
                    pair2.pdf = pdfFile;
                    pairList.add(pair2);
                    FileTime hl7FileTime = Files.getLastModifiedTime(hl7File, new LinkOption[0]);
                    FileTime pdfFileTime = Files.getLastModifiedTime(pdfFile, new LinkOption[0]);
                    if (hl7FileTime.compareTo(pdfFileTime) > 0) {
                        pair2.fileTime = hl7FileTime;
                    }
                    pdfFilesIterator.remove();
                    hl7FilesIterator.remove();
                    continue block15;
                }
            }
            hl7FilesIterator = hl7Files.listIterator();
            block17: while (hl7FilesIterator.hasNext()) {
                if (monitor != null && monitor.isCanceled()) break;
                hl7File = (Path)hl7FilesIterator.next();
                hl7FileName = DocumentImporter.getBaseName(hl7File);
                String hl7_transactionDateTime = "";
                String hl7_orderNr = "";
                String hl7_recipient = "";
                Matcher filenameMatcher = hl7FilenamePattern.matcher(hl7FileName);
                if (filenameMatcher.matches()) {
                    hl7_transactionDateTime = filenameMatcher.group("transactionDateTime");
                    hl7_orderNr = filenameMatcher.group("orderNr");
                    hl7_recipient = filenameMatcher.group("recipient");
                }
                ListIterator pdfFilesIterator = pdfFiles.listIterator();
                while (pdfFilesIterator.hasNext()) {
                    if (monitor != null && monitor.isCanceled()) break block17;
                    Path pdfFile = (Path)pdfFilesIterator.next();
                    String pdfFileName = DocumentImporter.getBaseName(pdfFile);
                    filenameMatcher = pdfFilenamePattern.matcher(pdfFileName);
                    if (!filenameMatcher.matches()) continue;
                    String pdf_transactionDateTime = filenameMatcher.group("transactionDateTime");
                    String pdf_orderNr = filenameMatcher.group("orderNr");
                    String pdf_recipient = filenameMatcher.group("recipient");
                    if (!hl7_transactionDateTime.equals(pdf_transactionDateTime) || !hl7_orderNr.equals(pdf_orderNr) || !hl7_recipient.equals(pdf_recipient)) continue;
                    FilePair pair3 = new FilePair();
                    pair3.hl7 = hl7File;
                    pair3.pdf = pdfFile;
                    pairList.add(pair3);
                    FileTime hl7FileTime = Files.getLastModifiedTime(hl7File, new LinkOption[0]);
                    FileTime pdfFileTime = Files.getLastModifiedTime(pdfFile, new LinkOption[0]);
                    if (hl7FileTime.compareTo(pdfFileTime) > 0) {
                        pair3.fileTime = hl7FileTime;
                    }
                    pdfFilesIterator.remove();
                    hl7FilesIterator.remove();
                    continue block17;
                }
            }
            for (Path hl7File2 : hl7Files) {
                if (monitor != null && monitor.isCanceled()) break;
                pair = new FilePair();
                pair.hl7 = hl7File2;
                pair.fileTime = Files.getLastModifiedTime(hl7File2, new LinkOption[0]);
                pairList.add(pair);
            }
            for (Path pdfFile : pdfFiles) {
                if (monitor != null && monitor.isCanceled()) break;
                pair = new FilePair();
                pair.pdf = pdfFile;
                pair.fileTime = Files.getLastModifiedTime(pdfFile, new LinkOption[0]);
                pairList.add(pair);
            }
            Collections.sort(pairList, new FilePairDateComparator());
            for (FilePair pair4 : pairList) {
                if (monitor != null && monitor.isCanceled()) break;
                String filename = "";
                if (pair4.hl7 != null) {
                    filename = pair4.hl7.getFileName().toString();
                } else if (pair4.pdf != null) {
                    filename = pair4.pdf.getFileName().toString();
                }
                if (monitor != null) {
                    monitor.subTask(MessageFormat.format(MedNetMessages.DocumentImporterPage_parseFile, filename));
                }
                if (contactLink == null || institutionKontakt == null) continue;
                boolean success = DocumentImporter.process(pair4.hl7, pair4.pdf, contactLink, institutionKontakt, true, true);
                if (success) {
                    if (pair4.hl7 != null) {
                        try {
                            Files.move(pair4.hl7, archiveDir.resolve(pair4.hl7.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException ioe) {
                            LOGGER.error(String.valueOf(logPrefix) + "IOException moving this file to the archive " + pair4.hl7.toString(), (Throwable)ioe);
                        }
                    }
                    if (pair4.pdf != null) {
                        try {
                            Files.move(pair4.pdf, archiveDir.resolve(pair4.pdf.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException ioe) {
                            LOGGER.error(String.valueOf(logPrefix) + "IOException moving this file to the archive " + pair4.pdf.toString(), (Throwable)ioe);
                        }
                    }
                    importSuccess.add(MessageFormat.format(MedNetMessages.DocumentImporterPage_FileSuccess, configFormPath.getInstitutionName(), pair4.toString()));
                    continue;
                }
                if (pair4.hl7 != null) {
                    try {
                        Files.move(pair4.hl7, errorDir.resolve(pair4.hl7.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException ioe) {
                        LOGGER.error(String.valueOf(logPrefix) + "IOException moving this file to the error " + pair4.hl7.toString(), (Throwable)ioe);
                    }
                }
                if (pair4.pdf != null) {
                    try {
                        Files.move(pair4.pdf, errorDir.resolve(pair4.pdf.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException ioe) {
                        LOGGER.error(String.valueOf(logPrefix) + "IOException moving this file to the error " + pair4.pdf.toString(), (Throwable)ioe);
                    }
                }
                if (monitor != null) {
                    monitor.subTask(MessageFormat.format(MedNetMessages.DocumentImporterPage_ErrorWhileParsingFile, filename));
                }
                importFailures.add(MessageFormat.format(MedNetMessages.DocumentImporterPage_FileFailure, configFormPath.getInstitutionName(), pair4.toString()));
            }
            if (monitor != null) {
                monitor.worked(100);
            }
            this.deleteOldArchiveFiles(archiveDir);
        }
        if (importFailures.size() <= 0) {
            SWTHelper.showInfo((String)MedNetMessages.DocumentImporterPage_ImportCompletedTitle, (String)MessageFormat.format(MedNetMessages.DocumentImporterPage_ImportCompletedSSuccessText, String.valueOf(importSuccess.size()), String.join((CharSequence)"\n", importSuccess)));
        } else {
            SWTHelper.showError((String)MedNetMessages.DocumentImporterPage_errorTitle, (String)MessageFormat.format(MedNetMessages.DocumentImporterPage_ImportError, String.valueOf(importSuccess.size()), String.valueOf(importFailures.size()), String.join((CharSequence)"\n", importFailures)));
        }
        if (monitor != null) {
            monitor.done();
        }
        LOGGER.info(String.valueOf(logPrefix) + "Import completed");
        return Status.OK_STATUS;
    }

    private void deleteOldArchiveFiles(Path archivPath) {
        String logPrefix = "deleteOldArchivFiles() - ";
        if (MedNet.getSettings().getArchivePurgeInterval() > 0) {
            LOGGER.info(String.valueOf(logPrefix) + "Purge archive dir " + archivPath.toString());
            Calendar cal = Calendar.getInstance();
            cal.add(5, 0 - MedNet.getSettings().getArchivePurgeInterval());
            FileTime timeLimit = FileTime.fromMillis(cal.getTimeInMillis());
            if (Files.exists(archivPath, new LinkOption[0]) && Files.isDirectory(archivPath, new LinkOption[0])) {
                try {
                    DirectoryStream<Path> fileStream = Files.newDirectoryStream(archivPath, new TimeFilter(timeLimit));
                    for (Path path : fileStream) {
                        try {
                            Files.delete(path);
                            LOGGER.info(String.valueOf(logPrefix) + "Following file has been deleted " + path.toString());
                        }
                        catch (IOException ioe) {
                            LOGGER.error(String.valueOf(logPrefix) + "IOException deleting file " + path.toString(), (Throwable)ioe);
                        }
                    }
                }
                catch (IOException ex) {
                    LOGGER.error(String.valueOf(logPrefix) + "IOException walking throw archiv directory " + archivPath.toString(), (Throwable)ex);
                }
            }
            LOGGER.info(String.valueOf(logPrefix) + "Purge of following archive completed" + archivPath.toString());
        } else {
            LOGGER.debug(String.valueOf(logPrefix) + "Purge intervall is negativ. Archive will not be purged");
        }
    }

    public String getTitle() {
        return MedNetMessages.DocumentImporterPage_titleImport;
    }

    public String getDescription() {
        return MedNetMessages.DocumentImporterPage_descriptionImport;
    }

    public Composite createPage(Composite parent) {
        return null;
    }

    private class FilePair {
        Path hl7 = null;
        Path pdf = null;
        FileTime fileTime = null;

        private FilePair() {
        }

        public String toString() {
            ArrayList<String> files = new ArrayList<String>();
            if (this.hl7 != null) {
                files.add(this.hl7.getFileName().toString());
            }
            if (this.pdf != null) {
                files.add(this.pdf.getFileName().toString());
            }
            return String.join((CharSequence)", ", files);
        }
    }

    private class FilePairDateComparator
    implements Comparator<FilePair> {
        private FilePairDateComparator() {
        }

        @Override
        public int compare(FilePair pair1, FilePair pair2) throws NullPointerException {
            if (pair1 == null || pair1.fileTime == null) {
                return -1;
            }
            if (pair2 == null || pair2.fileTime == null) {
                return 1;
            }
            return pair1.fileTime.compareTo(pair2.fileTime);
        }
    }

    private class TimeFilter
    implements DirectoryStream.Filter<Path> {
        private FileTime timeLimit = null;

        public TimeFilter(FileTime timeLimit) {
            this.timeLimit = timeLimit;
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            return Files.isRegularFile(entry, new LinkOption[0]) && Files.getLastModifiedTime(entry, new LinkOption[0]).compareTo(this.timeLimit) < 0;
        }
    }
}

