/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.mediport.util;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.util.Log;
import ch.medshare.mediport.config.Client;
import ch.medshare.mediport.config.ClientParam;
import ch.medshare.mediport.config.MPCProperties;
import ch.medshare.util.SystemProperties;
import ch.medshare.util.UtilFile;
import ch.rgw.tools.ExHandler;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class MediPortHelper {
    private static final String module = MediPortHelper.class.getName();
    private static final String MPC_NUMBER_POSTFIX = "/mpc_number";
    public static final FilenameFilter XML_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toUpperCase().endsWith(".XML");
        }
    };

    private static MPCProperties getProperties() {
        MPCProperties props = null;
        try {
            props = MPCProperties.getCurrent();
        }
        catch (IOException e) {
            Log.get((String)module).log(e.getMessage(), 3);
        }
        return props;
    }

    public static String getMandantPrefix(String label) {
        return String.valueOf(label) + MPC_NUMBER_POSTFIX;
    }

    public static Client getCurrentClient() {
        MPCProperties props = MediPortHelper.getProperties();
        if (props == null) {
            return null;
        }
        SettingsPreferenceStore prefs = new SettingsPreferenceStore(CoreHub.globalCfg);
        String prefix = MediPortHelper.getMandantPrefix(CoreHub.actMandant.getLabel());
        String numStr = prefs.getString(prefix);
        if (numStr != null && numStr.length() > 0) {
            return MediPortHelper.getProperties().getClient(Integer.parseInt(numStr));
        }
        return null;
    }

    public static ClientParam getCurrentParam(String paramName) {
        if (paramName == null || paramName.length() == 0) {
            return null;
        }
        Client client = MediPortHelper.getCurrentClient();
        if (client == null) {
            return null;
        }
        Integer paramNum = client.getParamKey(paramName);
        return client.getParam(paramNum);
    }

    public static List<IRnOutputter> getRnOutputter() {
        Vector<IRnOutputter> retList = new Vector<IRnOutputter>();
        for (Object outputter : Extensions.getClasses((String)"ch.elexis.core.data.RechnungsManager", (String)"outputter")) {
            if (!(outputter instanceof IRnOutputter)) continue;
            retList.add((IRnOutputter)outputter);
        }
        return retList;
    }

    public static int getReturnFiles() {
        Client client = MediPortHelper.getCurrentClient();
        if (client != null) {
            int errorCount = 0;
            File errorDir = new File(client.getError_dir());
            if (errorDir.exists()) {
                errorCount = errorDir.list(XML_FILTER).length;
            }
            int receiveCount = 0;
            File receiveDir = new File(client.getReceive_dir());
            if (receiveDir.exists()) {
                receiveCount = receiveDir.list(XML_FILTER).length;
            }
            return errorCount + receiveCount;
        }
        return 0;
    }

    public static String getPluginDirectory(String pluginName) {
        String filePath = null;
        Bundle bundle = Platform.getBundle((String)pluginName);
        if (bundle != null) {
            Path path = new Path("/");
            URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
            try {
                filePath = FileLocator.toFileURL((URL)url).getPath();
                filePath = filePath.substring(1);
            }
            catch (IOException e) {
                ExHandler.handle((Throwable)e);
            }
        }
        if (filePath != null) {
            return UtilFile.getCorrectPath(filePath);
        }
        return String.valueOf(SystemProperties.USER_DIR) + UtilFile.DIRECTORY_SEPARATOR;
    }
}

