/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.mediport.gui;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.util.SWTHelper;
import ch.medshare.awt.Desktop;
import ch.medshare.mediport.config.Client;
import ch.medshare.mediport.gui.Messages;
import ch.medshare.mediport.util.MediPortHelper;
import ch.medshare.util.UtilFile;
import ch.rgw.tools.ExHandler;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ErrorInvoiceForm
extends Composite {
    private final Client client;
    SettingsPreferenceStore prefs = new SettingsPreferenceStore(CoreHub.globalCfg);

    public ErrorInvoiceForm(Composite parent, int style, Client client) {
        super(parent, style);
        this.client = client;
        this.createArea();
    }

    private String addStyleSheetLine(String xmlContent, String xmlFilename) {
        int ssIndex = xmlContent.indexOf("<?xml-stylesheet");
        if (ssIndex >= 0) {
            int hrefIndex1 = xmlContent.indexOf("href=", ssIndex);
            int hrefIndex2 = xmlContent.indexOf("?>", hrefIndex1);
            return String.valueOf(xmlContent.substring(0, hrefIndex1)) + "href='" + xmlFilename + "'" + xmlContent.substring(hrefIndex2);
        }
        String newLine = "<?xml-stylesheet type='text/xsl' href='" + xmlFilename + "'?>";
        int index = xmlContent.indexOf("?>");
        if (index >= 0) {
            int index2 = xmlContent.indexOf("?>\n");
            if (index2 == -1) {
                newLine = String.valueOf(newLine) + "\n";
            }
            return String.valueOf(xmlContent.substring(0, index + 2)) + "\n" + newLine + xmlContent.substring(index + 2);
        }
        return newLine;
    }

    private void copyStylesheet(String toDir) throws IOException {
        String ssAbsolutePath = UtilFile.getCorrectPath((String)this.client.getStylesheet());
        if (ssAbsolutePath.startsWith("\\") && !ssAbsolutePath.startsWith("\\\\")) {
            ssAbsolutePath = "\\" + ssAbsolutePath;
        }
        if (ssAbsolutePath.startsWith("/") && !ssAbsolutePath.startsWith("//")) {
            ssAbsolutePath = "//" + ssAbsolutePath;
        }
        if (ssAbsolutePath != null && ssAbsolutePath.length() > 0) {
            File fromFile = new File(ssAbsolutePath);
            if (fromFile.exists()) {
                String ssFilename = fromFile.getName();
                String toFilenamePath = String.valueOf(toDir) + File.separator + ssFilename;
                File testFile = new File(toFilenamePath);
                if (testFile.exists()) {
                    testFile.delete();
                }
                UtilFile.copyFile((String)ssAbsolutePath, (String)toFilenamePath);
                File dir = new File(toDir);
                File[] fileArray = dir.listFiles(MediPortHelper.XML_FILTER);
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    String xmlContent = UtilFile.readTextFile((String)file.getAbsolutePath());
                    UtilFile.writeTextFile((String)file.getAbsolutePath(), (String)this.addStyleSheetLine(xmlContent, ssFilename));
                    ++n2;
                }
            } else {
                String message = MessageFormat.format(Messages.ErrorInvoiceForm_msg_copyStylesheet, fromFile.getAbsolutePath());
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ErrorInvoiceForm_error_copyStylesheet, (String)message);
            }
        }
    }

    private void openErrorDir(Shell shell, File directory) {
        if (directory.isDirectory()) {
            try {
                Desktop.open(directory);
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                MessageDialog.openError((Shell)shell, (String)Messages.ErrorInvoiceForm_msg_Fehlerverzeichnis, (String)ex.getMessage());
            }
        }
    }

    private void openReceiveDir(Shell shell, File directory) {
        if (directory.isDirectory()) {
            try {
                this.copyStylesheet(directory.getAbsolutePath());
                Desktop.open(directory);
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                MessageDialog.openError((Shell)shell, (String)Messages.ErrorInvoiceForm_msg_Antwortverzeichnis, (String)ex.getMessage());
            }
        }
    }

    private void createArea() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        final File errorDir = new File(this.client.getError_dir());
        final File receiveDir = new File(this.client.getReceive_dir());
        int countError = 0;
        if (errorDir != null && errorDir.isDirectory()) {
            countError = errorDir.list(MediPortHelper.XML_FILTER).length;
        }
        int countReceive = 0;
        if (receiveDir != null && receiveDir.isDirectory()) {
            countReceive = receiveDir.list(MediPortHelper.XML_FILTER).length;
        }
        Button btnErrorDir = new Button((Composite)this, 8);
        String msgErrorDir = MessageFormat.format(Messages.ErrorInvoiceForm_msg_Fehlerverzeichnis, new Integer(countError));
        btnErrorDir.setText(msgErrorDir);
        btnErrorDir.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Button btnReceiveDir = new Button((Composite)this, 8);
        String msgReceiveDir = MessageFormat.format(Messages.ErrorInvoiceForm_msg_Antwortverzeichnis, new Integer(countReceive));
        btnReceiveDir.setText(msgReceiveDir);
        btnReceiveDir.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        btnErrorDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorInvoiceForm.this.openErrorDir(ErrorInvoiceForm.this.getShell(), errorDir);
            }
        });
        btnReceiveDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorInvoiceForm.this.openReceiveDir(ErrorInvoiceForm.this.getShell(), receiveDir);
            }
        });
    }
}

